/*
 * Decompiled with CFR 0.152.
 */
public final class Map {
    public GameControl gamecontrol;
    public GameClass game;
    public Renderer renderer;
    public CompassMIDlet theApp;
    public AI ai;
    public int layer1VirtualWidth;
    public int layer1VirtualHeight;
    public static final int ROL_KIND_NOP = 0;
    public static final int ROL_KIND_NORMAL = 1;
    public static final int ROL_KIND_HALF_LR = 2;
    public static final int ROL_KIND_OPTION_LR = 3;
    public static final int ROL_KIND_OPTION_UD = 4;
    public static final int ROL_KIND_OPTION_LRUD = 5;
    public static final int ROL_KIND_SPECIAL = 6;
    public static final int ROL_KIND_ICICLE = 7;
    public byte percenthi;
    public byte percentlo;
    public static final int NUM_COLLISION_BOXES = 5;
    public static final int COLLISION_BOX_X = 0;
    public static final int COLLISION_BOX_Y = 1;
    public static final int COLLISION_BOX_W = 2;
    public static final int COLLISION_BOX_H = 3;
    public static final int COLLISION_BOX_VAR_SIZE = 4;
    public static final int COLLISION_BOX_ARRAY_SIZE = 20;
    public int[] collisionBoxes = new int[20];
    public static final int REMAP_BLOCKSET_MASK = 63;
    public static final int REMAP_BLOCKSET_SHIFT = 10;
    public static final int REMAP_STAGE_MASK = 15;
    public static final int REMAP_STAGE_SHIFT = 6;
    public static final int REMAP_AREA_MASK = 63;
    public static final int REMAP_AREA_SHIFT = 0;
    public int Map_FloorInCentre;
    public static final int MAX_STAGES = 11;
    public static final int DRAW_MAP_MULTIPLIER = 4;
    public static final int DRAW_MAP_X = 0;
    public static final int DRAW_MAP_Y = 1;
    public static final int DRAW_MAP_VAR_SIZE = 2;
    public static final String SRN_FILE_EXTENSION = "_v1.srn";
    public static final short END_OF_LINK_DATA = 127;
    public static final short LINK_STAGE = 0;
    public static final short LINK_AREA = 1;
    public static final short LINK_CHECKX = 2;
    public static final short LINK_CHECKY = 3;
    public static final short LINK_OFFSETX = 4;
    public static final short LINK_OFFSETY = 5;
    public static final short LINK_NEWX = 6;
    public static final short LINK_NEWY = 7;
    public static final short LENGTH_OF_LINK_DATA = 8;
    public byte[] hitArray;
    public short[] hitMetaBlocks;
    public int gbaVirtualScreenSize;
    public static final int SHAKE_AMOUNT = 500;
    public int pixelWidth;
    public int blockWidth;
    public int charWidth;
    public int blockPixelWidth;
    public int charPixelWidth;
    public int blockImageWidth;
    public static final int BLOCKS_ACROSS_IMAGE = 8;
    public static final int BLOCKS_ACROSS_IMAGE_MASK = 7;
    public static final int BLOCKS_ACROSS_IMAGE_SHIFT = 3;
    public static final int BLOCKS_DOWN_IMAGE = 7;
    public static final int PIXELS_ACROSS_METABLOCK_IMAGE = 128;
    public static final int PIXELS_PER_CHAR = 16;
    public static final int PIXELS_PER_METABLOCK = 128;
    public static final int PIXELS_ACROSS_METABLOCK = 16;
    public static final int CHARS_ACROSS_METABLOCK = 4;
    public static final int PIXELS_ACROSS_CHAR = 4;
    public static final int METABLOCK_PIXEL_SIZE = 256;
    public static final int NUM_LAYERS = 3;
    public int[] layerWidth = new int[3];
    public int[] layerHeight = new int[3];
    public int[] layerSize = new int[3];
    public short[][] layers;
    public int maxMapVirtualWidth;
    public int maxMapVirtualHeight;
    public int layer0GBAWidth;
    public int layer0GBAHeight;
    public int layer0Width;
    public int layer0Height;
    public int layer0Size;
    public int layer1Width;
    public int layer1Height;
    public int layer1Size;
    public int screenBlockWidth;
    public int screenBlockHeight;
    public int virtualScreenBlockWidth;
    public int virtualScreenBlockHeight;
    public static final int MAX_BLOCK_SPRITES = 56;
    public int[] blockSprites = new int[56];
    public int[][] nonEmptyBlock = new int[56][];
    public int currentBlockSprite = -1;
    public static final int METABLOCKS_PER_SCREEN = 56;
    public static final int PIXELS_DOWN_METABLOCK_IMAGE = 112;
    public static final int METABLOCKS_PER_SCREEN_SHIFT = 6;
    public int mapX;
    public int mapY;
    public int mapTargetX;
    public int mapTargetY;
    public boolean mapSnap;
    public int MAP_SMOOTH = 2;
    public int mapMaxX;
    public int mapMaxY;
    public int mapMinY;
    public int bottomOfMap;
    public static final byte COLLISION_NONE = 0;
    public static final byte COLLISION_SOLID = 1;
    public static final byte COLLISION_SOFT = 2;
    public static final byte COLLISION_ANGLETYPE = 4;
    public static final byte COLLISION_ANGLE = 8;
    public static final int COLLISION_DEMON = 128;
    public int numberOfMetaBlocks;
    public boolean metaBlocksLoaded;
    public boolean layer2drawInFront = false;
    public int pngImage;
    public static final byte[] jordan_exits = new byte[]{0, 2, 20, 1, 1, 0, 1, 0, 0, 3, 0, 0, 1, 2, 0, 19, 2, 0, 1, 2, 0, 3, 10, 1, 2, 0, 0, 14, 1, 1, 2, 2, 0, 14, 3, 0, 3, 0, 0, 8, 2, 1, 3, 2, 0, 8, 4, 0, 4, 0, 0, 8, 3, 1, 4, 2, 0, 8, 5, 0, 5, 0, 0, 8, 4, 1, 5, 2, 0, 8, 6, 0, 6, 0, 0, 9, 5, 1, 6, 0, 0, 3, 7, 0, 7, 2, 0, 3, 6, 1, 7, 0, 0, 3, 8, 0, 8, 2, 0, 3, 7, 1, 8, 0, 0, 3, 9, 0, 9, 2, 0, 3, 8, 1, 9, 0, 0, 8, 10, 0, 10, 2, 0, 8, 9, 1, 10, 0, 0, 3, 1, 2};
    public static final byte[] trollsund_exits = new byte[]{0, 4, 13, 8, 1, 0, 0, 4, 49, 8, 1, 3, 1, 5, 13, 8, 0, 0, 1, 4, 19, 8, 2, 1, 1, 4, 26, 8, 2, 2, 1, 5, 48, 8, 0, 1, 1, 4, 54, 8, 2, 5, 2, 4, 13, 8, 3, 0, 2, 5, 20, 8, 1, 1, 2, 5, 33, 8, 1, 2, 2, 4, 40, 8, 3, 1, 2, 4, 54, 8, 3, 2, 2, 5, 57, 8, 1, 4, 3, 5, 10, 8, 2, 0, 3, 5, 30, 8, 2, 3, 3, 5, 41, 8, 2, 4};
    public static final byte[] icesheet_exits = new byte[]{0, 2, 3, 8, 1, 0, 1, 0, 0, 8, 0, 0, 1, 2, 10, 8, 2, 0, 2, 0, 0, 8, 1, 0};
    public static final byte[][] stage_exits = new byte[][]{jordan_exits, null, trollsund_exits, null, icesheet_exits};
    public byte[] startArea = new byte[]{0, 1, 0, 2, 0};
    public byte[] Layer2OnFront = new byte[]{2, 0, 2, 1, 2, 2};
    public static final int EXIT_AT_LEFT = 0;
    public static final int EXIT_AT_TOP = 1;
    public static final int EXIT_AT_RIGHT = 2;
    public static final int EXIT_AT_BOTTOM = 3;
    public static final int[] pngTransparentArray = new int[]{0};
    public static final int PALETTE_DATA_OFFSET = 0;
    public static final int PALETTE_NUMBER_OFFSET = 2;
    public static final int PALETTE_HEADER_SIZE = 4;
    public int temp;
    public static final int B3_CHAR_FLIP_SHIFT = 4;
    public static final int B2_CHAR_FLIP_SHIFT = 6;
    public static final int METABLOCK_FLIP_SHIFT = 14;
    public static final int FLIP_V = 1;
    public static final int FLIP_H = 2;
    public static final int SRNM_STAGE = 0;
    public static final int SRNM_AREA = 1;
    public static final int SRNM_LAYER_X_WIDTH = 2;
    public static final int SRNM_LAYER_X_HEIGHT = 3;
    public static final int SRNM_LAYER_Y_WIDTH = 4;
    public static final int SRNM_LAYER_Y_HEIGHT = 5;
    public static final int SRNM_LAYER_Z_WIDTH = 6;
    public static final int SRNM_LAYER_Z_HEIGHT = 7;
    public static final int SRNM_HEADER_SIZE = 8;

    public final void Map_initClass(GameControl gameControl) {
        this.gamecontrol = gameControl;
        this.game = gameControl.game;
        this.renderer = gameControl.renderer;
        this.theApp = gameControl.theApp;
        this.ai = gameControl.ai;
    }

    public final void Map_SetupStage(int n) {
        if (n < 0) {
            n = 0;
        }
        this.gamecontrol.stageNumber = (byte)n;
        this.gamecontrol.areaNumber = this.startArea[n];
        this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
    }

    public final void Map_OpenArea() {
        int n;
        Map map;
        short[] sArray;
        int n2;
        byte by;
        int n3;
        int n4;
        byte by2;
        this.game.map = this;
        byte by3 = this.gamecontrol.areaNumber;
        byte by4 = by2 = this.gamecontrol.stageNumber;
        byte by5 = by2;
        byte by6 = by3;
        this.layer2drawInFront = false;
        int n5 = n4 = 0;
        while (n5 < this.Layer2OnFront.length) {
            if (this.Layer2OnFront[n4] == by2 && this.Layer2OnFront[n4 + 1] == by3) {
                this.layer2drawInFront = true;
                break;
            }
            n5 = n4 + 2;
        }
        this.layers = null;
        this.hitArray = null;
        this.hitMetaBlocks = null;
        this.gamecontrol.remapStageNumber = by5;
        this.gamecontrol.remapAreaNumber = by6;
        this.mapSnap = true;
        this.mapX = 0;
        this.mapY = 0;
        this.mapTargetX = 0;
        this.mapTargetY = 0;
        this.blockWidth = Renderer.convertToVirtual(128);
        this.blockWidth = CompassMIDlet.divideWithRemainder(this.blockWidth, 8);
        this.charWidth = this.blockWidth >> 4;
        this.pixelWidth = Renderer.virtualScreenWidth / Renderer.B_W;
        String string = "" + by4 / 10 + by4 % 10 + SRN_FILE_EXTENSION;
        int n6 = this.theApp.fileLoad(string, null, true, 0, 0);
        byte[] byArray = new byte[n6];
        this.theApp.fileLoad(string, byArray, false, 0, 0);
        this.metaBlocksLoaded = true;
        int n7 = -8;
        this.layerSize[0] = 0;
        this.layerSize[1] = 0;
        this.layerSize[2] = 0;
        do {
            n3 = byArray[(n7 += (this.layerSize[0] << 1) + (this.layerSize[1] << 2) + (this.layerSize[2] << 1) + 8) + 1] & 0x7F;
            by = byArray[n7 + 0];
            for (n2 = 0; n2 < 3; ++n2) {
                int n8;
                int n9;
                int[] nArray;
                this.layerWidth[n2] = byArray[n7 + 2 + (n2 << 1)];
                this.layerHeight[n2] = byArray[n7 + 3 + (n2 << 1)];
                if (this.layerWidth[n2] != 0) {
                    if (n2 == 0) {
                        this.layer0GBAWidth = this.layerWidth[n2] >> 3;
                        this.layer0GBAHeight = this.layerHeight[n2] >> 3;
                    }
                    nArray = this.layerSize;
                    n9 = n2;
                    n8 = this.layerWidth[n2] * this.layerHeight[n2];
                } else {
                    nArray = this.layerSize;
                    n9 = n2;
                    n8 = 0;
                }
                nArray[n9] = n8;
            }
        } while (n3 != by6 || by != by5);
        this.layers = new short[3][];
        for (n2 = 0; n2 < 3; ++n2) {
            this.layers[n2] = null;
            if (this.layerSize[n2] == 0) continue;
            this.layers[n2] = new short[this.layerSize[n2]];
            if (n2 != 1) continue;
            this.layer1VirtualWidth = this.layerWidth[n2] * this.blockWidth;
            this.layer1VirtualHeight = this.layerHeight[n2] * this.blockWidth;
        }
        int n10 = n7 += 8;
        n7 += this.layerSize[1] * 2;
        for (n2 = 0; n2 < 3; ++n2) {
            if (this.layerSize[n2] == 0) continue;
            this.Map_CopySRNData(n2, byArray, n7);
            n7 += this.layerSize[n2] * 2;
        }
        int n11 = n7 - n10;
        short[] sArray2 = new short[this.layerSize[0] + this.layerSize[1] + this.layerSize[2]];
        this.theApp.fillShortArray(sArray2, (short)-1);
        int n12 = 1;
        sArray2[0] = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            sArray = this.layers[n2];
            for (n4 = 0; n4 < this.layerSize[n2]; ++n4) {
                int n13;
                for (n13 = 0; sArray2[n13] != sArray[n4] && n13 < n12; ++n13) {
                }
                if (n13 != n12) continue;
                sArray2[n12++] = sArray[n4];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            this.layers[n2] = null;
        }
        n12 = (n12 + 7) / 8;
        this.Map_BuildMetaBlocks(sArray2, n12 *= 8, by4, by6);
        byArray = new byte[n11];
        string = "" + by4 / 10 + by4 % 10 + SRN_FILE_EXTENSION;
        this.theApp.fileLoad(string, byArray, false, n11, n10);
        this.hitMetaBlocks = new short[this.layerSize[1]];
        for (n4 = 0; n4 < this.layerSize[1] << 1; n4 += 2) {
            this.hitMetaBlocks[n4 >> 1] = (short)(((byArray[0 + n4] & 0xFF) << 8) + (byArray[1 + n4] & 0xFF));
        }
        n7 = 0 + this.layerSize[1] * 2;
        for (n2 = 0; n2 < 3; ++n2) {
            if (this.layerSize[n2] == 0) continue;
            this.layers[n2] = new short[this.layerSize[n2]];
            this.Map_CopySRNData(n2, byArray, n7);
            n7 += this.layerSize[n2] * 2;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            sArray = this.layers[n2];
            for (n4 = 0; n4 < this.layerSize[n2]; ++n4) {
                int n14 = 0;
                short s = (short)(sArray[n4] & 0xFFFF);
                while (sArray2[n14] != s) {
                    ++n14;
                }
                sArray[n4] = (short)n14;
            }
        }
        string = "hit_lib_v1.hit";
        n6 = this.theApp.fileLoad(string, null, true, 0, 0);
        this.hitArray = new byte[n6];
        this.theApp.fileLoad(string, this.hitArray, false, 0, 0);
        this.screenBlockWidth = CompassMIDlet.divideWithRemainder(65536, this.blockWidth) + 2;
        this.screenBlockHeight = CompassMIDlet.divideWithRemainder(Renderer.V_H, this.blockWidth) + 1;
        this.virtualScreenBlockHeight = this.screenBlockHeight * this.blockWidth;
        this.virtualScreenBlockWidth = this.screenBlockWidth * this.blockWidth;
        this.gbaVirtualScreenSize = this.blockWidth << 3;
        this.Map_FloorInCentre = this.Map_GetFloor(this.layer1VirtualWidth >> 1, this.layer1VirtualHeight - this.blockWidth, 0);
        this.maxMapVirtualWidth = this.layerWidth[1] * this.blockWidth;
        this.maxMapVirtualHeight = this.layerHeight[1] * this.blockWidth;
        this.mapMaxX = this.maxMapVirtualWidth - 65536 - (this.blockWidth >> 1);
        this.bottomOfMap = this.layerHeight[1] * this.blockWidth;
        this.mapMaxY = this.maxMapVirtualHeight - (Renderer.B_H / 16 - 1) * this.blockWidth;
        if (this.mapMaxY < 0) {
            this.mapMaxY = 0;
        }
        if (this.mapMaxX < 0) {
            this.mapMaxX = 0;
        }
        if (this.layer0GBAHeight > 1) {
            map = this;
            n = this.blockWidth;
        } else {
            map = this;
            n = 0;
        }
        map.mapMinY = n;
        this.mapX = 0;
        this.mapY = 0;
        this.mapTargetX = 0;
        this.mapTargetY = 0;
    }

    public final void Map_drawCollisionBlock(int n, int n2, int n3) {
    }

    public final void Map_setMapCoords(int n, int n2) {
        this.mapTargetX = CompassMIDlet.limit(n, 0, this.mapMaxX);
        this.mapTargetY = CompassMIDlet.limit(n2, this.mapMinY, this.mapMaxY);
        if (this.mapSnap) {
            this.mapX = this.mapTargetX;
            this.mapY = this.mapTargetY;
            this.mapSnap = false;
        }
    }

    public final int Map_GetHeight(int n, int n2) {
        return (n2 /= this.blockWidth) * this.blockWidth;
    }

    public final int Map_GetBlockIndex(int n, int n2, int n3, int n4) {
        return CompassMIDlet.limit(n2 / this.blockWidth, 0, n4 - 1) * n3 + CompassMIDlet.limit(n / this.blockWidth, 0, n3 - 1);
    }

    public final int Map_GetFloor(int n, int n2, int n3) {
        n2 /= this.charWidth;
        n2 *= this.charWidth;
        boolean bl = true;
        byte by = 0;
        int n4 = this.layerHeight[1] * this.blockWidth - this.charWidth;
        while (by == 0) {
            by = this.Map_GetCollision(n, n2);
            if (by == 0 || n3 == 0 && (by & 0x80) != 0) {
                by = 0;
                bl = false;
                if ((n2 += this.charWidth) <= n4) continue;
                return Integer.MAX_VALUE;
            }
            bl = true;
        }
        if (bl) {
            while (by != 0) {
                by = this.Map_GetCollision(n, n2);
                if (by != 0 && (n3 == 1 || n3 == 0 && (by & 0x80) == 0)) {
                    if ((n2 -= this.charWidth) >= 0) continue;
                    return Integer.MAX_VALUE;
                }
                n2 += this.charWidth;
                by = 0;
            }
        }
        this.Map_GetCollision(n, n2);
        n2 /= this.charWidth;
        --n2;
        return n2 *= this.charWidth;
    }

    public final int Map_GetBoxFloor(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] == 0) continue;
            int n5 = this.collisionBoxes[i + 0];
            n4 = this.collisionBoxes[i + 2] + n5;
            int n6 = this.collisionBoxes[i + 1];
            int n7 = n6 + this.collisionBoxes[i + 3];
            if (n < n5 || n > n4 || n2 > n7 || n3 <= n6) continue;
            n3 = n6;
        }
        return n3;
    }

    public final int Map_GetCeiling(int n, int n2) {
        if (n2 > this.maxMapVirtualHeight) {
            return 0;
        }
        while ((this.Map_GetCollision(n, n2) & 1) == 0) {
            if ((n2 -= this.charWidth) >= 0) continue;
            return -this.blockWidth;
        }
        byte by = this.Map_GetCollision(n, n2);
        if ((by & 8) != 0) {
            return this.Map_GetSlopeHeight(n, n2, by);
        }
        return (n2 /= this.charWidth) * this.charWidth;
    }

    public final void Map_UnloadArea() {
        for (int i = 0; i < 56; ++i) {
            this.renderer.RFM_IUnload(this.blockSprites[i]);
            this.blockSprites[i] = 0;
        }
        this.layers = null;
        this.hitArray = null;
        System.gc();
    }

    public final int Map_GetSlopeHeight(int n, int n2, byte by) {
        int n3 = n2 / this.charWidth;
        n3 *= this.charWidth;
        if ((by & 0x80) != 0) {
            n = (by & 0x30) >> 4;
            int n4 = n * this.charWidth >> 2;
            return n3 + n4 - this.charWidth;
        }
        int n5 = n %= this.charWidth;
        if ((by & 4) != 0) {
            n5 = this.charWidth - n5;
        }
        return n3 + n5 - this.charWidth;
    }

    public final byte Map_GetCollision(int n, int n2) {
        int n3 = this.Map_GetBlockIndex(n, n2, this.layerWidth[1], this.layerHeight[1]);
        if (n3 < 0 || n3 >= this.layerWidth[1] * this.layerHeight[1]) {
            return -1;
        }
        short s = this.hitMetaBlocks[n3];
        int n4 = n % this.blockWidth / (this.blockWidth >> 2) & 3;
        int n5 = n2 % this.blockWidth / (this.blockWidth >> 2) & 3;
        n4 = (n5 << 2) + n4;
        int n6 = (s << 4) + n4;
        byte by = (byte)(this.hitArray[n6] & 0xFF);
        return by;
    }

    public final void Map_Update() {
        this.mapX = CompassMIDlet.moveTowards(this.mapTargetX, this.mapX, this.MAP_SMOOTH);
        this.mapY = CompassMIDlet.moveTowards(this.mapTargetY, this.mapY, this.MAP_SMOOTH);
        this.mapX = CompassMIDlet.limit(this.mapX, 0, this.mapMaxX);
        this.mapY = CompassMIDlet.limit(this.mapY, this.mapMinY, this.mapMaxY);
    }

    public final void Map_GetNextAreaAndExit(int n) {
        int n2;
        byte[] byArray = stage_exits[this.gamecontrol.stageNumber];
        int n3 = byArray.length / 6;
        int n4 = 100000;
        int n5 = -1;
        byte by = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6;
            if (byArray[n2 * 6 + 0] != this.gamecontrol.areaNumber || byArray[n2 * 6 + 1] != n) continue;
            int n7 = Renderer.convertToBuild(this.ai.playerMapX);
            n7 /= 16;
            int n8 = Renderer.convertToBuild(this.ai.playerMapY);
            n8 /= 16;
            if ((n6 = (n7 -= byArray[n2 * 6 + 2]) * n7 + (n8 -= byArray[n2 * 6 + 3]) * n8) >= n4) continue;
            n4 = n6;
            n5 = n2;
            by = byArray[n5 * 6 + 5];
        }
        if (n5 == -1) {
            ++this.ai.playerOutOfMap;
            return;
        }
        int n9 = -1;
        int n10 = -1;
        byte by2 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (byArray[n5 * 6 + 4] != byArray[n2 * 6 + 0]) continue;
            if (by2 == by) {
                n9 = byArray[n2 * 6 + 2];
                n10 = byArray[n2 * 6 + 3];
                break;
            }
            ++by2;
        }
        this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
        this.gamecontrol.forceNewArea = byArray[n5 * 6 + 4];
        ++n10;
        n9 *= 16;
        n10 *= 16;
        n9 = Renderer.convertToVirtual(n9);
        n10 = Renderer.convertToVirtual(n10);
        this.gamecontrol.levelDirection = n;
        this.gamecontrol.newLevelPlayerScreenX = n9;
        this.gamecontrol.newLevelPlayerScreenY = n10;
    }

    public final void Map_CheckCentreExits() {
        byte[] byArray = stage_exits[this.gamecontrol.stageNumber];
        int n = byArray.length / 6;
        this.ai.playerCanExitUp = false;
        this.ai.playerCanExitDown = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (this.gamecontrol.areaNumber != byArray[i * 6 + 0] || byArray[i * 6 + 1] < 4) continue;
            int n3 = Renderer.convertToBuild(this.ai.playerMapX);
            int n4 = Renderer.convertToBuild(this.ai.playerMapY);
            n4 /= 16;
            byte by = byArray[i * 6 + 2];
            int n5 = (n3 /= 16) - by;
            byte by2 = byArray[i * 6 + 3];
            if (n5 * n5 + (n2 = --n4 - by2) * n2 >= 4) continue;
            if (byArray[i * 6 + 1] == 4) {
                this.ai.playerCanExitUp = true;
            }
            if (byArray[i * 6 + 1] != 5) continue;
            this.ai.playerCanExitDown = true;
        }
    }

    public final void Map_SetPlayerCentreExit() {
        int n;
        byte by = 0;
        byte by2 = 0;
        byte[] byArray = stage_exits[this.gamecontrol.stageNumber];
        int n2 = byArray.length / 6;
        for (n = 0; n < n2; ++n) {
            int n3;
            if (this.gamecontrol.areaNumber != byArray[n * 6 + 0] || byArray[n * 6 + 1] < 4) continue;
            int n4 = Renderer.convertToBuild(this.ai.playerMapX);
            int n5 = Renderer.convertToBuild(this.ai.playerMapY);
            n5 /= 16;
            byte by3 = byArray[n * 6 + 2];
            int n6 = (n4 /= 16) - by3;
            byte by4 = byArray[n * 6 + 3];
            if (n6 * n6 + (n3 = --n5 - by4) * n3 >= 4) continue;
            by = byArray[n * 6 + 4];
            by2 = byArray[n * 6 + 5];
        }
        int n7 = -1;
        int n8 = -1;
        byte by5 = 0;
        for (n = 0; n < n2; ++n) {
            if (by != byArray[n * 6 + 0]) continue;
            if (by5 == by2) {
                n7 = byArray[n * 6 + 2];
                n8 = byArray[n * 6 + 3];
                break;
            }
            ++by5;
        }
        this.gamecontrol.forceNewArea = by;
        this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
        ++n8;
        n7 *= 16;
        n8 *= 16;
        n7 = Renderer.convertToVirtual(n7);
        n8 = Renderer.convertToVirtual(n8);
        this.gamecontrol.levelDirection = -1;
        this.gamecontrol.newLevelPlayerScreenX = n7;
        this.gamecontrol.newLevelPlayerScreenY = n8;
    }

    public final boolean Map_CheckExit() {
        int n = this.ai.playerMapX;
        int n2 = this.ai.playerMapY;
        int n3 = (this.layerWidth[1] - 1) * this.blockWidth + ((this.blockWidth >> 1) - 1200);
        int n4 = (this.layerHeight[1] - 1) * this.blockWidth + ((this.blockWidth >> 1) - 1200);
        if (n >= n3) {
            this.Map_GetNextAreaAndExit(2);
            return true;
        }
        if (n <= this.blockWidth / 2) {
            this.Map_GetNextAreaAndExit(0);
            return true;
        }
        if (n2 <= this.blockWidth / 2) {
            this.Map_GetNextAreaAndExit(1);
            return true;
        }
        if (n2 >= n4) {
            this.Map_GetNextAreaAndExit(3);
            return true;
        }
        this.Map_CheckCentreExits();
        return false;
    }

    public final int Map_AddMetablock(short[] sArray, short s, int n) {
        int n2;
        for (n2 = 0; sArray[n2] != s && n2 < n; ++n2) {
        }
        if (n2 == n) {
            sArray[n2] = s;
            return n + 1;
        }
        return n;
    }

    public final short Map_FindMetablock(short[] sArray, short s) {
        short s2;
        short s3 = 0;
        while (sArray[s2 = s3] != s) {
            s3 = (short)(s2 + 1);
        }
        return s2;
    }

    public final void Map_BuildMetaBlocks(short[] sArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        String string = "" + n2 / 10 + n2 % 10;
        String string2 = string + "_4x4.csr";
        int n8 = this.theApp.fileLoad(string2, null, true, 0, 0);
        byte[] byArray = new byte[n8];
        this.theApp.fileLoad(string2, byArray, false, 0, 0);
        string2 = string + "_b3.mod";
        n8 = this.theApp.fileLoad(string2, null, true, 0, 0);
        byte[] byArray2 = new byte[n8];
        this.theApp.fileLoad(string2, byArray2, false, 0, 0);
        byte[] byArray3 = new byte[n * 256];
        for (n6 = 0; n6 < n; ++n6) {
            short s = sArray[n6];
            if (s == -1) continue;
            this.Map_DrawMetablock(byArray2, sArray[n6] & 0x3FFF, byArray, byArray3, n6, sArray[n6] & 0xC000);
        }
        byte[] byArray4 = new byte[768];
        string2 = "pal_lib_v1.col";
        n8 = this.theApp.fileLoad(string2, null, true, 0, 0);
        byte[] byArray5 = new byte[n8];
        this.theApp.fileLoad(string2, byArray5, false, 0, 0);
        int n9 = ((byArray5[0] & 0xFF) << 8) + (byArray5[1] & 0xFF);
        if (n2 == 16) {
            n2 = 0;
        }
        int n10 = 4;
        int n11 = 0;
        do {
            n10 += n11;
            n5 = byArray5[n10++] & 0xFF;
            n4 = byArray5[n10] & 0xF;
            n11 = byArray5[n10++] >> 4 & 0xF;
        } while (n5 != n3 || n4 != n2);
        for (n6 = 0; n6 < n11; ++n6) {
            int n12;
            if ((n12 = byArray5[n10++] & 0xFF) != 255) {
                n12 <<= 5;
                n12 += n9;
                for (int i = 0; i < 16; ++i) {
                    int n13 = (byArray5[n12++] & 0xFF) << 8;
                    byArray4[n7++] = (byte)((n13 += byArray5[n12++] & 0xFF) << 3 & 0xF8);
                    byArray4[n7++] = (byte)(n13 >> 2 & 0xF8);
                    byArray4[n7++] = (byte)(n13 >> 7 & 0xF8);
                }
                continue;
            }
            n7 += 48;
        }
        if (n2 == 1 && n3 == 5) {
            byArray4[474] = 40;
            byArray4[475] = 40;
            byArray4[476] = 40;
        }
        Map map = this;
        int n14 = map.currentBlockSprite = 0;
        while (n > 0) {
            if (this.blockSprites[this.currentBlockSprite] != 0) {
                this.renderer.RFM_IUnload(this.blockSprites[this.currentBlockSprite]);
            }
            if (this.nonEmptyBlock[this.currentBlockSprite] == null) {
                this.nonEmptyBlock[this.currentBlockSprite] = new int[2];
            }
            this.theApp.fillIntArray(this.nonEmptyBlock[this.currentBlockSprite], 0);
            int n15 = n < 56 ? n / 8 * 16 : 112;
            this.blockSprites[this.currentBlockSprite] = this.renderer.RFM_ILoadRAW(128, n15, 256, byArray3, byArray4, 255, this.currentBlockSprite * 128 * 112);
            n -= 56;
            Map map2 = this;
            map = map2;
            n14 = map2.currentBlockSprite + 1;
        }
        this.currentBlockSprite = -1;
    }

    public final void Map_DrawChar(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n * 8;
        n4 <<= 4;
        int n8 = n3 % 4 * 4;
        int n9 = n3 / 4 * 4;
        n2 += n8 + (n9 *= 128);
        if ((n5 & 1) != 0) {
            n6 = -128;
            n2 += 384;
        } else {
            n6 = 128;
        }
        if ((n5 & 2) != 0) {
            for (int i = 0; i < 4; ++i) {
                byte by = byArray[n7++];
                byArray2[n2 + 3] = (byte)((by >> 4 & 0xF) + n4 & 0xFF);
                byArray2[n2 + 2] = (byte)((by & 0xF) + n4 & 0xFF);
                by = byArray[n7++];
                byArray2[n2 + 1] = (byte)((by >> 4 & 0xF) + n4 & 0xFF);
                byArray2[n2 + 0] = (byte)((by & 0xF) + n4 & 0xFF);
                n2 += n6;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                byte by = byArray[n7++];
                byArray2[n2 + 0] = (byte)((by >> 4 & 0xF) + n4 & 0xFF);
                byArray2[n2 + 1] = (byte)((by & 0xF) + n4 & 0xFF);
                by = byArray[n7++];
                byArray2[n2 + 2] = (byte)((by >> 4 & 0xF) + n4 & 0xFF);
                byArray2[n2 + 3] = (byte)((by & 0xF) + n4 & 0xFF);
                n2 += n6;
            }
        }
    }

    public final void Map_drawBlock(int n, int n2, int n3, int n4) {
        int n5 = n3 & 7;
        int n6 = n3 >> 3;
        n6 %= 7;
        this.renderer.Renderer_DrawClippedIndexedBmp(this.blockSprites[n3 / 56], n, n2, 16, 16, n5 *= 16, n6 *= 16, false);
    }

    public final void Map_DrawMetablock(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 4;
        if (n == 0) {
            return;
        }
        n3 >>= 14;
        if (((n3 &= 3) & 2) != 0) {
            n6 = 3;
            n5 = -1;
        } else {
            n6 = 0;
            n5 = n4 = 1;
        }
        if ((n3 & 1) != 0) {
            n6 += 12;
            n7 = -4;
        }
        int n8 = (n2 & 7) * 16 + (n2 >> 3) * 16 * 128;
        int n9 = 4 + n * 48;
        for (int i = 0; i < 4; ++i) {
            int n10 = n6;
            for (int j = 0; j < 4; ++j) {
                int n11 = byArray[n9] >> 4 ^ n3;
                int n12 = byArray[n9++] & 0xF;
                int n13 = (byArray[n9++] & 0xFF) << 8;
                this.Map_DrawChar(byArray2, n13 += byArray[n9++] & 0xFF, byArray3, n8, n10, n12, n11);
                n10 += n4;
            }
            n6 += n7;
        }
    }

    public final void Map_RenderLayer(int n) {
        int n2 = this.layerSize[n];
        int n3 = this.layerWidth[n];
        int n4 = this.layerHeight[n];
        short[] sArray = this.layers[n];
        if (n2 != 0) {
            int n5 = this.mapX;
            int n6 = this.mapY;
            int n7 = this.Map_GetBlockIndex(n5, n6, n3, n4);
            if (n7 > n2) {
                return;
            }
            n5 %= this.blockWidth;
            n6 %= this.blockWidth;
            n5 = -n5;
            n6 = -n6;
            n5 = Renderer.convertToBuild(n5);
            n6 = Renderer.convertToBuild(n6);
            int n8 = n5;
            for (int i = 0; i < this.screenBlockHeight; ++i) {
                n5 = n8;
                if (n != 1 && i > this.layerHeight[1] - 2) {
                    return;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                int n9 = n7;
                for (int j = 0; j < this.screenBlockWidth; ++j) {
                    short s;
                    if (n9 >= n2) {
                        return;
                    }
                    if (this.isNonEmptyBlock(s = sArray[n9++])) {
                        this.Map_drawBlock(n5, n6, s, 0);
                    }
                    n5 += 16;
                }
                n6 += 16;
                n7 += n3;
            }
        }
    }

    public final boolean isNonEmptyBlock(int n) {
        int n2;
        int n3 = n / 56;
        int n4 = n % 56;
        return (this.nonEmptyBlock[n3][n4 >>= 5] & (n2 = 1 << (n4 & 0x1F))) != 0;
    }

    public final void Map_AddCollisionBox(int n, int n2, int n3, int n4) {
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] != 0) continue;
            this.collisionBoxes[i + 0] = n;
            this.collisionBoxes[i + 1] = n2;
            this.collisionBoxes[i + 2] = n3;
            this.collisionBoxes[i + 3] = n4;
            return;
        }
    }

    public final void Map_ClearCollisionBoxes() {
        for (int i = 2; i < 20; i += 4) {
            this.collisionBoxes[i] = 0;
        }
    }

    public final boolean Map_ScanBoxes(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] == 0) continue;
            int n4 = this.collisionBoxes[i + 0];
            n3 = this.collisionBoxes[i + 2] + n4;
            int n5 = this.collisionBoxes[i + 1];
            int n6 = n5 + this.collisionBoxes[i + 3];
            if (n < n4 || n > n3 || n2 > n6 || n2 < n5) continue;
            return true;
        }
        return false;
    }

    public final void Map_CopySRNData(int n, byte[] byArray, int n2) {
        short[] sArray = this.layers[n];
        int n3 = this.layerWidth[n];
        int n4 = this.layerHeight[n];
        int n5 = 0;
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    sArray[n5] = (short)(((byArray[n2 + (n5 << 1)] & 0xFF) << 8) + (byArray[n2 + (n5 << 1) + 1] & 0xFF));
                    ++n5;
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

