/*
 * Decompiled with CFR 0.152.
 */
public final class EGame {
    public static GameLogic logic;
    public static int iLevel;
    public static int iSpeed;
    public static int iHighscore;
    public static int iStateCur;
    public static int iDelayUpdateState;
    public static int iDelayEventNext;
    private static long lTimeState;
    private static long lTimeEvent;
    public static byte bGameLast;
    public static final int[] iArrHighScore;

    public static final void init() {
        GameField.init();
        EGameView.init();
    }

    private static final void updateLogic(byte gameType) {
        switch (gameType) {
            case 0: {
                logic = new GameLogicTetris();
                break;
            }
            case 1: {
                logic = new GameLogicSnake();
                break;
            }
            case 3: {
                logic = new GameLogicShooter();
                break;
            }
            case 4: {
                logic = new GameLogicTennis();
                break;
            }
            case 2: {
                logic = new GameLogicArcanoid();
            }
        }
    }

    public static final void load() throws Exception {
        GUtillIo.initRead(GUtillIo.getRsData("retro.games.alex.kipar.game"));
        iLevel = GUtillIo.readInt();
        iSpeed = GUtillIo.readInt();
        iHighscore = GUtillIo.readInt();
        iStateCur = GUtillIo.readInt();
        lTimeState = GUtillIo.readLong();
        lTimeEvent = GUtillIo.readLong();
        bGameLast = GUtillIo.readByte();
        if (iStateCur == 0 || iStateCur == 1) {
            EGame.updateLogic(bGameLast);
            logic.load();
            GameField.load();
        }
    }

    public static final void save() throws Exception {
        GUtillIo.initWrite();
        GUtillIo.writeInt(iLevel);
        GUtillIo.writeInt(iSpeed);
        GUtillIo.writeInt(iHighscore);
        GUtillIo.writeInt(iStateCur);
        GUtillIo.writeLong(lTimeState);
        GUtillIo.writeLong(lTimeEvent);
        GUtillIo.writeByte(bGameLast);
        if (iStateCur == 0 || iStateCur == 1) {
            logic.save();
            GameField.save();
        }
        GUtillIo.saveRsData("retro.games.alex.kipar.game", GUtillIo.toByteArray());
        GUtillIo.closeWrite();
    }

    public static final void start(byte gameType) {
        if (gameType != bGameLast) {
            logic = null;
            EGame.updateLogic(gameType);
            bGameLast = gameType;
            System.gc();
        }
        if (logic != null) {
            EGameView.disableFill();
            GameField.clear();
            EGameView.setTextState(4, (byte)0);
            iHighscore = iArrHighScore[gameType];
            logic.updateLevel(iLevel);
            iStateCur = 0;
            iDelayUpdateState = Constants.GAME_DELAY[gameType][iSpeed - 1];
            iDelayEventNext = iDelayUpdateState / 3;
        }
    }

    public static final void update() {
        switch (iStateCur) {
            case 0: {
                if (lTimeState < System.currentTimeMillis()) {
                    logic.updateState();
                    lTimeState = System.currentTimeMillis() + (long)iDelayUpdateState;
                }
                if (EGame.logic.gameover) {
                    E.updateAction(9, 800);
                    iStateCur = 3;
                    EGameView.fill(true);
                } else if (EGame.logic.gameup) {
                    if (++iSpeed > 15) {
                        iSpeed = 1;
                        if (++iLevel > 15) {
                            --iLevel;
                        }
                        iStateCur = 3;
                        EGameView.fill(true);
                    }
                    iDelayUpdateState = Constants.GAME_DELAY[bGameLast][iSpeed - 1];
                    iDelayEventNext = iDelayUpdateState / 3;
                    EGame.logic.gameup = false;
                } else if (lTimeEvent < System.currentTimeMillis() && logic.updateEvent()) {
                    lTimeEvent = System.currentTimeMillis() + (long)iDelayEventNext;
                }
                if (EGame.logic.score <= iArrHighScore[bGameLast]) break;
                EGame.iArrHighScore[EGame.bGameLast] = EGame.logic.score;
                iHighscore = EGame.logic.score;
                break;
            }
            case 3: {
                if (EGameView.bIsOnFill) break;
                GameField.clear();
                logic.updateLevel(iLevel);
                EGameView.fill(false);
                iStateCur = 2;
                break;
            }
            case 2: {
                if (EGameView.bIsOnFill) break;
                iStateCur = 0;
                break;
            }
        }
        if (E.pPos[0] != -1) {
            int[] point = new int[]{E.pPos[0], E.pPos[1]};
            if (point[1] > GUtillScreen.h - Gr2DText.getFontHeight()) {
                if (point[0] < GUtillScreen.w2) {
                    E.kStates[0] = true;
                } else {
                    E.kStates[1] = true;
                }
            } else if (!EGame.logic.active) {
                E.kStates[7] = true;
            } else {
                block5 : switch (bGameLast) {
                    case 0: {
                        int minx = GUtillScreen.w;
                        int maxx = 0;
                        int maxy = 0;
                        int index = EGameView.getBrickIndex(point);
                        if (EGameView.infoPressed(point)) {
                            E.kStates[7] = true;
                            break;
                        }
                        for (int i = 0; i < point.length; ++i) {
                            int[] pos = EGameView.getBrickPos(EGame.logic.figure_pos[i]);
                            if (pos[0] < minx) {
                                minx = pos[0];
                            }
                            if (pos[0] + EGameView.iBrickW > maxx) {
                                maxx = pos[0] + EGameView.iBrickW;
                            }
                            if (pos[1] + EGameView.iBrickH <= maxy) continue;
                            maxy = pos[1] + EGameView.iBrickH;
                        }
                        if (point[0] < minx) {
                            E.kStates[6] = true;
                            break;
                        }
                        if (point[0] > maxx && point[0] <= EGameView.iFieldWidth) {
                            E.kStates[8] = true;
                            break;
                        }
                        if (point[1] > maxy) {
                            E.kStates[10] = true;
                            break;
                        }
                        E.kStates[7] = true;
                        break;
                    }
                    case 1: {
                        GameLogicSnake ls = (GameLogicSnake)logic;
                        int[] pos = EGameView.getBrickPos(EGame.logic.figure_pos[0]);
                        switch (ls.iStepCur) {
                            case 0: {
                                if (point[1] < pos[1]) {
                                    E.kStates[4] = true;
                                    break block5;
                                }
                                if (point[1] > pos[1] + EGameView.iBrickH) {
                                    E.kStates[10] = true;
                                    break block5;
                                }
                                if (point[0] >= pos[0]) break block5;
                                E.kStates[6] = true;
                                break block5;
                            }
                            case 1: {
                                if (point[1] < pos[1]) {
                                    E.kStates[4] = true;
                                    break block5;
                                }
                                if (point[1] > pos[1] + EGameView.iBrickH) {
                                    E.kStates[10] = true;
                                    break block5;
                                }
                                if (point[0] <= pos[0] + EGameView.iBrickW) break block5;
                                E.kStates[8] = true;
                                break block5;
                            }
                            case 2: {
                                if (point[0] < pos[0]) {
                                    E.kStates[6] = true;
                                    break block5;
                                }
                                if (point[0] > pos[0] + EGameView.iBrickW) {
                                    E.kStates[8] = true;
                                    break block5;
                                }
                                if (point[1] >= pos[1]) break block5;
                                E.kStates[4] = true;
                                break block5;
                            }
                            case 3: {
                                if (point[0] < pos[0]) {
                                    E.kStates[6] = true;
                                    break block5;
                                }
                                if (point[0] > pos[0] + EGameView.iBrickW) {
                                    E.kStates[8] = true;
                                    break block5;
                                }
                                if (point[1] <= pos[1] + EGameView.iBrickH) break block5;
                                E.kStates[10] = true;
                                break block5;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (point[0] < EGameView.iFieldWidth / 2) {
                            E.kStates[6] = true;
                            break;
                        }
                        if (point[0] > EGameView.iFieldWidth) break;
                        E.kStates[8] = true;
                        break;
                    }
                    case 2: {
                        if (point[0] < EGameView.iFieldWidth / 2) {
                            E.kStates[6] = true;
                            break;
                        }
                        if (point[0] > EGameView.iFieldWidth) break;
                        E.kStates[8] = true;
                        break;
                    }
                    case 4: {
                        if (point[0] < EGameView.iFieldWidth / 2) {
                            E.kStates[6] = true;
                            break;
                        }
                        if (point[0] > EGameView.iFieldWidth) break;
                        E.kStates[8] = true;
                        break;
                    }
                }
            }
            E.clearPoint();
        }
        if (E.kStates[0]) {
            E.kStates[0] = false;
            E.updateAction(10, -1);
        } else if (E.kStates[1]) {
            E.kStates[1] = false;
            if (iStateCur == 0) {
                iStateCur = 1;
                EGameView.setTextState(4, (byte)1);
            } else if (iStateCur == 1) {
                iStateCur = 0;
                EGameView.setTextState(4, (byte)0);
            }
        }
    }

    public static final void render() {
        if (logic != null) {
            EGameView.render(logic);
        }
    }

    static {
        iLevel = 1;
        iSpeed = 1;
        iHighscore = 0;
        iStateCur = 2;
        iDelayUpdateState = 800;
        iDelayEventNext = 0;
        lTimeState = 0L;
        lTimeEvent = 0L;
        bGameLast = (byte)-1;
        iArrHighScore = new int[5];
    }
}

