/*
 * Decompiled with CFR 0.152.
 */
public class CafeCardsAIUtils
extends CardUtils
implements CafeCardsDefs,
CC_BuildConfig {
    private CafeCardsEngine engParent = null;
    private byte[] tmpHand;
    private byte[] tmpInfo;
    static final int GIN_MELD_TYPE_UNKNOWN = 0;
    static final int GIN_MELD_TYPE_GROUP = 1;
    static final int GIN_MELD_TYPE_RUN = 2;
    static final int GIN_FRAGMENT_N = 0;
    static final int GIN_FRAGMENT_N_SQ = 1;
    static final int GIN_MELDWEIGHT_MELD = 2;
    static final int GIN_MELDWEIGHT_DEADWOOD_BASE = 3;
    static final int GIN_MELDWEIGHT_DEADWOOD_N = 4;
    static final int GIN_MELDWEIGHT_PREFRUN = 5;
    static final int GIN_MELDWEIGHT_PREFRUNSRCH = 6;
    static final int GIN_MELDWEIGHT_EXISTS = 7;
    static final int GIN_MELDWEIGHT_CNCT = 8;
    static final int GIN_MELDWEIGHT_KNOCKABLE = 9;
    static final int GIN_MELDWEIGHT_CLOSED = 10;
    static final int GIN_MELDWEIGHT_GAP = 11;
    static final int GIN_MELDWEIGHT_PROBIFUSED = 12;
    static final int GIN_MELDWEIGHT_SRCHBREAKMELD = 13;
    static final int GIN_MELDWEIGHT_SRCHADDDEAD = 14;
    static final int GIN_MELDWEIGHT_TAKECARD = 15;
    public static final short[] ginMeldWeights_Std = new short[]{55, 15, 200, 6, 16, 0, 50, 70, 40, 400, 40, 50, 0, 50, 70, 100};
    byte[] tmpScoreGrp = null;
    byte[] mutMelds;
    byte[] mutHand;
    byte[] bestMeld;
    byte[] bestHand;
    byte[] mutType;
    static final int FINDMELD_NUMPASS = 20;
    byte[] newMelds;
    private byte[][] cardsPlayed = null;
    private int[] numPlayed = null;
    private boolean[] cardPackPlayed = null;
    private int[] countCardPlayed = null;
    private int[] countSuitPlayed = null;
    private int[][] countCardPlayedBy = null;
    private int[][] countSuitPlayedBy = null;
    private byte[][] countCardPickedBy = null;
    private int[] numCardPicked = null;
    static final int NUM_BLACKBOARD = 10;
    private int[] blackBoard = null;
    static final int BB_WHIST_SUITEMPTY_P0 = 0;
    static final int BB_WHIST_SUITEMPTY_P1 = 1;
    static final int BB_WHIST_SUITEMPTY_P2 = 2;
    static final int BB_WHIST_SUITEMPTY_P3 = 3;
    static final int BB_HEARTS_CHANGETARGET_P0 = 4;
    static final int BB_HEARTS_CHANGETARGET_P1 = 5;
    static final int BB_HEARTS_CHANGETARGET_P2 = 6;
    static final int BB_HEARTS_CHANGETARGET_P3 = 7;
    static final int BB_SPADES_PLAYPATTERN_P0 = 4;
    static final int BB_SPADES_PLAYPATTERN_P1 = 5;
    static final int BB_SPADES_PLAYPATTERN_P2 = 6;
    static final int BB_SPADES_PLAYPATTERN_P3 = 7;
    static final int[] BB_HEARTS_RESET = new int[]{0, 0, 0, 0, -1, -1, -1, -1};
    static final int[] BB_SPADES_RESET = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] BB_GIN_RESET = new int[0];

    protected CafeCardsAIUtils() {
        this.Debug_Message(this, "CLASS_ID=CafeCardsAIUtils instantiating");
    }

    protected final void InitUtils(CafeCardsEngine cafeCardsEngine) {
        if (this.engParent == null) {
            this.engParent = cafeCardsEngine;
            this.tmpHand = new byte[11];
            this.tmpInfo = new byte[11];
        }
    }

    protected final void GinMeldToOpp(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.GinSortByMeld(byArray3, byArray4, false, false);
        for (int i = 0; i < 11; ++i) {
            if (byArray2[i] != 0) continue;
            int n = this.GetFitToGroupGin(byArray[i], byArray3, -1);
            if (n >= 0 && this.GetMeldType(byArray4[n], byArray4, byArray3, 3, 0) != 1) {
                n = -1;
            }
            if (n < 0 && (n = this.GetFitToRunGin(byArray[i], byArray3, 0, -1)) >= 0 && this.GetMeldType(byArray4[n], byArray4, byArray3, 3, 0) != 2) {
                n = -1;
            }
            if (n < 0) continue;
            byArray2[i] = -byArray4[n];
        }
    }

    public final void GinSortByMeld(byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        byte by;
        boolean bl3;
        int n;
        int n2;
        for (n2 = 0; n2 < 11; ++n2) {
            if (byArray[n2] != -1) continue;
            byArray2[n2] = 0;
        }
        if (bl2) {
            this.GinSortByMeld(byArray, byArray2, true, false);
            for (n2 = 0; n2 < 11; ++n2) {
                if (byArray2[n2] <= 0) continue;
                int n3 = n = CardUtils.GetNumMatches(byArray2[n2], byArray2, 11);
                if (n > 5) {
                    n = 5;
                }
                if ((n = 80 - n * 12) < 0) {
                    n = 0;
                }
                int n4 = n2;
                while (n2 < n4 + n3) {
                    int n5 = n2++;
                    byArray2[n5] = (byte)(byArray2[n5] + n);
                }
                --n2;
            }
            bl = true;
        }
        do {
            bl3 = false;
            for (n2 = 1; n2 < 11; ++n2) {
                if (byArray[n2 - 1] > -1 && (byArray[n2] <= -1 || !(byArray2[n2 - 1] <= 0 && byArray2[n2] > 0 || byArray2[n2 - 1] > byArray2[n2] && byArray2[n2] > 0) && (byArray2[n2 - 1] != byArray2[n2] || CardUtils.DecodeCard(byArray[n2 - 1]) <= CardUtils.DecodeCard(byArray[n2])))) continue;
                by = byArray[n2];
                byArray[n2] = byArray[n2 - 1];
                byArray[n2 - 1] = by;
                by = byArray2[n2];
                byArray2[n2] = byArray2[n2 - 1];
                byArray2[n2 - 1] = by;
                bl3 = true;
            }
        } while (bl3);
        if (bl) {
            if (byArray2[0] > 1) {
                by = byArray2[0];
                for (n2 = 0; n2 < 11; ++n2) {
                    if (byArray2[n2] != by) continue;
                    byArray2[n2] = 1;
                }
            }
            for (n2 = 1; n2 < 11; ++n2) {
                if (byArray2[n2] <= 0 || byArray2[n2] <= byArray2[n2 - 1] + 1 || byArray2[n2] >= 90) continue;
                by = byArray2[n2];
                for (n = n2; n < 11; ++n) {
                    if (byArray2[n] != by) continue;
                    byArray2[n] = (byte)(byArray2[n2 - 1] + 1);
                }
            }
        }
    }

    public final void ReadMeld(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        this.ResetMeld(byArray);
        byte by = 1;
        while (n3 < 11) {
            for (int i = n3; i < 11; ++i) {
                byArray[i] = by;
            }
            if (this.GetMeldType(by, byArray, byArray2, n, n2) != 0) {
                while (n3 < 11 && byArray[n3] == by) {
                    ++n3;
                }
                by = (byte)(by + 1);
                continue;
            }
            byArray[n3] = 0;
            ++n3;
        }
    }

    public final void ResetMeld(byte[] byArray) {
        for (int i = 0; i < 11; ++i) {
            byArray[i] = 0;
        }
    }

    private final int GinScoreMeld(byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, short[] sArray, int n, CafeCardsPlayer cafeCardsPlayer) {
        if (this.tmpScoreGrp == null) {
            this.tmpScoreGrp = new byte[11];
        }
        if (by == 0) {
            return 0;
        }
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < 11; ++i) {
            if (byArray[i] != by) continue;
            this.tmpScoreGrp[n2] = byArray2[i];
            ++n2;
        }
        if (n2 < 2) {
            return 0;
        }
        return this.GinScoreMeld(this.tmpScoreGrp, n2, byArray2, byArray3, byArray4, sArray, n, cafeCardsPlayer);
    }

    public final int GinScoreMeld(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, short[] sArray, int n2, CafeCardsPlayer cafeCardsPlayer) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 == 0) {
            return 0;
        }
        if (n < 2) {
            return 0;
        }
        int n7 = 0;
        int n8 = -1;
        n7 = sArray[0] * n + sArray[1] * n * n;
        if (n2 == 2) {
            n7 += sArray[5];
        }
        for (n6 = 0; n6 < n; ++n6) {
            n5 = CardUtils.DecodeCard(byArray[n6]) + 1;
            if (n5 > 10) {
                n5 = 10;
            }
            n7 -= sArray[4] * n5 >> 2;
            if (byArray2 == null || (n4 = this.GetConnectionLevel(byArray[n6], byArray2, null, 0, n2)) <= 0) continue;
            n7 += n4 * sArray[8] / 8;
        }
        if (byArray3 != null && byArray4 != null) {
            n3 = CardUtils.FindInCards(byArray[0], byArray4, 11);
            if (n3 >= 0 && byArray3[n3] > 0) {
                n8 = 1;
                for (n6 = 1; n6 < n; ++n6) {
                    n5 = CardUtils.FindInCards(byArray[n6], byArray4, 11);
                    if (n5 >= 0 && byArray3[n5] != byArray3[n3]) continue;
                    n8 = (byte)(n8 + 1);
                }
            }
            if (n8 == n) {
                n7 += sArray[7];
            }
        }
        n4 = 0;
        int n9 = 0;
        byte by = -1;
        if (cafeCardsPlayer.GetParent().currentGameState == 3) {
            by = cafeCardsPlayer.GetParent().pile[0];
        }
        if (n2 == 2) {
            CardUtils.SortHandSuit(byArray, n, true);
            for (n6 = 0; n6 < n; ++n6) {
                byte by2;
                n3 = CardUtils.DecodeCard(byArray[n6]);
                if (n6 == 0) {
                    if (n3 == 12) {
                        n4 += sArray[10] * 3;
                    }
                    if (n3 == 11) {
                        n4 += 20;
                    }
                    if (n3 == 10) {
                        n4 += sArray[10];
                    }
                } else if (n6 == n - 1) {
                    if (n3 == 0) {
                        n4 += (sArray[10] + sArray[4]) * 3;
                    }
                    if (n3 == 1) {
                        n4 += (10 + sArray[4]) * 2;
                    }
                    if (n3 == 2) {
                        n4 += sArray[10] + sArray[4];
                    }
                }
                if (n6 > 0 && n3 != (by2 = (byte)(CardUtils.DecodeCard(byArray[n6 - 1]) - 1))) {
                    n4 += sArray[11];
                    if (cafeCardsPlayer != null && sArray[12] != 0 && this.GetCardPlayed(by2 = CardUtils.EncodePack(CardUtils.DecodeSuit(byArray[0]), by2), cafeCardsPlayer)) {
                        n4 += sArray[12] * 5;
                        n9 += 2;
                    }
                }
                if (cafeCardsPlayer != null && sArray[12] != 0) {
                    byte by3;
                    if (n6 == 0 && n3 < 12) {
                        by2 = (byte)n3;
                        by2 = (byte)(by2 + 1);
                        by3 = CardUtils.EncodePack(CardUtils.DecodeSuit(byArray[0]), by2);
                        if (by3 != by && this.GetCardPlayed(by3, cafeCardsPlayer) && CardUtils.FindInCards(by3, byArray2, 11) < 0) {
                            n4 += sArray[12] * (1 + n9);
                            ++n9;
                        }
                    }
                    if (n6 == n - 1 && n3 > 0) {
                        by2 = (byte)n3;
                        by2 = (byte)(by2 - 1);
                        by3 = CardUtils.EncodePack(CardUtils.DecodeSuit(byArray[0]), by2);
                        if (by3 != by && this.GetCardPlayed(by3, cafeCardsPlayer) && CardUtils.FindInCards(by3, byArray2, 11) < 0) {
                            n4 += sArray[12] * (1 + n9);
                            ++n9;
                        }
                    }
                }
                if (cafeCardsPlayer.GetSkillLevel() >= 7) continue;
                n9 >>= 1;
            }
        } else if (cafeCardsPlayer != null && sArray[12] > 0) {
            byte by4 = CardUtils.DecodeCard(byArray[0]);
            for (byte by5 = 0; by5 < 4; by5 = (byte)(by5 + 1)) {
                byte by6 = CardUtils.EncodePack(by5, by4);
                if (by6 == by || !this.GetCardPlayed(by6, cafeCardsPlayer) || CardUtils.FindInCards(by6, byArray2, 11) >= 0) continue;
                n4 += sArray[12] * (1 + n9);
                n9 += 1 + n9;
            }
            if (cafeCardsPlayer.GetSkillLevel() < 7) {
                n9 >>= 1;
            }
        }
        if (n4 > (n3 = n7 >> 1)) {
            n4 = n3 + (n4 - n3 >> 2);
        }
        if (n >= 3) {
            n7 += sArray[2] * (n + 1);
            n7 -= n4 >> 2;
        } else {
            n7 -= n4;
        }
        if (cafeCardsPlayer != null) {
            n3 = 10 + (n7 >> 2);
            if (n3 < 0) {
                n3 *= -2;
            }
            if (n3 < 20) {
                n3 = 20;
            }
            n7 += (this.RandX(n3) - this.RandX(n3)) / (3 + cafeCardsPlayer.GetRank());
        }
        return n7;
    }

    final void ValidateMelds(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.GinSortByMeld(byArray, byArray2, true, true);
        for (int i = 1; i <= 11; ++i) {
            this.GetMeldType((byte)i, byArray2, byArray, n2, n);
        }
    }

    final int GetConnectionLevel(byte by, byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n4 = -1;
        if (n2 != 1 && (n4 = this.GetFitToGroupGin(by, byArray, -1)) >= 0) {
            n3 += 7;
        }
        if (n2 != 2 && (n4 = this.GetFitToRunGin(by, byArray, n, -1)) >= 0) {
            n3 += 7;
        }
        if (n4 >= 0 && byArray2 != null && byArray2[n4] > 0) {
            n3 = (n4 = CardUtils.GetNumMatches(byArray2[n4], byArray2, 11)) >= 3 ? (n3 += 2 * n4 + 1) : (n3 += n4);
        }
        return n3;
    }

    final int GinHandScore(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, short[] sArray, int n, int n2, boolean bl, CafeCardsPlayer cafeCardsPlayer) {
        int n3;
        int n4;
        if (this.tmpScoreGrp == null) {
            this.tmpScoreGrp = new byte[11];
        }
        int n5 = 0;
        byte by = 1;
        int n6 = 1;
        int n7 = 0;
        for (n4 = 0; n4 < 11; ++n4) {
            if (byArray2[n4] <= n6) continue;
            n6 = byArray2[n4];
        }
        if (n6 > 90) {
            n6 = 90;
        }
        do {
            int n8;
            if ((n8 = this.GetMeldType(by, byArray2, byArray, n, n2)) == 0) continue;
            n3 = 0;
            for (n4 = 0; n4 < 11; ++n4) {
                if (byArray2[n4] != by) continue;
                this.tmpScoreGrp[n3] = byArray[n4];
                ++n3;
            }
            if (n3 < n) continue;
            n5 += this.GinScoreMeld(this.tmpScoreGrp, n3, byArray, byArray4, byArray3, sArray, n8, cafeCardsPlayer);
        } while ((by = (byte)(by + 1)) <= n6);
        for (n4 = 0; n4 < 11; ++n4) {
            if (byArray[n4] > -1) {
                int n9;
                int n10;
                n3 = CardUtils.GetNumMatches(byArray2[n4], byArray2, 11);
                if (byArray2[n4] == 0) {
                    n3 = 0;
                }
                if ((n10 = CardUtils.DecodeCard(byArray[n4]) + 1) > 10) {
                    n10 = 10;
                }
                if (byArray2[n4] == 0 && (n9 = this.GetConnectionLevel(byArray[n4], byArray, byArray2, n2, 0)) > 0) {
                    n5 += n9 * sArray[8] / 10;
                }
                if (byArray2[n4] == 0 || n3 < 3) {
                    if (n3 > 1) {
                        --n10;
                    }
                    n5 -= n10 * sArray[4] + sArray[3];
                    if (bl && n3 < n) {
                        byArray2[n4] = 0;
                    }
                }
                if (n3 >= 3) continue;
                n7 += n10;
                continue;
            }
            byArray2[n4] = 0;
        }
        if (n7 <= 10) {
            n5 += sArray[9];
        }
        return n5;
    }

    final int GetFitToGroupGin(byte by, byte[] byArray, int n) {
        int n2 = this.RandX(11);
        if (n >= 0) {
            n2 = n;
        }
        if (n2 == 11) {
            n2 = 0;
        }
        int n3 = n2;
        byte by2 = CardUtils.DecodeCard(by);
        do {
            if (byArray[n3] != by && CardUtils.DecodeCard(byArray[n3]) == by2) {
                return n3;
            }
            if (++n3 != 11) continue;
            n3 = 0;
        } while (n3 != n2);
        return -1;
    }

    final int GetFitToRunGin(byte by, byte[] byArray, int n, int n2) {
        int n3 = this.RandX(11);
        if (n2 >= 0) {
            n3 = n2;
        }
        if (n3 == 11) {
            n3 = 0;
        }
        int n4 = n3;
        byte by2 = CardUtils.DecodeCard(by);
        byte by3 = CardUtils.DecodeSuit(by);
        do {
            if (byArray[n4] != by && CardUtils.DecodeSuit(byArray[n4]) == by3 && Math.abs(CardUtils.DecodeCard(byArray[n4]) - by2) <= n + 1) {
                return n4;
            }
            if (++n4 != 11) continue;
            n4 = 0;
        } while (n4 != n3);
        return -1;
    }

    public final boolean IsMeldRun(int n, byte[] byArray, byte[] byArray2) {
        byte by = -1;
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < 11; ++i) {
            if (byArray2[i] != n) continue;
            if (by < 0) {
                by = CardUtils.DecodeSuit(byArray[i]);
                continue;
            }
            if (by != CardUtils.DecodeSuit(byArray[i])) continue;
            return true;
        }
        return false;
    }

    public final boolean IsMeldGroup(byte by, byte[] byArray, byte[] byArray2) {
        byte by2 = -1;
        if (by == 0) {
            return false;
        }
        for (int i = 0; i < 11; ++i) {
            if (byArray2[i] != by) continue;
            if (by2 < 0) {
                by2 = CardUtils.DecodeCard(byArray[i]);
                continue;
            }
            if (by2 != CardUtils.DecodeCard(byArray[i])) continue;
            return true;
        }
        return false;
    }

    private final int GetMeldType(byte by, byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        byte by2 = 0;
        int n8 = 0;
        for (n3 = 0; n3 < 11; ++n3) {
            if (by == byArray[n3]) {
                if (n6 == 0) {
                    by2 = byArray2[n3];
                    ++n6;
                    n5 = n3;
                    continue;
                }
                if (CardUtils.DecodeCard(byArray2[n3]) == CardUtils.DecodeCard(by2)) {
                    if (n4 == 0) {
                        n4 = 1;
                        ++n6;
                        continue;
                    }
                    if (n4 == 1) {
                        ++n6;
                        continue;
                    }
                    n3 = 11;
                    continue;
                }
                if (CardUtils.DecodeSuit(byArray2[n3]) == CardUtils.DecodeSuit(by2)) {
                    if (n8 == 0) {
                        n8 = CardUtils.DecodeCard(byArray2[n3]) > CardUtils.DecodeCard(by2) ? 1 : 2;
                    }
                    if (CardUtils.DecodeCard(byArray2[n3]) <= CardUtils.DecodeCard(by2) + n6 + n2 && CardUtils.DecodeCard(byArray2[n3]) > CardUtils.DecodeCard(by2) && n8 == 1 || CardUtils.DecodeCard(by2) <= CardUtils.DecodeCard(byArray2[n3]) + n6 + n2 && CardUtils.DecodeCard(by2) > CardUtils.DecodeCard(byArray2[n3]) && n8 == 2) {
                        if (n4 == 0) {
                            n4 = 2;
                            ++n6;
                            continue;
                        }
                        if (n4 == 2) {
                            ++n6;
                            continue;
                        }
                        n3 = 11;
                        continue;
                    }
                    n3 = 11;
                    continue;
                }
                n3 = 11;
                continue;
            }
            if (n6 <= 0) continue;
            ++n7;
        }
        if (n6 < n) {
            n3 = 0;
            n4 = 0;
        } else {
            n3 = n5 + n6 + n7;
        }
        for (int i = n3; i < 11; ++i) {
            if (byArray[i] != by) continue;
            byArray[i] = 0;
        }
        return n4;
    }

    final void FindMelds5(byte[] byArray, byte[] byArray2, short[] sArray, int n, int n2, int n3, CafeCardsPlayer cafeCardsPlayer) {
        int n4;
        int n5 = n3 * 20 / 10;
        if (byArray[10] == -1) {
            n5 -= n5 >> 2;
        }
        if (n5 < 8) {
            n5 = 8;
        }
        if (n < 2) {
            n = 2;
        }
        if (this.mutMelds == null) {
            this.bestMeld = new byte[11];
            this.bestHand = new byte[11];
            this.mutHand = new byte[11];
            this.mutMelds = new byte[11];
            this.mutType = new byte[11];
        }
        for (n4 = 0; n4 < 11; ++n4) {
            this.bestMeld[n4] = byArray2[n4];
            this.bestHand[n4] = byArray[n4];
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        int n6 = this.GinHandScore(this.bestHand, this.bestMeld, byArray, byArray2, sArray, n, n2, true, cafeCardsPlayer);
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        byte by = 0;
        for (int i = 0; i < n5; ++i) {
            by = 0;
            for (n4 = 0; n4 < 11; ++n4) {
                this.mutHand[n4] = this.bestHand[n4];
                this.mutMelds[n4] = this.bestMeld[n4];
                if (this.RandX(100) < 30) {
                    this.mutMelds[n4] = 0;
                }
                if (this.mutMelds[n4] > by) {
                    by = this.mutMelds[n4];
                }
                this.mutType[n4] = 0;
                if (this.mutMelds[n4] <= 0) continue;
                if (this.IsMeldGroup(this.mutMelds[n4], this.mutHand, this.mutMelds)) {
                    this.mutType[n4] = 1;
                    continue;
                }
                if (!this.IsMeldRun(this.mutMelds[n4], this.mutHand, this.mutMelds)) continue;
                this.mutType[n4] = 2;
            }
            by = (byte)(by + 1);
            for (int j = 0; j < 15; ++j) {
                int n7 = this.RandX(11);
                if (this.mutHand[n7] == -1) continue;
                byte by2 = CardUtils.DecodeSuit(this.mutHand[n7]);
                byte by3 = CardUtils.DecodeCard(this.mutHand[n7]);
                if (this.mutMelds[n7] != 0 && this.mutType[n7] == 0) {
                    if (this.IsMeldGroup(this.mutMelds[n7], this.mutHand, this.mutMelds)) {
                        this.mutType[n7] = 1;
                    } else if (this.IsMeldRun(this.mutMelds[n7], this.mutHand, this.mutMelds)) {
                        this.mutType[n7] = 2;
                    }
                }
                for (int k = 0; k < 11; ++k) {
                    if (n7 == k || this.mutHand[k] == -1 || this.mutMelds[k] != 0) continue;
                    boolean bl = false;
                    if (this.mutType[n7] != 2 && by3 == CardUtils.DecodeCard(this.mutHand[k]) && this.RandX(100) < 70) {
                        bl = true;
                        this.mutType[n7] = 1;
                    } else if (this.mutType[n7] != 1 && by2 == CardUtils.DecodeSuit(this.mutHand[k]) && this.RandX(100) < 80) {
                        if (this.mutType[n7] == 2) {
                            for (int i2 = 0; i2 < 11; ++i2) {
                                if (this.mutMelds[i2] != this.mutMelds[n7] || Math.abs(CardUtils.DecodeCard(this.mutHand[k]) - CardUtils.DecodeCard(this.mutHand[i2])) > n2 + 1) continue;
                                bl = true;
                                this.mutType[n7] = 2;
                            }
                        } else if (Math.abs(CardUtils.DecodeCard(this.mutHand[k]) - by3) <= n2 + 1) {
                            bl = true;
                            this.mutType[n7] = 2;
                        }
                    }
                    if (!bl) continue;
                    if (this.mutMelds[n7] > 0) {
                        this.mutMelds[k] = this.mutMelds[n7];
                    } else {
                        byte by4 = by;
                        by = (byte)(by + 1);
                        this.mutMelds[n7] = by4;
                        this.mutMelds[k] = by4;
                    }
                    this.mutType[k] = this.mutType[n7];
                }
            }
            this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
            int n8 = this.GinHandScore(this.mutHand, this.mutMelds, byArray, byArray2, sArray, n, n2, true, cafeCardsPlayer);
            if (n8 <= n6) continue;
            this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
            n6 = n8;
            for (n4 = 0; n4 < 11; ++n4) {
                this.bestMeld[n4] = this.mutMelds[n4];
                this.bestHand[n4] = this.mutHand[n4];
            }
            --n5;
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, true);
        for (n4 = 0; n4 < 11; ++n4) {
            byArray2[n4] = this.bestMeld[n4];
            byArray[n4] = this.bestHand[n4];
        }
    }

    final void FindMelds4(byte[] byArray, byte[] byArray2, short[] sArray, int n, int n2, int n3, CafeCardsPlayer cafeCardsPlayer) {
        int n4;
        if (n < 2) {
            n = 2;
        }
        if (this.mutMelds == null) {
            this.bestMeld = new byte[11];
            this.bestHand = new byte[11];
            this.mutHand = new byte[11];
            this.mutMelds = new byte[11];
            this.mutType = new byte[11];
        }
        byte by = 0;
        for (n4 = 0; n4 < 11; ++n4) {
            this.bestMeld[n4] = byArray2[n4];
            this.bestHand[n4] = byArray[n4];
            if (this.bestMeld[n4] <= by) continue;
            by = this.bestMeld[n4];
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        int n5 = this.GinHandScore(this.bestHand, this.bestMeld, byArray, byArray2, sArray, n, n2, true, cafeCardsPlayer);
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        int n6 = 50 + sArray[6];
        if (n6 < 30) {
            n6 = 30;
        }
        if (n6 > 70) {
            n6 = 70;
        }
        int n7 = 10;
        int n8 = -1;
        int n9 = 6;
        int n10 = 100;
        for (n4 = 0; n4 < 11; ++n4) {
            this.mutHand[n4] = this.bestHand[n4];
            this.mutMelds[n4] = this.bestMeld[n4];
        }
        boolean bl = false;
        while (n9 > 0) {
            int n11;
            int n12 = -1;
            int n13 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (this.mutMelds[n7] == 0 || n9 < 4 && this.RandX(100) < 30) {
                n13 = this.GetFitToGroupGin(this.mutHand[n7], this.mutHand, -1);
                n12 = this.GetFitToRunGin(this.mutHand[n7], this.mutHand, n2, -1);
                if (n13 >= 0 && n12 >= 0) {
                    int n14 = CardUtils.GetNumMatches(this.mutMelds[n13], this.mutMelds, 11);
                    int n15 = CardUtils.GetNumMatches(this.mutMelds[n12], this.mutMelds, 11);
                    if (n14 == 2 && n15 > 2 && this.RandX(100) < n10) {
                        n12 = -1;
                    }
                    if (n15 == 2 && n14 > 2 && this.RandX(100) < n10) {
                        n13 = -1;
                    }
                }
                if (n13 >= 0 && n12 >= 0) {
                    bl4 = this.IsMeldRun(this.mutMelds[n13], this.mutHand, this.mutMelds);
                    bl3 = this.IsMeldGroup(this.mutMelds[n12], this.mutHand, this.mutMelds);
                    bl2 = true;
                    if (bl3 && !bl4) {
                        n12 = -1;
                    }
                    if (!bl3 && bl4) {
                        n13 = -1;
                    }
                }
                if (n13 >= 0 && n12 >= 0) {
                    if (this.RandX(100) < n6) {
                        n13 = -1;
                    } else {
                        n12 = -1;
                    }
                }
                if (this.RandX(100) < 10) {
                    n12 = -1;
                    n13 = -1;
                }
            }
            int n16 = n11 = n13 > -1 ? n13 : n12;
            if (n11 >= 0 && n11 != n7) {
                boolean bl5 = false;
                if (this.mutMelds[n11] > 0) {
                    if (n13 > -1) {
                        if (!bl2) {
                            bl4 = this.IsMeldRun(this.mutMelds[n13], this.mutHand, this.mutMelds);
                        }
                        bl5 = bl4;
                    }
                    if (n12 > -1) {
                        if (!bl2) {
                            bl3 = this.IsMeldGroup(this.mutMelds[n12], this.mutHand, this.mutMelds);
                        }
                        bl5 = bl3;
                    }
                }
                byte by2 = this.mutMelds[n11];
                byte by3 = this.mutMelds[n7];
                if (bl5) {
                    if (n8 < 0) {
                        for (n4 = 0; n4 < 11; ++n4) {
                            if (this.mutMelds[n4] != by2) continue;
                            this.mutMelds[n4] = 0;
                        }
                        this.mutMelds[n11] = by = (byte)(by + 1);
                        this.mutMelds[n7] = by;
                        n8 = n7 + 1;
                        bl = true;
                    }
                } else if (this.mutMelds[n11] == 0) {
                    this.mutMelds[n7] = this.mutMelds[n11] = (by = (byte)(by + 1));
                    bl = true;
                } else if (this.mutMelds[n11] != this.mutMelds[n7]) {
                    this.mutMelds[n7] = this.mutMelds[n11];
                    bl = true;
                }
                if (by3 > 0 && (n8 < 0 || n8 == n7 + 1)) {
                    for (n4 = 0; n4 < 11; ++n4) {
                        if (this.mutMelds[n4] != by3) continue;
                        this.mutMelds[n4] = 0;
                    }
                    n8 = n7 + 1;
                    bl = true;
                }
                if (n8 >= 11) {
                    n8 = 0;
                }
            }
            if (bl && (n7 == n8 || n8 < 0)) {
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                int n17 = this.GinHandScore(this.mutHand, this.mutMelds, byArray, byArray2, sArray, n, n2, true, cafeCardsPlayer);
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                if (n17 > n5) {
                    n5 = n17;
                    by = 0;
                    for (n4 = 0; n4 < 11; ++n4) {
                        this.bestMeld[n4] = this.mutMelds[n4];
                        this.bestHand[n4] = this.mutHand[n4];
                        if (this.mutMelds[n4] <= by) continue;
                        by = this.mutMelds[n4];
                    }
                }
                n8 = -1;
                bl = false;
            }
            if (--n7 >= 0) continue;
            n7 += 11;
            if (--n9 > 0) {
                n10 -= 1 + (n10 - 50) / (1 + n9);
            }
            if (n10 >= 50) continue;
            n10 = 50;
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, true);
        for (n4 = 0; n4 < 11; ++n4) {
            byArray2[n4] = this.bestMeld[n4];
            byArray[n4] = this.bestHand[n4];
        }
    }

    final void FindMelds3(byte[] byArray, byte[] byArray2, short[] sArray, int n, int n2, int n3, CafeCardsPlayer cafeCardsPlayer) {
        int n4;
        int n5;
        byte by;
        int n6;
        if (n < 2) {
            n = 2;
        }
        int n7 = n3 * 20 / 10;
        if (byArray[10] == -1) {
            n7 -= n7 >> 2;
        }
        if (n7 < 8) {
            n7 = 8;
        }
        int n8 = 0;
        if (this.mutMelds == null) {
            this.bestMeld = new byte[11];
            this.bestHand = new byte[11];
            this.mutHand = new byte[11];
            this.mutMelds = new byte[11];
            this.mutType = new byte[11];
        }
        byte by2 = 0;
        for (n6 = 0; n6 < 11; ++n6) {
            this.bestMeld[n6] = byArray2[n6];
            this.bestHand[n6] = byArray[n6];
            if (this.bestMeld[n6] <= by2) continue;
            by2 = this.bestMeld[n6];
        }
        if (by2 == 0) {
            this.ReadMeld(this.bestMeld, this.bestHand, n, n2);
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        boolean bl = true;
        while (n7 > 0) {
            boolean bl2 = false;
            by2 = 0;
            by = -1;
            for (n6 = 0; n6 < 11; ++n6) {
                this.mutHand[n6] = this.bestHand[n6];
                this.mutMelds[n6] = this.bestMeld[n6];
                if (this.mutMelds[n6] <= by2) continue;
                by2 = this.mutMelds[n6];
            }
            int n9 = ((n - 1) * 11 >> 1) + (n3 >> 2);
            if ((n9 = this.RandX(n9)) == 0) {
                n9 = 1;
            }
            if (n9 > 7) {
                n9 = 7 + (n9 - 7 >> 2);
            }
            if (bl) {
                n9 = 0;
            }
            n6 = this.RandX(11);
            while (n9-- > 0) {
                if (this.mutHand[n6] != -1 && (this.mutMelds[n6] == 0 || this.RandX(100) < sArray[13])) {
                    int n10 = -1;
                    int n11 = this.GetFitToGroupGin(this.mutHand[n6], this.mutHand, -1);
                    if (n11 > -1 && this.mutMelds[n6] == this.mutMelds[n11] && this.mutMelds[n11] > 0) {
                        n11 = -1;
                    }
                    if (n11 < 0 || this.RandX(100) < sArray[6]) {
                        n10 = this.GetFitToRunGin(this.mutHand[n6], this.mutHand, n2, -1);
                        if (n10 > -1 && this.mutMelds[n6] == this.mutMelds[n10] && this.mutMelds[n10] > 0) {
                            n10 = -1;
                        }
                        if (n10 >= 0) {
                            n11 = -1;
                        }
                    }
                    if (n11 >= 0) {
                        if (this.mutMelds[n11] == 0) {
                            this.mutMelds[n6] = this.mutMelds[n11] = (by2 = (byte)(by2 + 1));
                            if (n > 2) {
                                if (this.RandX(100) < sArray[14]) {
                                    for (n5 = 0; n5 < 11; ++n5) {
                                        if (this.mutMelds[n5] != 0 && CardUtils.GetNumMatches(this.mutMelds[n5], this.mutMelds, 11) != 1 || (n4 = this.GetFitToGroupGin(this.mutHand[n5], this.mutHand, -1)) < 0 || this.mutMelds[n4] != by2) continue;
                                        this.mutMelds[n5] = by2;
                                        bl2 = true;
                                        --n9;
                                    }
                                }
                            } else {
                                bl2 = true;
                            }
                        } else if (CardUtils.GetNumMatches(this.mutMelds[n11], this.mutMelds, 11) == 1 || this.IsMeldGroup(this.mutMelds[n11], this.mutHand, this.mutMelds)) {
                            this.mutMelds[n6] = this.mutMelds[n11];
                            bl2 = true;
                        }
                    } else if (n10 >= 0) {
                        if (this.mutMelds[n10] == 0) {
                            this.mutMelds[n6] = this.mutMelds[n10] = (by2 = (byte)(by2 + 1));
                            if (n > 2) {
                                if (this.RandX(100) < sArray[14]) {
                                    for (n5 = 0; n5 < 11; ++n5) {
                                        if (this.mutMelds[n5] != 0 && CardUtils.GetNumMatches(this.mutMelds[n5], this.mutMelds, 11) != 1 || (n4 = this.GetFitToRunGin(this.mutHand[n5], this.mutHand, n2, -1)) < 0 || this.mutMelds[n4] != by2) continue;
                                        this.mutMelds[n5] = by2;
                                        bl2 = true;
                                        --n9;
                                    }
                                }
                            } else {
                                bl2 = true;
                            }
                        } else if (CardUtils.GetNumMatches(this.mutMelds[n10], this.mutMelds, 11) == 1 || this.IsMeldRun(this.mutMelds[n10], this.mutHand, this.mutMelds)) {
                            this.mutMelds[n6] = this.mutMelds[n10];
                            bl2 = true;
                        }
                    }
                }
                n6 += 1 + this.RandX(9);
                while (n6 >= 11) {
                    n6 -= 11;
                }
            }
            if (bl2 || bl) {
                for (n6 = 0; n6 < 11; ++n6) {
                    if (this.mutMelds[n6] <= 0 || CardUtils.GetNumMatches(this.mutMelds[n6], this.mutMelds, 11) >= n) continue;
                    by = this.mutMelds[n6];
                    for (n4 = n6; n4 < 11; ++n4) {
                        if (this.mutMelds[n4] != by) continue;
                        this.mutMelds[n4] = 0;
                    }
                }
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                int n12 = this.GinHandScore(this.mutHand, this.mutMelds, byArray, byArray2, sArray, n, n2, false, cafeCardsPlayer);
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                if (bl || n12 > n8) {
                    n8 = n12;
                    for (n6 = 0; n6 < 11; ++n6) {
                        this.bestMeld[n6] = this.mutMelds[n6];
                        this.bestHand[n6] = this.mutHand[n6];
                    }
                }
            }
            --n7;
            bl = false;
        }
        for (n6 = 0; n6 < 10; ++n6) {
            if (this.bestMeld[n6] <= 0) continue;
            int n13 = this.GetMeldType(this.bestMeld[n6], this.bestMeld, this.bestHand, 2, 0);
            by = this.bestMeld[n6];
            int n14 = -1;
            if (n13 != 0) {
                for (n5 = n6 + 1; n5 < 11; ++n5) {
                    if (this.bestMeld[n5] <= 0 || this.bestMeld[n5] == by || n13 != this.GetMeldType(this.bestMeld[n5], this.bestMeld, this.bestHand, 2, 0) || (n4 = n13 == 1 ? this.GetFitToGroupGin(this.bestHand[n6], this.bestHand, -1) : this.GetFitToRunGin(this.bestHand[n6], this.bestHand, n2, -1)) < 0 || this.bestMeld[n4] != this.bestMeld[n5] || this.bestMeld[n4] <= 0) continue;
                    n14 = this.bestMeld[n4];
                    break;
                }
            }
            if (n14 <= 0) continue;
            for (n5 = 0; n5 < 11; ++n5) {
                if (this.bestMeld[n5] != by) continue;
                this.bestMeld[n5] = n14;
            }
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, true);
        for (n6 = 0; n6 < 11; ++n6) {
            byArray2[n6] = this.bestMeld[n6];
            byArray[n6] = this.bestHand[n6];
        }
    }

    final void FindMelds3_OLD(byte[] byArray, byte[] byArray2, short[] sArray, int n, int n2, int n3, CafeCardsPlayer cafeCardsPlayer) {
        int n4;
        int n5;
        byte by;
        int n6;
        if (n < 2) {
            n = 2;
        }
        int n7 = n3 * 80 / 10;
        if (byArray[10] == -1) {
            n7 -= n7 >> 2;
        }
        if (n7 < 20) {
            n7 = 20;
        }
        int n8 = 0;
        if (this.mutMelds == null) {
            this.bestMeld = new byte[11];
            this.bestHand = new byte[11];
            this.mutHand = new byte[11];
            this.mutMelds = new byte[11];
            this.mutType = new byte[11];
        }
        byte by2 = 0;
        for (n6 = 0; n6 < 11; ++n6) {
            this.bestMeld[n6] = byArray2[n6];
            this.bestHand[n6] = byArray[n6];
            if (this.bestMeld[n6] <= by2) continue;
            by2 = this.bestMeld[n6];
        }
        if (by2 == 0) {
            this.ReadMeld(this.bestMeld, this.bestHand, n, n2);
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, false);
        int n9 = 50 + (sArray[5] >> 2);
        if (n9 < 30) {
            n9 = 30;
        }
        if (n9 > 70) {
            n9 = 70;
        }
        boolean bl = true;
        while (n7 > 0) {
            boolean bl2 = false;
            by2 = 0;
            by = -1;
            for (n6 = 0; n6 < 11; ++n6) {
                this.mutHand[n6] = this.bestHand[n6];
                this.mutMelds[n6] = this.bestMeld[n6];
                if (this.mutMelds[n6] <= by2) continue;
                by2 = this.mutMelds[n6];
            }
            int n10 = this.RandX(0 + ((n - 1) * 11 >> 1));
            if (n10 == 0) {
                n10 = 1;
            }
            if (bl) {
                n10 = 0;
            }
            n6 = this.RandX(11);
            while (n10-- > 0) {
                n6 += 1 + this.RandX(9);
                while (n6 >= 11) {
                    n6 -= 11;
                }
                if (bl && this.mutHand[10] != -1) {
                    n6 = 10;
                    n10 = 0;
                }
                if (this.mutHand[n6] == -1) continue;
                int n11 = -1;
                int n12 = this.GetFitToGroupGin(this.mutHand[n6], this.mutHand, -1);
                if (n12 > -1 && this.mutMelds[n6] == this.mutMelds[n12] && this.mutMelds[n12] > 0) {
                    n12 = -1;
                }
                if (n12 < 0 || this.RandX(100) < n9) {
                    n11 = this.GetFitToRunGin(this.mutHand[n6], this.mutHand, n2, -1);
                    if (n11 > -1 && this.mutMelds[n6] == this.mutMelds[n11] && this.mutMelds[n11] > 0) {
                        n11 = -1;
                    }
                    if (n11 >= 0) {
                        n12 = -1;
                    }
                }
                if (n12 >= 0) {
                    if (this.mutMelds[n12] == 0) {
                        this.mutMelds[n6] = this.mutMelds[n12] = (by2 = (byte)(by2 + 1));
                        if (this.RandX(100) >= 70) continue;
                        for (n5 = 0; n5 < 11; ++n5) {
                            if (this.mutMelds[n5] != 0 && CardUtils.GetNumMatches(this.mutMelds[n5], this.mutMelds, 11) != 1 || (n4 = this.GetFitToGroupGin(this.mutHand[n5], this.mutHand, -1)) < 0 || this.mutMelds[n4] != by2) continue;
                            this.mutMelds[n5] = by2;
                            bl2 = true;
                        }
                        continue;
                    }
                    if (CardUtils.GetNumMatches(this.mutMelds[n12], this.mutMelds, 11) != 1 && !this.IsMeldGroup(this.mutMelds[n12], this.mutHand, this.mutMelds)) continue;
                    this.mutMelds[n6] = this.mutMelds[n12];
                    bl2 = true;
                    continue;
                }
                if (n11 < 0) continue;
                if (this.mutMelds[n11] == 0) {
                    this.mutMelds[n6] = this.mutMelds[n11] = (by2 = (byte)(by2 + 1));
                    if (this.RandX(100) >= 70) continue;
                    for (n5 = 0; n5 < 11; ++n5) {
                        if (this.mutMelds[n5] != 0 && CardUtils.GetNumMatches(this.mutMelds[n5], this.mutMelds, 11) != 1 || (n4 = this.GetFitToRunGin(this.mutHand[n5], this.mutHand, n2, -1)) < 0 || this.mutMelds[n4] != by2) continue;
                        this.mutMelds[n5] = by2;
                        bl2 = true;
                    }
                    continue;
                }
                if (CardUtils.GetNumMatches(this.mutMelds[n11], this.mutMelds, 11) != 1 && !this.IsMeldRun(this.mutMelds[n11], this.mutHand, this.mutMelds)) continue;
                this.mutMelds[n6] = this.mutMelds[n11];
                bl2 = true;
            }
            if (bl2 || bl) {
                for (n6 = 0; n6 < 11; ++n6) {
                    if (this.mutMelds[n6] <= 0 || CardUtils.GetNumMatches(this.mutMelds[n6], this.mutMelds, 11) >= n) continue;
                    by = this.mutMelds[n6];
                    for (n4 = n6; n4 < 11; ++n4) {
                        if (this.mutMelds[n4] != by) continue;
                        this.mutMelds[n4] = 0;
                    }
                }
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                int n13 = this.GinHandScore(this.mutHand, this.mutMelds, byArray, byArray2, sArray, n, n2, false, cafeCardsPlayer);
                this.GinSortByMeld(this.mutHand, this.mutMelds, true, false);
                if (bl || n13 > n8) {
                    n8 = n13;
                    for (n6 = 0; n6 < 11; ++n6) {
                        this.bestMeld[n6] = this.mutMelds[n6];
                        this.bestHand[n6] = this.mutHand[n6];
                    }
                }
            }
            --n7;
            bl = false;
        }
        for (n6 = 0; n6 < 10; ++n6) {
            if (this.bestMeld[n6] <= 0) continue;
            int n14 = this.GetMeldType(this.bestMeld[n6], this.bestMeld, this.bestHand, 2, 0);
            by = this.bestMeld[n6];
            int n15 = -1;
            if (n14 != 0) {
                for (n5 = n6 + 1; n5 < 11; ++n5) {
                    if (this.bestMeld[n5] <= 0 || this.bestMeld[n5] == by || n14 != this.GetMeldType(this.bestMeld[n5], this.bestMeld, this.bestHand, 2, 0) || (n4 = n14 == 1 ? this.GetFitToGroupGin(this.bestHand[n6], this.bestHand, -1) : this.GetFitToRunGin(this.bestHand[n6], this.bestHand, n2, -1)) < 0 || this.bestMeld[n4] != this.bestMeld[n5] || this.bestMeld[n4] <= 0) continue;
                    n15 = this.bestMeld[n4];
                    break;
                }
            }
            if (n15 <= 0) continue;
            for (n5 = 0; n5 < 11; ++n5) {
                if (this.bestMeld[n5] != by) continue;
                this.bestMeld[n5] = n15;
            }
        }
        this.GinSortByMeld(this.bestHand, this.bestMeld, true, true);
        for (n6 = 0; n6 < 11; ++n6) {
            byArray2[n6] = this.bestMeld[n6];
            byArray[n6] = this.bestHand[n6];
        }
    }

    final void FindMelds1(byte[] byArray, byte[] byArray2, short[] sArray, int n, int n2, CafeCardsPlayer cafeCardsPlayer) {
        int n3;
        int n4;
        if (this.newMelds == null) {
            this.newMelds = new byte[11];
        }
        int n5 = 1;
        for (n4 = 0; n4 < 11; ++n4) {
            this.tmpHand[n4] = byArray[n4];
            this.newMelds[n4] = 0;
        }
        CardUtils.SortHandCard(this.tmpHand, 11, false, true);
        int n6 = 0;
        while (n6 < 11) {
            if (this.tmpHand[n6] != -1 && this.newMelds[n6] == 0) {
                int n7;
                int n8;
                byte by = CardUtils.DecodeCard(this.tmpHand[n6]);
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                n3 = n6;
                int n12 = 0;
                while (n3 < 11 && CardUtils.DecodeCard(this.tmpHand[n3]) == by) {
                    if (this.newMelds[n3] == 0) {
                        ++n9;
                        this.newMelds[n3] = (byte)(99 - n12);
                    }
                    int n13 = 1;
                    byte by2 = CardUtils.DecodeSuit(this.tmpHand[n3]);
                    n8 = by;
                    for (n4 = n3 + 1; n4 < 11; ++n4) {
                        n7 = CardUtils.DecodeCard(this.tmpHand[n4]);
                        if (CardUtils.DecodeSuit(this.tmpHand[n4]) != by2 || this.newMelds[n4] != 0 || n7 > n8 + n2 + n13) continue;
                        ++n13;
                        this.newMelds[n4] = (byte)(99 - n12);
                    }
                    if (n13 > n10) {
                        n10 = n13;
                        n11 = 99 - n12;
                    }
                    ++n3;
                    n12 = (byte)(n12 + 1);
                }
                if (n9 == n10 && n9 >= n) {
                    n8 = this.GinScoreMeld((byte)n11, this.newMelds, this.tmpHand, byArray2, byArray, sArray, 2, cafeCardsPlayer);
                    for (n4 = n6; n4 < n6 + n9; ++n4) {
                        this.tmpInfo[n4] = this.newMelds[n4];
                        this.newMelds[n4] = 90;
                    }
                    n7 = this.GinScoreMeld((byte)90, this.newMelds, this.tmpHand, byArray2, byArray, sArray, 1, cafeCardsPlayer);
                    for (n4 = n6; n4 < n6 + n9; ++n4) {
                        this.newMelds[n4] = this.tmpInfo[n4];
                    }
                    if (n8 > n7) {
                        n9 = 0;
                    } else {
                        n10 = 0;
                    }
                }
                if (n9 > n10 && n9 >= n) {
                    for (n4 = n6; n4 < n6 + n9; ++n4) {
                        this.newMelds[n4] = n5;
                    }
                    n5 = (byte)(n5 + 1);
                    n6 += n9;
                } else if (n10 >= n) {
                    for (n4 = n6; n4 < 11; ++n4) {
                        if (this.newMelds[n4] != n11) continue;
                        this.newMelds[n4] = n5;
                    }
                    n5 = (byte)(n5 + 1);
                } else {
                    ++n6;
                }
                for (n4 = 0; n4 < 11; ++n4) {
                    if (this.newMelds[n4] <= 90) continue;
                    this.newMelds[n4] = 0;
                }
                continue;
            }
            ++n6;
        }
        for (n4 = 0; n4 < 11; ++n4) {
            byArray[n4] = -1;
        }
        n3 = 0;
        for (n6 = 1; n6 < n5; ++n6) {
            for (n4 = 0; n4 < 11; ++n4) {
                if (this.newMelds[n4] != n6) continue;
                byArray[n3] = this.tmpHand[n4];
                byArray2[n3] = (byte)n6;
                ++n3;
            }
        }
        for (n4 = 0; n4 < 11; ++n4) {
            if (this.newMelds[n4] != 0) continue;
            byArray[n3] = this.tmpHand[n4];
            byArray2[n3] = 0;
            ++n3;
        }
    }

    protected void ResetAIStore() {
        int n;
        for (n = 0; n < this.engParent.numPlayers; ++n) {
            int n2;
            this.numPlayed[n] = 0;
            for (n2 = 0; n2 < this.cardsPlayed[n].length; ++n2) {
                this.cardsPlayed[n][n2] = -1;
            }
            if (this.countCardPickedBy == null) continue;
            this.numCardPicked[n] = 0;
            for (n2 = 0; n2 < this.countCardPickedBy[n].length; ++n2) {
                this.countCardPickedBy[n][n2] = -1;
            }
        }
        for (n = 0; n < this.packSize; ++n) {
            this.cardPackPlayed[n] = false;
        }
        for (n = 0; n < 4; ++n) {
            this.countSuitPlayed[n] = 0;
        }
        for (n = 0; n <= 13; ++n) {
            this.countCardPlayed[n] = 0;
        }
    }

    protected void InitAIStore() {
        switch (this.engParent.GetGameType()) {
            case 1: {
                this.cardsPlayed = new byte[4][13];
                this.numPlayed = new int[13];
                break;
            }
            case 2: {
                this.cardsPlayed = new byte[4][13];
                this.numPlayed = new int[13];
                break;
            }
            case 3: {
                this.cardsPlayed = new byte[2][30];
                this.numPlayed = new int[11];
                this.tmpHand = new byte[11];
                this.tmpInfo = new byte[11];
                this.countCardPickedBy = new byte[2][30];
                this.numCardPicked = new int[2];
                break;
            }
            case 0: {
                return;
            }
        }
        this.countCardPlayed = new int[14];
        this.countSuitPlayed = new int[4];
        this.cardPackPlayed = new boolean[this.packSize];
        this.blackBoard = new int[10];
        this.countCardPlayedBy = new int[this.engParent.numPlayers][14];
        this.countSuitPlayedBy = new int[this.engParent.numPlayers][4];
    }

    protected void CountCardPlayed(int n, byte by) {
        int n2 = n;
        int n3 = this.numPlayed[n2];
        this.numPlayed[n2] = n3 + 1;
        this.cardsPlayed[n][n3] = by;
        if (this.numPlayed[n] >= this.numPlayed.length) {
            this.numPlayed[n] = 0;
        }
        if (!this.cardPackPlayed[by]) {
            this.cardPackPlayed[by] = true;
            byte by2 = CardUtils.DecodeCard(by);
            byte by3 = CardUtils.DecodeSuit(by);
            byte by4 = by2;
            this.countCardPlayed[by4] = this.countCardPlayed[by4] + 1;
            byte by5 = by3;
            this.countSuitPlayed[by5] = this.countSuitPlayed[by5] + 1;
            int[] nArray = this.countCardPlayedBy[n];
            byte by6 = by2;
            nArray[by6] = nArray[by6] + 1;
            int[] nArray2 = this.countSuitPlayedBy[n];
            byte by7 = by3;
            nArray2[by7] = nArray2[by7] + 1;
            if (by2 == 0) {
                this.countCardPlayed[13] = this.countCardPlayed[13] + 1;
                int[] nArray3 = this.countCardPlayedBy[n];
                nArray3[13] = nArray3[13] + 1;
            }
        }
    }

    protected void CountCardPicked(int n, byte by) {
        if (this.numCardPicked[n] < 30) {
            this.countCardPickedBy[n][this.numCardPicked[n]] = by;
            int n2 = n;
            this.numCardPicked[n2] = this.numCardPicked[n2] + 1;
        }
    }

    public boolean GetCardPlayed(byte by, CafeCardsPlayer cafeCardsPlayer) {
        if (this.engParent.GetGameType() == 1 && by == CafeCardsDefs.QUEEN_SPADES) {
            return this.cardPackPlayed[by];
        }
        if (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) {
            return this.cardPackPlayed[by];
        }
        return this.RandX(10) < 5;
    }

    public int GetNumCardPlayed(byte by, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null) {
            return this.countCardPlayed[by];
        }
        return cafeCardsPlayer.DataClarity(this.countCardPlayed[by], 0, 4);
    }

    public int GetNumSuitPlayed(byte by, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null) {
            return this.countSuitPlayed[by];
        }
        return cafeCardsPlayer.DataClarity(this.countSuitPlayed[by], 0, 13);
    }

    public int GetNumCardPlayedBy(int n, byte by, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null) {
            return this.countCardPlayedBy[n][by];
        }
        return cafeCardsPlayer.DataClarity(this.countCardPlayedBy[n][by], 0, 4);
    }

    public int GetNumSuitPlayedBy(int n, byte by, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null) {
            return this.countSuitPlayedBy[n][by];
        }
        return cafeCardsPlayer.DataClarity(this.countSuitPlayedBy[n][by], 0, 13);
    }

    public byte GetHighestNotPlayedOfSuit(byte by, CafeCardsPlayer cafeCardsPlayer) {
        byte by2 = -1;
        for (byte by3 = 1; by3 <= 13; by3 = (byte)(by3 + 1)) {
            if (this.cardPackPlayed[CardUtils.EncodePack(by, by3)]) continue;
            by2 = by3;
        }
        if (cafeCardsPlayer == null) {
            return by2;
        }
        return (byte)cafeCardsPlayer.DataClarity(by2, 0, 13);
    }

    public byte GetLowestNotPlayedOfSuit(byte by, CafeCardsPlayer cafeCardsPlayer) {
        byte by2 = -1;
        for (byte by3 = 13; by3 >= 1; by3 = (byte)(by3 - 1)) {
            if (this.cardPackPlayed[CardUtils.EncodePack(by, by3)]) continue;
            by2 = by3;
        }
        if (cafeCardsPlayer == null) {
            return by2;
        }
        return (byte)cafeCardsPlayer.DataClarity(by2, 0, 13);
    }

    public int GetNumSuitPlayedAbove(byte by, byte by2, CafeCardsPlayer cafeCardsPlayer) {
        int n = 0;
        for (byte by3 = by2 = (byte)(by2 + 1); by3 <= 13; by3 = (byte)(by3 + 1)) {
            if (!this.cardPackPlayed[CardUtils.EncodePack(by, by3)]) continue;
            ++n;
        }
        if (cafeCardsPlayer == null) {
            return n;
        }
        return (byte)cafeCardsPlayer.DataClarity(n, 0, 13 - by2 + 1);
    }

    public int GetNumSuitPlayedBelow(byte by, byte by2, CafeCardsPlayer cafeCardsPlayer) {
        int n = 0;
        by2 = (byte)(by2 + 1);
        for (byte by3 = 0; by3 < by2; by3 = (byte)(by3 + 1)) {
            if (!this.cardPackPlayed[CardUtils.EncodePack(by, by3)]) continue;
            ++n;
        }
        if (cafeCardsPlayer == null) {
            return n;
        }
        return (byte)cafeCardsPlayer.DataClarity(n, 0, by2 - 1);
    }

    public int GetNumSuitPlayedAboveBy(int n, byte by, byte by2, CafeCardsPlayer cafeCardsPlayer) {
        int n2 = 0;
        for (int n3 = 0; n3 < this.cardsPlayed[n].length; n3 = (int)((byte)(n3 + 1))) {
            byte by3 = this.cardsPlayed[n][n3];
            if (by3 <= -1 || CardUtils.DecodeSuit(by3) != by || CardUtils.DecodeCardAH(by3) <= by2) continue;
            ++n2;
        }
        if (cafeCardsPlayer == null) {
            return n2;
        }
        return (byte)cafeCardsPlayer.DataClarity(n2, 0, 13 - by2 + 1);
    }

    public int GetNumSuitPlayedBelowBy(int n, byte by, byte by2, CafeCardsPlayer cafeCardsPlayer) {
        int n2 = 0;
        for (int n3 = 0; n3 < this.cardsPlayed[n].length; n3 = (int)((byte)(n3 + 1))) {
            byte by3 = this.cardsPlayed[n][n3];
            if (by3 <= -1 || CardUtils.DecodeSuit(by3) != by || CardUtils.DecodeCardAH(by3) >= by2) continue;
            ++n2;
        }
        if (cafeCardsPlayer == null) {
            return n2;
        }
        return (byte)cafeCardsPlayer.DataClarity(n2, 0, by2 - 1);
    }

    public boolean GetWasCardPlayedBy(int n, byte by, CafeCardsPlayer cafeCardsPlayer) {
        boolean bl;
        boolean bl2 = bl = CardUtils.FindInCards(by, this.cardsPlayed[n], this.cardsPlayed[n].length) >= 0;
        if (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) {
            return bl;
        }
        return this.RandX(100) >= 50;
    }

    public boolean GetWasCardPickedBy(int n, byte by, CafeCardsPlayer cafeCardsPlayer) {
        boolean bl;
        boolean bl2 = bl = CardUtils.FindInCards(by, this.countCardPickedBy[n], this.countCardPickedBy[n].length) >= 0;
        if (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) {
            return bl;
        }
        return this.RandX(100) >= 50;
    }

    public byte GetWinningPileSuitWhist(byte by) {
        int n = this.engParent.TrickWinnerWhist(by);
        if (n < 0) {
            return -1;
        }
        return CardUtils.DecodeSuit(this.engParent.pile[n]);
    }

    public byte GetWinningPileCardWhist(byte by) {
        int n = this.engParent.TrickWinnerWhist(by);
        if (n < 0) {
            return -1;
        }
        return CardUtils.DecodeCardAH(this.engParent.pile[n]);
    }

    public int GetNumSuitInPile(byte by) {
        int n = 0;
        for (int i = 0; i < this.engParent.numPlayers; ++i) {
            if (CardUtils.DecodeSuit(this.engParent.pile[i]) != by) continue;
            ++n;
        }
        return n;
    }

    public boolean GetCardInPile(byte by) {
        for (int i = 0; i < this.engParent.numPlayers; ++i) {
            if (this.engParent.pile[i] != by) continue;
            return true;
        }
        return false;
    }

    public boolean GetCardBlocked(byte by, int n, CafeCardsPlayer cafeCardsPlayer) {
        int n2;
        return (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) && (n2 = this.blackBoard[4 + n]) >= 0 && this.engParent.pile[n2] != -1 && CardUtils.FindInCards(by, this.engParent.changeHand[n], 3) >= 0;
    }

    public boolean GetCardWasPassed(byte by, int n, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) {
            return CardUtils.FindInCards(by, this.engParent.changeHand[n], 3) >= 0;
        }
        return this.RandX(100) >= 50;
    }

    public boolean GetSuitBlockedAbove(byte by, byte by2, int n, CafeCardsPlayer cafeCardsPlayer) {
        int n2 = 0;
        int n3 = this.blackBoard[4 + n];
        for (byte by3 = by2 = (byte)(by2 + 1); by3 <= 13; by3 = (byte)(by3 + 1)) {
            ++n2;
            if (this.cardPackPlayed[CardUtils.EncodePack(by, by3)]) {
                --n2;
                continue;
            }
            if (n3 < 0 || this.engParent.pile[n3] == -1 || CardUtils.FindInCards(CardUtils.EncodePack(by, by3), this.engParent.changeHand[n], 3) < 0) continue;
            --n2;
        }
        if (cafeCardsPlayer != null) {
            n2 = cafeCardsPlayer.DataClarity(n2, 0, 13 - by2 + 1);
        }
        return n2 == 0;
    }

    public byte GetSuitHighestPlayable(byte by, int n, CafeCardsPlayer cafeCardsPlayer) {
        byte by2 = 0;
        int n2 = this.blackBoard[4 + n];
        for (byte by3 = 0; by3 <= 13; by3 = (byte)(by3 + 1)) {
            boolean bl;
            byte by4 = CardUtils.EncodePack(by, by3);
            if (this.cardPackPlayed[by4]) continue;
            boolean bl2 = bl = n2 >= 0 && this.engParent.pile[n2] != -1 && CardUtils.FindInCards(by4, this.engParent.changeHand[n], 3) >= 0;
            if (bl) continue;
            by2 = by3;
        }
        if (cafeCardsPlayer != null) {
            by2 = (byte)cafeCardsPlayer.DataClarity(by2, 0, 13);
        }
        return by2;
    }

    public byte GetSuitLowestPlayable(byte by, int n, int n2, CafeCardsPlayer cafeCardsPlayer) {
        int n3 = 0;
        int n4 = this.blackBoard[4 + n];
        for (int n5 = 13; n5 >= n2; n5 = (byte)(n5 - 1)) {
            boolean bl;
            byte by2 = CardUtils.EncodePack(by, (byte)n5);
            if (this.cardPackPlayed[by2]) continue;
            boolean bl2 = bl = n4 >= 0 && this.engParent.pile[n4] != -1 && CardUtils.FindInCards(by2, this.engParent.changeHand[n], 3) >= 0;
            if (bl) continue;
            n3 = n5;
        }
        if (cafeCardsPlayer != null) {
            n3 = (byte)cafeCardsPlayer.DataClarity(n3, 0, 13);
        }
        return (byte)n3;
    }

    protected void ClearBlackBoard(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.blackBoard[i] = nArray[i];
        }
    }

    protected void SetBlackBoard(int n, int n2) {
        this.blackBoard[n] = n2;
    }

    protected int GetBlackBoard(int n) {
        return this.blackBoard[n];
    }

    public boolean GetSuitEmptyWhistPlayer(byte by, int n, CafeCardsPlayer cafeCardsPlayer) {
        if (cafeCardsPlayer == null || cafeCardsPlayer.DataClarity(5, 0, 10) == 5) {
            int n2 = 1 << by;
            return (this.blackBoard[0 + n] & n2) != 0;
        }
        return this.RandX(100) >= 70;
    }
}

