/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.Intro;

public class TileMap {
    private byte[] m_tileMapData;
    private short[] m_objectData;
    private short[] m_animData;
    private int m_viewportX;
    private int m_viewportY;
    private int m_viewportW;
    private int m_viewportH;
    private int m_cameraX;
    private int m_cameraY;
    private SDKImage m_tilesetImage;
    private boolean m_initialised;
    private int m_width;
    private int m_height;
    private SDKImage m_offscreenBuffer;
    private boolean m_useOffscreenBuffer;
    private boolean m_redrawWholeBuffer;
    private int m_oldWorldX;
    private int m_oldWorldY;
    private int m_blitX;
    private int m_blitY;
    private TileMap m_linkedTileMap;

    public final void setCameraX(int n) {
        this.m_cameraX = n;
    }

    public final void setCameraY(int n) {
        this.m_cameraY = n;
    }

    public final int getWidth() {
        return this.m_width;
    }

    public final int getHeight() {
        return this.m_height;
    }

    public final int getTileSizeX() {
        return 16;
    }

    public final int getTileSizeY() {
        return 8;
    }

    public final int coordTileToWorldX(int n) {
        return n << 20;
    }

    public final int coordTileToWorldY(int n) {
        return n << 19;
    }

    public void setTilesetImage(SDKImage sDKImage) {
        this.m_tilesetImage = sDKImage;
    }

    public final int getObjectCount() {
        if (this.m_objectData != null) {
            return this.m_objectData.length / 3;
        }
        return 0;
    }

    public final short[] getObjectData() {
        return this.m_objectData;
    }

    public final int getAnimCount() {
        if (this.m_animData != null) {
            return this.m_animData.length / 3;
        }
        return 0;
    }

    public final short[] getAnimData() {
        return this.m_animData;
    }

    public TileMap() {
        this.m_objectData = null;
        this.m_tilesetImage = null;
        this.m_initialised = false;
        this.m_viewportX = 0;
        this.m_viewportY = 0;
        this.m_viewportW = 0;
        this.m_viewportH = 0;
        this.m_cameraX = 0;
        this.m_cameraY = 0;
    }

    public TileMap(int n, SDKImage sDKImage) {
        this.m_objectData = null;
        this.m_tilesetImage = null;
        this.m_initialised = false;
        this.m_viewportX = 0;
        this.m_viewportY = 0;
        this.m_viewportW = 0;
        this.m_viewportH = 0;
        this.m_cameraX = 0;
        this.m_cameraY = 0;
        this.load(n);
        if (sDKImage != null) {
            this.setTilesetImage(sDKImage);
        }
    }

    public TileMap(int n, int n2, SDKImage sDKImage) {
        int n3 = n;
        int n4 = n2;
        this.m_tilesetImage = sDKImage;
        this.m_width = n3;
        this.m_height = n4;
        int n5 = n3 * n4;
        byte[] byArray = new byte[n5];
        for (int i = 0; i < n5; ++i) {
            byArray[i] = 0;
        }
        this.m_tileMapData = byArray;
        this.m_objectData = null;
        this.m_initialised = true;
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        if (this.m_useOffscreenBuffer && (this.m_viewportW != n3 || this.m_viewportH != n4)) {
            this.m_offscreenBuffer = null;
            this.m_offscreenBuffer = SDKUtils.createImage(n3, n4);
            this.m_redrawWholeBuffer = true;
        }
        this.m_viewportX = n;
        this.m_viewportY = n2;
        this.m_viewportW = n3;
        this.m_viewportH = n4;
    }

    public void render() {
        int n = Debug.PMGraphics_getClipX();
        int n2 = Debug.PMGraphics_getClipY();
        int n3 = Debug.PMGraphics_getClipWidth();
        int n4 = Debug.PMGraphics_getClipHeight();
        int n5 = this.m_cameraX >> 16;
        int n6 = this.m_cameraY >> 16;
        if (this.m_useOffscreenBuffer) {
            this.renderTilemapToOffscreenBuffer(n5, n6);
        } else {
            int n7 = n;
            int n8 = n2;
            int n9 = n3;
            int n10 = n4;
            if (n7 < this.m_viewportX) {
                n7 = this.m_viewportX;
            }
            if (n8 < this.m_viewportY) {
                n8 = this.m_viewportY;
            }
            if (n7 + n9 > this.m_viewportX + this.m_viewportW) {
                n9 -= n7 + n9 - (this.m_viewportX + this.m_viewportW);
            }
            if (n8 + n10 > this.m_viewportY + this.m_viewportH) {
                n10 -= n8 + n10 - (this.m_viewportY + this.m_viewportH);
            }
            this.renderTilemap(false, n5, n6, n7, n8, n9, n10);
            if (this.m_linkedTileMap != null) {
                this.m_linkedTileMap.renderTilemap(false, n5, n6, n7, n8, n9, n10);
            }
        }
        Debug.PMGraphics_setClip(n, n2, n3, n4);
    }

    private boolean load(int n) {
        int n2;
        int n3;
        int n4;
        if (this.m_initialised) {
            Debug.debug("already loaded... returning");
            return false;
        }
        Intro.ResourceManager_loadBinaryFile(n);
        Cursor.PMFile_readUnsignedByte();
        int n5 = Cursor.PMFile_readUnsignedByte();
        int n6 = Cursor.PMFile_readUnsignedByte();
        Cursor.PMFile_readUnsignedByte();
        Cursor.PMFile_readUnsignedByte();
        this.m_width = n5;
        this.m_height = n6;
        byte[] byArray = new byte[n5 * n6];
        for (n4 = 0; n4 < n5 * n6; ++n4) {
            byArray[n4] = Cursor.PMFile_readByte();
        }
        this.m_tileMapData = byArray;
        n4 = Cursor.PMFile_readUnsignedByte();
        if (n4 > 0) {
            short[] sArray = new short[n4 * 3];
            for (int i = 0; i < sArray.length; ++i) {
                n3 = Cursor.PMFile_readShort();
                sArray[i] = i % 3 == 0 ? Event.MapConstants_IDI_OBJECTLOOKUP_IDS[n3] : n3;
            }
            this.m_objectData = sArray;
        }
        if ((n2 = Cursor.PMFile_readUnsignedByte()) > 0) {
            short[] sArray = new short[n2 * 3];
            for (n3 = 0; n3 < sArray.length; ++n3) {
                short s = Cursor.PMFile_readShort();
                sArray[n3] = n3 % 3 == 0 ? Event.MapConstants_IDI_ANIMLOOKUP_IDS[s] : s;
            }
            this.m_animData = sArray;
        }
        Debug.debug("done reading map file");
        Cursor.PMFile_closeFile();
        this.m_initialised = true;
        return true;
    }

    private void renderTilemap(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        if (bl) {
            Debug.PMGraphics_setTarget(this.m_offscreenBuffer);
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = n & 0xF;
        int n16 = n2 & 7;
        int n17 = 0;
        if (n15 > 0) {
            n17 = 16 - n15;
        }
        int n18 = 0;
        if (n16 > 0) {
            n18 = 8 - n16;
        }
        if (n17 > n5) {
            n17 = n5;
        } else {
            n9 = n5 - n17;
            n10 = n9 >> 4;
            n11 = n9 & 0xF;
        }
        if (n18 > n6) {
            n18 = n6;
        } else {
            n12 = n6 - n18;
            n13 = n12 >> 3;
            n14 = n12 & 7;
        }
        int n19 = n8 = (n2 >> 3) * this.m_width + (n >> 4);
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = n3;
        int n24 = n4;
        int n25 = this.m_tileMapData.length - 1;
        byte[] byArray = this.m_tileMapData;
        SDKImage sDKImage = this.m_tilesetImage;
        if (n18 > 0) {
            if (n17 > 0) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, n17, n18);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21 - n15, n24 - n22 - n16, 0);
                    }
                }
                n23 += n17;
            }
            for (n7 = 0; n7 < n10; ++n7) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, 16, n18);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22 - n16, 0);
                    }
                }
                n23 += 16;
            }
            if (n11 > 0 && n8 >= 0) {
                if (n8 > n25) {
                    return;
                }
                if ((n20 = byArray[n8++] & 0xFF) != 255) {
                    n21 = (n20 & 7) << 4;
                    n22 = n20 >> 3 << 3;
                    Debug.PMGraphics_setClip(n23, n24, n11, n18);
                    Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22 - n16, 0);
                }
            }
            n24 += n18;
            n8 = n19 += this.m_width;
        }
        for (n7 = 0; n7 < n13; ++n7) {
            n23 = n3;
            if (n17 > 0) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, n17, 8);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21 - n15, n24 - n22, 0);
                    }
                }
                n23 += n17;
            }
            for (int i = 0; i < n10; ++i) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, 16, 8);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22, 0);
                    }
                }
                n23 += 16;
            }
            if (n11 > 0 && n8 >= 0) {
                if (n8 > n25) {
                    return;
                }
                if ((n20 = byArray[n8++] & 0xFF) != 255) {
                    n21 = (n20 & 7) << 4;
                    n22 = n20 >> 3 << 3;
                    Debug.PMGraphics_setClip(n23, n24, n11, 8);
                    Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22, 0);
                }
            }
            n24 += 8;
            n8 = n19 += this.m_width;
        }
        if (n14 > 0) {
            n23 = n3;
            if (n17 > 0) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, n17, n14);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21 - n15, n24 - n22, 0);
                    }
                }
                n23 += n17;
            }
            for (n7 = 0; n7 < n10; ++n7) {
                if (n8 >= 0) {
                    if (n8 > n25) {
                        return;
                    }
                    if ((n20 = byArray[n8++] & 0xFF) != 255) {
                        n21 = (n20 & 7) << 4;
                        n22 = n20 >> 3 << 3;
                        Debug.PMGraphics_setClip(n23, n24, 16, n14);
                        Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22, 0);
                    }
                }
                n23 += 16;
            }
            if (n11 > 0 && n8 >= 0) {
                if (n8 > n25) {
                    return;
                }
                if ((n20 = byArray[n8++] & 0xFF) != 255) {
                    n21 = (n20 & 7) << 4;
                    n22 = n20 >> 3 << 3;
                    Debug.PMGraphics_setClip(n23, n24, n11, n14);
                    Debug.PMGraphics_drawImage(sDKImage, n23 - n21, n24 - n22, 0);
                }
            }
        }
        if (bl) {
            Debug.PMGraphics_setTarget(null);
        }
    }

    public void setLinkedTileMap(TileMap tileMap) {
        this.m_linkedTileMap = tileMap;
    }

    public void setUseOffscreenBuffer(boolean bl) {
        if (bl && !this.m_useOffscreenBuffer) {
            if (this.m_viewportW > 0 && this.m_viewportH > 0) {
                this.m_offscreenBuffer = SDKUtils.createImage(this.m_viewportW, this.m_viewportH);
            }
            this.m_redrawWholeBuffer = true;
            this.m_oldWorldX = this.m_cameraX >> 16;
            this.m_oldWorldY = this.m_cameraY >> 16;
            this.m_blitX = 0;
            this.m_blitY = 0;
            this.m_useOffscreenBuffer = true;
        } else if (!bl && this.m_useOffscreenBuffer) {
            this.m_offscreenBuffer = null;
            this.m_useOffscreenBuffer = false;
        }
    }

    public void refreshOffscreenBuffer() {
        this.m_redrawWholeBuffer = true;
    }

    private void renderTilemapToOffscreenBuffer(int n, int n2) {
        int n3 = n - this.m_oldWorldX;
        int n4 = n2 - this.m_oldWorldY;
        int n5 = this.m_viewportW;
        int n6 = this.m_viewportH;
        if (this.m_redrawWholeBuffer || Math.abs(n3) > n5 || Math.abs(n4) > n6) {
            this.m_redrawWholeBuffer = false;
            this.renderTilemap(true, n, n2, 0, 0, n5, n6);
            if (this.m_linkedTileMap != null) {
                this.m_linkedTileMap.m_offscreenBuffer = this.m_offscreenBuffer;
                this.m_linkedTileMap.renderTilemap(true, n, n2, 0, 0, n5, n6);
            }
            this.m_blitX = 0;
            this.m_blitY = 0;
        } else {
            int n7 = this.m_blitX;
            int n8 = this.m_blitY;
            int n9 = this.renderTilemapToOffscreenBufferHoriz(n, n7, n8, n3, this.m_oldWorldX, this.m_oldWorldY);
            if (this.m_linkedTileMap != null) {
                this.m_linkedTileMap.renderTilemapToOffscreenBufferHoriz(n, n7, n8, n3, this.m_oldWorldX, this.m_oldWorldY);
            }
            this.m_blitX = n9;
            int n10 = this.renderTilemapToOffscreenBufferVert(n2, n8, n4, this.m_oldWorldY, n, n9);
            if (this.m_linkedTileMap != null) {
                this.m_linkedTileMap.renderTilemapToOffscreenBufferVert(n2, n8, n4, this.m_oldWorldY, n, n9);
            }
            this.m_blitY = n10;
            int n11 = n5 - this.m_blitX;
            int n12 = n6 - this.m_blitY;
            Debug.PMGraphics_setClip(this.m_viewportX, this.m_viewportY, n11, n12);
            Debug.PMGraphics_drawImage(this.m_offscreenBuffer, this.m_viewportX - this.m_blitX, this.m_viewportY - this.m_blitY, 0);
            Debug.PMGraphics_setClip(this.m_viewportX + n11, this.m_viewportY, this.m_blitX, n12);
            Debug.PMGraphics_drawImage(this.m_offscreenBuffer, n11 + this.m_viewportX, this.m_viewportY - this.m_blitY, 0);
            Debug.PMGraphics_setClip(this.m_viewportX, n12 + this.m_viewportY, n11, this.m_blitY);
            Debug.PMGraphics_drawImage(this.m_offscreenBuffer, this.m_viewportX - this.m_blitX, n12 + this.m_viewportY, 0);
            Debug.PMGraphics_setClip(this.m_viewportX + n11, n12 + this.m_viewportY, this.m_blitX, this.m_blitY);
            Debug.PMGraphics_drawImage(this.m_offscreenBuffer, n11 + this.m_viewportX, n12 + this.m_viewportY, 0);
        }
        this.m_oldWorldX = n;
        this.m_oldWorldY = n2;
    }

    private int renderTilemapToOffscreenBufferHoriz(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.m_viewportW;
        int n8 = this.m_viewportH;
        int n9 = n2 + n4;
        if (n4 > 0) {
            int n10 = n + n7 - n4;
            if (n9 > n7) {
                this.renderTilemap(true, n10, n6, n2, n3, n7 - n2, n8 - n3);
                this.renderTilemap(true, n10, n6 + n8 - n3, n2, 0, n7 - n2, n3);
                this.renderTilemap(true, n10 += n7 - n2, n6, 0, n3, n9 - n7, n8 - n3);
                this.renderTilemap(true, n10, n6 + n8 - n3, 0, 0, n9 - n7, n3);
                n9 -= n7;
            } else {
                this.renderTilemap(true, n10, n6, n2, n3, n4, n8 - n3);
                this.renderTilemap(true, n10, n6 + n8 - n3, n2, 0, n4, n3);
            }
        } else if (n4 < 0) {
            if (n9 < 0) {
                int n11 = n5 - n2;
                this.renderTilemap(true, n11, n6, 0, n3, n2, n8 - n3);
                this.renderTilemap(true, n11, n6 + n8 - n3, 0, 0, n2, n3);
                this.renderTilemap(true, n11 += n9, n6, n7 + n9, n3, -n9, n8 - n3);
                this.renderTilemap(true, n11, n6 + n8 - n3, n7 + n9, 0, -n9, n3);
                n9 = n7 + n9;
            } else {
                this.renderTilemap(true, n, n6, n9, n3, -n4, n8 - n3);
                this.renderTilemap(true, n, n6 + n8 - n3, n9, 0, -n4, n3);
            }
        }
        return n9;
    }

    private int renderTilemapToOffscreenBufferVert(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.m_viewportW;
        int n8 = this.m_viewportH;
        int n9 = n2 + n3;
        if (n3 > 0) {
            int n10 = n + n8 - n3;
            if (n9 > n8) {
                this.renderTilemap(true, n5, n10, n6, n2, n7 - n6, n8 - n2);
                this.renderTilemap(true, n5 + n7 - n6, n10, 0, n2, n6, n8 - n2);
                this.renderTilemap(true, n5, n10 += n8 - n2, n6, 0, n7 - n6, n9 - n8);
                this.renderTilemap(true, n5 + n7 - n6, n10, 0, 0, n6, n9 - n8);
                n9 -= n8;
            } else {
                this.renderTilemap(true, n5, n10, n6, n2, n7 - n6, n3);
                this.renderTilemap(true, n5 + n7 - n6, n10, 0, n2, n6, n3);
            }
        } else if (n3 < 0) {
            if (n9 < 0) {
                int n11 = n4 - n2;
                this.renderTilemap(true, n5, n11, n6, 0, n7 - n6, n2);
                this.renderTilemap(true, n5 + n7 - n6, n11, 0, 0, n6, n2);
                this.renderTilemap(true, n5, n11 += n9, n6, n8 + n9, n7 - n6, -n9);
                this.renderTilemap(true, n5 + n7 - n6, n11, 0, n8 + n9, n6, -n9);
                n9 = n8 + n9;
            } else {
                this.renderTilemap(true, n5, n, n6, n9, n7 - n6, -n3);
                this.renderTilemap(true, n5 + n7 - n6, n, 0, n9, n6, -n3);
            }
        }
        return n9;
    }

    public byte[] getTileMapData() {
        return this.m_tileMapData;
    }
}

