/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.TileMap;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;

public class Cursor {
    public static MapObject m_cursorObject;
    public static int m_cursorPosX;
    public static int m_cursorPosZ;
    public static int m_cursorDestX;
    public static int m_cursorDestZ;
    public static boolean m_cursorAtDest;
    public static int m_cursorAtDestTime;
    public static AnimPlayer m_cursorAnimPlayer;
    public static int m_cursorSelectTimer;
    public static int cursorX;
    public static int cursorY;
    public static int m_cursorSelectFlags;
    public static boolean m_cursorSnapping;
    public static boolean m_keyLeft;
    public static boolean m_keyRight;
    public static boolean m_keyDown;
    public static boolean m_keyUp;
    public static final short[] SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS;
    public static Canvas PMFile_canvas;
    public static DataInputStream PMFile_dis;
    public static int PMFile_fileLen;
    public static boolean PMFile_loadScreen;
    public static int PMFile_currentOffset;
    public static int PMFile_currentBin;
    public static int PMFile_currentFile;
    public static short[] PMFile_filesCRC;
    public static byte[] PMFile_filesCache;
    public static int[] PMFile_filesOffset;
    public static byte[] PMFile_filesBin;
    public static int[] PMFile_filesLen;
    public static int PMFile_fileCount;
    private static int PMFile_poly;
    private static int[] PMFile_crcTable;

    public static void stopCursor() {
        m_keyLeft = false;
        m_keyRight = false;
        m_keyDown = false;
        m_keyUp = false;
    }

    public static void processKeysCursor() {
        Cursor.processKeysCursorDirs();
        if (Cursor.keyAnyDir()) {
            StateInGame.clearCameraFollow();
        }
    }

    public static boolean keyAnyDir() {
        return Cursor.keyAnyLeft() || Cursor.keyAnyRight() || Cursor.keyAnyUp() || Cursor.keyAnyDown();
    }

    public static boolean keyAnyLeft() {
        return AnimationManager.PMInput_isHeld(648);
    }

    public static boolean keyAnyRight() {
        return AnimationManager.PMInput_isHeld(1296);
    }

    public static boolean keyAnyUp() {
        return AnimationManager.PMInput_isHeld(416);
    }

    public static boolean keyAnyDown() {
        return AnimationManager.PMInput_isHeld(1600);
    }

    public static void processKeysCursorDirs() {
        m_keyLeft = Cursor.keyAnyLeft();
        m_keyRight = Cursor.keyAnyRight();
        m_keyUp = Cursor.keyAnyUp();
        m_keyDown = Cursor.keyAnyDown();
    }

    public static void processKeysFire() {
        int n;
        int n2;
        StateInGame.clearCameraFollow();
        MapObject mapObject = m_cursorObject;
        if (mapObject != null && m_cursorAtDest) {
            if (mapObject != null && mapObject.equals(StateInGame.m_playerSim)) {
                StateInGame.showQuickLinks();
            } else {
                StateInGame.showContextMenu(mapObject);
            }
        } else if (StateInGame.m_state == 5 && m_cursorAtDest && Main.m_simWorld.isWorldPointWalkable(n2 = Main.m_simWorld.coordScreenToWorldX(m_cursorPosX, m_cursorPosZ), n = Main.m_simWorld.coordScreenToWorldZ(m_cursorPosX, m_cursorPosZ))) {
            StateInGame.processSimAction(76, null, n2, n);
        }
    }

    public static void renderCursor() {
        if (Event.m_eventState == 1) {
            return;
        }
        cursorX = m_cursorPosX;
        cursorY = m_cursorPosZ;
        if (StateInGame.m_quickLinksActive && m_cursorObject != null) {
            cursorX = m_cursorDestX;
            cursorY = m_cursorDestZ;
        }
        cursorX = (cursorX >> 16) + Main.m_simWorld.getCameraPixelX();
        cursorY = (cursorY >> 16) + Main.m_simWorld.getCameraPixelY();
        if (StateInGame.m_quickLinksActive) {
            StateInGame.renderQuickLinksMarker(cursorX, cursorY);
        } else {
            int n;
            AnimationManager.drawAnim(m_cursorAnimPlayer, cursorX, cursorY);
            if (m_cursorAtDest && m_cursorObject != null && m_cursorAtDestTime < 1000 && (n = m_cursorObject.getTooltipStringId()) != 4) {
                int n2 = GameConstants.TextHandler_getStringWidth(n, 1);
                int n3 = GameConstants.TextHandler_getLineHeight(1) - 2;
                int n4 = 3 + n2 + 3;
                int n5 = 2 + n3 + 2;
                int n6 = Math.max(0, cursorX + -5 - n4);
                int n7 = cursorY + -5 - n5;
                AnimationManager.setColor(77);
                Debug.PMGraphics_drawRect(n6, n7, n4, n5);
                AnimationManager.setColor(76);
                Debug.PMGraphics_fillRect(n6 + 1, n7 + 1, n4 - 1, n5 - 1);
                GameConstants.TextHandler_drawString(n, 1, n6 + 3 + (n2 >> 1), n7 + 2, 17);
            }
        }
    }

    public static void updateCursorPosition(int n) {
        int n2;
        int n3;
        int n4;
        if (!m_cursorSnapping) {
            n4 = (m_keyRight ? 65536 : 0) + (m_keyLeft ? -65536 : 0);
            n3 = (m_keyDown ? 65536 : 0) + (m_keyUp ? -65536 : 0);
            if (n4 != 0 || n3 != 0) {
                n2 = IStringConstants.MathExt_Fatan2(n3, n4);
                Cursor.changeCursorSnapCheck(n2, true);
            }
        }
        if (m_cursorSnapping) {
            int n5;
            if (m_cursorObject != null) {
                m_cursorObject.getHotSpot(StateInGame.m_tempInt10);
                m_cursorDestX = StateInGame.m_tempInt10[0];
                m_cursorDestZ = StateInGame.m_tempInt10[1];
            }
            if ((n4 = (StateInGame.m_quickLinksActive ? 19660 : 19660) * n) >= (n5 = IStringConstants.MathExt_Fmag2(n3 = m_cursorDestX - m_cursorPosX >> 8, n2 = m_cursorDestZ - m_cursorPosZ >> 8)) << 8) {
                m_cursorPosX = m_cursorDestX;
                m_cursorPosZ = m_cursorDestZ;
            } else {
                n4 = IStringConstants.MathExt_Fdiv(n4, n5);
                m_cursorPosX += IStringConstants.MathExt_Fmul(n3, n4);
                m_cursorPosZ += IStringConstants.MathExt_Fmul(n2, n4);
            }
            m_cursorAtDest = m_cursorPosX == m_cursorDestX && m_cursorPosZ == m_cursorDestZ;
            m_cursorSnapping = m_cursorSnapping && !m_cursorAtDest;
        } else if (m_cursorSelectTimer <= 0) {
            n4 = n * ((m_keyRight ? 13107 : 0) + (m_keyLeft ? -13107 : 0));
            n3 = n * ((m_keyDown ? 13107 : 0) + (m_keyUp ? -13107 : 0));
            m_cursorPosX += n4;
            m_cursorPosZ += n3;
            if (n4 != 0 || n3 != 0) {
                m_cursorObject = null;
                m_cursorSelectTimer = 0;
                Cursor.clipCursorPos();
                m_cursorDestX = m_cursorPosX;
                m_cursorDestZ = m_cursorPosZ;
                m_cursorAtDest = true;
                m_cursorAtDestTime = 0;
            } else if (m_cursorObject != null && m_cursorAtDest) {
                m_cursorObject.getHotSpot(StateInGame.m_tempInt10);
                m_cursorDestX = StateInGame.m_tempInt10[0];
                m_cursorDestZ = StateInGame.m_tempInt10[1];
                m_cursorPosX = StateInGame.m_tempInt10[0];
                m_cursorPosZ = StateInGame.m_tempInt10[1];
            }
        }
        m_cursorAtDestTime = m_cursorAtDest ? (m_cursorAtDestTime += n) : 0;
    }

    public static void clipCursorPos() {
        TileMap tileMap = Main.m_simWorld.getTileMap();
        int n = (tileMap.getWidth() * tileMap.getTileSizeX() << 16) - 983040;
        int n2 = (tileMap.getHeight() * tileMap.getTileSizeY() << 16) - 983040;
        m_cursorPosX = IStringConstants.MathExt_clip(m_cursorPosX, 983040, n);
        m_cursorPosZ = IStringConstants.MathExt_clip(m_cursorPosZ, 983040, n2);
    }

    public static void updateCursor(int n) {
        if (StateInGame.isCurtainActive()) {
            return;
        }
        if (!StateInGame.m_pauseMenuActive) {
            Cursor.updateCursorPosition(n);
        }
        if (m_cursorObject != null && m_cursorSelectTimer > 0) {
            m_cursorSelectTimer -= n;
        }
        int n2 = m_cursorAtDest && m_cursorObject != null || StateInGame.m_contextMenuActive ? 231 : 230;
        m_cursorAnimPlayer.startAnim(n2, 4);
        m_cursorAnimPlayer.updateAnim(n);
    }

    public static void setCursorObject(MapObject mapObject) {
        m_cursorObject = mapObject;
        if (mapObject != null) {
            mapObject.getHotSpot(StateInGame.m_tempInt10);
            m_cursorDestX = StateInGame.m_tempInt10[0];
            m_cursorDestZ = StateInGame.m_tempInt10[1];
            m_cursorSnapping = true;
            m_cursorAtDestTime = 0;
        } else {
            m_cursorDestX = m_cursorPosX;
            m_cursorDestZ = m_cursorPosZ;
            m_cursorSnapping = false;
        }
    }

    public static void setCursorSelectFlags(int n) {
        m_cursorSelectFlags = n;
        if (m_cursorObject == null || !m_cursorObject.getFlag(n)) {
            Cursor.setCursorObject(null);
        }
    }

    public static MapObject cursorSnapObject(int n, boolean bl) {
        int n2 = StateInGame.m_viewportWidth << 16;
        int n3 = StateInGame.m_viewportHeight << 16;
        int n4 = bl ? 0x2D0000 : 0x190000;
        MapObject mapObject = null;
        long l = (n4 >> 8) * (n4 >> 8);
        int n5 = m_cursorPosX;
        int n6 = m_cursorPosZ;
        int n7 = IStringConstants.MathExt_normaliseAngleRadiansF(n);
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n8 = mapObjectArray.length;
        int n9 = m_cursorSelectFlags;
        for (int i = 0; i < n8; ++i) {
            long l2;
            long l3;
            long l4;
            int n10;
            int n11;
            MapObject mapObject2 = mapObjectArray[i];
            mapObject2.getHotSpot(StateInGame.m_tempInt10);
            int n12 = StateInGame.m_tempInt10[0];
            int n13 = StateInGame.m_tempInt10[1];
            if (mapObject2 != null && mapObject2.equals(m_cursorObject) || !mapObject2.getFlag(n9)) continue;
            int n14 = Math.abs(n5 - n12);
            int n15 = Math.abs(n6 - n13);
            if (n14 > n2 || n15 > n3 || n14 == 0 && n15 == 0 || bl && (n11 = Math.abs(IStringConstants.MathExt_normaliseAngleRadiansF(n7 - (n10 = IStringConstants.MathExt_Fatan2(n13 - n6, n12 - n5))))) >= 51472 || (l4 = (l3 = (long)(n5 - n12 >> 8)) * l3 + (l2 = (long)(n6 - n13 >> 8)) * l2) >= l) continue;
            mapObject = mapObject2;
            l = l4;
        }
        return mapObject;
    }

    public static void changeCursorSnapCheck(int n, boolean bl) {
        MapObject mapObject = Cursor.cursorSnapObject(n, bl);
        if (mapObject != null) {
            Cursor.setCursorObject(mapObject);
            m_cursorSelectTimer = 200;
        }
    }

    public static SDKString SDKStringUtilsHandler_replace(SDKString sDKString, SDKString[] sDKStringArray) {
        return sDKString.replace(sDKStringArray);
    }

    public static SDKString SDKStringUtilsHandler_replaceFirst(SDKString sDKString, SDKString sDKString2) {
        return sDKString.replaceFirst(sDKString2);
    }

    public static SDKString SDKStringUtilsHandler_replaceFirst(SDKString sDKString, String string) {
        return sDKString.replaceFirst(string);
    }

    public static SDKString SDKStringUtilsHandler_intToSdkstring(int n) {
        return new SDKString(Integer.toString(n));
    }

    public static short[] SDKStringUtilsHandler_wrapSDKString(SDKString sDKString, short[] sArray, int n, short s) {
        return SDKUtils.wrapString(sDKString, sArray, n, s);
    }

    public static void SDKStringUtilsHandler_drawWrappedSDKString(SDKString sDKString, short[] sArray, int n, int n2, int n3, int n4, int n5) {
        SDKUtils.drawWrappedString(sDKString, sArray, n, n2, n3, n4, n5);
    }

    public static void SDKStringUtilsHandler_setSDKFont(Object object) {
        SDKUtils.setFont(object);
    }

    public static SDKString SDKStringUtilsHandler_stringToSDKString(String string) {
        return new SDKString(string);
    }

    public static Object SDKStringUtilsHandler_loadSDKFont(SDKImage sDKImage, byte[] byArray) {
        return SDKUtils.loadFont(sDKImage, byArray);
    }

    public static int SDKStringUtilsHandler_loadTextHeader(byte[] byArray) {
        return SDKUtils.loadTextHeader(byArray);
    }

    public static int SDKStringUtilsHandler_chooseLanguage(int n) {
        return SDKUtils.chooseLanguage(n);
    }

    public static String SDKStringUtilsHandler_getAppProp(String string) {
        return SDKMIDlet.getAppProp(string);
    }

    public static void MinigameLanguage_update(int n) {
    }

    public static int PMFile_fileNumber(short s) {
        for (int i = 0; i < PMFile_fileCount; ++i) {
            if (PMFile_filesCRC[i] != s) continue;
            return i;
        }
        Event.PMDebug_println("Cursor.PMFile_fileNumber(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
        return -1;
    }

    public static void PMFile_initBFC() {
        PMFile_currentBin = -1;
        PMFile_currentOffset = 0;
        Cursor.PMFile_initCRC();
        try {
            int n;
            String string = "/head.bfc";
            PMFile_dis = new DataInputStream(string.getClass().getResourceAsStream(string));
            PMFile_fileCount = n = PMFile_dis.readUnsignedShort();
            PMFile_filesCRC = new short[n];
            PMFile_filesCache = new byte[n];
            PMFile_filesOffset = new int[n];
            PMFile_filesBin = new byte[n];
            PMFile_filesLen = new int[n];
            for (int i = 0; i < n; ++i) {
                Cursor.PMFile_filesCRC[i] = (short)PMFile_dis.readUnsignedShort();
                Cursor.PMFile_filesCache[i] = PMFile_dis.readByte();
                Cursor.PMFile_filesOffset[i] = PMFile_dis.readUnsignedByte() << 16 | PMFile_dis.readUnsignedByte() << 8 | PMFile_dis.readUnsignedByte();
                Cursor.PMFile_filesBin[i] = (byte)PMFile_dis.readUnsignedByte();
                Cursor.PMFile_filesLen[i] = PMFile_fileLen = PMFile_dis.readUnsignedByte() << 16 | PMFile_dis.readUnsignedByte() << 8 | PMFile_dis.readUnsignedByte();
            }
        }
        catch (Exception exception) {
            Event.PMDebug_println("Cursor.PMFile_cacheFile(): Exception!");
        }
    }

    public static void PMFile_initCRC() {
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            int n2 = i << 8;
            for (int j = 0; j < 8; ++j) {
                n = ((n ^ n2) & 0x8000) != 0 ? n << 1 ^ PMFile_poly : (n <<= 1);
                n2 <<= 1;
                n &= 0xFFFF;
            }
            Cursor.PMFile_crcTable[i] = n;
        }
    }

    public static short PMFile_calcCRC(String string) {
        int n = 65535;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c >> 8);
            n = (PMFile_crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
            by = (byte)(c & 0xFF);
            n = (PMFile_crcTable[(by ^ n >> 8) & 0xFF] ^ n << 8) & 0xFFFF;
        }
        return (short)(n & 0xFFFF);
    }

    public static byte[] PMFile_fileToByteArrayNoBFC(String string) {
        byte[] byArray;
        if (!Cursor.PMFile_openFile(string)) {
            return null;
        }
        int n = 2048;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                byArray2[n2] = PMFile_dis.readByte();
            }
            byArray = byArray2;
        }
        catch (Exception exception) {
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = byArray2[i];
            }
        }
        return byArray;
    }

    public static byte[] PMFile_fileToByteArray(String string) {
        byte[] byArray = Cursor.PMFile_fileToByteArray(Cursor.PMFile_calcCRC(string));
        if (byArray == null) {
            return Cursor.PMFile_fileToByteArrayNoBFC(string);
        }
        return byArray;
    }

    public static byte[] PMFile_fileToByteArray(short s) {
        if (!Cursor.PMFile_openFile(s)) {
            Event.PMDebug_println("Cursor.PMFile_fileToByteArray(): WARNING! Unable to find file in the bfc. Check /res/bfc.log to make sure the file is in the build.");
            return null;
        }
        byte[] byArray = new byte[PMFile_fileLen];
        Cursor.PMFile_read(byArray, 0, PMFile_fileLen);
        return byArray;
    }

    public static byte[] PMFile_fileToConstByteArray(String string) {
        return Cursor.PMFile_fileToConstByteArray(Cursor.PMFile_calcCRC(string));
    }

    public static byte[] PMFile_fileToConstByteArray(short s) {
        return Cursor.PMFile_fileToByteArray(s);
    }

    public static boolean PMFile_openFile(String string) {
        short s = Cursor.PMFile_calcCRC(string);
        boolean bl = Cursor.PMFile_openFile(s);
        if (bl) {
            return true;
        }
        try {
            Event.PMDebug_println("Cursor.PMFile_openFile(): WARNING! Failed to open file from the bfc. Trying to open it in the jar file.");
            InputStream inputStream = null;
            inputStream = string.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                return false;
            }
            PMFile_dis = new DataInputStream(inputStream);
        }
        catch (Exception exception) {
            Event.PMDebug_println("Cursor.PMFile_openFile(): ERROR! File not found in jar.");
            return false;
        }
        return true;
    }

    public static boolean PMFile_openFile(short s) {
        int n;
        if (PMFile_loadScreen) {
            Main.drawLoading();
        }
        if ((n = Cursor.PMFile_fileNumber(s)) != -1) {
            PMFile_fileLen = PMFile_filesLen[n];
            if (PMFile_currentBin == PMFile_filesBin[n] && PMFile_currentOffset <= PMFile_filesOffset[n]) {
                Cursor.PMFile_skip(PMFile_filesOffset[n] - PMFile_currentOffset);
                return true;
            }
            try {
                if (PMFile_dis != null) {
                    Cursor.PMFile_forceClose();
                }
                PMFile_dis = new DataInputStream(PMFile_canvas.getClass().getResourceAsStream("/" + PMFile_filesBin[n] + ".bfc"));
                PMFile_dis.skip(PMFile_filesOffset[n]);
                PMFile_currentBin = PMFile_filesBin[n];
                PMFile_currentOffset = PMFile_filesOffset[n];
                return true;
            }
            catch (Exception exception) {
                Event.PMDebug_println("Cursor.PMFile_openFile(): ERROR! Exception caught.");
            }
        }
        return false;
    }

    public static void PMFile_skip(int n) {
        PMFile_currentOffset += n;
        try {
            while (n > 0) {
                n = (int)((long)n - PMFile_dis.skip(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] PMFile_read(byte[] byArray, int n, int n2) {
        PMFile_currentOffset += n2;
        try {
            int n3 = 0;
            while (n2 > 0) {
                n3 = PMFile_dis.read(byArray, n, n2);
                n2 -= n3;
                n += n3;
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static short PMFile_readShort() {
        PMFile_currentOffset += 2;
        try {
            return PMFile_dis.readShort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int PMFile_readUnsignedByte() {
        ++PMFile_currentOffset;
        try {
            return PMFile_dis.readUnsignedByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static byte PMFile_readByte() {
        ++PMFile_currentOffset;
        try {
            return PMFile_dis.readByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int PMFile_readInt() {
        PMFile_currentOffset += 4;
        try {
            return PMFile_dis.readInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void PMFile_forceClose() {
        try {
            PMFile_dis.close();
            PMFile_currentFile = -1;
            PMFile_currentBin = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PMFile_dis = null;
    }

    public static void PMFile_closeFile() {
    }

    static {
        SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS = new short[]{643, 512, 87, 638, 507, 639, 508, 640, 509, 641, 510, 642, 511, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 62, -1, 570, 2, 0, 571, 572, 573, 574, 569, 700, 701, 575, 63, 577, 5, 4, 578, 579, 580, 581, 576, 698, 699, 582, 61, 584, 585, 586, 587, 588, 583, 702, 703, 589, 64, 591, 1, 592, 593, 594, 595, 590, 704, 705, 596, 65, 598, 3, 599, 600, 601, 602, 597, 706, 707, 603, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 501, 276, 283, 502, 278, 285, 503, 273, 280, 504, 277, 284, 505, 279, 286, 506, 275, 282, 403, 402, 404, 405, 418, 44, 419, 420, 421, 422, 423, 406, 42, 407, 408, 409, 410, 411, 412, 43, 413, 414, 415, 417, 416, 425, 424, 427, 426, 428, 429, 430, 431, 463, 466, 467, 464, 465, 468, 469, 470, 473, 474, 471, 472, 475, 476, 477, 480, 481, 478, 479, 482, 483, 484, 487, 488, 485, 486, 489, 490, 491, 494, 495, 492, 493, 496, 497, 843, 844, 842, 845, 850, 849, 851, 852, 848, 853, 847, 846, 855, 860, 863, 862, 861, 866, 867, 868, 869, 980, 981, 982, 983, 984, 985, 871, 872, 873, 874, 890, 889, 885, 886, 883, 884, 882, 881, 880, 879, 877, 876, 875, 4, 0, 242, -2, 40, 41, 2, 3, 51, 52, -3, 12, -4, 28, 46, 47, 54, 302, 231, 5, 303, 304, 6, 348, 349, 316, 317, 308, 233, 350, 314, 326, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 310, 234, 311, 312, 344, 313, 237, 319, 345, 346, 347, 320, 321, 342, 236, 343, 318, 309, 235, 339, 11, 341, 340, 26, 315, 238, 322, 323, 324, 325, 327, 328, 305, 232, 306, 307, 351, 352, 353, 243, 293, 245, 246, 802, 803, 933, 937, 248, 250, 38, 253, 44, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 266, 269, 32, 270, 271, 272, 273, 274, 31, 275, 277, 295, 278, 283, 42, 284, 285, 286, 43, 287, 791, 840, 841, 296, 297, 298, 299, 973, 974, 975, 976, 977, 978, 292, 294, 826, 940, 0, 442, 443, 444, 445, 446, 447, 448, 449, 450, 3, 451, 452, 1, 453, 454, 2, 455, 456, 457, 458, 459, 460, 461, 462, 366, 0, 367, 368, 369, 1, 2, 3, 370, 371, 373, 374, 375, 376, 377, 378};
        PMFile_dis = null;
        PMFile_loadScreen = false;
        PMFile_currentOffset = -1;
        PMFile_currentBin = -1;
        PMFile_currentFile = -1;
        PMFile_poly = 4129;
        PMFile_crcTable = new int[256];
    }
}

