/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Controller;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Vector2_short;

public class Viewport
extends Component {
    public byte mSubtype = (byte)-1;
    public boolean mClipChildren;
    public short mOffsetX;
    public short mOffsetY;
    public static final boolean supportsDynamicSerialization;
    public Component m_pLastChild;
    public static final byte typeID;
    public Component m_pFirstChild;
    public static final byte typeNumber;

    public Viewport() {
    }

    public void destruct() {
        while (this.m_pFirstChild != null) {
            this.m_pFirstChild.SetViewport(null);
        }
    }

    public static Viewport Cast(Object object, Viewport viewport) {
        return (Viewport)object;
    }

    public void Term() {
    }

    public void OffsetTo(Vector2_short vector2_short) {
        this.OffsetTo(vector2_short.GetX(), vector2_short.GetY());
    }

    public void OffsetBy(Vector2_short vector2_short) {
        this.OffsetBy(vector2_short.GetX(), vector2_short.GetY());
    }

    public Vector2_short GetOffset() {
        return new Vector2_short(this.mOffsetX, this.mOffsetY);
    }

    public void OnDraw(DisplayContext displayContext) {
        short s = (short)(this.mRect_left - this.mOffsetX);
        short s2 = (short)(this.mRect_top - this.mOffsetY);
        displayContext.OffsetBy(s, s2);
        if (this.mClipChildren) {
            short s3 = displayContext.GetClippingRectLeft();
            short s4 = displayContext.GetClippingRectTop();
            short s5 = displayContext.GetClippingRectWidth();
            short s6 = displayContext.GetClippingRectHeight();
            short s7 = this.mOffsetX;
            short s8 = this.mOffsetY;
            int n = s3 + s5;
            int n2 = s7 + this.mRect_width;
            short s9 = s4 + s6;
            short s10 = s8 + this.mRect_height;
            if (s3 > s7) {
                s7 = s3;
            }
            if (s4 > s8) {
                s8 = s4;
            }
            if (n < n2) {
                n2 = n;
            }
            if (s9 < s10) {
                s10 = s9;
            }
            s9 = (short)(n2 - s7);
            s10 = (short)(s10 - s8);
            if (s9 > 0 && s10 > 0) {
                displayContext.SetClippingRect(s7, s8, s9, s10);
                this.DrawChildList(displayContext);
                displayContext.SetClippingRect(s3, s4, s5, s6);
            }
        } else {
            this.DrawChildList(displayContext);
        }
        displayContext.OffsetBy(-s, -s2);
    }

    public Vector2_short GetDelta() {
        return new Vector2_short(this.GetDeltaX(), this.GetDeltaY());
    }

    public void OffsetBy(short s, short s2) {
        this.mOffsetX = (short)(this.mOffsetX + s);
        this.mOffsetY = (short)(this.mOffsetY + s2);
        super.Invalidate();
    }

    public short GetOffsetX() {
        return this.mOffsetX;
    }

    public short GetOffsetY() {
        return this.mOffsetY;
    }

    public short GetDeltaX() {
        short s = 0;
        if (this.m_pViewport != null) {
            s = this.m_pViewport.GetDeltaX();
        }
        return (short)(s + this.GetRectLeft() - this.mOffsetX);
    }

    public short GetDeltaY() {
        short s = 0;
        if (this.m_pViewport != null) {
            s = this.m_pViewport.GetDeltaY();
        }
        return (short)(s + this.GetRectTop() - this.mOffsetY);
    }

    public void GetRequiredOffsetChange(Vector2_short vector2_short, Component component, boolean bl) {
        Viewport viewport;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (viewport = component.GetViewport(); viewport != null && viewport != this; viewport = viewport.GetViewport()) {
            n3 += viewport.GetRectLeft() - viewport.mOffsetX;
            n4 += viewport.GetRectTop() - viewport.mOffsetY;
        }
        if (viewport == null) {
            vector2_short.SetX((short)0);
            vector2_short.SetY((short)0);
            return;
        }
        int n5 = n3 + component.GetRectLeft() - this.mOffsetX;
        n4 = n4 + component.GetRectTop() - this.mOffsetY;
        n3 = n5 + component.GetRectWidth() - this.mRect_width;
        int n6 = n4 + component.GetRectHeight() - this.mRect_height;
        int n7 = component.GetRectWidth() > this.mRect_width ? 1 : 0;
        boolean bl2 = component.GetRectHeight() > this.mRect_height;
        if (n7 != 0) {
            n7 = bl ? n3 : n5;
            n = n7;
        } else {
            if (n5 < 0) {
                n = n5;
            }
            if (n3 > 0) {
                n = n3;
            }
        }
        if (bl2) {
            n7 = bl ? n6 : n4;
            n2 = n7;
        } else {
            if (n4 < 0) {
                n2 = n4;
            }
            if (n6 > 0) {
                n2 = n6;
            }
        }
        vector2_short.SetX((short)n);
        vector2_short.SetY((short)n2);
    }

    public void ChangeOffsetToShow(Component component, boolean bl) {
        Vector2_short vector2_short = new Vector2_short();
        this.GetRequiredOffsetChange(vector2_short, component, bl);
        this.OffsetBy(vector2_short.GetX(), vector2_short.GetY());
    }

    public void SetClipChildren(boolean bl) {
        this.mClipChildren = bl;
    }

    public void OffsetTo(short s, short s2) {
        this.mOffsetX = s;
        this.mOffsetY = s2;
        super.Invalidate();
    }

    public boolean GetClipChildren() {
        return this.mClipChildren;
    }

    public void SetSubtype(int n) {
        this.mSubtype = (byte)n;
    }

    public int GetSubtype() {
        return this.mSubtype;
    }

    public void OnAttach(boolean bl) {
        super.OnAttach(bl);
        Component component = this.m_pLastChild;
        while (component != null) {
            component.OnAttach(bl);
            component = component.m_pPreviousSibling;
        }
        int n = bl ? 1 : 0;
        this.SendMsg(this, -122, n);
    }

    public void OnChildEvent(Component component) {
        if (this.GetViewport() != null) {
            this.GetViewport().OnChildEvent(component);
        }
    }

    public void ControlValue(int n, boolean bl, Controller controller) {
        if (n == 6) {
            Component component = this.m_pLastChild;
            while (component != null) {
                component.ControlValue(n, bl, controller);
                component = component.m_pPreviousSibling;
            }
        }
        super.ControlValue(n, bl, controller);
    }

    public byte GetTypeID() {
        return 68;
    }

    public static Class AsClass() {
        return null;
    }

    public Viewport(Viewport viewport) {
        this.SetViewport(viewport);
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mOffsetX = package_.SerializeIntrinsic(this.mOffsetX);
        this.mOffsetY = package_.SerializeIntrinsic(this.mOffsetY);
        this.mClipChildren = package_.SerializeIntrinsic(this.mClipChildren);
        this.mSubtype = package_.SerializeIntrinsic(this.mSubtype);
        int n = package_.SerializeIntrinsic((short)0);
        for (int i = 0; i < n; ++i) {
            Component.Cast(package_.SerializePointer((byte)-59, true, false), null).SetViewport(this);
        }
    }

    public void DrawChildList(DisplayContext displayContext) {
        Component component = ((Viewport)component).m_pLastChild;
        while (component != null) {
            if (component.IsVisible()) {
                component.OnDraw(displayContext);
            }
            component = component.m_pPreviousSibling;
        }
    }

    public void SendComponentToBack(Component component) {
        if (this.m_pFirstChild != this.m_pLastChild) {
            this.RemoveChild(component);
            component.m_pPreviousSibling = this.m_pLastChild;
            this.m_pLastChild = component;
        }
    }

    public void BringComponentToFront(Component component) {
        if (this.m_pFirstChild != this.m_pLastChild) {
            this.RemoveChild(component);
            this.AddChild(component);
        }
    }

    public void PutComponentBehind(Component component, Component component2) {
        if (this.m_pFirstChild != this.m_pLastChild && component != component2) {
            this.RemoveChild(component);
            Component component3 = component2.m_pPreviousSibling;
            if (component3 == null) {
                this.m_pFirstChild = component;
            }
            component.m_pPreviousSibling = component3;
            component2.m_pPreviousSibling = component;
        }
    }

    public void PutComponentInFront(Component component, Component component2) {
        if (this.m_pFirstChild != this.m_pLastChild && component != component2) {
            this.RemoveChild(component);
            Component component3 = this.FindNextSibling(component2);
            component.m_pPreviousSibling = component2;
            if (component3 != null) {
                component3.m_pPreviousSibling = component;
                return;
            }
            this.m_pLastChild = component;
        }
    }

    public short GetChildCount() {
        short s = 0;
        Component component = component.m_pLastChild;
        while (component != null) {
            s = (short)(s + 1);
            component = component.m_pPreviousSibling;
        }
        return s;
    }

    public Component GetChild(int n) {
        Component component = component.m_pLastChild;
        for (int i = 0; i < n; ++i) {
            component = component.m_pPreviousSibling;
        }
        return component;
    }

    public void AddChild(Component component) {
        Component component2 = this.m_pFirstChild;
        component.m_pPreviousSibling = null;
        if (component2 != null) {
            component2.m_pPreviousSibling = component;
        } else {
            this.m_pLastChild = component;
        }
        this.m_pFirstChild = component;
        component.Invalidate();
    }

    public void RemoveChild(Component component) {
        Component component2 = component.m_pPreviousSibling;
        Component component3 = this.FindNextSibling(component);
        if (component2 == null) {
            this.m_pFirstChild = component3;
        }
        if (component3 != null) {
            component3.m_pPreviousSibling = component2;
        } else {
            this.m_pLastChild = component2;
        }
        component.m_pPreviousSibling = null;
        component.Invalidate();
    }

    public Component FindNextSibling(Component component) {
        Component component2 = null;
        Component component3 = component3.m_pLastChild;
        while (component3 != null && component != component3) {
            component2 = component3;
            component3 = component3.m_pPreviousSibling;
        }
        return component2;
    }

    public static Viewport[] InstArrayViewport(int n) {
        Viewport[] viewportArray = new Viewport[n];
        for (int i = 0; i < n; ++i) {
            viewportArray[i] = new Viewport();
        }
        return viewportArray;
    }

    public static Viewport[][] InstArrayViewport(int n, int n2) {
        Viewport[][] viewportArray = new Viewport[n][];
        for (int i = 0; i < n; ++i) {
            viewportArray[i] = new Viewport[n2];
            for (int j = 0; j < n2; ++j) {
                viewportArray[i][j] = new Viewport();
            }
        }
        return viewportArray;
    }

    public static Viewport[][][] InstArrayViewport(int n, int n2, int n3) {
        Viewport[][][] viewportArray = new Viewport[n][][];
        for (int i = 0; i < n; ++i) {
            viewportArray[i] = new Viewport[n2][];
            for (int j = 0; j < n2; ++j) {
                viewportArray[i][j] = new Viewport[n3];
                for (int k = 0; k < n3; ++k) {
                    viewportArray[i][j][k] = new Viewport();
                }
            }
        }
        return viewportArray;
    }
}

