/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.bejeweled.Particle;
import ca.jamdat.flight.Application;
import ca.jamdat.flight.BitmapMap;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;

public class ParticleGenerator
extends TimeControlled {
    public int mNbOfSources;
    public Particle[] mParticles;
    public static final int downHalfCircle;
    public static final int circle;
    public static final int upHalfCircle;
    public BitmapMap[] mParticlesBitmapMaps;
    public boolean mIsPaused;
    public int mNextPhysicsUpdateTimer;
    public int mNextParticleIndex;
    public short mRect_width;
    public static final int rightHalfCircle;
    public short mRect_left;
    public short mRect_top;
    public static final int leftHalfCircle;
    public int[] mSources = new int[30];
    public short mRect_height;
    public int mSourcesIndex;
    public int mNbOfParticles;

    public ParticleGenerator() {
        this.mParticlesBitmapMaps = new BitmapMap[2];
        this.mParticles = Particle.InstArrayParticle(165);
        this.FlushParticles();
        this.FlushParticleSources();
    }

    public void destruct() {
    }

    public void OnTime(int n, int n2) {
        int n3;
        if (this.mIsPaused) {
            return;
        }
        this.mNextPhysicsUpdateTimer += n2;
        int n4 = this.mNextPhysicsUpdateTimer > 30 ? 1 : 0;
        n = n4;
        if (this.mNbOfParticles > 0) {
            n3 = 0;
            if (n4 != 0) {
                Application.GetInstance().SetDirty(true);
                n3 = this.mNextPhysicsUpdateTimer / 30;
            }
            for (n4 = 0; n4 < 165; ++n4) {
                if (this.mParticles[n4].GetType() == -1 || this.mParticles[n4].ParticleOnTime(n2, n3)) continue;
                this.mParticles[n4].Init(-1, Short.MAX_VALUE, null);
                --this.mNbOfParticles;
            }
            if (n != 0) {
                this.mNextPhysicsUpdateTimer -= n3 * 30;
            }
        }
        if (this.mNbOfSources > 0) {
            for (n4 = 0; n4 < 6; ++n4) {
                int n5;
                n3 = n4 * 5;
                if (this.mSources[n3] == 0) continue;
                n = n3 + 4;
                this.mSources[n] = n5 = this.mSources[n] + n2;
                if (this.mSources[n3 + 4] <= this.mSources[n3 + 3]) continue;
                this.mSources[n3 + 4] = 0;
                switch (this.mSources[n3]) {
                    case 1: {
                        this.CreateSmallSparks(this.mSources[n3 + 1], this.mSources[n3 + 2]);
                    }
                }
            }
        }
    }

    public void Start() {
        this.mIsPaused = false;
    }

    public void Pause() {
        this.mIsPaused = true;
    }

    public void UnloadResources() {
        this.UnRegisterInGlobalTime();
        for (int i = 0; i < 2; ++i) {
            this.mParticlesBitmapMaps[i] = null;
        }
    }

    public void OnDraw(DisplayContext displayContext) {
        if (this.mIsPaused) {
            return;
        }
        if (this.mNbOfParticles > 0) {
            for (int i = 0; i < 165; ++i) {
                if (!this.mParticles[i].IsVisible()) continue;
                this.mParticles[i].ParticuleOnDraw(displayContext);
            }
        }
    }

    public void Stop() {
        this.FlushParticles();
        this.mIsPaused = true;
    }

    public void LoadResources() {
        Package package_ = GameApp.GetGameAppInstance().GetPackage((byte)9, false);
        for (int i = 0; i < 2; ++i) {
            BitmapMap bitmapMap = this.mParticlesBitmapMaps[i];
            this.mParticlesBitmapMaps[i] = BitmapMap.Cast(package_.GetEntryPoint(0 + i), null);
        }
        this.RegisterInGlobalTime();
    }

    public void FlushParticleSources() {
        this.mSourcesIndex = 0;
        this.mNbOfSources = 0;
        for (int i = 0; i < 30; ++i) {
            this.mSources[i] = 0;
        }
    }

    public void FlushParticles() {
        for (int i = 0; i < 165; ++i) {
            this.mParticles[i].Init(-1, Short.MAX_VALUE, null);
        }
        this.mNextParticleIndex = 0;
        this.mNbOfParticles = 0;
    }

    public void AddParticleSource(int n, int n2, int n3, int n4) {
        int n5;
        if (this.mSourcesIndex >= 6) {
            this.mSourcesIndex = 0;
        }
        if (this.mSources[n5 = this.mSourcesIndex * 5] == 0) {
            ++this.mNbOfSources;
        }
        this.mSources[n5] = n;
        this.mSources[n5 + 1] = n2;
        this.mSources[n5 + 2] = n3;
        this.mSources[n5 + 3] = n4;
        this.mSources[n5 + 4] = n4;
        ++this.mSourcesIndex;
    }

    public void CreateSmallSparksSource(int n, int n2) {
        this.AddParticleSource(1, n, n2, 800);
    }

    public void CreateSelectionSparks(int n, int n2) {
        this.CreateParticleBurst(3, n, n2, 2, 15, 0, 72, 1);
    }

    public void CreateSmallSparks(int n, int n2) {
        this.CreateParticleBurst(0, n, n2, 0, FlMath.Random((short)1, (short)2), 8, 15, 1);
    }

    public void JewelExplosion(int n, int n2, int n3, int n4) {
        if (GameApp.GetGameAppInstance().GetGameState().GetGameType() == 3) {
            n4 = 0;
        }
        this.CreateParticleBurst(1, n, n2, 2, n4, 0, 72, n3 + 231);
    }

    /*
     * WARNING - void declaration
     */
    public int GetSpeedModifier(int n, boolean bl) {
        void var2_8;
        if (n == 2 || bl && (n == 1 || n == 3) || !bl && (n == 4 || n == 0)) {
            void var2_5;
            if (FlMath.Random((short)0, (short)1) == 0) {
                int n2 = -1;
            } else {
                boolean bl2 = true;
            }
            return (int)var2_5;
        }
        if (n == 0 || n == 1) {
            int n3 = -1;
        } else {
            boolean bl3 = true;
        }
        return (int)var2_8;
    }

    public void AddParticle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mNextParticleIndex >= 165) {
            this.mNextParticleIndex = 0;
        }
        if (this.mParticles[this.mNextParticleIndex].GetType() == -1) {
            ++this.mNbOfParticles;
        }
        int n7 = n;
        if (n == 3) {
            n7 = 1;
        }
        this.mParticles[this.mNextParticleIndex].Init(n, n6, this.mParticlesBitmapMaps[n7]);
        this.mParticles[this.mNextParticleIndex].SetTopLeft((short)(n2 - (this.mParticles[this.mNextParticleIndex].GetSize() >> 1)), (short)(n3 - (this.mParticles[this.mNextParticleIndex].GetSize() >> 1)));
        this.mParticles[this.mNextParticleIndex].AddSpeed(n4, n5);
        ++this.mNextParticleIndex;
    }

    public void CreateParticleBurst(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        for (int i = 0; i < n5; ++i) {
            short s = FlMath.Random((short)n6, (short)n7);
            this.AddParticle(n, n2, n3, FlMath.Random((short)n6, (short)n7) * this.GetSpeedModifier(n4, false), s * this.GetSpeedModifier(n4, true), n8);
        }
    }

    public static ParticleGenerator[] InstArrayParticleGenerator(int n) {
        ParticleGenerator[] particleGeneratorArray = new ParticleGenerator[n];
        for (int i = 0; i < n; ++i) {
            particleGeneratorArray[i] = new ParticleGenerator();
        }
        return particleGeneratorArray;
    }

    public static ParticleGenerator[][] InstArrayParticleGenerator(int n, int n2) {
        ParticleGenerator[][] particleGeneratorArray = new ParticleGenerator[n][];
        for (int i = 0; i < n; ++i) {
            particleGeneratorArray[i] = new ParticleGenerator[n2];
            for (int j = 0; j < n2; ++j) {
                particleGeneratorArray[i][j] = new ParticleGenerator();
            }
        }
        return particleGeneratorArray;
    }

    public static ParticleGenerator[][][] InstArrayParticleGenerator(int n, int n2, int n3) {
        ParticleGenerator[][][] particleGeneratorArray = new ParticleGenerator[n][][];
        for (int i = 0; i < n; ++i) {
            particleGeneratorArray[i] = new ParticleGenerator[n2][];
            for (int j = 0; j < n2; ++j) {
                particleGeneratorArray[i][j] = new ParticleGenerator[n3];
                for (int k = 0; k < n3; ++k) {
                    particleGeneratorArray[i][j][k] = new ParticleGenerator();
                }
            }
        }
        return particleGeneratorArray;
    }
}

