/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.BejeweledState;
import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.bejeweled.StretchableFrame;
import ca.jamdat.flight.BitmapMap;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.KeyFrameSequence;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class GameCursor
extends StretchableFrame {
    public int mkMaxCursorWidth;
    public int mkMinCursorHeight;
    public int mCornerAnimPeriod;
    public boolean mGlowingUp;
    public int mLastGrowDir;
    public boolean mEnabled;
    public int mCursorCol;
    public static final int kGrowingState;
    public int mPosCorrectionX;
    public int mResizeState;
    public TimeSystem mpResizeTimeSystem;
    public int mPosCorrectionY;
    public int mCornerAnimTime;
    public int mkMaxCursorHeight;
    public int mStartX;
    public int mStartY;
    public int mCursorRow;
    public int mCurrentCornerFrame;
    public static final int kShrinkingState;
    public int mkMinCursorWidth;
    public KeyFrameSequence mpResizeSequence;
    public int mElementSize;
    public boolean mNeedPositionCorrection;
    public static final int kStableState;

    public GameCursor(Viewport viewport, BitmapMap bitmapMap, int n, int n2, int n3, int n4) {
        super(viewport, bitmapMap, 5);
        this.mStartX = n;
        this.mStartY = n2;
        this.mCursorRow = 3;
        this.mCursorCol = 3;
        this.mElementSize = n3;
        this.mCornerAnimPeriod = 100;
        this.mGlowingUp = true;
        this.mResizeState = 2;
        this.mLastGrowDir = 0;
        this.mkMinCursorWidth = n3 - n4 + 6;
        this.mkMaxCursorWidth = 2 * n3 - n4 + 6;
        this.mkMinCursorHeight = n3 - n4 + 6;
        this.mkMaxCursorHeight = 2 * n3 - n4 + 6;
        this.mComputeBorderOffset = false;
        this.mDrawMiddleSection = false;
        this.mTilesIndexes[0] = 4;
        this.mTilesIndexes[1] = 0;
        this.mTilesIndexes[2] = 12;
        this.mTilesIndexes[3] = 3;
        this.mTilesIndexes[5] = 1;
        this.mTilesIndexes[6] = 20;
        this.mTilesIndexes[7] = 2;
        this.mTilesIndexes[8] = 28;
        Package package_ = GameApp.GetGameAppInstance().GetPackage((byte)15);
        Object object = TimeSystem.Cast(package_.GetEntryPoint(48), null);
        this.mpResizeTimeSystem = object;
        this.mpResizeTimeSystem.Stop();
        this.mpResizeSequence = KeyFrameSequence.Cast(package_.GetEntryPoint(49), null);
        object = new int[2];
        object[0] = this.mkMinCursorWidth;
        object[1] = this.mkMinCursorHeight;
        this.mpResizeSequence.SetKeyFrame(0, (short)0, (int[])object);
        GameApp.GetGameAppInstance().Register(this, true);
        this.ComputeTilingValues();
    }

    public void Show(boolean bl) {
        if (GameApp.GetGameAppInstance().IsPausing() && bl) {
            return;
        }
        this.GetViewport().SetVisible(bl);
        this.Enable(bl);
    }

    public void destruct() {
    }

    public void Enable(boolean bl) {
        this.mEnabled = bl;
    }

    public void OnSelect(int n) {
        Object object = GameApp.GetGameAppInstance().GetPackage((byte)15);
        if (n == 3) {
            this.mCornerAnimPeriod = 50;
            object = BitmapMap.Cast(((Package)object).GetEntryPoint(2), null);
        } else {
            this.mCornerAnimPeriod = 100;
            object = BitmapMap.Cast(((Package)object).GetEntryPoint(1), null);
        }
        this.SetTiles((BitmapMap)object);
    }

    public void OnDirection(int n, int n2) {
        if (this.mEnabled) {
            if (n == 2 || n == 1) {
                switch (n2) {
                    case 1: {
                        --this.mCursorRow;
                        if (this.mCursorRow != -1) break;
                        this.mCursorRow = 7;
                        break;
                    }
                    case -1: {
                        ++this.mCursorRow;
                        if (this.mCursorRow != 8) break;
                        this.mCursorRow = 0;
                        break;
                    }
                    case -3: {
                        ++this.mCursorCol;
                        if (this.mCursorCol != 8) break;
                        this.mCursorCol = 0;
                        break;
                    }
                    case 3: {
                        --this.mCursorCol;
                        if (this.mCursorCol != -1) break;
                        this.mCursorCol = 7;
                    }
                }
                this.UpdateDisplay();
                return;
            }
            if (n == 3) {
                this.Grow(n2);
            }
        }
    }

    public void SetPosition(int n, int n2) {
        this.mCursorRow = n;
        this.mCursorCol = n2;
        this.UpdateDisplay();
    }

    public void Grow(int n) {
        Object object = GameApp.GetGameAppInstance().GetGameState();
        if (n == 3 && (this.mCursorCol == 0 || ((BejeweledState)object).GetJewelAt(this.mCursorRow, this.mCursorCol - 1) == -1) || n == -3 && (this.mCursorCol == 7 || ((BejeweledState)object).GetJewelAt(this.mCursorRow, this.mCursorCol + 1) == -1) || n == 1 && (this.mCursorRow == 0 || ((BejeweledState)object).GetJewelAt(this.mCursorRow - 1, this.mCursorCol) == -1) || n == -1 && (this.mCursorRow == 7 || ((BejeweledState)object).GetJewelAt(this.mCursorRow + 1, this.mCursorCol) == -1)) {
            return;
        }
        this.mNeedPositionCorrection = false;
        object = new int[2];
        switch (n) {
            case 3: {
                this.mNeedPositionCorrection = true;
            }
            case -3: {
                object[0] = this.mkMaxCursorWidth;
                object[1] = this.mkMinCursorHeight;
                break;
            }
            case 1: {
                this.mNeedPositionCorrection = true;
            }
            case -1: {
                object[0] = this.mkMinCursorWidth;
                object[1] = this.mkMaxCursorHeight;
            }
        }
        this.mpResizeSequence.SetKeyFrame(1, (short)300, (int[])object);
        this.mpResizeTimeSystem.SetTimeFlowSpeed(F32.FromInt(1, 16));
        this.mpResizeTimeSystem.Start();
        this.Enable(false);
        this.mLastGrowDir = n;
        this.mResizeState = 0;
    }

    public boolean IsEnabled() {
        return this.mEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void Shrink(boolean bl) {
        void var1_4;
        if (bl) {
            if (this.mLastGrowDir == 3) {
                --this.mCursorCol;
            } else if (this.mLastGrowDir == -3) {
                ++this.mCursorCol;
            } else if (this.mLastGrowDir == -1) {
                ++this.mCursorRow;
            } else if (this.mLastGrowDir == 1) {
                --this.mCursorRow;
            }
            int n = 200;
            boolean bl2 = !this.mNeedPositionCorrection;
            this.mNeedPositionCorrection = bl2;
        } else {
            int n = 400;
        }
        this.mpResizeTimeSystem.SetTimeFlowSpeed(F32.FromInt(-1, 16));
        this.mpResizeTimeSystem.SetTotalTime(300 + var1_4);
        this.mpResizeTimeSystem.Start();
        this.mLastGrowDir = 0;
        this.mResizeState = 1;
    }

    public boolean IsGrowAnimOver() {
        return this.mResizeState == 2;
    }

    public int GetGrowDirection() {
        return this.mLastGrowDir;
    }

    public int GetCursorRow() {
        return this.mCursorRow;
    }

    public int GetCursorCol() {
        return this.mCursorCol;
    }

    public void OnTime(int n, int n2) {
        this.mCornerAnimTime += n2;
        if (this.mCornerAnimTime >= this.mCornerAnimPeriod) {
            if (this.mGlowingUp) {
                ++this.mCurrentCornerFrame;
                if (this.mCurrentCornerFrame >= 8) {
                    this.mCurrentCornerFrame = 6;
                    this.mGlowingUp = false;
                }
            } else {
                --this.mCurrentCornerFrame;
                if (this.mCurrentCornerFrame < 0) {
                    this.mCurrentCornerFrame = 1;
                    this.mGlowingUp = true;
                }
            }
            this.mTilesIndexes[0] = 4 + this.mCurrentCornerFrame;
            this.mTilesIndexes[2] = 12 + this.mCurrentCornerFrame;
            this.mTilesIndexes[6] = 20 + this.mCurrentCornerFrame;
            this.mTilesIndexes[8] = 28 + this.mCurrentCornerFrame;
            this.Invalidate();
            this.mCornerAnimTime = 0;
        }
        if (this.mResizeState != 2) {
            this.mpResizeTimeSystem.OnTime(n, n2);
            super.OnTime(n, n2);
            n2 = this.GetRectWidth();
            n = this.GetRectHeight();
            if (this.mNeedPositionCorrection) {
                this.mPosCorrectionX = this.mkMinCursorWidth - n2;
                this.mPosCorrectionY = this.mkMinCursorHeight - n;
                this.UpdateDisplay();
            }
            if (this.mResizeState == 0) {
                if (n2 == this.mkMaxCursorWidth || n == this.mkMaxCursorHeight) {
                    this.mpResizeTimeSystem.Stop();
                    this.mPosCorrectionX = 0;
                    this.mPosCorrectionY = 0;
                    this.mResizeState = 2;
                    return;
                }
            } else if (n2 == this.mkMinCursorWidth && n == this.mkMinCursorHeight) {
                this.mpResizeTimeSystem.Stop();
                this.mPosCorrectionX = 0;
                this.mPosCorrectionY = 0;
                this.mResizeState = 2;
                this.OnSelect(2);
                this.Enable(true);
            }
        }
    }

    public void Unload() {
        super.UnloadResources();
        GameApp.GetGameAppInstance().UnRegister(this, true);
        this.mpResizeTimeSystem.Stop();
        this.mpResizeTimeSystem = null;
        this.mpResizeSequence = null;
    }

    public void UpdateDisplay() {
        this.GetViewport().SetTopLeft(new Vector2_short((short)(this.mStartX + this.mCursorCol * this.mElementSize + this.mPosCorrectionX), (short)(this.mStartY + this.mCursorRow * this.mElementSize + this.mPosCorrectionY)));
    }
}

