/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.BaseScene;
import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.bejeweled.GameScene;
import ca.jamdat.bejeweled.StretchableFrame;
import ca.jamdat.flight.BitmapMap;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Viewport;

public class CommonResourcesManager
extends TimeControlled {
    public static final int kMenuToMultiPlayerFrameAnim;
    public boolean mSkipOnTimeBeforeAnimStart;
    public int mPaletteTransitionSwitchTime;
    public Sprite mBejeweledLogo;
    public boolean mNeedIntroAnim = true;
    public TimeSystem mpMenuToSingleTimeSystem;
    public StretchableFrame mpHighlightFrame;
    public static final int kMenuGameOverToMenuGenericAnim;
    public int mCurrentAnim = -1;
    public static final int kSinglePlayerToMenuFrameAnim;
    public static final int kFadeOutAnim;
    public static final int kMenuGameOverToMultiAnim;
    public int mQueuedAnim = -1;
    public static final int kMenuGenericToMenuGameOverAnim;
    public StretchableFrame mpMainFrame;
    public boolean mAnimNeedResize;
    public static final int kMultiPlayerToMenuFrameAnim;
    public int mAnimationState = 1;
    public static final int kStartingAnimState;
    public static final int kFadeInAnim;
    public static final int kUnQueuingAnimState;
    public int mCurrentAnimTime;
    public static final int kIdleAnimState;
    public static final int kMenuToSinglePlayerFrameAnim;
    public static final int kNoAnimation;
    public TimeSystem mpOrderedTimeSystem;
    public Viewport mpCommonViewport;
    public boolean mPlayingPaletteTransition;
    public int mCurrentPaletteTransition;
    public static final int kIntroAnim;
    public int mCurrentAnimPeriod;
    public Viewport mpHighlightViewport;
    public Viewport mpFrameViewport;
    public TimeSystem mpCurrentAnimTimeSystem;
    public TimeSystem mpIntroTimeSystem;
    public boolean mReverseAnim;
    public static final int kPlayingAnimState;

    public CommonResourcesManager() {
        Package package_ = GameApp.GetGameAppInstance().GetPackage((byte)10);
        this.mpCommonViewport = Viewport.Cast(package_.GetEntryPoint(10), null);
        this.mpFrameViewport = Viewport.Cast(package_.GetEntryPoint(8), null);
        BitmapMap bitmapMap = null;
        this.mpMainFrame = new StretchableFrame(this.mpFrameViewport, bitmapMap, 1);
        this.mpMainFrame.SendToBack();
        this.mpOrderedTimeSystem = new TimeSystem();
        this.mpOrderedTimeSystem.RegisterInGlobalTime();
        this.mpHighlightViewport = Viewport.Cast(package_.GetEntryPoint(9), null);
        this.mpHighlightFrame = new StretchableFrame(this.mpHighlightViewport, bitmapMap, 4);
        this.mpHighlightViewport.SetVisible(false);
        this.mpMenuToSingleTimeSystem = TimeSystem.Cast(package_.GetEntryPoint(12), null);
        this.mpOrderedTimeSystem.Register(this.mpMenuToSingleTimeSystem);
        this.mpMenuToSingleTimeSystem.Stop();
        this.mpIntroTimeSystem = TimeSystem.Cast(package_.GetEntryPoint(15), null);
        this.mpOrderedTimeSystem.Register(this.mpIntroTimeSystem);
        this.mpIntroTimeSystem.Stop();
    }

    public void destruct() {
        if (this.mBejeweledLogo != null) {
            this.mBejeweledLogo.SetViewport(null);
            this.mBejeweledLogo = null;
        }
        this.mpOrderedTimeSystem.UnRegister(this);
        if (this.mpCurrentAnimTimeSystem != null) {
            this.StopCurrentAnimation();
            this.mpCurrentAnimTimeSystem = null;
        }
        if (this.mpHighlightViewport != null) {
            this.mpHighlightViewport.SetViewport(null);
            this.mpHighlightViewport = null;
            this.mpHighlightFrame.UnloadResources();
            this.mpHighlightFrame = null;
        }
        this.mpOrderedTimeSystem.UnRegister(this.mpMenuToSingleTimeSystem);
        this.mpMenuToSingleTimeSystem = null;
        this.mpOrderedTimeSystem.UnRegister(this.mpIntroTimeSystem);
        this.mpIntroTimeSystem = null;
        this.mpOrderedTimeSystem.UnRegisterInGlobalTime();
        this.mpOrderedTimeSystem = null;
        if (this.mpFrameViewport != null) {
            this.mpMainFrame.UnloadResources();
            this.mpMainFrame = null;
            this.mpFrameViewport.SetViewport(null);
            this.mpFrameViewport = null;
            this.mpCommonViewport.SetViewport(null);
            this.mpCommonViewport = null;
        }
    }

    public Viewport GetCommonViewport() {
        return this.mpCommonViewport;
    }

    public Viewport GetHighlightViewport() {
        return this.mpHighlightViewport;
    }

    public void PlayAnimation(int n, int n2) {
        this.mCurrentAnim = n;
        this.mQueuedAnim = n2;
        this.mAnimNeedResize = false;
        this.mReverseAnim = false;
        switch (this.mCurrentAnim) {
            case 0: {
                this.mReverseAnim = true;
            }
            case 1: {
                if (this.mCurrentAnim == 1) {
                    GameApp.GetGameAppInstance().GetParticleGenerator().Stop();
                    GameApp.GetGameAppInstance().PlaySound(3, true);
                }
                this.mCurrentAnimPeriod = 200;
                break;
            }
            case 3: 
            case 5: {
                this.mReverseAnim = true;
            }
            case 2: 
            case 4: {
                this.mpCurrentAnimTimeSystem = this.mpMenuToSingleTimeSystem;
                this.mCurrentAnimPeriod = 300;
                this.mAnimNeedResize = true;
                break;
            }
            case 9: {
                this.mpCurrentAnimTimeSystem = this.mpIntroTimeSystem;
                this.mCurrentAnimPeriod = 800;
                this.mNeedIntroAnim = false;
            }
        }
        if (this.mpCurrentAnimTimeSystem == null) {
            this.StartRunTimePaletteTransition();
            return;
        }
        this.StartCurrentAnimation();
    }

    public boolean IsPlayingAnimation() {
        return this.mAnimationState != 1;
    }

    public boolean NeedIntroAnimation() {
        return this.mNeedIntroAnim;
    }

    public void ShowBejeweledLogo(boolean bl) {
        Viewport viewport = Viewport.Cast(GameApp.GetGameAppInstance().GetPackage((byte)10).GetEntryPoint(10), null);
        if (bl) {
            this.LoadBejeweledLogo();
            this.mBejeweledLogo.SetViewport(viewport);
            this.mBejeweledLogo.SendToBack();
            viewport.SendComponentToBack(viewport.GetChild(1));
            return;
        }
        this.UnloadBejeweledLogo();
    }

    public void LoadBejeweledLogo() {
        if (this.mBejeweledLogo == null) {
            this.mBejeweledLogo = Sprite.Cast(GameApp.GetGameAppInstance().GetPackage((byte)5).GetEntryPoint(0), null);
        }
        this.mBejeweledLogo.SetVisible(true);
    }

    public void OnTime(int n, int n2) {
        switch (this.mAnimationState) {
            case 0: {
                if (this.mSkipOnTimeBeforeAnimStart) {
                    this.mSkipOnTimeBeforeAnimStart = false;
                    return;
                }
                this.mpCurrentAnimTimeSystem.Start();
                this.mAnimationState = 2;
                return;
            }
            case 2: {
                if (this.mPlayingPaletteTransition) {
                    this.mPaletteTransitionSwitchTime += n2;
                    if (this.mPaletteTransitionSwitchTime >= 50) {
                        while (this.mPaletteTransitionSwitchTime > 50) {
                            this.mPaletteTransitionSwitchTime -= 50;
                            n = this.mCurrentPaletteTransition;
                            int n3 = this.mCurrentAnim == 0 ? -1 : 1;
                            this.mCurrentPaletteTransition = n + n3;
                            if (this.mCurrentPaletteTransition < 0) {
                                this.mCurrentPaletteTransition = 0;
                                break;
                            }
                            if (this.mCurrentPaletteTransition < 4) continue;
                            this.mCurrentPaletteTransition = 3;
                            break;
                        }
                        this.mpHighlightFrame.AdjustHighLightFrame(this.mCurrentPaletteTransition);
                    }
                }
                if (this.mAnimNeedResize) {
                    this.SynchronizeViewportsSizes();
                }
                if (this.mCurrentAnimTime > this.mCurrentAnimPeriod) {
                    if (this.mPlayingPaletteTransition) {
                        this.StopRunTimePaletteTransition();
                        return;
                    }
                    this.StopCurrentAnimation();
                    return;
                }
                this.mCurrentAnimTime += n2;
                return;
            }
            case 3: {
                BaseScene baseScene = (BaseScene)GameApp.GetGameAppInstance().GetScene();
                if (baseScene != null && baseScene.GetPackageID() == 16) {
                    boolean bl = this.mQueuedAnim == 2 || this.mQueuedAnim == 4 || this.mQueuedAnim == 0;
                    ((GameScene)baseScene).ShowJewelViewport(bl);
                }
                this.PlayAnimation(this.mQueuedAnim, -1);
            }
        }
    }

    public void UnloadBejeweledLogo() {
        if (this.mBejeweledLogo != null) {
            this.mBejeweledLogo.SetViewport(null);
            this.mBejeweledLogo = null;
        }
    }

    public void StartCurrentAnimation() {
        if (this.mAnimationState == 1) {
            this.mpOrderedTimeSystem.Register(this);
        }
        if (this.mAnimNeedResize) {
            this.mpOrderedTimeSystem.Register(this.mpMainFrame);
            this.mpOrderedTimeSystem.Register(this.mpHighlightFrame);
        }
        if (this.mReverseAnim) {
            this.mpCurrentAnimTimeSystem.SetTimeFlowSpeed(F32.FromInt(-1, 16));
            this.mpCurrentAnimTimeSystem.SetTotalTime(this.mCurrentAnimPeriod);
        } else {
            this.mpCurrentAnimTimeSystem.SetTimeFlowSpeed(F32.FromInt(1, 16));
        }
        this.mCurrentAnimTime = 0;
        if (this.mCurrentAnim == 9) {
            this.mSkipOnTimeBeforeAnimStart = false;
            this.mpCurrentAnimTimeSystem.Start();
            this.mAnimationState = 2;
            return;
        }
        this.mSkipOnTimeBeforeAnimStart = true;
        this.mAnimationState = 0;
    }

    public void StopCurrentAnimation() {
        if (this.mAnimNeedResize) {
            this.mpOrderedTimeSystem.UnRegister(this.mpMainFrame);
            this.mpOrderedTimeSystem.UnRegister(this.mpHighlightFrame);
        }
        if (this.mCurrentAnim == 0) {
            GameApp.GetGameAppInstance().GetParticleGenerator().Start();
        }
        this.mpCurrentAnimTimeSystem.Stop();
        this.mpCurrentAnimTimeSystem = null;
        this.mCurrentAnimPeriod = 0;
        this.mCurrentAnim = -1;
        this.UnqueueAnimation();
    }

    public void StartRunTimePaletteTransition() {
        if (this.mAnimationState == 1) {
            this.mpOrderedTimeSystem.Register(this);
        }
        if (this.mCurrentAnim == 1) {
            this.mCurrentPaletteTransition = 0;
        } else if (this.mCurrentAnim == 0) {
            this.mCurrentPaletteTransition = 3;
        }
        this.mpHighlightViewport.SetVisible(true);
        this.mpHighlightFrame.AdjustHighLightFrame(this.mCurrentPaletteTransition);
        this.mCurrentAnimTime = 0;
        this.mPaletteTransitionSwitchTime = 0;
        this.mAnimationState = 2;
        this.mPlayingPaletteTransition = true;
    }

    public void StopRunTimePaletteTransition() {
        if (this.mCurrentAnim == 0) {
            this.mpHighlightViewport.SetVisible(false);
            GameApp.GetGameAppInstance().GetParticleGenerator().Start();
        }
        this.mCurrentAnimPeriod = 0;
        this.mCurrentAnim = -1;
        this.mPlayingPaletteTransition = false;
        this.UnqueueAnimation();
    }

    public void UnqueueAnimation() {
        if (this.mQueuedAnim != -1) {
            if (this.mAnimationState == 1) {
                this.mpOrderedTimeSystem.Register(this);
            }
            this.mAnimationState = 3;
            return;
        }
        this.mpOrderedTimeSystem.UnRegister(this);
        this.mAnimationState = 1;
    }

    public void SynchronizeViewportsSizes() {
        FlRect flRect = new FlRect(this.mpFrameViewport.GetRect());
        flRect.SetHeight(240 - (flRect.GetTop() + 0));
        this.mpFrameViewport.SetRect(flRect);
        flRect.MoveBy(0, 0);
        flRect.SetWidth(flRect.GetWidth() + 0);
        flRect.SetHeight(flRect.GetHeight() + 0);
        this.mpHighlightViewport.SetRect(flRect);
    }

    public static CommonResourcesManager[] InstArrayCommonResourcesManager(int n) {
        CommonResourcesManager[] commonResourcesManagerArray = new CommonResourcesManager[n];
        for (int i = 0; i < n; ++i) {
            commonResourcesManagerArray[i] = new CommonResourcesManager();
        }
        return commonResourcesManagerArray;
    }

    public static CommonResourcesManager[][] InstArrayCommonResourcesManager(int n, int n2) {
        CommonResourcesManager[][] commonResourcesManagerArray = new CommonResourcesManager[n][];
        for (int i = 0; i < n; ++i) {
            commonResourcesManagerArray[i] = new CommonResourcesManager[n2];
            for (int j = 0; j < n2; ++j) {
                commonResourcesManagerArray[i][j] = new CommonResourcesManager();
            }
        }
        return commonResourcesManagerArray;
    }

    public static CommonResourcesManager[][][] InstArrayCommonResourcesManager(int n, int n2, int n3) {
        CommonResourcesManager[][][] commonResourcesManagerArray = new CommonResourcesManager[n][][];
        for (int i = 0; i < n; ++i) {
            commonResourcesManagerArray[i] = new CommonResourcesManager[n2][];
            for (int j = 0; j < n2; ++j) {
                commonResourcesManagerArray[i][j] = new CommonResourcesManager[n3];
                for (int k = 0; k < n3; ++k) {
                    commonResourcesManagerArray[i][j][k] = new CommonResourcesManager();
                }
            }
        }
        return commonResourcesManagerArray;
    }
}

