/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;

public class MapObjectSim
extends MapObject {
    private int tempApp = 0;
    private int m_appearance = 0;
    private int m_subAppearance = 0;
    private int m_appearanceBank = 0;
    public int m_simState = 0;
    private int m_simStateTime = 0;
    private int m_posture = 0;
    private int m_targetPosture = 0;
    private MapObject m_postureObject;
    private int m_simAction = 0;
    private int m_simActionPhaseIndex = 0;
    private int m_simPhase = 0;
    private MapObject m_simActionArg1;
    private int m_simActionArg2 = 0;
    private int m_simActionArg3 = 0;
    public int m_simActionPrev = 0;
    private int m_queuedSimAction = 0;
    private MapObject m_queuedSimActionArg1;
    private int m_queuedSimActionArg2 = 0;
    private int m_queuedSimActionArg3 = 0;
    private int m_needFlags = 0;
    private int m_needCheckTimer = 0;
    private MapObject m_occupiedObject;
    private int m_occupiedIndex = 0;
    private int m_walkDestXF = 0;
    private int m_walkDestZF = 0;
    private int[] m_walkPath;
    private int m_walkPathLength = 0;
    private int m_walkPathPoint = 0;
    private boolean m_walkStopShort = false;
    private int m_checkPosXF = 0;
    private int m_checkPosZF = 0;
    private int m_conversationSim = 0;
    private int m_conversationTimer = 0;
    private int m_lastConversationTimer = 0;
    private int m_feedbackSubAppearance = 0;
    private boolean m_feedbackLoop = false;
    private boolean m_feedbackRealTime = false;
    private int m_feedbackTime = 0;
    private int m_feedbackFloaterAnimId = 0;
    private boolean m_feedbackAnimateFloater = false;
    private int m_feedbackSpeechBubbleAnimId = 0;
    private int[] m_speakMale = new int[]{8, 8};
    private int[] m_speakFemale = new int[]{9, 9};
    public MapObject lastInteractivityObject;
    private int callOverDirectionDir = -551;
    private int[] GENERIC_NEEDS = new int[]{2, 8, 16, 4, 64};

    public MapObjectSim() {
        this.isMapObject = false;
    }

    public final void init(int n, int n2, int n3, int n4, int n5) {
        super.init(n, n2, n3, n4, n5);
        this.m_simState = 0;
        this.m_posture = 0;
        this.m_targetPosture = 0;
        this.m_postureObject = null;
        this.m_simAction = 0;
        this.m_simPhase = 0;
        this.m_simActionArg1 = null;
        this.m_queuedSimAction = -1;
        this.m_queuedSimActionArg1 = null;
        this.m_occupiedObject = null;
        this.m_occupiedIndex = -1;
        this.m_walkDestXF = this.getPosX();
        this.m_walkDestZF = this.getPosZ();
        this.m_walkPath = new int[529];
        this.m_conversationSim = -1;
        this.m_lastConversationTimer = -1;
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = true;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackSpeechBubbleAnimId = -1;
        this.getAnimPlayerCreate(2);
        this.getAnimPlayerCreate(1);
        this.m_appearance = -1;
        this.m_subAppearance = 0;
        if (StateInGame.isMapMode()) {
            this.m_appearanceBank = Main.m_simData.getSimMacromapColor(n5);
            this.setAppearance(2);
        } else {
            if (Main.m_simData.getSimAttribute(n5, 0) == 0) {
                this.setAppearance(0);
            } else {
                this.setAppearance(1);
            }
            this.m_appearanceBank = -1;
        }
        if (n5 == 0) {
            int n6 = 0;
            while (true) {
                if (n6 >= 6) break;
                if (Main.m_simData.m_buffsActive[n6] != -1) {
                    this.startBuff(Main.m_simData.m_buffsActive[n6]);
                }
                ++n6;
            }
        }
        this.simStateTransition(1);
    }

    public final void update(int n) {
        if (this.m_simStateTime < 3000000) {
            this.m_simStateTime += n;
        }
        if (this.m_conversationSim != -1) {
            this.m_conversationTimer += n;
            if (this.m_conversationTimer > 20000) {
                GlobalConstants.PMDebug_println("conversation timed out");
                this.clearConversation();
            }
        } else if (this.m_lastConversationTimer >= 0) {
            this.m_lastConversationTimer += n;
            if (this.m_lastConversationTimer > 20000) {
                this.m_lastConversationTimer = -1;
            }
        }
        switch (this.m_simState) {
            case 10: {
                this.simUpdateWaiting(n);
                break;
            }
            case 1: {
                this.simUpdateIdle(n);
                break;
            }
            case 2: {
                this.simUpdateChangePosture(n);
                break;
            }
            case 3: {
                this.simUpdateWalking(n);
                break;
            }
            case 4: {
                this.simUpdateFeedback(n);
                break;
            }
            case 5: {
                this.simUpdateGetAttention(n);
                break;
            }
            case 6: {
                this.simUpdateGetOccupied(n);
                break;
            }
            case 7: {
                this.simUpdateListen(n);
                break;
            }
            case 8: {
                this.simUpdateHide(n);
                break;
            }
        }
    }

    public final void render2D() {
        if (this.m_simState == 8 || this.m_appearanceBank == -1) {
            return;
        }
        SimWorld simWorld = Main.m_simWorld;
        int n = simWorld.getCameraPixelX();
        int n2 = simWorld.getCameraPixelY();
        int n3 = n + simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n4 = n2 + simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ()) - (StateInGame.camOffsetZ >> 16);
        AnimPlayer animPlayer = null;
        if (this.m_subAppearance != 45) {
            if (!(StateInGame.isMapMode() || Event.m_eventState == 2 || this.m_targetPosture != 0 && this.m_targetPosture != 6)) {
                AnimationManager.drawAnimFrame(109, 0, n3, n4);
            }
            AnimationManager.setBank(this.m_appearanceBank);
            animPlayer = this.getAnimPlayer(0);
            if (!StateInGame.isMapMode()) {
                int n5 = animPlayer.getAnimID();
                int n6 = animPlayer.getCurrAnimFrame();
                this.drawSimAnim(n5, n6, n3, n4);
            } else {
                animPlayer.drawAnim(n3, n4);
                if (this.getId() == 0) {
                    StateInGame.renderPlayerGem(n3, n4 - 16);
                }
            }
            if (this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getPostureObject() == null) {
                this.getSimActionArg1Sim().render2DPost();
            }
            AnimationManager.setBank(0);
        }
        AnimPlayer animPlayer2 = this.getAnimPlayer(2);
        if (this.m_feedbackTime > 0 && animPlayer2.isAnimating() && StateInGame.m_mapMode != 2) {
            int[] nArray = MapObject.s_tempInt10;
            int n7 = this.m_feedbackAnimateFloater ? Camera.MathExt_smoothstepF(1000, 2000, this.m_feedbackTime) : 65536;
            int n8 = n7 * 10;
            int n9 = n3;
            int n10 = n4 + (n8 >> 16) - 60 - 10;
            AnimationManager.drawAnim(animPlayer2, n9, n10);
            if (this.m_simPhase == 5) {
                animPlayer2.getFirePointCurrFrame(nArray, 0);
                AnimationManager.drawAnimFrame(this.m_feedbackSpeechBubbleAnimId, 0, n9 + nArray[0], n10 + nArray[1]);
            }
        }
    }

    public final void render2DPost() {
        int n;
        int n2 = Main.m_simWorld.getSubAppearanceAnimSet(this.m_appearance, this.m_subAppearance, true);
        if (n2 != 0 && (n = Main.m_simWorld.getAnim(n2, this.getFacingDir())) != 359) {
            int n3 = Main.m_simWorld.getCameraPixelX();
            int n4 = Main.m_simWorld.getCameraPixelY();
            int n5 = n3;
            int n6 = n4;
            if (this.m_subAppearance == 45) {
                int[] nArray = MapObject.s_tempInt10;
                this.m_simActionArg1.getBathSimPos(nArray);
                n5 += nArray[0];
                n6 += nArray[1];
            } else {
                n5 += Main.m_simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
                n6 += Main.m_simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
            }
            int n7 = this.getAnimPlayer(0).getCurrAnimFrame();
            AnimationManager.setBank(this.m_appearanceBank);
            this.drawSimAnim(n, n7, n5, n6);
            AnimationManager.setBank(0);
        }
    }

    public void drawSimAnim(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = this.m_appearance == 0 ? 601 : 499;
        int n6 = Main.m_simData.getSimAttribute(this.getId(), 2) + 1;
        int[] nArray = null;
        boolean bl2 = bl = this.getId() == 0;
        if (bl) {
            nArray = MapObject.s_tempInt10;
        }
        boolean bl3 = AnimationManager.drawAnimFrameExt(n, n2, n3, n4, n5, n6, nArray);
        if (bl && bl3) {
            StateInGame.renderPlayerGem(nArray[0], nArray[1]);
        }
    }

    public final int getTooltipStringId() {
        return Main.m_simData.getSimName(this.getId());
    }

    private final void setAppearance(int n) {
        if (this.m_appearance != n) {
            this.m_appearance = n;
            int n2 = this.m_subAppearance;
            this.m_subAppearance = -1;
            this.setSubAppearance(n2);
        }
    }

    public final void setSubAppearance(int n) {
        boolean bl = this.getFacingDir() == 0 || this.getFacingDir() == 1;
        if (this.m_subAppearance != (n = Main.m_simWorld.mapSubAppearance(n, bl))) {
            this.m_subAppearance = n;
            int n2 = Main.m_simWorld.getSubAppearanceAnimSet(this.m_appearance, n, false);
            this.setAnimSet(n2);
        }
    }

    public final void setBank(int n) {
        this.m_appearanceBank = n;
    }

    public final int getBank() {
        return this.m_appearanceBank;
    }

    private final void simStateTransition(int n) {
        if (n == 1 && this.m_simState == 4 && this.m_posture == 2 && this.getId() == 0 && this.callOverDirectionDir != -551) {
            this.setFacingDir(this.callOverDirectionDir);
        }
        this.cleanUpOldState(this.m_simState, n);
        this.setRuntimeFlag(128);
        int n2 = this.m_simState;
        this.m_simState = n;
        this.m_simStateTime = 0;
        int n3 = -1;
        switch (n) {
            case 10: {
                this.setSubAppearance(0);
                break;
            }
            case 1: {
                n3 = this.m_posture == 4 ? 15 : (this.m_posture == 5 ? 49 : (this.m_posture == 1 ? 19 : (this.m_posture == 2 ? 19 : (this.m_posture == 3 ? 23 : (this.m_posture == 6 ? 38 : (this.m_posture == 7 ? 31 : 0))))));
                this.setSubAppearance(n3);
                break;
            }
            case 2: {
                this.tempApp = n3;
                int n4 = this.handlePostureChange(this.m_posture);
                n3 = this.tempApp;
                Debug.ASSERT(n4 != this.m_posture, "invalid posture change");
                Debug.ASSERT(n3 != -1, "invalid posture transition appearance type");
                this.m_posture = n4;
                this.unsetRuntimeFlag(128);
                this.setSubAppearance(n3);
                break;
            }
            case 3: {
                Debug.ASSERT(this.m_posture == 0, "not standing but trying to walk!");
                this.setSubAppearance(1);
                if (this.getId() != 0 || !StateInGame.isMapMode() || this.isInView() || n2 == 3) break;
                StateInGame.setCameraFollow(this);
                break;
            }
            case 4: {
                if (this.m_feedbackFloaterAnimId != -1) {
                    this.getAnimPlayer(2).startAnim(this.m_feedbackFloaterAnimId, 20);
                    if (this.m_simPhase == 5) {
                        this.m_feedbackSpeechBubbleAnimId = Main.m_simData.getActionTalkIcon(this.m_simAction);
                    }
                } else {
                    this.getAnimPlayer(2).setAnimating(false);
                }
                if (this.m_feedbackSubAppearance == -1) {
                    this.m_feedbackSubAppearance = Main.m_simData.d_actionWorldArgs[this.m_simAction];
                }
                MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
                if (this.m_simAction == 87 || this.m_simAction == 88) {
                    if (Main.m_simData.actionAccept(this.getId(), mapObjectSim.getId(), this.m_simAction)) {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(33);
                        this.m_feedbackSubAppearance = 36;
                    } else {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(35);
                        this.m_feedbackSubAppearance = 34;
                    }
                } else if (this.m_simAction == 98) {
                    mapObjectSim.unsetRuntimeFlag(128);
                    mapObjectSim.setSubAppearance(27);
                } else if (this.m_simAction == 89) {
                    int n5 = mapObjectSim.getId();
                    if (Main.m_simData.actionAccept(this.getId(), n5, this.m_simAction)) {
                        Event.triggerEvent(3, -1, n5, 940, -1);
                    }
                }
                if (!this.m_feedbackLoop) {
                    this.unsetRuntimeFlag(128);
                }
                this.setSubAppearance(this.m_feedbackSubAppearance);
                break;
            }
            case 5: 
            case 6: {
                this.setSubAppearance(0);
                break;
            }
            case 7: {
                this.setFacingObject(this.m_simActionArg1);
                int n6 = 7;
                if (this.getSimActionArg1Sim() != null && (this.getSimActionArg1Sim().getSimAction() == 87 || this.getSimActionArg1Sim().getSimAction() == 88)) {
                    n6 = 0;
                }
                this.setSubAppearance(n6);
                break;
            }
            case 9: {
                this.destroy();
                break;
            }
        }
        if (this.m_simState == 1 && this.m_posture == 2 && this.getId() == 0) {
            this.callOverDirectionDir = this.getFacingDir();
        }
    }

    public final void cleanUpOldState(int n, int n2) {
        switch (n) {
            case 3: {
                this.callOverDirectionDir = -551;
                if (n2 == 3 || !StateInGame.isMapMode()) break;
                this.setAppearance(2);
                if (StateInGame.getCameraFollow() == null || !StateInGame.getCameraFollow().equals(this)) break;
                StateInGame.setCameraFollow(null);
                break;
            }
            case 2: {
                if (this.m_postureObject == null || this.m_posture != 0) break;
                this.m_postureObject.releasePostRenderTarget(this);
                this.m_postureObject = null;
                break;
            }
        }
    }

    private final int handlePostureChange(int n) {
        MapObject mapObject = this.m_simActionArg1;
        switch (this.m_posture) {
            default: {
                Debug.ASSERT(false, "invalid current posture");
            }
            case 0: {
                if (this.m_targetPosture == 7) {
                    this.tempApp = 29;
                    n = 7;
                    this.m_postureObject = mapObject;
                    mapObject.phonePickup();
                    break;
                }
                if (this.m_targetPosture == 3) {
                    this.tempApp = 22;
                    n = 3;
                    break;
                }
                if (this.m_targetPosture == 1 || this.m_targetPosture == 4 || this.m_targetPosture == 5) {
                    this.m_postureObject = mapObject;
                    mapObject.setPostRenderTarget(this);
                    this.tempApp = 20;
                    n = 1;
                    break;
                }
                if (this.m_targetPosture == 6) {
                    this.tempApp = 39;
                    n = 6;
                    break;
                }
                Debug.ASSERT(mapObject != null, "sitting without a chair");
                mapObject.setPostRenderTarget(this);
                this.m_postureObject = mapObject;
                int n2 = 0;
                int n3 = 0;
                int n4 = this.getFacingDir();
                if (n4 == 0) {
                    n2 = 524288;
                } else if (n4 == 1) {
                    n3 = 524288;
                } else if (n4 == 2) {
                    n2 = -524288;
                } else if (n4 == 3) {
                    n3 = -524288;
                } else {
                    Debug.ASSERT(false, "invalid sim facing");
                }
                int n5 = mapObject.getFacingDir();
                this.setFacingDir(n5);
                int n6 = 0;
                int n7 = 0;
                if (n5 == 0) {
                    n6 = -196608;
                    n2 += 131072;
                } else if (n5 == 1) {
                    n7 = -196608;
                    n3 += 131072;
                } else if (n5 == 2) {
                    n6 = 196608;
                    n2 -= 131072;
                } else if (n5 == 3) {
                    n7 = 196608;
                    n3 -= 131072;
                } else {
                    Debug.ASSERT(false, "invalid chair facing");
                }
                if (mapObject.chairShouldSnap()) {
                    mapObject.setPos(mapObject.getPosX() + n6, mapObject.getPosZ() + n7);
                    mapObject.setRuntimeFlag(131072);
                } else {
                    n2 -= n6;
                    n3 -= n7;
                }
                this.setPos(this.getPosX() + n2, this.getPosZ() + n3);
                this.tempApp = 20;
                n = 2;
                break;
            }
            case 1: {
                if (this.m_targetPosture == 0) {
                    this.tempApp = 18;
                    n = 0;
                    break;
                }
                if (this.m_targetPosture == 4) {
                    this.tempApp = 17;
                    n = 4;
                    break;
                }
                if (this.m_targetPosture != 5) break;
                this.tempApp = 48;
                n = 5;
                Main.m_simData.setMotiveAdjust(1, 0x190000);
                break;
            }
            case 2: {
                this.tempApp = 18;
                n = 0;
                break;
            }
            case 3: {
                this.tempApp = 25;
                n = 0;
                break;
            }
            case 4: {
                this.tempApp = 16;
                n = 1;
                break;
            }
            case 5: {
                this.tempApp = 50;
                n = 1;
                break;
            }
            case 6: {
                this.tempApp = 37;
                n = 0;
                break;
            }
            case 7: {
                this.tempApp = 30;
                n = 0;
                this.m_postureObject.phoneHangup();
            }
        }
        return n;
    }

    public final void simFeedback(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_feedbackSubAppearance = n;
        this.m_feedbackLoop = n2 >= 0;
        this.m_feedbackTime = n2;
        this.m_feedbackFloaterAnimId = n3;
        this.m_feedbackAnimateFloater = bl;
        this.m_feedbackRealTime = bl2;
        this.simStateTransition(4);
    }

    private final void endFeedback() {
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = false;
        this.m_feedbackTime = -1;
        this.m_feedbackFloaterAnimId = -1;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackRealTime = true;
    }

    private final void simHide(int n, boolean bl) {
        this.m_feedbackTime = n;
        this.m_feedbackRealTime = bl;
        this.simStateTransition(8);
    }

    private final void simUpdateIdle(int n) {
        MapObject mapObject;
        MapObject mapObject2;
        this.updateAnim(n);
        this.m_needCheckTimer += n;
        if (this.getType() == 0) {
            if (this.m_simStateTime > 3000 && Main.m_simData.buffGetActiveSlot(10) != -1) {
                this.beginSimAction(3, null);
                return;
            }
            if (this.m_simStateTime > 3500 && this.m_posture == 0) {
                int n2 = Main.m_simData.getMoodLevel();
                if (n2 > 0x4B0000) {
                    this.beginSimAction(5, null);
                    return;
                }
                if (n2 < -3276800) {
                    this.beginSimAction(6, null);
                    return;
                }
            }
        }
        if (this.m_posture == 1 && this.m_postureObject.getParentType() == 8 && (mapObject2 = StateInGame.findRandomObjectByParentType(21)) != null && mapObject2.getRuntimeFlag(64) && this.m_simStateTime > 1000) {
            int n3 = 16;
            if (mapObject2.getRuntimeFlag(32768)) {
                n3 = 15;
            }
            this.beginSimAction(n3, null);
            return;
        }
        if (this.m_posture == 0 && this.m_simStateTime > 5000 && (mapObject = StateInGame.findRandomObjectByParentType(17)) != null && mapObject.getRuntimeFlag(64)) {
            int n4 = Main.m_simWorld.coordWorldToWorldTileX(mapObject.getPosX());
            int n5 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
            int n6 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
            int n7 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
            if (Math.abs(n6 - n4) + Math.abs(n7 - n5) < 8) {
                this.beginSimAction(17, null);
                return;
            }
        }
        if (this.m_needCheckTimer > 2500 && this.occupiedIsEmpty()) {
            this.m_needCheckTimer = 0;
            this.checkNeeds();
        }
    }

    public MapObject getPostureObject() {
        return this.m_postureObject;
    }

    private final void simUpdateChangePosture(int n) {
        this.updateAnim(n);
        if (!this.isAnimating()) {
            if (this.m_posture == 0 && this.m_postureObject != null && this.m_postureObject.getParentType() == 6) {
                int n2 = 131072;
                int n3 = 0;
                int n4 = 0;
                switch (this.getFacingDir()) {
                    default: {
                        Debug.ASSERT(false, "invalid facing, getting off chair");
                    }
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n3 = -1;
                        break;
                    }
                    case 3: {
                        n4 = -1;
                    }
                }
                MapObject mapObject = this.m_postureObject;
                if (mapObject.getRuntimeFlag(131072)) {
                    mapObject.unsetRuntimeFlag(131072);
                    mapObject.setPos(mapObject.getPosX() + n3 * 196608, mapObject.getPosZ() + n4 * 196608);
                } else {
                    n2 += 196608;
                }
                int n5 = 524288;
                int n6 = this.getPosX() + n4 * n5 + n3 * -n2;
                int n7 = this.getPosZ() + n3 * n5 + n4 * -n2;
                boolean bl = Main.m_simWorld.isWorldPointWalkable(n6, n7);
                int n8 = this.getPosX() + n4 * -n5 + n3 * -n2;
                int n9 = this.getPosZ() + n3 * -n5 + n4 * -n2;
                boolean bl2 = Main.m_simWorld.isWorldPointWalkable(n8, n9);
                boolean bl3 = StateInGame.isObjectAt(0, n8, n9);
                if (bl && (bl3 || !bl2)) {
                    this.setPos(n6, n7);
                } else {
                    this.setPos(n8, n9);
                }
            }
            if (this.m_posture == this.m_targetPosture) {
                this.endSimPhase();
            } else {
                this.simStateTransition(2);
            }
        }
    }

    private final void simUpdateWaiting(int n) {
        if (this.m_simStateTime > 500) {
            this.endSimPhase();
        } else {
            if (this.m_simAction == 167) {
                StateInGame.showTutorialMessage((byte)21, 818, 919);
            }
            if (this.m_simAction == 163) {
                StateInGame.showTutorialMessage((byte)25, 818, 980);
            }
            if (this.m_simAction == 168) {
                StateInGame.showTutorialMessage((byte)22, 825, 918);
            }
            if (this.m_simAction == 164) {
                StateInGame.showTutorialMessage((byte)26, 825, 981);
            }
            if (this.m_simAction == 169) {
                StateInGame.showTutorialMessage((byte)23, 832, 917);
            }
            if (this.m_simAction == 165) {
                StateInGame.showTutorialMessage((byte)27, 832, 982);
            }
            if (this.m_simAction == 170) {
                StateInGame.showTutorialMessage((byte)24, 839, 920);
            }
            if (this.m_simAction == 166) {
                StateInGame.showTutorialMessage((byte)28, 839, 983);
            }
        }
    }

    private final void simUpdateWalking(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getPosX();
        int n7 = this.getPosZ();
        int n8 = this.m_walkDestXF;
        int n9 = this.m_walkDestZF;
        int n10 = Main.m_simWorld.coordWorldToWorldTileX(n6);
        int n11 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
        int n12 = Main.m_simWorld.getAttribute(n10, n11);
        int n13 = Camera.MathExt_sign(n8 - n6);
        int n14 = n13 != 0 ? 0 : Camera.MathExt_sign(n9 - n7);
        int n15 = 2048;
        int n16 = 1310;
        if (this.getRuntimeFlag(4096)) {
            n15 = 1638;
            n16 = 983;
        } else if (this.getRuntimeFlag(2048)) {
            n15 = 2621;
            n16 = 1474;
        }
        if (StateInGame.isMapMode()) {
            n15 = n16;
            if (this.hasCar()) {
                n5 = Main.m_simWorld.coordWorldToWorldTileX(n6);
                n4 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
                n3 = Main.m_simWorld.getAttribute(n5, n4);
                int n17 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                if (n2 != 0) {
                    int n18;
                    if (n14 == 0) {
                        n18 = Main.m_simWorld.coordWorldTileToWorldCenterX(n5);
                        n3 = n13 < 0 && n6 <= n18 || n13 > 0 && n6 >= n18 ? Main.m_simWorld.getAttribute(n5 + n13, n4) : Main.m_simWorld.getAttribute(n5 - n13, n4);
                    } else {
                        n18 = Main.m_simWorld.coordWorldTileToWorldCenterZ(n4);
                        n3 = n14 < 0 && n7 <= n18 || n14 > 0 && n7 >= n18 ? Main.m_simWorld.getAttribute(n5, n4 + n14) : Main.m_simWorld.getAttribute(n5, n4 - n14);
                    }
                    int n19 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                }
                if (n2 != 0) {
                    n15 = 3276;
                    this.setAppearance(3);
                } else {
                    this.setAppearance(2);
                }
            }
        }
        n5 = n15 * n;
        n7 += n14 * n5;
        if (n13 > 0 && (n6 += n13 * n5) > n8 || n13 < 0 && n6 < n8) {
            n6 = n8;
        }
        if (n14 > 0 && n7 > n9 || n14 < 0 && n7 < n9) {
            n7 = n9;
        }
        this.setFacingDir(n13, n14);
        this.setPos(n6, n7);
        if (!StateInGame.isMapMode()) {
            n4 = Main.m_simWorld.coordWorldToWorldTileX(n6);
            n3 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
            n2 = Main.m_simWorld.getAttribute(n4, n3);
            if ((n12 & 0x20) == 0) {
                if ((n2 & 0x20) != 0) {
                    GlobalConstants.PMDebug_println("opening door");
                    MapObject mapObject = StateInGame.findRandomObjectByParentType(9);
                    if (mapObject != null && !mapObject.getRuntimeFlag(64)) {
                        mapObject.respondToAction(155, this);
                    }
                }
            }
        }
        this.updateAnim(n);
        if (n6 == n8 && n7 == n9) {
            if (!this.occupiedIsEmpty() && this.getType() != 0) {
                this.failSimPhase(true);
            } else if (this.m_simActionArg1 != null && (this.m_simActionArg1.getPosX() != this.m_checkPosXF || this.m_simActionArg1.getPosZ() != this.m_checkPosZF)) {
                this.simWalkTo(this.m_simActionArg1, 0, 0);
            } else {
                n4 = !this.setOccupied(this.m_simActionArg1) ? 1 : 0;
                n2 = this.m_walkPathLength != -1 ? (this.m_walkPathLength >> 1) - this.m_walkPathPoint : -1;
                if (n2 > ((n3 = this.m_walkStopShort || n4 != 0 ? 1 : 0) != 0 ? 2 : 1)) {
                    if (this.m_simActionArg1 != null && ((n2 & 3) == 0 || n2 < 4)) {
                        if (n4 == 0) {
                            this.setOccupied(null);
                            this.setOccupied(this.m_simActionArg1);
                        }
                        this.simWalkTo(this.m_simActionArg1, 0, 0);
                    } else {
                        ++this.m_walkPathPoint;
                        this.m_walkDestXF = this.m_walkPath[(this.m_walkPathPoint << 1) + 0];
                        this.m_walkDestZF = this.m_walkPath[(this.m_walkPathPoint << 1) + 1];
                    }
                } else {
                    this.m_walkPathLength = -1;
                    if (n4 != 0) {
                        this.beginSimPhase(9);
                    } else {
                        this.endSimPhase();
                    }
                }
            }
        }
    }

    private final void simWalkTo(MapObject mapObject, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Object[] objectArray;
        int n7;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = n;
        int n9 = n2;
        if (mapObject != null) {
            bl = false;
            bl2 = !this.setOccupied(mapObject);
            n7 = this.m_occupiedIndex;
            if (n7 == -1) {
                n7 = mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), false, null);
            }
            if (n7 == -1) {
                this.failSimPhase(false);
                return;
            }
            objectArray = MapObject.s_tempInt10;
            mapObject.getInterestPoint((int[])objectArray, n7);
            n8 = objectArray[0];
            n9 = objectArray[1];
            this.m_checkPosXF = mapObject.getPosX();
            this.m_checkPosZF = mapObject.getPosZ();
        }
        n8 = Main.m_simWorld.coordWorldTileToWorldCenterX(Main.m_simWorld.coordWorldToWorldTileX(n8));
        n9 = Main.m_simWorld.coordWorldTileToWorldCenterZ(Main.m_simWorld.coordWorldToWorldTileZ(n9));
        if ((n8 != this.getPosX() || n9 != this.getPosZ()) && this.m_posture != 0) {
            GlobalConstants.PMDebug_println("not standing, so getting up");
            --this.m_simActionPhaseIndex;
            this.beginSimPhase(29);
            return;
        }
        if (StateInGame.isHouseMode() && this.getId() == 0 && Main.m_simWorld.m_houseId != 0 && this.m_simAction != 158 && !this.getRuntimeFlag(32)) {
            if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                GlobalConstants.PMDebug_println("barging in check...");
                n7 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
                int n10 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
                n6 = Main.m_simWorld.coordWorldToWorldTileX(n8);
                n5 = Main.m_simWorld.coordWorldToWorldTileZ(n9);
                if ((Main.m_simWorld.getAttribute(n7, n10) & 0x10) == 0) {
                    if ((Main.m_simWorld.getAttribute(n6, n5) & 0x10) != 0) {
                        GlobalConstants.PMDebug_println("barge-in override");
                        this.m_queuedSimAction = this.m_simAction;
                        this.m_queuedSimActionArg1 = this.m_simActionArg1;
                        this.m_queuedSimActionArg2 = this.m_simActionArg2;
                        this.m_queuedSimActionArg3 = this.m_simActionArg3;
                        this.setRuntimeFlag(16);
                        this.beginSimAction(158, StateInGame.findRandomObjectByParentType(9));
                        return;
                    }
                }
            }
        }
        this.unsetRuntimeFlag(32);
        n7 = 0;
        if (StateInGame.isMapMode()) {
            n7 = this.hasCar() ? 2 : 4;
        } else {
            n7 = 8;
            objectArray = StateInGame.getSimObjects();
            if (objectArray.length > 1) {
                Main.m_simWorld.pathClearAvoidTiles();
                for (n6 = 0; n6 < objectArray.length; ++n6) {
                    int n11 = objectArray[n6];
                    if (n11 == null || n11.equals(this)) continue;
                    n4 = Main.m_simWorld.coordWorldToWorldTileX(n11.getPosX());
                    n3 = Main.m_simWorld.coordWorldToWorldTileZ(n11.getPosZ());
                    Main.m_simWorld.pathAddAvoidTile(n4, n3);
                }
                n7 |= 1;
            }
        }
        int n12 = this.getPosX();
        n6 = this.getPosZ();
        this.m_walkPathLength = 0;
        this.m_walkPathLength = Main.m_simWorld.pathFind(n12, n6, n8, n9, n7, this.m_walkPath);
        if (!bl && bl2 && this.m_walkPathLength == 2) {
            GlobalConstants.PMDebug_println("target busy, already there");
            this.beginSimPhase(9);
        } else if (bl && this.m_walkPathLength == 2) {
            GlobalConstants.PMDebug_println("stop short, already there");
            this.endSimPhase();
        } else if (this.m_walkPathLength >= 2) {
            this.m_walkPathPoint = 0;
            this.m_walkStopShort = bl;
            this.m_walkDestXF = this.m_walkPath[(this.m_walkPathPoint << 1) + 0];
            this.m_walkDestZF = this.m_walkPath[(this.m_walkPathPoint << 1) + 1];
            this.simStateTransition(3);
        } else {
            n5 = n12 - n8;
            n4 = n6 - n9;
            n3 = Math.abs(n5) + Math.abs(n4);
            int n13 = 524288;
            if (n3 <= n13) {
                if (n3 != 0) {
                    GlobalConstants.PMDebug_println("very close");
                    this.m_walkPathPoint = 0;
                    this.m_walkStopShort = bl;
                    this.m_walkDestXF = n8;
                    this.m_walkDestZF = n9;
                    this.simStateTransition(3);
                } else {
                    GlobalConstants.PMDebug_println("already there");
                    this.endSimPhase();
                }
            } else {
                GlobalConstants.PMDebug_println("too far/invalid path");
                this.failSimPhase(false);
            }
        }
    }

    public final int getFeedbackTime() {
        return this.m_feedbackTime;
    }

    private final void simUpdateFeedback(int n) {
        int n2;
        int n3 = this.getAnimPlayer(0).getCurrAnimFrame();
        this.updateAnim(n);
        int n4 = this.getAnimPlayer(0).getCurrAnimFrame();
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        if (n3 != n4) {
            if (this.m_simAction == 152 && n4 == 2) {
                if (this.m_simActionArg1.getType() == 65) {
                    this.m_simActionArg1.trashCanKick(this);
                }
                if (this.m_simActionArg1.getType() == 142) {
                    this.m_simActionArg1.interactStart(15200);
                }
            }
            if (this.m_simAction == 98 && n4 == 2 && (this.getId() == 0 || this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getId() == 0)) {
                Camera.PMVibrate_vibrate(40);
                if (this.getId() == 0) {
                    ++Main.m_simData.numSlapsGiven;
                }
            }
            int n5 = n2 = this.getFacingDir() == 0 || this.getFacingDir() == 1 ? 2 : 3;
            if (this.m_simAction == 88 && this.m_subAppearance == 36 && n4 == n2) {
                Event.triggerEvent(2, 140, this.getSimActionArg1().getId(), 140, -1);
                ++Main.m_simData.numKissesGiven;
            }
            if (this.m_simAction == 4 && n4 == 15 && Main.randPercent() < 5) {
                StateInGame.killPlayer(805);
            }
        }
        this.getAnimPlayer(2).updateAnim(n);
        n2 = 0;
        if (this.m_feedbackLoop) {
            if (this.m_feedbackRealTime) {
                n2 = this.m_feedbackTime <= Main.m_simData.getGameTimeAbs() ? 1 : 0;
            } else {
                if (StateInGame.m_state != 16) {
                    this.m_feedbackTime -= n;
                }
                n2 = this.m_feedbackTime <= 0 ? 1 : 0;
            }
        } else {
            int n6 = n2 = !animPlayer.isAnimating() ? 1 : 0;
        }
        if (this.m_simPhase == 47 && this.getSimActionArg1().coffeeMachineIsReady()) {
            this.endSimPhase();
        }
        if (n2 != 0) {
            this.m_feedbackSubAppearance = -1;
            this.m_feedbackTime = -1;
            this.m_feedbackLoop = true;
            this.endSimPhase();
            this.cleanUpAfterInteractivity();
        } else {
            int n7 = 1000 << 2;
            if (this.getId() == 0 && this.m_simPhase == 19 && this.m_simStateTime > n7 && this.m_feedbackRealTime) {
                if (this.m_feedbackTime - Main.m_simData.getGameTimeAbs() > 60 && this.occupiedIsEmpty() && !StateInGame.isCurtainActive()) {
                    StateInGame.snapCameraPosition();
                    StateInGame.startCurtainIn();
                }
            }
            if (this.m_simPhase == 16 && this.m_simActionArg1.getParentType() == 3 && this.m_subAppearance != 45 && this.m_simActionArg1.bathIsFull()) {
                if (this.getId() == 0) {
                    Main.m_simData.setMotiveAdjust(3, 0x640000);
                }
                this.setSubAppearance(45);
            }
        }
    }

    private final void simUpdateGetAttention(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (this.m_simAction != 99) {
            int n2 = mapObjectSim.getPosX() - this.getPosX();
            int n3 = mapObjectSim.getPosZ() - this.getPosZ();
            int n4 = Math.abs(n2) + Math.abs(n3);
            int n5 = 524288;
            if (n4 > n5) {
                this.failSimPhase(false);
                return;
            }
        }
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (mapObjectSim.isIdle()) {
            mapObjectSim.beginSimAction(2, this);
            this.endSimPhase();
        }
    }

    private final void simUpdateGetOccupied(int n) {
        this.updateAnim(n);
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (this.setOccupied(this.m_simActionArg1)) {
            this.beginSimPhase(1);
        }
    }

    private final void simUpdateListen(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (mapObjectSim == null || mapObjectSim.isIdle()) {
            this.endSimPhase();
        } else if (mapObjectSim != null && mapObjectSim.getRuntimeFlag(1024)) {
            if (Main.m_simData.hasSimGotTrait(this.getId(), 12) != -1) {
                if (!this.getRuntimeFlag(262144)) {
                    Main.m_simData.tryDiscoverTrait(this.getId(), 12);
                    this.setRuntimeFlag(262144);
                }
            } else {
                mapObjectSim.interrupt();
                this.clearConversation();
                int n2 = 0;
                if (Main.m_simData.hasSimGotTrait(this.getId(), 13) != -1 || Main.randPercent() > 50) {
                    n2 = 0x20 | 2;
                    Main.m_simData.tryDiscoverTrait(this.getId(), 13);
                    Main.m_simData.adjustRelLevels(this.getId(), -1, -1);
                }
                this.beginSimAction(14, mapObjectSim, n2, 0);
            }
        }
    }

    private final void simUpdateHide(int n) {
        if (this.m_simAction == 183) {
            return;
        }
        if (this.m_feedbackRealTime) {
            if (this.m_feedbackTime <= Main.m_simData.getGameTimeAbs()) {
                this.endSimPhase();
            }
        } else if (this.m_feedbackTime > 0) {
            this.m_feedbackTime -= n;
            if (this.m_feedbackTime <= 0) {
                this.endSimPhase();
                this.cleanUpAfterInteractivity();
            }
        }
    }

    public final void cleanUpAfterInteractivity() {
        if (this.lastInteractivityObject != null) {
            this.lastInteractivityObject.interactEnd();
            int n = this.lastInteractivityObject.getType();
            switch (n) {
                default: {
                    break;
                }
                case 134: {
                    Main.m_simData.setMotiveAdjust(5, 0x780000);
                    if (!GameConstants.Minigame_inspired) break;
                    StateInGame.showMessageBox(369, 370);
                    break;
                }
                case 136: {
                    Main.m_simData.setMotiveAdjust(3, -4915200);
                    break;
                }
                case 120: {
                    if (!GameConstants.Minigame_inspired) break;
                    StateInGame.showMessageBox(965, 966);
                    break;
                }
                case 151: {
                    Main.m_simData.setMotiveAdjust(5, 0x780000);
                    if (!GameConstants.Minigame_inspired) break;
                    StateInGame.showMessageBox(1060, 1061);
                    break;
                }
                case 164: {
                    Main.m_simData.setMotiveAdjust(5, 0x780000);
                    break;
                }
                case 163: {
                    Main.m_simData.setMotiveAdjust(5, 0x780000);
                    if (!GameConstants.Minigame_inspired) break;
                    StateInGame.showMessageBox(1066, 1067);
                }
            }
            this.lastInteractivityObject = null;
            Cursor.hide = false;
        }
    }

    public final int getSimAction() {
        return this.m_simAction;
    }

    public final int getSimPhase() {
        return this.m_simPhase;
    }

    public final MapObject getSimActionArg1() {
        return this.m_simActionArg1;
    }

    public final MapObjectSim getSimActionArg1Sim() {
        if (this.m_simActionArg1 == null || this.m_simActionArg1.isMapObject) {
            return null;
        }
        return (MapObjectSim)this.m_simActionArg1;
    }

    public final boolean isIdle() {
        return (Main.m_simData.d_actionFlags[this.m_simAction] & 2) != 0;
    }

    public final boolean isReady() {
        return this.isIdle() || this.m_simPhase == 8 || this.m_simPhase == 9 || this.m_simPhase == 1;
    }

    public final boolean isWorking() {
        return this.m_simPhase == 25;
    }

    public final boolean isSleeping() {
        return (this.m_simAction == 129 || this.m_simAction == 128) && this.m_posture == 4;
    }

    public final void queueSimAction(int n, MapObject mapObject, int n2, int n3) {
        if (this.isReady()) {
            this.beginSimAction(n, mapObject, n2, n3);
        } else {
            this.m_queuedSimAction = n;
            this.m_queuedSimActionArg1 = mapObject;
            this.m_queuedSimActionArg2 = n2;
            this.m_queuedSimActionArg3 = n3;
        }
    }

    public final void beginSimAction(int n, MapObject mapObject) {
        this.beginSimAction(n, mapObject, 0, 0);
    }

    public final void beginSimAction(int n, MapObject mapObject, int n2, int n3) {
        if (this.m_simPhase != 0) {
            this.endSimPhase(true);
        }
        this.unsetRuntimeFlag(262146);
        if (n == 126 && this.m_appearance == 0 && Main.randPercent() < 50) {
            n = 127;
        }
        this.m_simAction = n;
        this.m_simActionArg1 = mapObject;
        this.m_simActionArg2 = n2;
        this.m_simActionArg3 = n3;
        if (mapObject == null && n != 111 || !this.setOccupied(mapObject)) {
            // empty if block
        }
        int n4 = this.getId();
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (n4 == 0 && mapObjectSim != null) {
            GameConstants.Minigame_npcID = -1;
            if ((Main.m_simData.d_actionFlags[n] & 1) != 0) {
                this.setConversation(mapObjectSim);
                if (n == 163) {
                    GameConstants.Minigame_npcID = mapObjectSim.getId();
                }
                if (n == 164) {
                    GameConstants.Minigame_npcID = mapObjectSim.getId();
                }
                if (n == 165) {
                    GameConstants.Minigame_npcID = mapObjectSim.getId();
                }
                if (n == 166) {
                    GameConstants.Minigame_npcID = mapObjectSim.getId();
                }
            }
        }
        byte by = Main.m_simData.d_actionPhases[n][0];
        this.m_simActionPhaseIndex = 0;
        this.beginSimPhase(by);
    }

    public final void playerAction(MapObject mapObject) {
        if (mapObject != null && !mapObject.equals(this) && (this.m_needFlags & 0x20) != 0) {
            MapObjectSim mapObjectSim = StateInGame.getPlayerSim().getSimActionArg1Sim();
            if (this.m_conversationSim == 0 || mapObjectSim != null && this.m_conversationSim == mapObjectSim.getId()) {
                GlobalConstants.PMDebug_println("abort talking");
                this.clearConversation();
            }
        }
    }

    public final boolean setOccupied(MapObject mapObject) {
        Debug.ASSERT(mapObject != null && !mapObject.equals(this), "attempting to get occupied flag on self");
        if (mapObject != null && mapObject.equals(this.m_occupiedObject)) {
            return true;
        }
        if (this.m_occupiedObject != null) {
            this.m_occupiedObject.occupiedRelease(this.m_occupiedIndex);
            this.m_occupiedObject = null;
            this.m_occupiedIndex = -1;
        }
        if (mapObject == null) {
            return true;
        }
        if (mapObject.occupiedIsAnyAvailable()) {
            int n = -1;
            if (mapObject.getParentType() == 9) {
                int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
                int n3 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
                int n4 = Main.m_simWorld.getAttribute(n2, n3);
                n = (n4 & 0x10) != 0 ? 0 : 1;
            } else {
                n = mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), true, this);
            }
            if (n != -1 && mapObject.occupiedCapture(n, this)) {
                this.m_occupiedObject = mapObject;
                this.m_occupiedIndex = n;
                return true;
            }
        }
        return false;
    }

    public MapObject getOccupiedObject() {
        return this.m_occupiedObject;
    }

    private final void endSimAction() {
        boolean bl = this.getRuntimeFlag(4);
        this.unsetRuntimeFlag(12);
        this.m_simActionPrev = this.m_simAction;
        int n = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        boolean bl2 = this.getId() == 0;
        this.beginSimAction(0, null);
        int n2 = Main.m_simData.d_actionFlags[n];
        if (!bl && mapObjectSim != null && (n2 & 1) != 0) {
            this.setOccupied(null);
            mapObjectSim.setOccupied(null);
            boolean bl3 = mapObjectSim.respondToAction(n, this);
            if (bl3) {
                this.clearConversation();
            }
            if (bl2) {
                int n3 = mapObjectSim.getId();
                if (n == 98) {
                    Main.m_simData.setSimCurRelStateFlags(n3, 4);
                } else if (n == 87) {
                    Main.m_simData.setSimCurRelStateFlags(n3, 32);
                } else if (n == 97) {
                    Main.m_simData.setSimCurRelStateFlags(n3, 64);
                }
            }
        } else if (!bl) {
            switch (n) {
                default: {
                    break;
                }
                case 171: 
                case 172: 
                case 184: {
                    StateInGame.gotoMapForObject(mapObject);
                    break;
                }
                case 116: {
                    StateInGame.gotoMap();
                    break;
                }
                case 148: {
                    StateInGame.showQuitJob();
                    break;
                }
                case 4: {
                    if (bl2) {
                        Main.m_simData.adjustMotiveLevel(3, -6553600);
                    }
                    if (StateInGame.isObjectAt(1, this.getPosX(), this.getPosZ())) break;
                    int n4 = -1;
                    if (StateInGame.m_mapMode == 0) {
                        n4 = Main.m_simWorld.objectBuy(7, this.getPosX(), this.getPosZ(), this.getFacingDir());
                    }
                    StateInGame.createObject(7, this.getPosX(), this.getPosZ(), this.getFacingDir(), n4);
                    break;
                }
                case 157: {
                    if (bl2) break;
                    this.m_simStateTime = 0;
                    StateInGame.showDoorKnock(this.getId());
                    break;
                }
                case 174: {
                    Main.m_simData.adjustMotiveLevel(0, 65536);
                    break;
                }
                case 128: 
                case 129: {
                    this.m_needFlags &= 0xFFFFFFFB;
                }
            }
        }
        if (n == 158) {
            this.unsetRuntimeFlag(16);
            if (bl) {
                this.m_queuedSimAction = -1;
                this.m_queuedSimActionArg1 = null;
            } else {
                this.setRuntimeFlag(32);
            }
        }
        if (mapObject != null && mapObjectSim == null && !bl) {
            mapObject.respondToAction(n, this);
            if (bl2) {
                Main.m_simData.setQuickLinkVisited(mapObject.getType());
            }
        }
        if (this.m_queuedSimAction != -1 && this.isIdle()) {
            this.beginSimAction(this.m_queuedSimAction, this.m_queuedSimActionArg1, this.m_queuedSimActionArg2, this.m_queuedSimActionArg3);
            this.m_queuedSimAction = -1;
            this.m_queuedSimActionArg1 = null;
        }
    }

    public final boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        int n2 = mapObjectSim.getId();
        int n3 = this.getId();
        int[] nArray = MapObject.s_tempInt10;
        Main.m_simData.relationshipAction(nArray, n2, n3, n);
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        if ((n4 & 0x40) != 0) {
            StateInGame.advertiseEvent(25, mapObjectSim, this);
        }
        if (n == 108 || n == 103) {
            this.beginSimAction(0, null);
            this.setNeedFlag(256);
        } else if (n5 != -1) {
            if ((Main.m_simData.d_actionFlags[n5] & 1) == 0 && n5 != 111) {
                mapObjectSim = null;
            }
            if (n2 == 0 && n5 == 13) {
                if (Main.m_simData.isTraitDiscovered(n3, 17)) {
                    Main.m_simData.dreamCompleteEvent(6);
                }
                Main.m_simData.setSimCurRelStateFlags(n3, 8);
            }
            this.beginSimAction(n5, mapObjectSim, n4, 0);
            if (n6 != -1) {
                StateInGame.createEffectAnim(this.getPosX(), this.getPosZ(), n6, 0);
            }
        }
        return (n4 & 0x20) != 0;
    }

    public final boolean respondToEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        if (this.isSleeping()) {
            return false;
        }
        if (n == 25 && Main.m_simData.getSimPartner(this.getId()) != mapObject.getId()) {
            return false;
        }
        int[] nArray = MapObject.s_tempInt10;
        Main.m_simData.relationshipAction(nArray, mapObjectSim.getId(), this.getId(), n);
        int n2 = nArray[1];
        if (n2 != -1) {
            int n3 = nArray[0];
            MapObject mapObject2 = (n3 & 0x2000) != 0 ? mapObject : mapObjectSim;
            this.interrupt();
            this.queueSimAction(n2, mapObject2, 0, 0);
            this.setRuntimeFlag(8);
            return true;
        }
        return false;
    }

    private final void beginSimPhase(int n) {
        boolean bl;
        this.m_simPhase = n;
        int n2 = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        int n3 = this.m_simActionArg2;
        int n4 = this.m_simActionArg3;
        boolean bl2 = bl = this.getId() == 0;
        if (bl && mapObjectSim != null) {
            Main.m_simData.setLastNPC(mapObjectSim.getId());
        }
        boolean bl3 = false;
        block0 : switch (n) {
            case 49: {
                this.simStateTransition(10);
                break;
            }
            case 0: {
                if (this.m_posture == 7 || this.m_posture == 6) {
                    --this.m_simActionPhaseIndex;
                    this.beginSimPhase(29);
                    break;
                }
                this.simStateTransition(1);
                break;
            }
            case 1: {
                this.simWalkTo(mapObject, n3, n4);
                break;
            }
            case 2: 
            case 3: {
                if (mapObject != null && mapObject.getRuntimeFlag(512) && (n2 == 126 || n2 == 127)) {
                    this.failSimPhase(false);
                    this.endSimAction();
                    break;
                }
                if (mapObject != null) {
                    this.setFacingObject(mapObject);
                } else {
                    this.setFacingDir(n3 - this.getPosX(), n4 - this.getPosZ());
                }
                if (n == 3) {
                    this.setFacingDir(this.getFacingDir() + 2 & 3);
                }
                this.endSimPhase();
                break;
            }
            case 4: {
                this.setFacingDir(mapObject.getFacingDir());
                this.endSimPhase();
                break;
            }
            case 8: {
                this.simStateTransition(5);
                break;
            }
            case 9: {
                this.simStateTransition(6);
                break;
            }
            case 10: {
                this.getSimActionArg1Sim().interrupt();
                this.endSimPhase();
                break;
            }
            case 11: {
                this.simStateTransition(7);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.performPhaseFeedback(n2, n);
                bl3 = true;
                break;
            }
            case 20: {
                if (mapObject.getRuntimeFlag(256)) {
                    this.failSimPhase(false);
                    break;
                }
                mapObject.turnOn();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 21: {
                mapObject.turnOff();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 22: {
                int n5 = Main.m_simWorld.coordWorldToWorldTileX(mapObject.getPosX());
                int n6 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
                MapObject mapObject2 = StateInGame.findObjectByParentTypeNearest(8, n5, n6);
                if (mapObject2 != null) {
                    int n7 = Main.m_simWorld.coordWorldToWorldTileX(mapObject2.getPosX());
                    int n8 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject2.getPosZ());
                    int n9 = Main.m_simWorld.getAttribute(n5, n6) & 0xF;
                    int n10 = Main.m_simWorld.getAttribute(n7, n8) & 0xF;
                    int n11 = Math.abs(mapObject2.getFacingDir() - mapObject.getFacingDir());
                    if (n9 == n10 && n11 != 0) {
                        this.beginSimAction(149, mapObject2, 0, 0);
                    } else {
                        this.beginSimAction(111, mapObject, 0, 0);
                    }
                } else {
                    this.beginSimAction(111, mapObject, 0, 0);
                }
                bl3 = true;
                break;
            }
            case 23: {
                int n12;
                int n13 = this.m_simActionPhaseIndex - 1;
                boolean bl4 = n13 >= 0 && Main.m_simData.d_actionPhases[this.m_simAction][n13] == 12;
                int n14 = 10;
                MapObject mapObject3 = null;
                if (bl4) {
                    for (n12 = 0; !(n12 >= n14 || (mapObject3 = StateInGame.findRandomNeedObject(128, true)) != null && mapObject3.occupiedIsEmpty() && mapObject3.getType() == 50); ++n12) {
                        mapObject3 = null;
                    }
                }
                if (mapObject3 == null) {
                    for (n12 = 0; !(n12 >= n14 || (mapObject3 = StateInGame.findRandomNeedObject(128, true)) != null && mapObject3.occupiedIsEmpty()); ++n12) {
                    }
                }
                if (mapObject3 != null) {
                    this.m_simActionArg1 = mapObject3;
                    this.endSimPhase();
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 24: {
                if (bl) {
                    Main.m_simData.setMotiveAdjust(5, 0x300000);
                    Main.m_simData.setFastforward(true);
                }
                this.simFeedback(53, 10000, -1, false, false);
                break;
            }
            case 13: {
                this.simFeedback(4, 7500, -1, false, false);
                Main.m_simData.setFastforward(true);
                break;
            }
            case 14: {
                this.simFeedback(4, 7500, -1, false, false);
                Main.m_simData.setFastforward(true);
                break;
            }
            case 12: {
                if (bl && Main.m_simData.startRecipe(n3) && mapObject.getParentType() == 18) {
                    mapObject.stoveStart();
                    this.simFeedback(4, 7500, -1, false, false);
                    Main.m_simData.setFastforward(true);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 55: {
                if (!bl) break;
                StateInGame.showMessageBoxFun();
                this.endSimPhase();
                break;
            }
            case 51: {
                if (GameConstants.Minigame_areNecessaryToolsAvailable(0)) {
                    if (n2 == 159 && StateInGame.m_mapMode == 1 && !GameConstants.Minigame_isMinigameAvailable(0)) {
                        StateInGame.showMessageBox(459, 818);
                        this.endSimPhase();
                        break;
                    }
                    GameConstants.Minigame_beginMiniGame(0, mapObject);
                    break;
                }
                StateInGame.showMessageBox(460, 818);
                this.endSimPhase();
                GameConstants.Minigame_npcID = -1;
                break;
            }
            case 52: {
                if (GameConstants.Minigame_areNecessaryToolsAvailable(2)) {
                    if (n2 == 160 && StateInGame.m_mapMode == 1 && !GameConstants.Minigame_isMinigameAvailable(2)) {
                        StateInGame.showMessageBox(461, 825);
                        this.endSimPhase();
                        break;
                    }
                    GameConstants.Minigame_beginMiniGame(1, mapObject);
                    break;
                }
                StateInGame.showMessageBox(462, 825);
                this.endSimPhase();
                GameConstants.Minigame_npcID = -1;
                break;
            }
            case 53: {
                if (GameConstants.Minigame_areNecessaryToolsAvailable(1)) {
                    if (n2 == 161 && StateInGame.m_mapMode == 1 && !GameConstants.Minigame_isMinigameAvailable(1)) {
                        StateInGame.showMessageBox(463, 832);
                        this.endSimPhase();
                        break;
                    }
                    GameConstants.Minigame_beginMiniGame(2, mapObject);
                    break;
                }
                StateInGame.showMessageBox(464, 832);
                this.endSimPhase();
                GameConstants.Minigame_npcID = -1;
                break;
            }
            case 54: {
                if (GameConstants.Minigame_areNecessaryToolsAvailable(3)) {
                    if (n2 == 162 && StateInGame.m_mapMode == 1 && !GameConstants.Minigame_isMinigameAvailable(3)) {
                        StateInGame.showMessageBox(469, 839);
                        this.endSimPhase();
                        break;
                    }
                    GameConstants.Minigame_beginMiniGame(3, mapObject);
                    break;
                }
                StateInGame.showMessageBox(470, 839);
                this.endSimPhase();
                GameConstants.Minigame_npcID = -1;
                break;
            }
            case 15: {
                int n15;
                if (mapObject.getRuntimeFlag(256)) {
                    this.failSimPhase(false);
                    break;
                }
                int n16 = 5000;
                if (bl) {
                    n15 = 0x640000;
                    if (n2 == 133) {
                        n15 = Main.m_simWorld.getRecipeReplenishes(n3);
                    } else if (mapObject.getParentType() == 12) {
                        n15 /= 2;
                    }
                    Main.m_simData.setMotiveAdjust(0, n15);
                    Main.m_simData.setFastforward(true);
                }
                if (mapObject.getParentType() == 12) {
                    mapObject.fridgeOpen();
                    n16 = 7000;
                }
                n15 = 4;
                if (this.m_posture == 2 || this.m_posture == 1) {
                    n15 = 55;
                }
                this.simFeedback(n15, n16, -1, false, false);
                bl3 = true;
                break;
            }
            case 16: {
                if (mapObject.getRuntimeFlag(512)) {
                    this.failSimPhase(false);
                    break;
                }
                int n17 = mapObject.getParentType();
                if (n17 == 16) {
                    if (bl) {
                        Main.m_simData.setMotiveAdjust(3, 0x640000);
                        Main.m_simData.setFastforward(true);
                        ++StateInGame.numShowers;
                    }
                    mapObject.showerStart();
                    this.simHide(15000, false);
                    bl3 = true;
                    break;
                }
                if (n17 == 3) {
                    mapObject.bathToFill();
                    mapObject.setPostRenderTarget(this);
                    if (bl) {
                        Main.m_simData.setFastforward(true);
                    }
                    this.simFeedback(4, 8000, -1, false, false);
                    bl3 = true;
                    break;
                }
                if (n17 == 2) {
                    if (bl) {
                        Main.m_simData.setFastforward(true);
                        if (!this.getRuntimeFlag(1024)) {
                            Main.m_simData.setMotiveAdjust(3, 0x640000);
                        }
                    }
                    mapObject.basinStart();
                    this.simFeedback(4, 8000, -1, false, false);
                    break;
                }
                Debug.ASSERT(false, "what are we washing at?!");
                break;
            }
            case 56: {
                int n18 = mapObject.getType();
                switch (n18) {
                    default: {
                        break block0;
                    }
                    case 33: {
                        Event.triggerEvent(9, -1, 1, -1, -1);
                        this.endSimAction();
                        break block0;
                    }
                    case 34: {
                        Event.triggerEvent(9, -1, 2, -1, -1);
                        this.endSimAction();
                        break block0;
                    }
                    case 35: {
                        Event.triggerEvent(9, -1, 3, -1, -1);
                        this.endSimAction();
                        break block0;
                    }
                    case 36: 
                }
                Event.triggerEvent(9, -1, 4, -1, -1);
                this.endSimAction();
                break;
            }
            case 50: {
                if (bl) {
                    this.lastInteractivityObject = mapObject;
                }
                if (mapObject.getType() == 134) {
                    this.simFeedback(12, 3000, -1, false, false);
                    if (Main.randPercent() < 10) {
                        GameConstants.Minigame_inspired = true;
                    }
                    mapObject.interactStart();
                }
                if (mapObject.getType() == 136) {
                    this.simHide(4800, false);
                    mapObject.interactStart(14000);
                }
                if (mapObject.getType() == 120) {
                    this.simFeedback(19, 10700, -1, false, false);
                    if (Main.randPercent() < 10) {
                        GameConstants.Minigame_inspired = true;
                    }
                    mapObject.interactStart(10700);
                }
                if (mapObject.getType() == 127) {
                    this.simFeedback(28, 9600, -1, false, false);
                    mapObject.interactStart(9600);
                }
                if (mapObject.getType() == 151) {
                    this.simFeedback(-4, 7650, -1, false, false);
                    mapObject.interactStart(7650);
                }
                if (mapObject.getType() == 149) {
                    this.simFeedback(28, 5200, -1, false, false);
                    mapObject.interactStart(5200);
                }
                if (mapObject.getType() == 163) {
                    this.simFeedback(14, 10000, -1, false, false);
                    if (Main.randPercent() < 10) {
                        GameConstants.Minigame_inspired = true;
                    }
                    mapObject.interactStart(10000);
                }
                if (mapObject.getType() == 164) {
                    this.simFeedback(13, 12000, -1, false, false);
                    mapObject.interactStart(12000);
                }
                Cursor.hide = true;
                Cursor.stopCursor();
                StateInGame.hideContextMenu();
                StateInGame.snapCameraAndCursor(mapObject);
                break;
            }
            case 17: {
                if (bl) {
                    Main.m_simData.setMotiveAdjust(2, 0x4B0000);
                    Main.m_simData.setFastforward(true);
                }
                int n19 = n2 == 126 ? 23 : 24;
                this.simFeedback(n19, 2000, -1, false, false);
                break;
            }
            case 18: 
            case 19: {
                this.performPhaseSleep(n);
                bl3 = true;
                break;
            }
            case 27: {
                if (bl) {
                    int n20 = Main.m_simData.getJobSearchCareerFromObject(mapObject);
                    int n21 = Main.m_simData.getJobSearchLevel(n20);
                    StateInGame.showJobOffer(n20, n21);
                }
                this.endSimPhase();
                break;
            }
            case 25: {
                if (bl) {
                    this.simStateTransition(8);
                    Main.m_simData.setLastNPC(-1);
                    Cursor.m_cursorAtDestTime = 1000;
                    StateInGame.startCurtainIn();
                    break;
                }
                MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                if (mapObjectSimArray.length == 2 && Main.m_simWorld.m_houseId == Main.m_simData.getSimHome(this.getId()) && !Main.m_simData.isWelcome()) {
                    StateInGame.kickPlayer(506, Main.m_simData.getSimName(this.getId()));
                }
                this.simStateTransition(9);
                break;
            }
            case 26: {
                StateInGame.finishCallAction(n2, n3);
                this.endSimPhase();
                break;
            }
            case 42: {
                StateInGame.buyFurniture();
                this.endSimPhase();
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.performPhasePosture(n);
                break;
            }
            case 28: {
                if (StateInGame.isHouseMode() && Main.getNextHouseId() == Main.m_simData.getSimHome(this.getId()) && Main.m_simWorld.m_houseId != 0) {
                    StateInGame.kickPlayer(502, 419);
                }
                this.endSimPhase();
                break;
            }
            case 38: {
                if (n2 == 132 && mapObject != null && mapObject.getParentType() == 12 && mapObject.getRuntimeFlag(256)) {
                    this.failSimPhase(true);
                    break;
                }
                if (bl) {
                    this.performPhaseCheckMoney();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 39: {
                if (bl) {
                    this.performPhaseCheckLock();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 40: {
                if (bl) {
                    this.performPhaseCheckHappy();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 41: {
                StateInGame.openShop(mapObject);
                this.endSimPhase();
                break;
            }
            case 43: {
                StateInGame.m_timeHit = 60;
                Main.m_simData.setMotiveAdjust(1, -786432);
                Main.m_simData.setMotiveAdjust(3, -786432);
                this.performPhasePlant();
                break;
            }
            case 44: {
                StateInGame.m_timeHit = 30;
                Main.m_simData.setMotiveAdjust(1, -393216);
                Main.m_simData.setMotiveAdjust(3, -393216);
                this.performPhaseTend();
                break;
            }
            case 45: {
                mapObject.plantHarvest();
                this.endSimPhase();
                break;
            }
            case 46: {
                mapObject.plantUproot();
                this.endSimPhase();
                break;
            }
            case 47: {
                Debug.ASSERT(mapObject.getParentType() == 7, "drinking at non-coffee machine");
                mapObject.coffeeMachineActivate();
                this.simFeedback(0, 60000, -1, false, false);
                bl3 = true;
                break;
            }
            case 48: {
                if (bl) {
                    Main.m_simData.setMotiveAdjust(2, -983040);
                    Main.m_simData.setMotiveAdjust(1, 983040);
                    Main.m_simData.setFastforward(true);
                }
                this.simFeedback(4, 2000, -1, false, false);
                break;
            }
        }
        if (bl && bl3 && (Main.m_simData.d_actionFlags[n2] & 0x100000) != 0) {
            StateInGame.advertiseEvent(22, this, this.m_simActionArg1);
        }
        if (this.getRuntimeFlag(2)) {
            this.failSimPhase(true);
        }
    }

    private void performPhaseFeedback(int n, int n2) {
        int n3;
        MapObject mapObject;
        if (n == 157 && (mapObject = StateInGame.findRandomObjectByParentType(9)) != null && mapObject.getRuntimeFlag(64)) {
            this.endSimPhase();
            return;
        }
        int n4 = -1;
        int n5 = -1;
        if (n2 == 5 && this.getId() == 0) {
            int n6 = n5 = this.getFacingDir() == 3 || this.getFacingDir() == 0 ? 741 : 742;
            if (Main.m_simData.getSimAttribute(this.getId(), 0) == 1) {
                if (this.m_speakFemale != null && this.m_speakFemale.length > 0) {
                    PMAudio.play(this.m_speakFemale[Main.rand(0, this.m_speakFemale.length - 1)], 1);
                }
            } else if (this.m_speakMale != null && this.m_speakMale.length > 0) {
                PMAudio.play(this.m_speakMale[Main.rand(0, this.m_speakMale.length - 1)], 1);
            }
        }
        boolean bl = false;
        if (n != 143 && n != 144 && n != 119 && this.m_simActionArg2 != 0) {
            n5 = Main.responseToFeedbackAnim(this.m_simActionArg2);
            bl = true;
        }
        int n7 = n3 = n2 == 7 ? -1 : 2000;
        if (n == 17) {
            n3 = 5000;
        }
        this.simFeedback(n4, n3, n5, bl, false);
        if (this.getId() == 0) {
            if (n == 153) {
                Main.m_simData.setMotiveAdjust(3, -983040);
            } else if (n == 15 || n == 16) {
                Main.m_simData.setMotiveAdjust(5, 0x300000);
            } else if (n == 17) {
                Main.m_simData.setMotiveAdjust(5, 0x400000);
            }
        }
    }

    private void performPhaseSleep(int n) {
        int n2 = Main.m_simData.getGameTimeAbs();
        int n3 = Main.m_simData.getWakeupTime(this.getId());
        if (n == 18) {
            n3 = Math.min(n3, n2 + 120);
        }
        int n4 = n3 - n2;
        if (this.getId() == 0) {
            Main.m_simData.setFastforward(true);
            Main.m_simData.setMotiveAdjust(1, 0x320000);
        }
        this.stopSecondaryAnim();
        this.setEffectAnimId(this.getFacingDir() == 0 ? 111 : 110);
        this.simFeedback(15, n2 + n4, -1, false, true);
    }

    private void performPhasePosture(int n) {
        int n2;
        if (n == 30) {
            Debug.ASSERT(this.m_simActionArg1 != null, "can't auto-sit without a chair");
            if (this.m_simActionArg1.getParentType() == 6) {
                n = 32;
            } else {
                this.setFacingDir(this.getFacingDir() + 2 & 3);
                n = 31;
            }
        }
        int n3 = n == 29 ? 0 : (n == 31 ? 1 : (n == 32 ? 2 : (n == 33 ? 3 : (n == 36 ? 6 : (n == 34 ? 4 : (n2 = n == 35 ? 5 : 7))))));
        if (this.m_posture == n2) {
            this.endSimPhase();
        } else {
            this.m_targetPosture = n2;
            this.simStateTransition(2);
        }
    }

    private void performPhaseCheckMoney() {
        int n = Main.m_simData.getCostForAction(this.m_simAction);
        int n2 = Main.m_simData.getMoney();
        if (n2 >= n) {
            if (this.m_simAction == 132 || this.m_simAction == 174) {
                Main.m_simData.adjustMoney(-n, 2);
            } else {
                Main.m_simData.adjustMoney(-n, -1);
            }
            StateInGame.createEffectMoney(this.getPosX(), this.getPosZ(), n);
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    private void performPhaseCheckLock() {
        boolean bl = true;
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        if (mapObjectSimArray.length > 1) {
            bl = false;
        } else if (Main.m_simData.isWelcome()) {
            bl = false;
        }
        if (bl) {
            this.failSimPhase(false);
        } else {
            this.endSimPhase();
        }
    }

    private void performPhaseCheckHappy() {
        if (Main.m_simData.buffGetActiveSlot(12) != -1 || Main.m_simData.buffGetActiveSlot(11) != -1) {
            int n = 7;
            if (Main.randPercent() < 50) {
                n = 14;
            }
            this.beginSimAction(n, this.m_simActionArg1);
        } else {
            this.endSimPhase();
        }
    }

    private void performPhasePlant() {
        int n = this.m_simActionArg2;
        if (Main.m_simData.getInventoryCount(n) > 0) {
            Main.m_simData.adjustInventory(n, -1);
            this.m_simActionArg1.plantSeed(n);
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    private void performPhaseTend() {
        if (Main.m_simData.getInventoryCount(28) > 0 && Main.m_simData.getInventoryCount(29) > 0) {
            Main.m_simData.adjustInventory(29, -1);
            this.m_simActionArg1.plantGrow();
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    public final void endSimPhase() {
        this.endSimPhase(false);
    }

    private final void endSimPhase(boolean bl) {
        int n;
        int n2 = Main.m_simData.d_actionPhases[this.m_simAction].length;
        boolean bl2 = this.getId() == 0;
        MapObject mapObject = this.m_simActionArg1;
        switch (this.m_simPhase) {
            case 15: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(0, 0);
                    Main.m_simData.setFastforward(false);
                }
                if (mapObject == null || mapObject.getParentType() != 12) break;
                mapObject.fridgeClose();
                break;
            }
            case 24: {
                if (!bl2) break;
                Main.m_simData.setMotiveAdjust(5, 0);
                Main.m_simData.setFastforward(false);
                break;
            }
            case 12: {
                if (bl || mapObject.getParentType() != 18) break;
                mapObject.stoveEnd();
                Main.m_simData.setFastforward(false);
                Main.m_simData.dreamCompleteEvent(15);
                break;
            }
            case 13: {
                if (!bl) {
                    mapObject.cleanObject();
                }
                Main.m_simData.setFastforward(false);
                break;
            }
            case 14: {
                if (!bl) {
                    mapObject.repairObject();
                }
                Main.m_simData.setFastforward(false);
                break;
            }
            case 18: 
            case 19: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(1, 0);
                    Main.m_simData.setFastforward(false);
                    if (this.m_simPhase == 18 && StateInGame.isZoomMapMode() && mapObject.getParentType() == 8) {
                        Main.m_simData.dreamCompleteEvent(2);
                    }
                }
                this.setEffectAnimId(-1);
                this.recheckBuffEffects();
                break;
            }
            case 16: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(3, 0);
                    Main.m_simData.setFastforward(false);
                }
                if (mapObject == null) break;
                n = mapObject.getParentType();
                if (n == 16) {
                    mapObject.showerEnd();
                    break;
                }
                if (n == 2) {
                    mapObject.basinEnd();
                    break;
                }
                if (n != 3) break;
                mapObject.bathToEmpty();
                mapObject.releasePostRenderTarget(this);
                break;
            }
            case 50: {
                if (mapObject.getType() == 120) {
                    Main.m_simData.dreamCompleteEvent(9);
                }
                if (mapObject.getType() == 127) {
                    Main.m_simData.dreamCompleteEvent(11);
                }
                if (mapObject.getType() == 134) {
                    Main.m_simData.dreamCompleteEvent(4);
                }
                if (mapObject.getType() == 136) {
                    Main.m_simData.dreamCompleteEvent(10);
                }
                if (mapObject.getType() == 151) {
                    Main.m_simData.dreamCompleteEvent(31);
                }
                if (mapObject.getType() != 149) break;
                Main.m_simData.dreamCompleteEvent(33);
                break;
            }
            case 17: {
                if (!bl2) break;
                Main.m_simData.setMotiveAdjust(2, 0);
                Main.m_simData.setFastforward(false);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.endFeedback();
                if (!bl2) break;
                if (this.m_simAction == 153) {
                    Main.m_simData.setMotiveAdjust(3, 0);
                    break;
                }
                if (this.m_simAction != 15 && this.m_simAction != 16 && this.m_simAction != 17) break;
                Main.m_simData.setMotiveAdjust(5, 0);
                break;
            }
            case 47: {
                if (mapObject == null) break;
                mapObject.coffeeMachineDeactivate();
                break;
            }
            case 48: {
                if (!bl2) break;
                Main.m_simData.setMotiveAdjust(2, 0);
                Main.m_simData.setMotiveAdjust(1, 0);
                Main.m_simData.setFastforward(false);
                break;
            }
            case 25: {
                if (!bl2) break;
                MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                for (int i = 0; i < mapObjectSimArray.length; ++i) {
                    if (mapObjectSimArray[i].getType() == 0) continue;
                    mapObjectSimArray[i].destroy();
                }
                Main.m_simWorld.spawnSimsZoomMap();
                break;
            }
        }
        if (!bl) {
            if (this.m_simActionPhaseIndex < n2 - 1) {
                ++this.m_simActionPhaseIndex;
                n = Main.m_simData.d_actionPhases[this.m_simAction][this.m_simActionPhaseIndex];
                this.beginSimPhase(n);
            } else {
                this.endSimAction();
            }
        }
    }

    public final void interrupt() {
        GlobalConstants.PMDebug_println("interrupt");
        if (this.getRuntimeFlag(2)) {
            return;
        }
        this.setRuntimeFlag(2);
        int n = Main.m_simData.d_actionFlags[this.m_simAction];
        if ((n & 1) != 0 && (n & 0x80000) == 0 && this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getId() != this.getId() && !this.getSimActionArg1Sim().getRuntimeFlag(2)) {
            this.getSimActionArg1Sim().interrupt();
        }
        this.failSimPhase(true);
    }

    private final void failSimPhase(boolean bl) {
        if (this.m_simAction == 4) {
            return;
        }
        if (this.getId() == 0) {
            Main.m_simData.setFastforward(false);
        }
        this.setRuntimeFlag(4);
        int n = -1;
        int n2 = 138;
        switch (this.m_simPhase) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: {
                break;
            }
            case 1: {
                n = 137;
                break;
            }
            case 23: {
                if (this.m_simAction == 151) {
                    n = 134;
                    break;
                }
                n = 131;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 47: 
            case 48: {
                this.endSimPhase(true);
                this.endSimAction();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.endSimPhase();
                break;
            }
            case 12: {
                n = 511;
                n2 = Main.m_simWorld.d_itemDescStringIds[Main.m_simWorld.d_recipeItems[this.m_simActionArg2]];
                if (this.m_simActionArg1 == null) break;
                this.m_simActionArg1.stoveEnd();
                break;
            }
            case 43: {
                n = 133;
                break;
            }
            case 44: {
                n = 135;
                break;
            }
            case 38: {
                n = 132;
                break;
            }
            case 39: {
                n = 130;
                break;
            }
            case 40: {
                n = 136;
                break;
            }
        }
        if (n != -1) {
            if (!bl && this.getId() == 0) {
                StateInGame.showMessageBox(n, n2);
            }
            this.endSimAction();
        }
    }

    private final void checkNeeds() {
        if (!this.isIdle()) {
            return;
        }
        if (StateInGame.m_state == 16) {
            return;
        }
        int n = this.m_needFlags;
        if ((n & 0x101) != 0) {
            MapObject mapObject = StateInGame.findRandomObjectByType(4);
            this.beginSimAction(183, mapObject);
            return;
        }
        if (StateInGame.getContextMenuObject() != null && (StateInGame.getContextMenuObject().equals(this) || this.getType() == 0)) {
            return;
        }
        if (this.getId() != 0 && this.m_lastConversationTimer == -1 && this.checkNeedChat()) {
            return;
        }
        if (StateInGame.m_mapMode != 2) {
            if ((n & 0x5E) != 0) {
                for (int i = 0; i < this.GENERIC_NEEDS.length; ++i) {
                    MapObject mapObject;
                    int n2 = this.GENERIC_NEEDS[i];
                    if ((n & n2) == 0 || (mapObject = StateInGame.findRandomNeedObject(n2, false)) == null) continue;
                    this.beginSimAction(Main.m_simWorld.getObjectFirstAction(mapObject.getType()), mapObject);
                    this.m_needFlags &= ~n2;
                    return;
                }
            } else if (this.getId() == 0 && this.m_lastConversationTimer == -1 && ArrayHandler.Rms_getAutonomityEnabled()) {
                this.checkNeedChat();
                this.setNeedFlag(Main.m_simData.getPlayerNeedFlags());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean checkNeedChat() {
        void var3_10;
        int n;
        int n2;
        MapObjectSim mapObjectSim;
        block19: {
            mapObjectSim = null;
            if (this.m_conversationSim != -1 && !this.checkNeedChatSim(mapObjectSim = StateInGame.findSim(this.m_conversationSim))) {
                mapObjectSim = null;
            }
            int n3 = this.getId();
            if (StateInGame.m_mapMode == 0) {
                if (Main.m_simData.getSimHome(n3) != Main.m_simWorld.m_houseId) {
                    if (!Main.m_simData.getSimCurRelStateFlags(n3, 1) && (n3 != 0 || ArrayHandler.Rms_getAutonomityEnabled())) {
                        if ((this.m_needFlags & 0x200) == 0) {
                            MapObject mapObject = StateInGame.findRandomObjectByParentType(9);
                            if (mapObject != null) {
                                this.beginSimAction(157, mapObject);
                                GlobalConstants.PMDebug_println("knocking on door");
                                this.m_needFlags |= 0x200;
                                return true;
                            }
                            break block19;
                        } else {
                            if (n3 != 0) {
                                if (this.m_simStateTime <= 30000) return true;
                                GlobalConstants.PMDebug_println("leaving...");
                                this.m_needFlags |= 0x100;
                                return true;
                            }
                            this.m_needFlags &= 0xFFFFFDFF;
                            return true;
                        }
                    }
                }
                this.m_needFlags &= 0xFFFFFDFF;
            }
        }
        if (mapObjectSim == null) {
            if (Main.randPercent() < 85) {
                return false;
            }
            MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
            int n4 = mapObjectSimArray.length;
            n2 = Main.rand(0, n4 - 1);
            for (n = 0; n < n4; ++n) {
                MapObjectSim mapObjectSim2 = mapObjectSimArray[n2];
                n2 = (n2 + 1) % mapObjectSimArray.length;
                if (!this.checkNeedChatSim(mapObjectSim2)) {
                    continue;
                }
                mapObjectSim = mapObjectSim2;
                break;
            }
        }
        if (mapObjectSim == null) return false;
        int[] nArray = new int[]{65, 90, 100};
        int[] nArray2 = new int[]{69, 81, 95};
        n2 = Main.m_simData.getMoodLevel();
        if (n2 < -3276800) {
            int[] nArray3 = new int[]{20, 30, 100};
        } else if (n2 > 0x4B0000) {
            int[] nArray4 = new int[]{10, 99, 100};
        } else if (n2 > 0x280000) {
            int[] nArray5 = new int[]{30, 90, 100};
        }
        n = Main.randPercent();
        int n5 = 0;
        while (n5 < ((void)var3_10).length) {
            if (n <= var3_10[n5]) {
                this.beginSimAction(nArray2[n5], mapObjectSim);
                return true;
            }
            ++n5;
        }
        return true;
    }

    private final boolean checkNeedChatSim(MapObjectSim mapObjectSim) {
        if (mapObjectSim != null && mapObjectSim.equals(this) || mapObjectSim == null) {
            return false;
        }
        MapObject mapObject = StateInGame.getContextMenuObject();
        if (mapObjectSim != null && mapObjectSim.equals(mapObject)) {
            return false;
        }
        if (mapObjectSim.getId() == 0 && mapObject != null) {
            return false;
        }
        if (mapObjectSim.getId() == 0 && mapObjectSim.lastInteractivityObject != null) {
            return false;
        }
        if (mapObjectSim.isSleeping()) {
            return false;
        }
        if (mapObjectSim.m_conversationSim != -1 && mapObjectSim.m_conversationSim != this.getId()) {
            return false;
        }
        if (mapObjectSim.getRuntimeFlag(8)) {
            return false;
        }
        return !mapObjectSim.getRuntimeFlag(1024) || Main.m_simData.hasSimGotTrait(this.getId(), 12) != -1;
    }

    public final void clearNeedFlags() {
        this.m_needFlags = 0;
    }

    public final void setNeedFlag(int n) {
        this.m_needFlags |= n;
    }

    public final void startBuff(int n) {
        switch (n) {
            default: {
                break;
            }
            case 9: {
                this.setRuntimeFlag(1024);
                if (StateInGame.isMapMode()) break;
                this.setEffectAnimId(118);
                this.setSecondaryAnim(115, 20);
                break;
            }
            case 6: {
                this.setRuntimeFlag(2048);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.setRuntimeFlag(4096);
            }
        }
    }

    public final void endBuff(int n) {
        switch (n) {
            default: {
                break;
            }
            case 9: {
                this.unsetRuntimeFlag(1024);
                if (StateInGame.isMapMode()) break;
                this.setEffectAnimId(-1);
                this.stopSecondaryAnim();
                break;
            }
            case 6: {
                this.unsetRuntimeFlag(2048);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.unsetRuntimeFlag(4096);
            }
        }
    }

    private void recheckBuffEffects() {
        if (this.getRuntimeFlag(1024)) {
            this.startBuff(9);
        }
    }

    public final void setConversation(MapObjectSim mapObjectSim) {
        this.m_conversationSim = mapObjectSim.getId();
        this.m_lastConversationTimer = -1;
        this.setNeedFlag(32);
        mapObjectSim.m_conversationSim = this.getId();
        mapObjectSim.m_lastConversationTimer = -1;
        mapObjectSim.setNeedFlag(32);
    }

    private final void clearConversation() {
        MapObjectSim mapObjectSim = StateInGame.findSim(this.m_conversationSim);
        if (mapObjectSim != null) {
            mapObjectSim.m_needFlags &= 0xFFFFFFDF;
            mapObjectSim.m_conversationSim = -1;
            mapObjectSim.m_conversationTimer = 0;
            mapObjectSim.m_lastConversationTimer = 0;
        }
        this.m_needFlags &= 0xFFFFFFDF;
        this.m_conversationSim = -1;
        this.m_conversationTimer = 0;
        this.m_lastConversationTimer = 0;
    }

    private final boolean hasCar() {
        int n = Main.m_simData.getSimCareer(this.getId());
        if (n != -1) {
            boolean bl;
            int n2 = Main.m_simData.getSimCareerLevel(this.getId());
            boolean bl2 = bl = (Main.m_simData.getCareerLevelFlags(n, n2) & 0x10) != 0;
            if (bl) {
                return true;
            }
        }
        if (this.getType() == 0 && Main.m_simData.getInventoryCount(59) != 0) {
            return true;
        }
        return Main.m_simData.hasSimGotFlag(this.getId(), 1);
    }

    public void gotoSleep(MapObject mapObject) {
        Debug.ASSERT(mapObject != null, "can't sleep on null");
        boolean bl = this.setOccupied(mapObject);
        Debug.ASSERT(bl, "couldn't get occupied flag for bed");
        int[] nArray = MapObject.s_tempInt10;
        mapObject.getInterestPoint(nArray, this.m_occupiedIndex);
        this.setPos(nArray[0], nArray[1]);
        this.setFacingObject(mapObject);
        this.setFacingDir((this.getFacingDir() + 2) % 4);
        this.m_posture = 4;
        this.m_targetPosture = 4;
        this.m_postureObject = mapObject;
        mapObject.setPostRenderTarget(this);
        if (this.getId() == 0) {
            StateInGame.snapCameraAndCursor(mapObject);
        }
        this.beginSimAction(129, mapObject);
    }
}

