/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Camera;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.constants.AnimConstants;
import dk.progressivemedia.skeleton.state.StateInGame;

public class AnimationManager {
    private static byte[] s_colourData;
    private static short[][] s_subImages;
    private static int s_curBank;
    private static SDKImage[][] s_animImageArray;
    private static short subImageFileLoadProgress;
    private static int subImageFileLoadCIndex;
    private static int subImageFileLoadCIndexMax;
    private static short animFileLoadProgress;
    private static int animFileLoadCIndex;
    private static int animFileLoadCIndexMax;
    private static short[][] s_frameDurations;
    private static short[][] s_frameOffsets;
    private static short[][] s_frameData;
    public static int[] primitiveBinaryDataCount;
    public static int[] primitiveDataCount;
    public static final String[] TextHandler_RFF;
    public static final String[] TextHandler_PNG;
    public static Object[] TextHandler_fonts;
    public static SDKImage[] TextHandler_fontImages;
    public static int TextHandler_m_numLanguages;
    public static byte[] TextHandler_fontSpaceWidth;
    public static byte[] TextHandler_fontLineHeight;
    public static int TextHandler_m_getStringInstance;
    public static SDKString[] TextHandler_m_sdkStringInstances;
    public static SDKString[] TextHandler_m_dynamicStrings;
    public static SDKString[] TextHandler_s_sdkStrings2;
    public static SDKString[] TextHandler_s_sdkStrings3;
    public static SDKString TextHandler_m_tempStringBuffer;
    public static SDKString[] TextHandler_m_tempStringBuffers;
    public static int TextHandler_m_tempBufferIndex;
    public static short[] TextHandler_m_wrapOffsets;
    public static SDKString TextHandler_m_wrapString;
    public static short[][] TextHandler_m_wrapChunkOffsets;
    public static SDKString[] TextHandler_m_wrapChunkStrings;
    public static short[] TextHandler_m_wrapChunkStringIds;
    public static short[] TextHandler_m_wrapChunkStringWidths;
    public static int[] TextHandler_m_scrollerStringId;
    public static SDKString[] TextHandler_m_scrollerStringArray;
    public static int[] TextHandler_m_scrollerStringWidth;
    public static int[] TextHandler_m_scrollerTime;
    public static int[] TextHandler_m_scrollerOffset;
    private static int MinigameMusic_inputBlockTimer;
    private static final int[] MinigameMusic_GAME_TIME;
    private static final int[] MinigameMusic_SPEED_PERCENTAGE;
    private static int[] MinigameMusic_chordsX;
    private static int[] MinigameMusic_chordsY;
    private static boolean[] MinigameMusic_chordsCleared;
    private static int MinigameMusic_chordsMissed;
    private static int MinigameMusic_nextChordToPlay;
    private static int MinigameMusic_totalChordCount;
    private static int MinigameMusic_chordsPerSec;
    private static int MinigameMusic_chordSpeed;
    private static int MinigameMusic_chordSpacing;
    private static int MinigameMusic_maxVisibleChords;
    private static boolean MinigameMusic_redrawLives;
    private static int MinigameMusic_topFretboardSegmentY;
    private static int MinigameMusic_inputAreaRectY;
    private static int MinigameMusic_playerInputWorldCenterY;
    private static int MinigameMusic_inputAreaWorldHeight;
    private static int MinigameMusic_firstChordStartY;
    private static int MinigameMusic_string1_x;
    private static int MinigameMusic_string2_x;
    private static int MinigameMusic_string3_x;
    private static int MinigameMusic_key4BoxCenterX;
    private static int MinigameMusic_key5BoxCenterX;
    private static int MinigameMusic_key6BoxCenterX;
    private static int MinigameMusic_fretboardSegmentWidth;
    private static int MinigameMusic_fretboardSegmentHeight;
    private static int MinigameMusic_chordWidth;
    private static int MinigameMusic_chordHeight;
    private static int MinigameMusic_halfGuitarStringWidth;
    private static int MinigameMusic_guitarStringHeight;
    private static int MinigameMusic_worldSpaceChordHeight;
    private static int MinigameMusic_lowestChordToUpdate;
    private static int MinigameMusic_highestChordToUpdate;
    public static final short[] SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS;
    public static int PMTouch_id;

    public static final boolean loadColorsFile() {
        s_colourData = GameConstants.PMFile_fileToByteArray(Intro.ResourceConstants_RESOURCE_FILENAMES_LIST[77]);
        return true;
    }

    public static final void setColor(int n) {
        if (s_colourData != null) {
            int n2 = n * 3;
            ArrayOptimizer.PMGraphics_setColor(s_colourData[n2] & 0xFF, s_colourData[n2 + 1] & 0xFF, s_colourData[n2 + 2] & 0xFF);
        }
    }

    public static final boolean loadSubimageFile() {
        if (subImageFileLoadProgress == 0) {
            s_subImages = new short[5][1947];
            Cursor.ResourceManager_loadBinaryFile(78);
            subImageFileLoadProgress = (short)(subImageFileLoadProgress + 1);
            return false;
        }
        short[][] sArray = s_subImages;
        if ((subImageFileLoadCIndexMax += 60) > 1946) {
            subImageFileLoadCIndexMax = 1946;
        }
        while (subImageFileLoadCIndex <= subImageFileLoadCIndexMax) {
            int n = subImageFileLoadCIndex++;
            sArray[0][n] = (short)GameConstants.PMFile_readUnsignedByte();
            sArray[1][n] = GameConstants.PMFile_readShort();
            sArray[2][n] = GameConstants.PMFile_readShort();
            sArray[3][n] = GameConstants.PMFile_readShort();
            sArray[4][n] = GameConstants.PMFile_readShort();
        }
        return subImageFileLoadCIndexMax == 1946;
    }

    public static final boolean loadAnimFile() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (animFileLoadProgress == 0) {
            Cursor.ResourceManager_loadBinaryFile(76);
            s_frameDurations = new short[790][];
            s_frameOffsets = new short[790][];
            s_frameData = new short[790][];
            animFileLoadProgress = 1;
            return false;
        }
        if (animFileLoadProgress == 1) {
            short[][] sArray = s_frameDurations;
            short[][] sArray2 = s_frameOffsets;
            short[][] sArray3 = s_frameData;
            if ((animFileLoadCIndexMax += 24) > 789) {
                animFileLoadCIndexMax = 789;
            }
            while (animFileLoadCIndex <= animFileLoadCIndexMax) {
                n = animFileLoadCIndex;
                int n2 = 0;
                int n3 = GameConstants.PMFile_readUnsignedByte();
                for (int i = 0; i < n3; ++i) {
                    GameConstants.PMFile_readShort();
                    int n4 = GameConstants.PMFile_readUnsignedByte();
                    for (int j = 0; j < n4; ++j) {
                        int n5 = GameConstants.PMFile_readUnsignedByte();
                        int n6 = primitiveBinaryDataCount[n5];
                        for (int k = 0; k < n6; ++k) {
                            GameConstants.PMFile_readByte();
                        }
                        n2 += primitiveDataCount[n5];
                    }
                }
                sArray[n] = new short[n3];
                sArray2[n] = new short[n3];
                sArray3[n] = new short[n2];
                ++animFileLoadCIndex;
            }
            if (animFileLoadCIndexMax != 789) {
                return false;
            }
            animFileLoadProgress = (short)2;
            return false;
        }
        if (animFileLoadProgress == 2) {
            GameConstants.PMFile_closeFile();
            Cursor.ResourceManager_loadBinaryFile(76);
            animFileLoadCIndex = 0;
            animFileLoadCIndexMax = 0;
            animFileLoadProgress = (short)3;
            return false;
        }
        if (animFileLoadProgress == 3) {
            if ((animFileLoadCIndexMax += 24) > 789) {
                animFileLoadCIndexMax = 789;
            }
            while (animFileLoadCIndex <= animFileLoadCIndexMax) {
                n = animFileLoadCIndex;
                int n7 = 0;
                short[] sArray = s_frameData[n];
                short[] sArray4 = s_frameDurations[n];
                short[] sArray5 = s_frameOffsets[n];
                int n8 = GameConstants.PMFile_readUnsignedByte();
                for (int i = 0; i < n8; ++i) {
                    sArray4[i] = GameConstants.PMFile_readShort();
                    sArray5[i] = (short)n7;
                    int n9 = GameConstants.PMFile_readUnsignedByte();
                    for (int j = 0; j < n9; ++j) {
                        int n10 = GameConstants.PMFile_readUnsignedByte();
                        switch (n10) {
                            case 0: 
                            case 11: {
                                sArray[n7 + 3] = GameConstants.PMFile_readShort();
                                sArray[n7 + 1] = GameConstants.PMFile_readShort();
                                sArray[n7 + 2] = GameConstants.PMFile_readShort();
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: {
                                sArray[n7 + 1] = GameConstants.PMFile_readShort();
                                sArray[n7 + 2] = GameConstants.PMFile_readShort();
                                sArray[n7 + 3] = GameConstants.PMFile_readShort();
                                sArray[n7 + 4] = GameConstants.PMFile_readShort();
                                break;
                            }
                            case 7: {
                                sArray[n7 + 1] = GameConstants.PMFile_readShort();
                                sArray[n7 + 2] = GameConstants.PMFile_readShort();
                                break;
                            }
                            case 10: {
                                sArray[n7 + 1] = GameConstants.PMFile_readByte();
                            }
                        }
                        sArray[n7] = (short)n10;
                        n7 += primitiveDataCount[n10];
                    }
                }
                ++animFileLoadCIndex;
            }
            if (animFileLoadCIndexMax != 789) {
                return false;
            }
        }
        GameConstants.PMFile_closeFile();
        s_frameDurations = ArrayOptimizer.Optimize(s_frameDurations);
        s_frameOffsets = ArrayOptimizer.Optimize(s_frameOffsets);
        s_frameData = ArrayOptimizer.Optimize(s_frameData);
        GlobalConstants.PMDebug_println(2, "finished, loadAnimFile");
        return true;
    }

    private static final int getFrameOffsetStart(int n, int n2) {
        if (n >= 0 && n < s_frameOffsets.length && n2 >= 0 && n2 < s_frameOffsets[n].length) {
            return s_frameOffsets[n][n2];
        }
        GlobalConstants.PMDebug_println("BLEEP! wrong offset!");
        return 0;
    }

    private static final int getFrameOffsetEnd(int n, int n2) {
        short[] sArray = s_frameOffsets[n];
        if (n2 < sArray.length - 1) {
            return sArray[n2 + 1];
        }
        return s_frameData[n].length;
    }

    public static final boolean loadImage(int n) {
        return AnimationManager.loadImage(n, null, null, 0);
    }

    public static final boolean loadImage(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = 73;
        while (--n3 >= 0 && n != AnimConstants.IMAGE_RES_IDS[n3]) {
        }
        if (73 == n3) {
            GlobalConstants.PMDebug_println(1, "No resID found!");
            return false;
        }
        SDKImage[] sDKImageArray = s_animImageArray[n2];
        if (sDKImageArray[n3] == null) {
            SDKImage sDKImage = nArray != null ? Cursor.ResourceManager_loadImage(n, nArray, nArray2) : Cursor.ResourceManager_loadImage(n);
            sDKImageArray[n3] = sDKImage;
            if (sDKImage == null) {
                GlobalConstants.PMDebug_println("load fail");
                return false;
            }
        }
        return true;
    }

    public static final boolean unloadImage(int n, int n2) {
        int n3 = 73;
        while (--n3 >= 0 && n != AnimConstants.IMAGE_RES_IDS[n3]) {
        }
        if (n3 < 0) {
            GlobalConstants.PMDebug_println("unload aborted (resID not found)");
            return false;
        }
        if (n2 == -1) {
            int n4 = 6;
            while (--n4 >= 0) {
                if (s_animImageArray[n4][n3] == null) continue;
                AnimationManager.s_animImageArray[n4][n3] = null;
                Event.PMSystem_forceGC();
            }
        } else if (s_animImageArray[n2][n3] != null) {
            AnimationManager.s_animImageArray[n2][n3] = null;
            Event.PMSystem_forceGC();
        }
        return true;
    }

    public static final void drawAnimFrame(int n, int n2, int n3, int n4) {
        short s;
        if (n < 0) {
            return;
        }
        int n5 = 1;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            n5 = -1;
        }
        SDKImage[] sDKImageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        short[] sArray2 = s_frameData[n];
        int n6 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n6; i += primitiveDataCount[s]) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                short s2 = sArray2[i + 3];
                short s3 = sArray[0][s2];
                short s4 = sArray[1][s2];
                short s5 = sArray[2][s2];
                short s6 = sArray[3][s2];
                short s7 = sArray[4][s2];
                int n7 = s3 & 0xFFFF;
                SDKImage sDKImage = sDKImageArray[n7];
                if (sDKImage == null) continue;
                int n8 = n3 + n5 * sArray2[i + 1];
                int n9 = n4 + sArray2[i + 2];
                if (n5 < 0) {
                    n8 -= s6;
                }
                int n10 = 0;
                if (n5 > 0 && s == 11 || n5 < 0 && s == 0) {
                    n10 = 2;
                }
                ArrayOptimizer.PMGraphics_drawRegion(sDKImage, s4, s5, s6, s7, n10, n8, n9, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            AnimationManager.drawPrimitive(n3, n4, sArray2, i, n5);
        }
    }

    public static final boolean drawAnimFrameExt(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        short s;
        if (n < 0) {
            return false;
        }
        int n7 = 1;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            n7 = -1;
        }
        SDKImage[] sDKImageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        boolean bl = false;
        short[] sArray2 = s_frameData[n];
        int n8 = AnimationManager.getFrameOffsetEnd(n, n2);
        short[] sArray3 = n5 >= 0 ? s_frameData[n5] : null;
        block0: for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n8; i += primitiveDataCount[s]) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                int n9;
                int n10;
                SDKImage sDKImage;
                short s2 = sArray2[i + 3];
                short s3 = sArray[0][s2];
                short s4 = sArray[1][s2];
                short s5 = sArray[2][s2];
                short s6 = sArray[3][s2];
                short s7 = sArray[4][s2];
                int n11 = n3 + n7 * sArray2[i + 1];
                int n12 = n4 + sArray2[i + 2];
                if (n7 < 0) {
                    n11 -= s6;
                }
                if ((sDKImage = sDKImageArray[n10 = s3 & 0xFFFF]) != null) {
                    n9 = 0;
                    if (n7 > 0 && s == 11 || n7 < 0 && s == 0) {
                        n9 = 2;
                    }
                    ArrayOptimizer.PMGraphics_drawRegion(sDKImage, s4, s5, s6, s7, n9, n11, n12, 20);
                }
                if (sArray3 == null) continue;
                n9 = AnimationManager.getAnimFrameCount(n5);
                for (int j = 0; j < n9; ++j) {
                    int n13;
                    int n14;
                    int n15 = AnimationManager.getFrameOffsetStart(n5, j);
                    int n16 = sArray3[n15 + 3] & 0xFFFF;
                    if (s2 != n16) continue;
                    int n17 = AnimationManager.getFrameOffsetEnd(n5, j);
                    short s8 = sArray3[n15 + 1];
                    short s9 = sArray3[n15 + 2];
                    int n18 = 0;
                    do {
                        if ((n15 += primitiveDataCount[sArray3[n15 + 0]]) >= n17 || sArray3[n15 + 0] != 0) continue;
                        ++n18;
                    } while (n18 < n6 && n15 < n17);
                    if (nArray != null) {
                        bl = true;
                        n14 = n17 - primitiveDataCount[7];
                        nArray[0] = n11 + sArray3[n14 + 1] - s8;
                        nArray[1] = n12 + sArray3[n14 + 2] - s9;
                    }
                    if (n15 >= n17) continue block0;
                    n14 = sArray3[n15 + 1] - s8;
                    int n19 = sArray3[n15 + 2] - s9;
                    short s10 = sArray3[n15 + 3];
                    short s11 = sArray[0][s10];
                    short s12 = sArray[1][s10];
                    short s13 = sArray[2][s10];
                    short s14 = sArray[3][s10];
                    short s15 = sArray[4][s10];
                    int n20 = s11 & 0xFFFF;
                    SDKImage sDKImage2 = sDKImageArray[n20];
                    if (sDKImage == null) continue block0;
                    if (n7 > 0 && s == 11 || n7 < 0 && s == 0) {
                        n13 = 2;
                        short s16 = s14;
                        short s17 = s6;
                        n14 = -n14 - (s16 - s17);
                    } else {
                        n13 = 0;
                    }
                    ArrayOptimizer.PMGraphics_drawRegion(sDKImage2, s12, s13, s14, s15, n13, n14 += n11, n19 += n12, 20);
                    continue block0;
                }
                continue;
            }
            AnimationManager.drawPrimitive(n3, n4, sArray2, i, n7);
        }
        return bl;
    }

    private static void drawPrimitive(int n, int n2, short[] sArray, int n3, int n4) {
        short s = sArray[n3 + 0];
        block0 : switch (s) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                short s2 = sArray[n3 + 3];
                short s3 = sArray[n3 + 4];
                int n5 = n + n4 * sArray[n3 + 1];
                int n6 = n2 + sArray[n3 + 2];
                if (n4 < 0) {
                    n5 -= s2;
                }
                switch (s) {
                    case 3: {
                        ArrayOptimizer.PMGraphics_drawRect(n5, n6, s2, s3);
                        break block0;
                    }
                    case 4: {
                        ArrayOptimizer.PMGraphics_fillRect(n5, n6, s2, s3);
                        break block0;
                    }
                    case 5: {
                        ArrayOptimizer.PMGraphics_drawArc(n5, n6, s2, s3, 0, 360);
                        break block0;
                    }
                    case 6: {
                        ArrayOptimizer.PMGraphics_fillArc(n5, n6, s2, s3, 0, 360);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                int n7 = n + n4 * sArray[n3 + 1];
                int n8 = n2 + sArray[n3 + 2];
                int n9 = n + n4 * sArray[n3 + 3];
                int n10 = n2 + sArray[n3 + 4];
                ArrayOptimizer.PMGraphics_drawLine(n7, n8, n9, n10);
                break;
            }
            case 10: {
                AnimationManager.setColor(sArray[n3 + 1]);
                break;
            }
        }
    }

    public static final int getAnimFrameCount(int n) {
        return s_frameDurations[n &= 0xFFFFBFFF].length;
    }

    public static final short getAnimFrameDuration(int n, int n2) {
        return s_frameDurations[n &= 0xFFFFBFFF][n2];
    }

    private static final int getPrimitiveX(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[n + 1];
            }
            case 8: {
                short s = sArray[n + 1];
                short s2 = sArray[n + 3];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveY(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[n + 2];
            }
            case 8: {
                short s = sArray[n + 2];
                short s2 = sArray[n + 4];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveWidth(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[3][n2 &= 0xFFFF];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 3];
            }
            case 8: {
                int n3 = sArray[n + 1] - sArray[n + 3];
                return Math.abs(n3);
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private static final int getPrimitiveHeight(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[4][n2 &= 0xFFFF];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 4];
            }
            case 8: {
                int n3 = sArray[n + 2] - sArray[n + 4];
                return Math.abs(n3);
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public static final int getAnimFrameX(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n5 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n5 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n5 < n3) {
            int n6;
            short s = sArray[n5 + 0];
            if (s != 10 && (n6 = AnimationManager.getPrimitiveX(sArray, n5)) < n4) {
                n4 = n6;
            }
            n5 += primitiveDataCount[s];
        }
        return n4;
    }

    public static final int getAnimFrameY(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n5 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n5 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n5 < n3) {
            int n6;
            short s = sArray[n5 + 0];
            if (s != 10 && (n6 = AnimationManager.getPrimitiveY(sArray, n5)) < n4) {
                n4 = n6;
            }
            n5 += primitiveDataCount[s];
        }
        return n4;
    }

    public static final int getAnimFrameWidth(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveX(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveWidth(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += primitiveDataCount[s];
        }
        return n5 - n4;
    }

    public static final int getAnimFrameHeight(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveY(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveHeight(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += primitiveDataCount[s];
        }
        return n5 - n4;
    }

    public static final int getAnimFrameFirePointCount(int n, int n2) {
        short s;
        int n3 = 0;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n4 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n4; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 7) continue;
            ++n3;
        }
        return n3;
    }

    public static final boolean getAnimFrameFirePoint(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 7) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                if (bl) {
                    nArray[0] = -nArray[0];
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public static final boolean getAnimFrameCollisionBox(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 2) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                nArray[2] = sArray[i + 3];
                nArray[3] = sArray[i + 4];
                if (bl) {
                    // empty if block
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        return false;
    }

    public static final void drawAnim(AnimPlayer animPlayer, int n, int n2) {
        AnimationManager.drawAnimFrame(animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    public static final void setBank(int n) {
        if (n >= 0 && n < 6) {
            s_curBank = n;
        }
    }

    public static void TextHandler_loadTextSDKStrings() {
        int n;
        TextHandler_m_numLanguages = Event.Ea_loadTextHeader(GameConstants.PMFile_fileToByteArray("hdr"));
        int n2 = 0;
        n2 += ArrayHandler.Rms_GSLangIndex;
        int n3 = n2 = Event.Ea_chooseLanguage(n2);
        if (n2 < 0) {
            n2 = 0;
        }
        TextHandler_fonts = new Object[6];
        TextHandler_fontImages = new SDKImage[6];
        for (n = 0; n < 6; ++n) {
            AnimationManager.TextHandler_fontImages[n] = Debug.PMImage_loadImage(TextHandler_PNG[n], "");
        }
        for (n = 0; n < 6; ++n) {
            AnimationManager.TextHandler_fonts[n] = Event.Ea_loadSDKFont(TextHandler_fontImages[n], GameConstants.PMFile_fileToByteArray(TextHandler_RFF[n]));
        }
        Event.PMSystem_forceGC();
        AnimationManager.TextHandler_loadLanguageChunks(n2);
        ArrayHandler.Rms_GSLangIndex = n3;
        AnimationManager.TextHandler_precalculateFontData();
    }

    public static int TextHandler_getNumLanguages() {
        return TextHandler_m_numLanguages;
    }

    public static void TextHandler_loadLanguageChunks(int n) {
        ArrayHandler.Rms_GSLangIndex = n;
        Event.Ea_setCurrentLanguage(n);
        Event.Ea_loadStringsChunk(1);
        TextHandler_m_wrapString = null;
        ArrayHandler.fillArray(TextHandler_m_wrapChunkStringIds, -1);
        ArrayHandler.fillArray(TextHandler_m_wrapChunkStringWidths, -1);
        ArrayHandler.fillArray(TextHandler_m_wrapChunkStrings, null);
        ArrayHandler.fillArray(TextHandler_m_scrollerStringId, -1);
        ArrayHandler.fillArray(TextHandler_m_scrollerStringArray, null);
        Intro.LoadingScreen_string = null;
    }

    public static int TextHandler_getSpaceWidth(int n) {
        return TextHandler_fontSpaceWidth[n];
    }

    public static int TextHandler_getLineHeight(int n) {
        return TextHandler_fontLineHeight[n];
    }

    public static SDKString TextHandler_getString(int n) {
        if (n == -1987) {
            return ArrayHandler.Rms_getSimName();
        }
        if (n <= -2) {
            return TextHandler_m_dynamicStrings[n - -12];
        }
        SDKString sDKString = TextHandler_m_sdkStringInstances[TextHandler_m_getStringInstance];
        TextHandler_m_getStringInstance = (TextHandler_m_getStringInstance + 1) % 10;
        if (n <= 3) {
            sDKString = Event.Ea_getHeaderString(Event.Ea_getCurrentLanguage(), n, sDKString);
            return sDKString;
        }
        sDKString = Event.Ea_getString(n, sDKString);
        return sDKString;
    }

    public static int TextHandler_getStringWidth(int n, int n2) {
        Event.Ea_setSDKFont(TextHandler_fonts[n2]);
        SDKString sDKString = AnimationManager.TextHandler_getString(n);
        return Event.Ea_getStringSize(sDKString);
    }

    public static int TextHandler_getStringWidth(SDKString sDKString, int n) {
        Event.Ea_setSDKFont(TextHandler_fonts[n]);
        return Event.Ea_getStringSize(sDKString);
    }

    public static void TextHandler_drawRawString(SDKString sDKString, int n, int n2, int n3, int n4) {
        Event.Ea_setSDKFont(TextHandler_fonts[n]);
        AnimationManager.TextHandler_drawString(sDKString, n, n2, n3, n4);
    }

    public static void TextHandler_dynamicString(int n, int n2, int n3) {
        SDKString sDKString = AnimationManager.TextHandler_getString(n2);
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = Event.Ea_replaceFirst(sDKString, AnimationManager.TextHandler_getString(n3));
    }

    public static void TextHandler_dynamicString(int n, int n2, int n3, int n4) {
        SDKString sDKString = AnimationManager.TextHandler_getString(n2);
        AnimationManager.TextHandler_s_sdkStrings2[0] = AnimationManager.TextHandler_getString(n3);
        AnimationManager.TextHandler_s_sdkStrings2[1] = AnimationManager.TextHandler_getString(n4);
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = Event.Ea_replace(sDKString, TextHandler_s_sdkStrings2);
    }

    public static void TextHandler_dynamicString(int n, int n2, SDKString sDKString) {
        SDKString sDKString2 = AnimationManager.TextHandler_getString(n2);
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = Event.Ea_replaceFirst(sDKString2, sDKString);
    }

    public static void TextHandler_dynamicString(int n, int n2, SDKString sDKString, SDKString sDKString2) {
        SDKString sDKString3 = AnimationManager.TextHandler_getString(n2);
        AnimationManager.TextHandler_s_sdkStrings2[0] = sDKString;
        AnimationManager.TextHandler_s_sdkStrings2[1] = sDKString2;
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = Event.Ea_replace(sDKString3, TextHandler_s_sdkStrings2);
    }

    public static void TextHandler_dynamicString(int n, int n2, SDKString sDKString, SDKString sDKString2, SDKString sDKString3) {
        SDKString sDKString4 = AnimationManager.TextHandler_getString(n2);
        AnimationManager.TextHandler_s_sdkStrings3[0] = sDKString;
        AnimationManager.TextHandler_s_sdkStrings3[1] = sDKString2;
        AnimationManager.TextHandler_s_sdkStrings3[2] = sDKString3;
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = Event.Ea_replace(sDKString4, TextHandler_s_sdkStrings3);
    }

    public static void TextHandler_dynamicString(int n, SDKString sDKString) {
        AnimationManager.TextHandler_m_dynamicStrings[n - -12] = sDKString;
    }

    public static SDKString TextHandler_clearStringBuffer() {
        if (++TextHandler_m_tempBufferIndex >= 25) {
            TextHandler_m_tempBufferIndex = 0;
        }
        TextHandler_m_tempStringBuffer = TextHandler_m_tempStringBuffers[TextHandler_m_tempBufferIndex];
        TextHandler_m_tempStringBuffer.setLength(0);
        return TextHandler_m_tempStringBuffer;
    }

    public static void TextHandler_appendStringIdToBuffer(int n) {
        TextHandler_m_tempStringBuffer.append(AnimationManager.TextHandler_getString(n));
    }

    public static void TextHandler_appendSDKStringToBuffer(SDKString sDKString) {
        TextHandler_m_tempStringBuffer.append(sDKString);
    }

    public static void TextHandler_appendStringToBuffer(String string) {
        int n = string.length();
        int n2 = TextHandler_m_tempStringBuffer.length();
        TextHandler_m_tempStringBuffer.setLength(n2 + n);
        for (int i = 0; i != n; ++i) {
            TextHandler_m_tempStringBuffer.setCharAt(n2 + i, string.charAt(i));
        }
    }

    public static void TextHandler_appendIntToBuffer(int n) {
        int n2 = TextHandler_m_tempStringBuffer.length();
        if (n == 0) {
            TextHandler_m_tempStringBuffer.setLength(n2 + 1);
            TextHandler_m_tempStringBuffer.setCharAt(n2, '0');
        } else {
            if (n < 0) {
                TextHandler_m_tempStringBuffer.setLength(n2 + 1);
                TextHandler_m_tempStringBuffer.setCharAt(n2++, '-');
                n = -n;
            }
            int n3 = -1;
            boolean bl = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl) {
                    bl = true;
                    TextHandler_m_tempStringBuffer.setLength(n2 + 1);
                    TextHandler_m_tempStringBuffer.setCharAt(n2++, (char)(48 + n3));
                }
                n -= n3 * i;
            }
        }
    }

    public static void TextHandler_appendIntToBufferWithThousandSep(int n) {
        int n2 = TextHandler_m_tempStringBuffer.length();
        if (n == 0) {
            TextHandler_m_tempStringBuffer.setLength(n2 + 1);
            TextHandler_m_tempStringBuffer.setCharAt(n2++, '0');
        } else {
            if (n < 0) {
                TextHandler_m_tempStringBuffer.setLength(n2 + 1);
                TextHandler_m_tempStringBuffer.setCharAt(n2++, '-');
                n = -n;
            }
            int n3 = -1;
            boolean bl = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl) {
                    bl = true;
                    TextHandler_m_tempStringBuffer.setLength(n2 + 1);
                    TextHandler_m_tempStringBuffer.setCharAt(n2++, (char)(48 + n3));
                    if (i == 1000000000 || i == 1000000 || i == 1000) {
                        TextHandler_m_tempStringBuffer.append(AnimationManager.TextHandler_getString(853));
                        n2 = TextHandler_m_tempStringBuffer.length();
                    }
                }
                n -= n3 * i;
            }
        }
    }

    public static void TextHandler_appendMoneyToBuffer(int n) {
        int n2 = TextHandler_m_tempBufferIndex;
        SDKString sDKString = TextHandler_m_tempStringBuffer;
        SDKString sDKString2 = AnimationManager.TextHandler_clearStringBuffer();
        AnimationManager.TextHandler_appendIntToBufferWithThousandSep(Math.abs(n));
        SDKString sDKString3 = Event.Ea_replaceFirst(AnimationManager.TextHandler_getString(474), sDKString2);
        if (n < 0) {
            SDKString sDKString4 = Event.Ea_stringToSDKString("-");
            sDKString.append(sDKString4);
        }
        sDKString.append(sDKString3);
        TextHandler_m_tempStringBuffer = sDKString;
        TextHandler_m_tempBufferIndex = n2;
    }

    public static void TextHandler_appendTimeToBuffer24Hour(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        int n4 = TextHandler_m_tempStringBuffer.length();
        TextHandler_m_tempStringBuffer.setLength(n4 + 5);
        TextHandler_m_tempStringBuffer.setCharAt(n4 + 0, (char)(48 + n2 / 10));
        TextHandler_m_tempStringBuffer.setCharAt(n4 + 1, (char)(48 + n2 % 10));
        TextHandler_m_tempStringBuffer.setCharAt(n4 + 2, ':');
        TextHandler_m_tempStringBuffer.setCharAt(n4 + 3, (char)(48 + n3 / 10));
        TextHandler_m_tempStringBuffer.setCharAt(n4 + 4, (char)(48 + n3 % 10));
    }

    public static void TextHandler_initWraps() {
        TextHandler_m_wrapOffsets = new short[255];
        AnimationManager.TextHandler_m_wrapOffsets[0] = 0;
        TextHandler_m_wrapChunkOffsets = new short[20][15];
        for (int i = 0; i < 20; ++i) {
            AnimationManager.TextHandler_m_wrapChunkOffsets[i][0] = 0;
        }
        TextHandler_m_wrapChunkStrings = new SDKString[20];
        TextHandler_m_wrapChunkStringIds = new short[20];
        TextHandler_m_wrapChunkStringWidths = new short[20];
    }

    public static int TextHandler_wrapString(int n, int n2, int n3) {
        SDKString sDKString;
        Event.Ea_setSDKFont(TextHandler_fonts[n2]);
        if (n == -1) {
            return 0;
        }
        TextHandler_m_wrapString = AnimationManager.TextHandler_getString(n).toSDKString();
        if (n == 8) {
            TextHandler_m_wrapString = Event.Ea_replaceFirst(TextHandler_m_wrapString, Event.Ea_getAppProp("MIDlet-Version"));
        }
        if (n == 459 || n == 461 || n == 463 || n == 469) {
            sDKString = AnimationManager.TextHandler_clearStringBuffer();
            AnimationManager.TextHandler_appendTimeToBuffer24Hour(GameConstants.Minigame_practiceTimeOpen);
            AnimationManager.TextHandler_appendStringIdToBuffer(854);
            AnimationManager.TextHandler_appendTimeToBuffer24Hour(GameConstants.Minigame_practiceTimeClose);
            TextHandler_m_wrapString = Event.Ea_replaceFirst(TextHandler_m_wrapString, sDKString);
        }
        if (n == 976 || n == 979) {
            sDKString = AnimationManager.TextHandler_getString(Main.m_simData.getSimName(GameConstants.Minigame_npcID));
            TextHandler_m_wrapString = Event.Ea_replaceFirst(TextHandler_m_wrapString, sDKString);
        }
        TextHandler_m_wrapOffsets = Event.Ea_wrapSDKString(TextHandler_m_wrapString, TextHandler_m_wrapOffsets, n3, (short)124);
        return TextHandler_m_wrapOffsets[0];
    }

    public static int TextHandler_getNumWrappedLines() {
        return TextHandler_m_wrapOffsets[0];
    }

    public static void TextHandler_drawWrappedString(int n, int n2, int n3, int n4) {
        if ((n4 & 2) > 0) {
            int n5 = Event.Ea_getLineSize() * TextHandler_m_wrapOffsets[0];
            n3 -= n5 >> 1;
            n4 ^= 2;
            n4 |= 0x10;
        }
        Event.Ea_setSDKFont(TextHandler_fonts[n]);
        AnimationManager.TextHandler_drawWrappedSDKString(TextHandler_m_wrapString, TextHandler_m_wrapOffsets, 1, TextHandler_m_wrapOffsets[0], n2, n3, n4);
    }

    public static void TextHandler_drawString(int n, int n2, int n3, int n4, int n5) {
        if (n != -1) {
            SDKString sDKString = AnimationManager.TextHandler_getString(n);
            Event.Ea_setSDKFont(TextHandler_fonts[n2]);
            AnimationManager.TextHandler_drawString(sDKString, n2, n3, n4, n5);
        }
    }

    public static void TextHandler_drawString(SDKString sDKString, int n, int n2, int n3, int n4) {
        if (!Event.Ea_equal(sDKString, null)) {
            Event.Ea_setSDKFont(TextHandler_fonts[n]);
            if ((n4 & 2) != 0) {
                n3 -= Event.Ea_getLineSize() - Event.Ea_getLeadingSpacing() >> 1;
                n4 ^= 2;
                n4 |= 0x10;
            }
            Event.Ea_drawString(sDKString, n2, n3, n4);
        }
    }

    public static void TextHandler_drawPartWrappedString(int n, int n2, int n3, int n4, int n5, int n6) {
        Event.Ea_setSDKFont(TextHandler_fonts[n]);
        if ((n4 & 2) > 0) {
            int n7 = Event.Ea_getLineSize() * n6;
            n3 -= n7 >> 1;
            n4 ^= 2;
            n4 |= 0x10;
        }
        n6 = Math.min(TextHandler_m_wrapOffsets[0] - n5, n6);
        AnimationManager.TextHandler_drawWrappedSDKString(TextHandler_m_wrapString, TextHandler_m_wrapOffsets, n5 + 1, n6, n2, n3, n4);
    }

    public static int TextHandler_wrapStringChunk(int n, int n2, int n3, int n4) {
        Event.Ea_setSDKFont(TextHandler_fonts[n3]);
        AnimationManager.TextHandler_m_wrapChunkStringIds[n] = (short)n2;
        AnimationManager.TextHandler_m_wrapChunkStringWidths[n] = (short)n4;
        if (n2 == -1) {
            return 0;
        }
        AnimationManager.TextHandler_m_wrapChunkStrings[n] = AnimationManager.TextHandler_getString(n2).toSDKString();
        AnimationManager.TextHandler_m_wrapChunkOffsets[n] = Event.Ea_wrapSDKString(TextHandler_m_wrapChunkStrings[n], TextHandler_m_wrapChunkOffsets[n], n4, (short)124);
        return TextHandler_m_wrapChunkOffsets[n][0];
    }

    public static int TextHandler_getNumWrappedLinesChunk(int n) {
        return TextHandler_m_wrapChunkOffsets[n][0];
    }

    public static void TextHandler_drawWrappedStringChunk(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 != TextHandler_m_wrapChunkStringIds[n] || n4 != TextHandler_m_wrapChunkStringWidths[n]) {
            AnimationManager.TextHandler_wrapStringChunk(n, n2, n3, n4);
            AnimationManager.TextHandler_m_wrapChunkStringIds[n] = (short)n2;
            AnimationManager.TextHandler_m_wrapChunkStringWidths[n] = (short)n4;
        }
        if ((n7 & 2) > 0) {
            int n8 = Event.Ea_getLineSize() * TextHandler_m_wrapChunkOffsets[n][0];
            n6 -= n8 >> 1;
            n7 ^= 2;
            n7 |= 0x10;
        }
        Event.Ea_setSDKFont(TextHandler_fonts[n3]);
        AnimationManager.TextHandler_drawWrappedSDKString(TextHandler_m_wrapChunkStrings[n], TextHandler_m_wrapChunkOffsets[n], 1, TextHandler_m_wrapChunkOffsets[n][0], n5, n6, n7);
    }

    public static void TextHandler_drawClippedString(int n, int n2, int n3, int n4, int n5, int n6) {
        AnimationManager.TextHandler_drawClippedString(AnimationManager.TextHandler_getString(n), n2, n3, n4, n5, n6);
    }

    public static void TextHandler_drawClippedString(SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnimationManager.TextHandler_getStringWidth(sDKString, n);
        if (n6 <= n4) {
            if ((n5 & 1) != 0) {
                n2 += n4 >> 1;
            }
            AnimationManager.TextHandler_drawString(sDKString, n, n2, n3, n5);
        } else {
            int n7 = ArrayOptimizer.PMGraphics_getClipX();
            int n8 = ArrayOptimizer.PMGraphics_getClipY();
            int n9 = ArrayOptimizer.PMGraphics_getClipWidth();
            int n10 = ArrayOptimizer.PMGraphics_getClipHeight();
            int n11 = AnimationManager.TextHandler_getStringWidth(330, n);
            ArrayOptimizer.PMGraphics_setClip(n2, n8, n4 - n11, n10);
            AnimationManager.TextHandler_drawString(sDKString, n, n2, n3, n5 & 0xFFFFFFF6 | 4);
            ArrayOptimizer.PMGraphics_setClip(n7, n8, n9, n10);
            AnimationManager.TextHandler_drawString(330, n, n2 + n4, n3, n5 & 0xFFFFFFFA | 8);
        }
    }

    public static void TextHandler_resetScrollers() {
        int n = 22;
        while (--n >= 0) {
            AnimationManager.TextHandler_m_scrollerStringId[n] = -1;
            AnimationManager.TextHandler_m_scrollerStringArray[n] = null;
        }
    }

    public static void TextHandler_resetScrollerTimers(int n, int n2) {
        for (int i = n; i < n + n2 && i < TextHandler_m_scrollerOffset.length; ++i) {
            AnimationManager.TextHandler_m_scrollerOffset[i] = 0;
            AnimationManager.TextHandler_m_scrollerTime[i] = 0;
        }
    }

    public static void TextHandler_setupScroller(int n, int n2, int n3) {
        if (n < 22) {
            AnimationManager.TextHandler_m_scrollerTime[n] = 0;
            AnimationManager.TextHandler_m_scrollerStringId[n] = n3;
            AnimationManager.TextHandler_m_scrollerStringArray[n] = n3 <= -2 ? AnimationManager.TextHandler_getString(n3) : (n3 <= 3 ? Event.Ea_getHeaderString(Event.Ea_getCurrentLanguage(), n3) : Event.Ea_getString(n3));
            if (n3 != -1) {
                AnimationManager.TextHandler_m_scrollerStringWidth[n] = AnimationManager.TextHandler_getStringWidth(n3, n2);
                AnimationManager.TextHandler_m_scrollerOffset[n] = 0;
            }
        }
    }

    public static void TextHandler_setupScroller(int n, int n2, SDKString sDKString) {
        if (n < 22) {
            AnimationManager.TextHandler_m_scrollerTime[n] = 0;
            AnimationManager.TextHandler_m_scrollerStringId[n] = -1;
            AnimationManager.TextHandler_m_scrollerStringArray[n] = sDKString;
            if (!Event.Ea_equal(sDKString, null)) {
                AnimationManager.TextHandler_m_scrollerStringWidth[n] = AnimationManager.TextHandler_getStringWidth(sDKString, n2);
                AnimationManager.TextHandler_m_scrollerOffset[n] = 0;
            }
        }
    }

    public static void TextHandler_updateScrollers(int n) {
        int[] nArray = TextHandler_m_scrollerStringId;
        SDKString[] sDKStringArray = TextHandler_m_scrollerStringArray;
        int n2 = 22;
        while (--n2 >= 0) {
            if (nArray[n2] < 0 && Event.Ea_equal(sDKStringArray[n2], null)) continue;
            int n3 = n2;
            TextHandler_m_scrollerTime[n3] = TextHandler_m_scrollerTime[n3] + n;
            if (TextHandler_m_scrollerTime[n2] <= 1500) continue;
            long l = TextHandler_m_scrollerTime[n2] - 1500;
            AnimationManager.TextHandler_m_scrollerOffset[n2] = (int)(l * 20L >> 10);
            int n4 = TextHandler_m_scrollerStringWidth[n2] + 20;
            if (TextHandler_m_scrollerOffset[n2] < n4) continue;
            int n5 = n2;
            TextHandler_m_scrollerOffset[n5] = TextHandler_m_scrollerOffset[n5] - n4;
            int n6 = n2;
            TextHandler_m_scrollerTime[n6] = TextHandler_m_scrollerTime[n6] - (n4 << 10) / 20;
        }
    }

    public static void TextHandler_renderScroller(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (TextHandler_m_scrollerStringId[n] != n2 || TextHandler_m_scrollerStringWidth[n] != AnimationManager.TextHandler_getStringWidth(n2, n3)) {
            AnimationManager.TextHandler_setupScroller(n, n3, n2);
        }
        if (TextHandler_m_scrollerStringWidth[n] <= n6) {
            if ((n7 & 1) != 0) {
                n4 += n6 >> 1;
            } else if ((n7 & 8) != 0) {
                n4 += n6;
            }
            AnimationManager.TextHandler_drawString(n2, n3, n4, n5, n7);
        } else {
            int n8 = ArrayOptimizer.PMGraphics_getClipX();
            int n9 = ArrayOptimizer.PMGraphics_getClipY();
            int n10 = ArrayOptimizer.PMGraphics_getClipWidth();
            int n11 = ArrayOptimizer.PMGraphics_getClipHeight();
            ArrayOptimizer.PMGraphics_setClip(n4, n9, n6, n11);
            n7 = n7 & 0xFFFFFFF6 | 4;
            AnimationManager.TextHandler_drawString(n2, n3, n4 - TextHandler_m_scrollerOffset[n], n5, n7);
            AnimationManager.TextHandler_drawString(n2, n3, n4 - TextHandler_m_scrollerOffset[n] + TextHandler_m_scrollerStringWidth[n] + 20, n5, n7);
            ArrayOptimizer.PMGraphics_setClip(n8, n9, n10, n11);
        }
    }

    public static void TextHandler_renderScroller(int n, SDKString sDKString, int n2, int n3, int n4, int n5, int n6) {
        if (Event.Ea_equal(TextHandler_m_scrollerStringArray[n], null) && TextHandler_m_scrollerStringArray[n] != null && !TextHandler_m_scrollerStringArray[n].equals(sDKString) && TextHandler_m_scrollerStringWidth[n] != AnimationManager.TextHandler_getStringWidth(sDKString, n2)) {
            AnimationManager.TextHandler_setupScroller(n, n2, sDKString);
        }
        if (Event.Ea_equal(TextHandler_m_scrollerStringArray[n], null) || TextHandler_m_scrollerStringWidth[n] != AnimationManager.TextHandler_getStringWidth(sDKString, n2)) {
            AnimationManager.TextHandler_setupScroller(n, n2, sDKString);
        }
        if (TextHandler_m_scrollerStringWidth[n] <= n5) {
            if ((n6 & 1) != 0) {
                n3 += n5 >> 1;
            } else if ((n6 & 8) != 0) {
                n3 += n5;
            }
            AnimationManager.TextHandler_drawString(sDKString, n2, n3, n4, n6);
        } else {
            int n7 = ArrayOptimizer.PMGraphics_getClipX();
            int n8 = ArrayOptimizer.PMGraphics_getClipY();
            int n9 = ArrayOptimizer.PMGraphics_getClipWidth();
            int n10 = ArrayOptimizer.PMGraphics_getClipHeight();
            ArrayOptimizer.PMGraphics_setClip(n3, n8, n5, n10);
            n6 = n6 & 0xFFFFFFF6 | 4;
            AnimationManager.TextHandler_drawString(sDKString, n2, n3 - TextHandler_m_scrollerOffset[n], n4, n6);
            AnimationManager.TextHandler_drawString(sDKString, n2, n3 - TextHandler_m_scrollerOffset[n] + TextHandler_m_scrollerStringWidth[n] + 20, n4, n6);
            ArrayOptimizer.PMGraphics_setClip(n7, n8, n9, n10);
        }
    }

    public static void TextHandler_renderWavyString(int n, int n2, int n3, int n4, int n5, int n6) {
        if (TextHandler_m_scrollerStringId[n] != n2) {
            AnimationManager.TextHandler_setupScroller(n, n3, Event.Ea_getString(n2));
            AnimationManager.TextHandler_m_scrollerStringId[n] = n2;
            AnimationManager.TextHandler_m_scrollerTime[n] = 1500;
        }
        SDKString sDKString = TextHandler_m_scrollerStringArray[n];
        int n7 = AnimationManager.TextHandler_getStringWidth(sDKString, n3);
        if ((n6 & 1) != 0) {
            n4 -= n7 >> 1;
        } else if ((n6 & 8) != 0) {
            n4 -= n7;
        }
        n6 = n6 & 0xFFFFFFF6 | 4;
        SDKString sDKString2 = AnimationManager.TextHandler_clearStringBuffer();
        sDKString2.setLength(1);
        int n8 = sDKString.length();
        int n9 = TextHandler_m_scrollerOffset[n] << 1;
        if (n9 > n7 + 20) {
            AnimationManager.TextHandler_m_scrollerTime[n] = 1500;
            AnimationManager.TextHandler_m_scrollerOffset[n] = 0;
            n9 = 0;
        }
        int n10 = n9 - 10 - 20;
        int n11 = n10 + 20;
        int n12 = 0;
        for (int i = 0; i < n8; ++i) {
            sDKString2.setCharAt(0, sDKString.charAt(i));
            if (n12 < n10 || n12 > n11) {
                AnimationManager.TextHandler_drawString(sDKString2, n3, n4 + n12, n5, n6);
            } else {
                int n13 = Camera.MathExt_Fdiv(n12 - n10 << 16, 0x140000);
                int n14 = Camera.MathExt_Fmul(411775, n13) - 205887;
                int n15 = Camera.MathExt_Fcos(n14) * 6;
                AnimationManager.TextHandler_drawString(sDKString2, n3, n4 + n12, n5 - (n15 >> 16) - 6, n6);
            }
            n12 += AnimationManager.TextHandler_getStringWidth(sDKString2, n3);
        }
        sDKString = null;
        sDKString2 = null;
    }

    public static void TextHandler_precalculateFontData() {
        TextHandler_fontSpaceWidth = new byte[6];
        TextHandler_fontLineHeight = new byte[6];
        int n = 6;
        while (--n >= 0) {
            if (TextHandler_fonts[n] == null) continue;
            Event.Ea_setSDKFont(TextHandler_fonts[n]);
            AnimationManager.TextHandler_fontSpaceWidth[n] = (byte)Event.Ea_getSpaceSpacing();
            AnimationManager.TextHandler_fontLineHeight[n] = (byte)Event.Ea_getLineSize();
        }
    }

    public static void TextHandler_drawWrappedSDKString(SDKString sDKString, short[] sArray, int n, int n2, int n3, int n4, int n5) {
        short s = sArray[sArray[0] + 2];
        int n6 = Event.Ea_getLineSize() + 1;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            short s2 = sArray[i];
            int n8 = sArray[i + 1] - s2;
            short s3 = (short)sDKString.charAt(sArray[i + 1] - 1);
            if (s3 == s || s3 == 32) {
                --n8;
            }
            Event.Ea_drawSubString(sDKString, s2, n8, n3, n4, n5);
            n4 += n6;
        }
    }

    public static void MinigameMusic_init() {
        MinigameMusic_fretboardSegmentWidth = AnimationManager.getAnimFrameWidth(335, 0);
        MinigameMusic_fretboardSegmentHeight = AnimationManager.getAnimFrameHeight(335, 0);
        MinigameMusic_chordWidth = AnimationManager.getAnimFrameWidth(332, 0);
        MinigameMusic_chordHeight = AnimationManager.getAnimFrameHeight(332, 0);
        MinigameMusic_halfGuitarStringWidth = AnimationManager.getAnimFrameWidth(341, 0) >> 1;
        MinigameMusic_guitarStringHeight = AnimationManager.getAnimFrameHeight(341, 0);
        int n = Main.m_simData.getSkillRank(GameConstants.Minigame_gameSkill);
        GameConstants.Minigame_gameTimer = GameConstants.Minigame_gameTimerMax = MinigameMusic_GAME_TIME[n];
        MinigameMusic_chordsMissed = 0;
        MinigameMusic_nextChordToPlay = 0;
        MinigameMusic_redrawLives = true;
        MinigameMusic_worldSpaceChordHeight = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(65536, MinigameMusic_chordHeight << 16), GameConstants.Minigame_height << 16);
        MinigameMusic_firstChordStartY = -65536 - MinigameMusic_worldSpaceChordHeight;
        int n2 = MinigameMusic_GAME_TIME[n] / 1000 << 16;
        MinigameMusic_chordsPerSec = Camera.MathExt_Fmul(98304, MinigameMusic_SPEED_PERCENTAGE[n]);
        MinigameMusic_totalChordCount = Camera.MathExt_Fmul(n2, MinigameMusic_chordsPerSec) >> 16;
        MinigameMusic_chordSpeed = 16384;
        int n3 = Camera.MathExt_Fmul(n2, MinigameMusic_chordSpeed);
        MinigameMusic_chordSpacing = Camera.MathExt_Fdiv(n3, MinigameMusic_totalChordCount << 16);
        MinigameMusic_maxVisibleChords = Camera.MathExt_Fdiv(65536 + MinigameMusic_worldSpaceChordHeight, MinigameMusic_chordSpacing) >> 16;
        MinigameMusic_lowestChordToUpdate = 0;
        MinigameMusic_highestChordToUpdate = MinigameMusic_maxVisibleChords;
        MinigameMusic_chordsX = new int[MinigameMusic_totalChordCount];
        MinigameMusic_chordsY = new int[MinigameMusic_totalChordCount];
        MinigameMusic_chordsCleared = new boolean[MinigameMusic_totalChordCount];
        int n4 = MinigameMusic_fretboardSegmentWidth * 55 / 100;
        int n5 = 120 - n4;
        int n6 = 120;
        int n7 = 120 + n4;
        MinigameMusic_key4BoxCenterX = n5;
        MinigameMusic_key5BoxCenterX = n6;
        MinigameMusic_key6BoxCenterX = n7;
        int n8 = MinigameMusic_fretboardSegmentWidth * 2 << 16;
        MinigameMusic_string1_x = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(65536, n5 << 16), n8);
        MinigameMusic_string2_x = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(65536, n6 << 16), n8);
        MinigameMusic_string3_x = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(65536, n7 << 16), n8);
        AnimationManager.MinigameMusic_generateSessionChords(n);
        for (MinigameMusic_topFretboardSegmentY = 245 - MinigameMusic_fretboardSegmentHeight / 5; MinigameMusic_topFretboardSegmentY > GameConstants.Minigame_top; MinigameMusic_topFretboardSegmentY -= MinigameMusic_fretboardSegmentHeight) {
        }
        GlobalConstants.Particle_init(3, 340, -1, 450, 0, 0xFFFFFF, 1, 50, 90076, 115812);
        int n9 = Camera.MathExt_Fmul(Camera.MathExt_Fdiv(-MinigameMusic_firstChordStartY, MinigameMusic_chordSpeed), 65536000) >> 16;
        GameConstants.Minigame_gameTimerMax += n9;
        GameConstants.Minigame_gameTimer += n9;
    }

    public static void MinigameMusic_deinit() {
        MinigameMusic_chordsX = null;
        MinigameMusic_chordsY = null;
        MinigameMusic_chordsCleared = null;
        GlobalConstants.Particle_deinit();
    }

    private static void MinigameMusic_generateSessionChords(int n) {
        int n2 = MinigameMusic_firstChordStartY;
        int n3 = MinigameMusic_chordSpacing;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < MinigameMusic_chordsY.length; ++i) {
            int n6;
            while ((n6 = Debug.PMRandom_get16() % 3) == n4 && n6 == n5) {
            }
            switch (n6) {
                case 0: {
                    AnimationManager.MinigameMusic_chordsX[i] = MinigameMusic_string1_x;
                    break;
                }
                case 1: {
                    AnimationManager.MinigameMusic_chordsX[i] = MinigameMusic_string2_x;
                    break;
                }
                case 2: {
                    AnimationManager.MinigameMusic_chordsX[i] = MinigameMusic_string3_x;
                }
            }
            n5 = n4;
            n4 = n6;
            AnimationManager.MinigameMusic_chordsY[i] = n2;
            n2 -= n3;
        }
    }

    public static void MinigameMusic_update(int n) {
        MinigameMusic_inputBlockTimer = MinigameMusic_inputBlockTimer > 0 ? (MinigameMusic_inputBlockTimer -= n) : 0;
        if (!GameConstants.Minigame_done) {
            GameConstants.Minigame_gameTimer -= n;
            if (n > 0) {
                ++GameConstants.Minigame_runningUpdates;
            }
        }
        AnimationManager.MinigameMusic_updateChords(n);
        GlobalConstants.Particle_update(n);
        if (MinigameMusic_chordsMissed >= 3) {
            if (GameConstants.Minigame_endTimer == 4000) {
                GameConstants.Minigame_endTimer = 500;
            }
            if ((GameConstants.Minigame_endTimer -= n) <= 0 && !GameConstants.Minigame_done) {
                GameConstants.Minigame_done = true;
                GameConstants.Minigame_clearBg = true;
                GameConstants.Minigame_stateTransitionMiniGame(2);
            }
        } else if (GameConstants.Minigame_gameTimer <= 0) {
            if (GameConstants.Minigame_endTimer == 4000) {
                GameConstants.Minigame_endTimer = PMAudio.isEnabled ? 3000 : 500;
            }
            GameConstants.Minigame_endTimer -= n;
            if (!GameConstants.Minigame_done) {
                PMAudio.play(11, 1);
                GameConstants.Minigame_clearBg = true;
                GameConstants.Minigame_done = true;
                Main.setSoftKeys(1, 0);
            }
            if (GameConstants.Minigame_endTimer <= 0) {
                GameConstants.Minigame_stateTransitionMiniGame(1);
            }
        }
    }

    public static void MinigameMusic_render() {
        int n;
        ArrayOptimizer.PMGraphics_setColor(0);
        if (GameConstants.Minigame_clearBg) {
            n = 120 - MinigameMusic_fretboardSegmentWidth;
            ArrayOptimizer.PMGraphics_fillRect(0, GameConstants.Minigame_top, n, GameConstants.Minigame_height);
            ArrayOptimizer.PMGraphics_fillRect(n + 2 * MinigameMusic_fretboardSegmentWidth, GameConstants.Minigame_top, 240 - n - 2 * MinigameMusic_fretboardSegmentWidth, GameConstants.Minigame_height);
            MinigameMusic_redrawLives = true;
        }
        ArrayOptimizer.PMGraphics_fillRect(0, GameConstants.Minigame_top + GameConstants.Minigame_height - 3, 240, 3);
        n = ArrayOptimizer.PMGraphics_getClipX();
        int n2 = ArrayOptimizer.PMGraphics_getClipY();
        int n3 = ArrayOptimizer.PMGraphics_getClipWidth();
        int n4 = ArrayOptimizer.PMGraphics_getClipHeight();
        ArrayOptimizer.PMGraphics_setClip(0, GameConstants.Minigame_top, 240, GameConstants.Minigame_height);
        boolean bl = GameConstants.Minigame_clearBg;
        AnimationManager.MinigameMusic_drawFretboard(bl);
        AnimationManager.MinigameMusic_drawGuitarStrings();
        AnimationManager.MinigameMusic_drawChords();
        AnimationManager.MinigameMusic_drawInputRect();
        if (MinigameMusic_redrawLives) {
            AnimationManager.MinigameMusic_drawLives();
            MinigameMusic_redrawLives = false;
        }
        if (!GameConstants.Minigame_done) {
            GlobalConstants.Particle_draw(0, 0);
        }
        if (GameConstants.Minigame_gameTimer < GameConstants.Minigame_gameTimerMax && !GameConstants.Minigame_done && GameConstants.Minigame_runningUpdates > 2) {
            GameConstants.Minigame_clearBg = false;
        }
        ArrayOptimizer.PMGraphics_setClip(n, n2, n3, n4);
        if (GameConstants.Minigame_gameTimer <= 0 || GameConstants.Minigame_done || !StateInGame.m_pauseMenuActive) {
            // empty if block
        }
    }

    public static void MinigameMusic_processKeys() {
        GameConstants.Minigame_key = -1;
        if (MinigameMusic_inputBlockTimer > 0) {
            return;
        }
        if (MinigameMusic_chordsMissed < 3 && GameConstants.Minigame_gameTimer > 0) {
            if (ArrayHandler.PMInput_isPressed(8)) {
                GameConstants.Minigame_key = 4;
            } else if (ArrayHandler.PMInput_isPressed(1)) {
                GameConstants.Minigame_key = 5;
            } else if (ArrayHandler.PMInput_isPressed(16)) {
                GameConstants.Minigame_key = 6;
            }
        }
    }

    private static void MinigameMusic_drawFretboard(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = MinigameMusic_fretboardSegmentWidth * 2 << 16;
        int n9 = AnimationManager.getAnimFrameWidth(337, 0) >> 1;
        int n10 = AnimationManager.getAnimFrameHeight(337, 0) >> 1;
        int n11 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n8, MinigameMusic_string1_x), 65536) >> 16) - n9;
        int n12 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n8, MinigameMusic_string2_x), 65536) >> 16) - n9;
        int n13 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n8, MinigameMusic_string3_x), 65536) >> 16) - n9;
        int n14 = 9;
        int n15 = MinigameMusic_fretboardSegmentHeight - n14;
        int n16 = GameConstants.Minigame_top + GameConstants.Minigame_height;
        if (bl) {
            do {
                n6 = MinigameMusic_topFretboardSegmentY + MinigameMusic_fretboardSegmentHeight * n7;
                n5 = 120 - MinigameMusic_fretboardSegmentWidth;
                AnimationManager.drawAnimFrame(335, 0, n5, n6);
                AnimationManager.drawAnimFrame(336, 0, n5 += MinigameMusic_fretboardSegmentWidth, n6);
                ++n7;
            } while (n6 + MinigameMusic_fretboardSegmentHeight < n16);
        } else {
            n4 = MinigameMusic_chordWidth >> 1;
            n3 = MinigameMusic_chordHeight >> 1;
            n2 = GameConstants.Minigame_height << 16;
            if (MinigameMusic_highestChordToUpdate >= MinigameMusic_totalChordCount) {
                MinigameMusic_highestChordToUpdate = MinigameMusic_totalChordCount - 1;
            }
            ArrayOptimizer.PMGraphics_setClip(n11 - 1, GameConstants.Minigame_top, n13 - n11 + MinigameMusic_chordWidth + 2, GameConstants.Minigame_height);
            n7 = 0;
            do {
                n6 = MinigameMusic_topFretboardSegmentY + MinigameMusic_fretboardSegmentHeight * n7;
                n5 = 120 - MinigameMusic_fretboardSegmentWidth;
                AnimationManager.drawAnimFrame(335, 0, n5, n6);
                AnimationManager.drawAnimFrame(336, 0, n5 += MinigameMusic_fretboardSegmentWidth, n6);
                ++n7;
            } while (n6 + 3 * MinigameMusic_fretboardSegmentHeight < n16);
            ArrayOptimizer.PMGraphics_setClip(0, GameConstants.Minigame_top, 240, GameConstants.Minigame_height);
            do {
                n6 = MinigameMusic_topFretboardSegmentY + MinigameMusic_fretboardSegmentHeight * n7;
                n5 = 120 - MinigameMusic_fretboardSegmentWidth;
                AnimationManager.drawAnimFrame(335, 0, n5, n6);
                AnimationManager.drawAnimFrame(336, 0, n5 += MinigameMusic_fretboardSegmentWidth, n6);
                ++n7;
            } while (n6 + MinigameMusic_fretboardSegmentHeight < n16);
        }
        n4 = n7 - 3;
        n3 = 1;
        n2 = n15 >> 1;
        for (n = n4; n >= 0; --n) {
            n6 = MinigameMusic_topFretboardSegmentY + MinigameMusic_fretboardSegmentHeight * (n + 1) - n2 - n10;
            if (n == n4) {
                AnimationManager.drawAnimFrame(337, 0, n11, n6);
                AnimationManager.drawAnimFrame(337, 0, n13, n6);
            } else if (n3 != 0) {
                AnimationManager.drawAnimFrame(337, 0, n12, n6);
            }
            n3 = n3 == 0 ? 1 : 0;
        }
        n = n15 * 35 / 100;
        MinigameMusic_inputAreaWorldHeight = Camera.MathExt_Fdiv(Camera.MathExt_Fmul(65536, n << 16), GameConstants.Minigame_height << 16);
        int n17 = n7 - 2;
        MinigameMusic_inputAreaRectY = MinigameMusic_topFretboardSegmentY + n14 + n17 * MinigameMusic_fretboardSegmentHeight + (n15 - n >> 1);
        int n18 = MinigameMusic_inputAreaRectY - GameConstants.Minigame_top;
        MinigameMusic_playerInputWorldCenterY = -Camera.MathExt_Fmul(Camera.MathExt_Fdiv(65536, GameConstants.Minigame_height << 16), GameConstants.Minigame_height - n18 - (n >> 1) << 16);
    }

    private static void MinigameMusic_updateChords(int n) {
        if (MinigameMusic_lowestChordToUpdate >= MinigameMusic_totalChordCount) {
            return;
        }
        int n2 = MinigameMusic_worldSpaceChordHeight >> 1;
        int n3 = MinigameMusic_inputAreaWorldHeight >> 1;
        int n4 = MinigameMusic_lowestChordToUpdate;
        int n5 = MinigameMusic_highestChordToUpdate;
        boolean bl = true;
        if (n5 >= MinigameMusic_totalChordCount) {
            n5 = MinigameMusic_totalChordCount - 1;
        }
        int n6 = n * MinigameMusic_chordSpeed / 1000;
        boolean bl2 = false;
        if (n4 > 0) {
            MinigameMusic_chordsY[0] = MinigameMusic_chordsY[0] + n6;
        }
        int n7 = MinigameMusic_chordsY[0] - MinigameMusic_firstChordStartY;
        for (int i = n4; i <= n5; ++i) {
            int n8 = i;
            MinigameMusic_chordsY[n8] = MinigameMusic_chordsY[n8] + n6;
            int n9 = MinigameMusic_chordsY[i];
            int n10 = MinigameMusic_chordsX[i];
            if (n9 - n2 - 100 > 0) {
                bl2 = true;
            }
            boolean bl3 = n9 > MinigameMusic_playerInputWorldCenterY - n3;
            boolean bl4 = n9 > MinigameMusic_playerInputWorldCenterY + n3;
            boolean bl5 = false;
            if (bl3 && !bl4) {
                bl5 = AnimationManager.MinigameMusic_checkChordStruck(n10);
            }
            if (bl5) {
                MinigameMusic_inputBlockTimer = 475;
                int n11 = AnimationManager.getAnimFrameWidth(340, 2);
                int n12 = AnimationManager.getAnimFrameHeight(340, 2);
                int n13 = MinigameMusic_fretboardSegmentWidth * 2;
                int n14 = 0;
                if (n10 == MinigameMusic_string1_x) {
                    n14 = Camera.MathExt_Fmul(n13 << 16, MinigameMusic_string1_x) >> 16;
                } else if (n10 == MinigameMusic_string2_x) {
                    n14 = Camera.MathExt_Fmul(n13 << 16, MinigameMusic_string2_x) >> 16;
                } else if (n10 == MinigameMusic_string3_x) {
                    n14 = Camera.MathExt_Fmul(n13 << 16, MinigameMusic_string3_x) >> 16;
                }
                int n15 = GameConstants.Minigame_height - (Camera.MathExt_Fmul(GameConstants.Minigame_height << 16, -MinigameMusic_chordsY[i]) >> 16) + GameConstants.Minigame_top;
                AnimationManager.MinigameMusic_chordsCleared[i] = true;
                GlobalConstants.Particle_add(3, n14 - (n11 >> 1), n15 - (n12 >> 1), 50);
            }
            if (!bl4 || MinigameMusic_nextChordToPlay != i) continue;
            if (MinigameMusic_chordsMissed < 3 && GameConstants.Minigame_gameTimer > 0 && !MinigameMusic_chordsCleared[i]) {
                ++MinigameMusic_chordsMissed;
                MinigameMusic_redrawLives = true;
            }
            ++MinigameMusic_nextChordToPlay;
        }
        if (bl2) {
            ++MinigameMusic_lowestChordToUpdate;
            ++MinigameMusic_highestChordToUpdate;
            if (n5 < MinigameMusic_totalChordCount - 1) {
                int n16 = n5 + 1;
                MinigameMusic_chordsY[n16] = MinigameMusic_chordsY[n16] + n7;
            }
        }
    }

    private static void MinigameMusic_drawChords() {
        int n = MinigameMusic_chordWidth >> 1;
        int n2 = MinigameMusic_chordHeight >> 1;
        int n3 = MinigameMusic_fretboardSegmentWidth * 2 << 16;
        int n4 = GameConstants.Minigame_height << 16;
        if (MinigameMusic_highestChordToUpdate >= MinigameMusic_totalChordCount) {
            MinigameMusic_highestChordToUpdate = MinigameMusic_totalChordCount - 1;
        }
        for (int i = MinigameMusic_lowestChordToUpdate; i <= MinigameMusic_highestChordToUpdate; ++i) {
            if (MinigameMusic_chordsCleared[i]) continue;
            int n5 = (Camera.MathExt_Fmul(n3, MinigameMusic_chordsX[i]) >> 16) - n;
            int n6 = (Camera.MathExt_Fmul(n4, MinigameMusic_chordsY[i]) >> 16) + GameConstants.Minigame_height + GameConstants.Minigame_top - n2;
            int n7 = MinigameMusic_chordsX[i];
            if (n7 == MinigameMusic_string1_x) {
                AnimationManager.drawAnimFrame(332, 0, n5, n6);
                continue;
            }
            if (n7 == MinigameMusic_string2_x) {
                AnimationManager.drawAnimFrame(333, 0, n5, n6);
                continue;
            }
            if (n7 != MinigameMusic_string3_x) continue;
            AnimationManager.drawAnimFrame(334, 0, n5, n6);
        }
    }

    private static boolean MinigameMusic_checkChordStruck(int n) {
        boolean bl = false;
        switch (GameConstants.Minigame_key) {
            case 4: {
                if (n != MinigameMusic_string1_x) break;
                bl = true;
                break;
            }
            case 5: {
                if (n != MinigameMusic_string2_x) break;
                bl = true;
                break;
            }
            case 6: {
                if (n != MinigameMusic_string3_x) break;
                bl = true;
            }
        }
        return bl;
    }

    private static void MinigameMusic_drawGuitarStrings() {
        int n = 0;
        int n2 = MinigameMusic_fretboardSegmentWidth * 2 << 16;
        int n3 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n2, MinigameMusic_string1_x), 65536) >> 16) - MinigameMusic_halfGuitarStringWidth;
        int n4 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n2, MinigameMusic_string2_x), 65536) >> 16) - MinigameMusic_halfGuitarStringWidth;
        int n5 = (Camera.MathExt_Fdiv(Camera.MathExt_Fmul(n2, MinigameMusic_string3_x), 65536) >> 16) - MinigameMusic_halfGuitarStringWidth;
        do {
            int n6 = MinigameMusic_guitarStringHeight * n + GameConstants.Minigame_top;
            AnimationManager.drawAnimFrame(341, 0, n3, n6);
            AnimationManager.drawAnimFrame(342, 0, n4, n6);
            AnimationManager.drawAnimFrame(343, 0, n5, n6);
        } while (++n * MinigameMusic_guitarStringHeight < GameConstants.Minigame_height);
    }

    private static void MinigameMusic_drawInputRect() {
        int n = 3;
        int n2 = 9;
        int n3 = 120 - MinigameMusic_fretboardSegmentWidth - n + 1;
        int n4 = MinigameMusic_inputAreaRectY;
        int n5 = (MinigameMusic_fretboardSegmentWidth + n) * 2 - 1 - 2;
        int n6 = GameConstants.Minigame_height * MinigameMusic_inputAreaWorldHeight / 65536;
        int n7 = AnimationManager.getAnimFrameWidth(341, 0);
        int n8 = 0;
        int n9 = MinigameMusic_chordWidth;
        boolean bl = false;
        if (n9 % 2 == 1 && n7 % 2 == 1) {
            --n9;
        }
        if (GameConstants.Minigame_key > -1) {
            switch (GameConstants.Minigame_key) {
                case 4: {
                    n8 = MinigameMusic_key4BoxCenterX - (n9 >> 1);
                    ArrayOptimizer.PMGraphics_setColor(1504016);
                    bl = true;
                    break;
                }
                case 5: {
                    n8 = MinigameMusic_key5BoxCenterX - (n9 >> 1);
                    ArrayOptimizer.PMGraphics_setColor(15929585);
                    bl = true;
                    break;
                }
                case 6: {
                    n8 = MinigameMusic_key6BoxCenterX - (n9 >> 1);
                    ArrayOptimizer.PMGraphics_setColor(16713229);
                    bl = true;
                }
            }
            if (bl) {
                ArrayOptimizer.PMGraphics_fillRect(n8, n4 + n, n9, n6 - (n - 1) * 2);
            }
        }
        ArrayOptimizer.PMGraphics_setColor(1630943);
        ArrayOptimizer.PMGraphics_drawRect(n3, n4, n5, n6);
        ArrayOptimizer.PMGraphics_drawRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
        ArrayOptimizer.PMGraphics_setColor(1768185);
        ArrayOptimizer.PMGraphics_drawRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
    }

    private static void MinigameMusic_drawLives() {
        int n = AnimationManager.getAnimFrameWidth(338, 0);
        int n2 = AnimationManager.getAnimFrameHeight(338, 0);
        int n3 = AnimationManager.getAnimFrameWidth(339, 0);
        int n4 = AnimationManager.getAnimFrameHeight(339, 0);
        int n5 = 240 - n - 3;
        int n6 = GameConstants.Minigame_top + n2 * 10 / 100;
        int n7 = n2 * 85 / 100;
        if (!GameConstants.Minigame_done) {
            ArrayOptimizer.PMGraphics_setColor(0);
            ArrayOptimizer.PMGraphics_fillRect(n5, n6, 240 - n5, 2 * n7 + n2);
        }
        AnimationManager.drawAnimFrame(338, 0, n5, n6);
        if (MinigameMusic_chordsMissed >= 1) {
            AnimationManager.drawAnimFrame(339, 0, n5, n6 + n2 - n4 - 1);
        }
        AnimationManager.drawAnimFrame(338, 0, n5, n6 += n7);
        if (MinigameMusic_chordsMissed >= 2) {
            AnimationManager.drawAnimFrame(339, 0, n5, n6 + n2 - n4 - 1);
        }
        AnimationManager.drawAnimFrame(338, 0, n5, n6 += n7);
        if (MinigameMusic_chordsMissed >= 3) {
            AnimationManager.drawAnimFrame(339, 0, n5, n6 + n2 - n4 - 1);
        }
    }

    static {
        s_animImageArray = new SDKImage[6][73];
        subImageFileLoadProgress = 0;
        subImageFileLoadCIndex = 0;
        subImageFileLoadCIndexMax = 0;
        animFileLoadProgress = 0;
        animFileLoadCIndex = 0;
        animFileLoadCIndexMax = 0;
        primitiveBinaryDataCount = new int[]{6, 8, 8, 8, 8, 8, 8, 4, 8, 0, 1, 6};
        primitiveDataCount = new int[]{4, 5, 5, 5, 5, 5, 5, 3, 5, 0, 2, 4};
        TextHandler_RFF = new String[]{"fnt0.rff", "fnt1.rff", "fnt2.rff", "fnt3.rff", "fnt4.rff", "fnt5.rff"};
        TextHandler_PNG = new String[]{"fnt0.png", "fnt1.png", "fnt2.png", "fnt3.png", "fnt4.png", "fnt5.png"};
        TextHandler_m_dynamicStrings = new SDKString[10];
        TextHandler_s_sdkStrings2 = new SDKString[2];
        TextHandler_s_sdkStrings3 = new SDKString[3];
        TextHandler_m_scrollerStringId = new int[22];
        TextHandler_m_scrollerStringArray = new SDKString[22];
        TextHandler_m_scrollerStringWidth = new int[22];
        TextHandler_m_scrollerTime = new int[22];
        TextHandler_m_scrollerOffset = new int[22];
        MinigameMusic_GAME_TIME = new int[]{20000, 20000, 25000, 25000, 30000, 30000};
        MinigameMusic_SPEED_PERCENTAGE = new int[]{32768, 39322, 44564, 49152, 52429, 55706};
        SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS = new short[]{359, 557, -1, 5, 171, 732, 614, 116, 108, 609, 1, 154, 672, 673, 0, 165, 586, 167, 166, 587, 167, 588, 171, 592, 6, 169, 172, 593, 173, 594, 168, 589, 3, 168, 169, 590, 170, 591, 174, 595, 9, 170, 175, 596, 176, 597, 1051, 114, 1052, 1053, 1054, 449, 584, 23, 119, 582, 120, 121, 122, 581, 583, 585, 580, 559, 25, 125, 16, 560, 13, 128, 129, 130, 149, 132, 561, 15, 151, 64, 562, 16, 150, 128, 1076, 17, 134, 563, 18, 131, 577, 155, 156, 157, 158, 440, 579, 19, 132, 2, 598, 20, 396, 599, 600, 21, 141, 142, 610, 22, 143, 144, 145, 611, 24, 124, 1080, 2, 133, 422, 612, 27, 613, 28, 126, 8, 615, 29, 152, 153, 616, 30, 135, 136, 139, 140, 137, 138, 947, 948, 420, 949, 950, 951, 952, 953, 954, 961, 393, 962, 416, 960, 955, 967, 968, 969, 970, 971, 11, 123, 1035, 1049, 1040, 1034, 1038, 1039, 1041, 26, 419, 1036, 1037, 421, 1070, 1071, 1072, 1073, 1074, 1075, 283, 184, 273, 172, 274, 275, 276, 277, 278, 279, 280, 281, 282, 257, 601, 264, 603, 261, 602, 270, 604, 237, 608, 173, 49, 959, 50, 51, 54, 963, 177, 34, 956, 159, 183, 147, 148, 46, 975, 38, 957, 146, 47, 958, 174, 41, 42, 973, 178, 43, 4, 115, 44, 45, 78, 572, 79, 573, 161, 94, 574, 175, 90, 576, 571, 176, 75, 570, 82, 83, 84, 86, 575, 87, 1048, 112, 113, 59, 564, 160, 57, 565, 58, 60, 61, 1062, 180, 64, 1058, 179, 70, 566, 67, 68, 69, 95, 102, 567, 162, 103, 568, 98, 569, 104, 105, 106, 1064, 181, 1068, 182, 377, 205, 378, 206, 379, 207, 380, 208, 381, 209, 382, 210, 383, 211, 384, 212, 385, 213, 386, 214, 387, 215, 388, 216, 389, 217, 390, 218, 391, 219, 392, 220, 393, 221, 394, 222, 395, 223, 396, 224, 397, 225, 398, 226, 399, 227, 400, 228, 401, 229, 402, 230, 403, 231, 404, 232, 376, 235, 375, 234, 410, 184, 412, 196, 409, 187, 408, 182, 411, 197, 985, 986, 1001, 406, 195, 993, 183, 994, 199, 414, 201, 995, 189, 405, 192, 997, 193, 1003, 185, 1002, 988, 188, 989, 190, 990, 181, 415, 204, 374, 186, 999, 194, 1000, 200, 987, 991, 203, 992, 191, 996, 202, 998, 198, 372, 233, 1004, 236, 1020, 1012, 1013, 1016, 1019, 1005, 1006, 1007, 1008, 1011, 1009, 1010, 1014, 1015, 1017, 1018, 177, 178, 179, 180, 606, 16991, 16990, 607, 604, 16989, 16988, 605, 602, 16987, 16986, 603, 666, 17051, 17050, 667, 628, 17013, 17012, 629, 599, 16984, 16983, 600, 572, 16957, 16956, 573, 574, 16959, 16958, 575, 576, 16961, 16960, 577, 16962, 578, 565, 16950, 16949, 566, 567, 16952, 16951, 568, 608, 16993, 16992, 609, 611, 16996, 16995, 612, 613, 16998, 16997, 614, 615, 17001, 16999, 617, 616, 17002, 17000, 618, 619, 17005, 17003, 621, 620, 17006, 17004, 622, 635, 17021, 17019, 637, 636, 17022, 17020, 638, 639, 17025, 17023, 641, 642, 17028, 17026, 644, 661, 17047, 17045, 663, 16994, 610, 17048, 664, 17037, 653, 17036, 652, 16979, 595, 656, 17041, 17040, 657, 596, 16981, 16980, 597, 626, 17011, 17010, 627, 632, 17016, 631, 17015, 630, 17014, 17049, 665, 585, 16970, 16969, 586, 16971, 587, 588, 16973, 16972, 589, 590, 16975, 16974, 591, 592, 16977, 16976, 593, 16978, 594, 579, 16964, 16963, 580, 581, 16966, 16965, 582, 659, 17044, 17043, 660, 571, 570, 16954, 584, 16968, 598, 16982, 623, 17007, 624, 17009, 17008, 625, 17017, 633, 17018, 634, 17029, 645, 649, 17035, 17033, 651, 650, 17034, 646, 17032, 17030, 648, 647, 17031, 583, 16967, 17038, 654, 17039, 655, 16953, 569, 658, 17042, 640, 17024, 662, 17046, 643, 17027, 504, 16889, 16888, 505, 502, 16887, 16886, 503, 500, 16885, 16884, 501, 563, 16948, 16947, 564, 526, 16911, 16910, 527, 497, 16882, 16881, 498, 470, 16855, 16854, 471, 472, 16857, 16856, 473, 474, 16859, 16858, 475, 16860, 476, 463, 16848, 16847, 464, 465, 16850, 16849, 466, 506, 16891, 16890, 507, 509, 16894, 16893, 510, 511, 16896, 16895, 512, 513, 16899, 16897, 515, 514, 16900, 16898, 516, 517, 16903, 16901, 519, 518, 16904, 16902, 520, 533, 16919, 16917, 535, 534, 16920, 16918, 536, 537, 16923, 16921, 539, 540, 16926, 16924, 542, 558, 16944, 16942, 560, 16892, 508, 16945, 561, 16935, 551, 16934, 550, 16877, 493, 554, 16939, 16938, 555, 494, 16879, 16878, 495, 524, 16909, 16908, 525, 530, 16914, 529, 16913, 528, 16912, 16946, 562, 483, 16868, 16867, 484, 16869, 485, 486, 16871, 16870, 487, 488, 16873, 16872, 489, 490, 16875, 16874, 491, 16876, 492, 477, 16862, 16861, 478, 479, 16864, 16863, 480, 556, 16941, 16940, 557, 469, 468, 16852, 482, 16866, 496, 16880, 521, 16905, 522, 16907, 16906, 523, 16915, 531, 16916, 532, 16927, 543, 547, 16933, 16931, 549, 548, 16932, 544, 16930, 16928, 546, 545, 16929, 481, 16865, 16936, 552, 16937, 553, 16851, 467, 538, 16922, 559, 16943, 541, 16925, 289, 290, 288, 291, 293, 294, 292, 295, 285, 286, 284, 287, 16751, 367, 16750, 366, 16813, 429, 16814, 430, 16812, 428, 16754, 370, 16755, 371, 16817, 433, 16818, 434, 381, 16767, 16765, 383, 382, 16766, 16770, 386, 16821, 437, 16822, 438, 16823, 439, 16776, 392, 16775, 391, 16781, 397, 408, 409, 16840, 456, 16839, 455, 16795, 411, 16794, 410, 16809, 425, 459, 16844, 460, 16846, 462, 16845, 461, 427, 16811, 426, 16810, 369, 16753, 377, 378, 16761, 16762, 395, 404, 405, 16748, 364, 16749, 365, 16746, 362, 16747, 363, 16815, 431, 16816, 432, 389, 390, 16808, 424, 372, 16758, 16756, 374, 373, 16757, 16820, 436, 16819, 435, 16772, 388, 16771, 387, 16778, 394, 16796, 412, 16797, 413, 16798, 414, 16799, 415, 16807, 423, 16768, 384, 368, 16752, 16801, 417, 16782, 398, 16783, 399, 16786, 402, 16787, 403, 375, 376, 16759, 16760, 16841, 457, 16842, 458, 16802, 418, 16769, 385, 16790, 406, 16791, 407, 16784, 400, 16785, 401, 379, 380, 16763, 16764, 80, 81, 92, 93, 76, 77, 31, 32, 39, 40, 66, 65, 63, 62, 97, 96, 101, 100};
        PMTouch_id = -1;
    }
}

