/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Resources
implements ResourceSettings {
    private static int[] IDX;
    private static String[] FILE;
    private static String IDX_FILE;
    private static String FILE_FILE;
    private static String FILE_OFF_FILE;
    private static int[] FILE_OFF;
    private static boolean isDataPreloaded;
    private static byte[] preloadedData;
    private static Image[] images;
    private static byte[][] files;
    private static int[] fileListToLoad;
    private static int loadFileStep;
    private static int[] imageListToLoad;
    private static int loadImageStep;
    private static int[] crcTable;

    private Resources() {
    }

    private static void loadIdx() {
        if (IDX == null) {
            try {
                int i;
                DataInputStream dis = new DataInputStream(new Object().getClass().getResourceAsStream(IDX_FILE));
                IDX = new int[284];
                for (i = 0; i <= 283; ++i) {
                    Resources.IDX[i] = dis.readInt();
                }
                dis.close();
                dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE_FILE));
                FILE = new String[dis.readShort()];
                for (i = 0; i < FILE.length; ++i) {
                    Resources.FILE[i] = dis.readUTF();
                }
                dis.close();
                dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE_OFF_FILE));
                FILE_OFF = new int[dis.readShort()];
                for (i = 0; i < FILE_OFF.length; ++i) {
                    Resources.FILE_OFF[i] = dis.readInt();
                }
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int getPakId(int fileId) {
        int fileOffset = IDX[fileId];
        int idx = 0;
        int i = 0;
        while (i < FILE_OFF.length && fileOffset >= FILE_OFF[i]) {
            idx = i++;
        }
        return idx;
    }

    public static int fileSize(int fileId) {
        Resources.loadIdx();
        return IDX[fileId + 1] - IDX[fileId];
    }

    private static void preloadData() {
        try {
            Resources.loadIdx();
            int size = IDX[282];
            preloadedData = new byte[size];
            for (int i = 0; i < FILE.length - 1; ++i) {
                DataInputStream dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE[i]));
                dis.readFully(preloadedData, FILE_OFF[i], FILE_OFF[i + 1] - FILE_OFF[i]);
                dis.close();
            }
            DataInputStream dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE[FILE.length - 1]));
            dis.readFully(preloadedData, FILE_OFF[FILE.length - 1], size - FILE_OFF[FILE.length - 1]);
            dis.close();
            isDataPreloaded = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static InputStream getStream(int fileId) {
        byte[] data = Resources.loadFile(fileId);
        return new ByteArrayInputStream(data);
    }

    public static DataInputStream getInternalStream(int fileId) {
        DataInputStream dis = null;
        Resources.loadIdx();
        int startOffset = IDX[fileId];
        int pakId = 0;
        pakId = Resources.getPakId(fileId);
        startOffset -= FILE_OFF[pakId];
        try {
            if (IDX[fileId + 1] - IDX[fileId] > 0) {
                dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE[pakId]));
                dis.skipBytes(startOffset);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dis;
    }

    public static byte[] loadFile(int fileId) {
        byte[] data = null;
        Resources.loadIdx();
        if (files[fileId] != null) {
            data = new byte[files[fileId].length];
            System.arraycopy(files[fileId], 0, data, 0, data.length);
        } else {
            int startOffset = IDX[fileId];
            int pakId = 0;
            pakId = Resources.getPakId(fileId);
            startOffset -= FILE_OFF[pakId];
            try {
                data = new byte[IDX[fileId + 1] - IDX[fileId]];
                if (data.length > 0) {
                    DataInputStream dis = new DataInputStream(new Object().getClass().getResourceAsStream(FILE[pakId]));
                    dis.skipBytes(startOffset);
                    dis.readFully(data);
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static void loadFiles(int[] fileIdList, boolean unloadUndefined) {
        int j;
        boolean fileNeeded;
        int i;
        if (unloadUndefined) {
            for (i = 0; i < files.length; ++i) {
                fileNeeded = false;
                for (j = 0; j < fileIdList.length; ++j) {
                    if (i != fileIdList[j]) continue;
                    fileNeeded = true;
                    break;
                }
                if (fileNeeded) continue;
                Resources.files[i] = null;
            }
        }
        System.gc();
        for (i = 0; i < files.length; ++i) {
            fileNeeded = false;
            for (j = 0; j < fileIdList.length; ++j) {
                if (i != fileIdList[j]) continue;
                fileNeeded = true;
                if (files[i] != null) continue;
                Resources.files[i] = Resources.loadFile(i);
            }
        }
    }

    public static void unloadAllFiles() {
        files = new byte[283][];
        System.gc();
    }

    public static void unloadFiles(int[] fileIdList) {
        for (int i = 0; i < fileIdList.length; ++i) {
            Resources.files[fileIdList[i]] = null;
        }
        System.gc();
    }

    public static int loadFilesInit(int[] fileIdList, boolean unloadUndefined) {
        if (fileListToLoad == null) {
            fileListToLoad = fileIdList;
        } else {
            int i;
            int[] tmp = new int[fileListToLoad.length + fileIdList.length];
            for (i = 0; i < fileListToLoad.length; ++i) {
                tmp[i] = fileListToLoad[i];
            }
            while (i < tmp.length) {
                tmp[i] = fileIdList[i - fileListToLoad.length];
                ++i;
            }
            fileListToLoad = tmp;
        }
        loadFileStep = 0;
        for (int i = 0; i < files.length; ++i) {
            boolean fileNeeded = false;
            for (int j = 0; j < fileIdList.length; ++j) {
                if (i != fileIdList[j]) continue;
                fileNeeded = true;
                break;
            }
            if (fileNeeded || !unloadUndefined) continue;
            Resources.files[i] = null;
        }
        System.gc();
        return fileListToLoad.length;
    }

    public static boolean loadFilesStep() {
        if (fileListToLoad != null && loadFileStep < fileListToLoad.length) {
            if (files[fileListToLoad[loadFileStep]] == null) {
                Resources.files[Resources.fileListToLoad[Resources.loadFileStep]] = Resources.loadFile(fileListToLoad[loadFileStep]);
            }
            ++loadFileStep;
            return true;
        }
        imageListToLoad = null;
        return false;
    }

    public static byte[] getFile(int fileId) {
        byte[] data = null;
        if (files[fileId] != null) {
            data = new byte[files[fileId].length];
            System.arraycopy(files[fileId], 0, data, 0, data.length);
        }
        return data;
    }

    public static Image loadImage(int fileId) {
        Image image = null;
        Resources.loadIdx();
        byte[] data = Resources.loadFile(fileId);
        if (data.length != 0) {
            try {
                image = Image.createImage((byte[])data, (int)0, (int)data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public static void loadImages(int[] imageIdList, boolean unloadUndefined) {
        int j;
        boolean imageNeeded;
        int i;
        if (unloadUndefined) {
            for (i = 0; i < images.length; ++i) {
                imageNeeded = false;
                for (j = 0; j < imageIdList.length; ++j) {
                    if (i != imageIdList[j]) continue;
                    imageNeeded = true;
                    break;
                }
                if (imageNeeded) continue;
                Resources.images[i] = null;
            }
        }
        System.gc();
        for (i = 0; i < images.length; ++i) {
            imageNeeded = false;
            for (j = 0; j < imageIdList.length; ++j) {
                if (i != imageIdList[j]) continue;
                imageNeeded = true;
                if (images[i] != null) continue;
                Resources.images[i] = Resources.loadImage(i);
            }
        }
        System.gc();
    }

    public static void unloadAllImages() {
        for (int i = 282; i >= 0; --i) {
            Resources.images[i] = null;
        }
        System.gc();
    }

    public static void unloadImages(int[] imageIdList) {
        for (int i = 0; i < imageIdList.length; ++i) {
            Resources.images[imageIdList[i]] = null;
        }
        System.gc();
    }

    public static int loadImagesInit(int[] imageIdList, boolean unloadUndefined) {
        if (imageListToLoad == null) {
            imageListToLoad = imageIdList;
        } else {
            int i;
            int[] tmp = new int[imageListToLoad.length + imageIdList.length];
            for (i = 0; i < imageListToLoad.length; ++i) {
                tmp[i] = imageListToLoad[i];
            }
            while (i < tmp.length) {
                tmp[i] = imageIdList[i - imageListToLoad.length];
                ++i;
            }
            imageListToLoad = tmp;
        }
        loadImageStep = 0;
        for (int i = 0; i < images.length; ++i) {
            boolean imageNeeded = false;
            for (int j = 0; j < imageIdList.length; ++j) {
                if (i != imageIdList[j]) continue;
                imageNeeded = true;
                break;
            }
            if (imageNeeded || !unloadUndefined) continue;
            Resources.images[i] = null;
        }
        System.gc();
        return imageListToLoad.length;
    }

    public static boolean loadImagesStep() {
        if (imageListToLoad != null && loadImageStep < imageListToLoad.length) {
            if (images[imageListToLoad[loadImageStep]] == null) {
                Resources.images[Resources.imageListToLoad[Resources.loadImageStep]] = Resources.loadImage(imageListToLoad[loadImageStep]);
            }
            ++loadImageStep;
            return true;
        }
        imageListToLoad = null;
        return false;
    }

    public static Image getImage(int imageId) {
        return images[imageId];
    }

    public static String formatString(String source, String[] params) {
        StringBuffer sourceBuffer = new StringBuffer(source);
        for (int c = 0; c < sourceBuffer.length(); ++c) {
            if (sourceBuffer.charAt(c) != '%' || c >= sourceBuffer.length() - 1 || sourceBuffer.charAt(++c) < '0' || sourceBuffer.charAt(c) > '9') continue;
            int id = sourceBuffer.charAt(c) - 48;
            sourceBuffer.delete(--c, c + 3);
            sourceBuffer.insert(c, params[id]);
        }
        return sourceBuffer.toString();
    }

    public static Image replaceImagePalete(int imgId, int paletteId) {
        int paletteIndex;
        byte[] palette = Resources.loadFile(paletteId);
        byte[] imgData = Resources.loadFile(imgId);
        int paletteLength = (imgData[paletteIndex = Resources.getPLTEStartLocation(imgData)] << 24) + (imgData[paletteIndex + 1] << 16) + (imgData[paletteIndex + 2] << 8) + imgData[paletteIndex + 3];
        if (paletteLength < palette.length) {
            return null;
        }
        System.arraycopy(palette, 0, imgData, paletteIndex += 8, palette.length);
        long crc = Resources.calculateCrc(imgData, paletteIndex - 4, paletteLength + 4);
        Resources.writeInt(imgData, paletteIndex + paletteLength, crc);
        Image carImg = null;
        if (imgData.length != 0) {
            try {
                carImg = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return carImg;
    }

    private static int getPLTEStartLocation(byte[] data) {
        if (data[37] == 80 && data[38] == 76 && data[39] == 84 && data[40] == 69) {
            return 33;
        }
        int i = 0;
        do {
            if (data[i] != 80 || data[i + 1] != 76 || data[i + 2] != 84 || data[i + 3] != 69) continue;
            return i - 4;
        } while (++i < data.length - 3);
        return -1;
    }

    private static long calculateCrc(byte[] buf, int off, int len) {
        if (crcTable == null) {
            crcTable = Resources.createCrcTable();
        }
        int c = -1;
        while (--len >= 0) {
            c = crcTable[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    private static int[] createCrcTable() {
        crcTable = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            Resources.crcTable[n] = c;
        }
        return crcTable;
    }

    private static void writeInt(byte[] data, int offset, long crc) {
        data[offset++] = (byte)(crc >>> 24 & 0xFFL);
        data[offset++] = (byte)(crc >>> 16 & 0xFFL);
        data[offset++] = (byte)(crc >>> 8 & 0xFFL);
        data[offset++] = (byte)(crc & 0xFFL);
    }

    static {
        IDX_FILE = "/pak.idx";
        FILE_FILE = "/FILE";
        FILE_OFF_FILE = "/FILE_OFF";
        images = new Image[283];
        files = new byte[283][];
        crcTable = null;
    }
}

