/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

class MIDPSoundPlayer
implements PlayerListener {
    static final int MAX_NR_OF_SOUNDS = 24;
    static final int SYSTEM_MIN_VOLUME = 0;
    static final int SYSTEM_MAX_VOLUME = 5;
    static final int SOUND_TYPE_AMR = 0;
    static final int SOUND_TYPE_MIDI = 1;
    Hashtable MIDPSoundHash;
    int lastSnd;
    int lastTime;
    TheGame tg;
    String mimeType_SFX = "audio/amr";
    String mimeType_Music = "audio/midi";
    Player currentPlayer;
    int last_soundID = -1;
    boolean looped = false;

    MIDPSoundPlayer(TheGame me) {
        this.tg = me;
        this.MIDPSoundHash = new Hashtable();
    }

    void DisposeAllSounds() {
    }

    void FreeSound(int soundID) {
    }

    String getSndFileName(int soundID) {
        String name = "";
        switch (soundID) {
            case 838: {
                name = "music_menu";
                break;
            }
            case 841: {
                name = "theme";
                break;
            }
            case 847: {
                name = "brake";
                break;
            }
            case 850: {
                name = "dash";
                break;
            }
            case 853: {
                name = "hit_big";
                break;
            }
            case 856: {
                name = "hit_small";
                break;
            }
            case 859: {
                name = "jump";
                break;
            }
            case 862: {
                name = "king_talk";
                break;
            }
            case 865: {
                name = "pickup_01";
                break;
            }
            case 868: {
                name = "pickup_02";
                break;
            }
            case 871: {
                name = "pickup_03";
                break;
            }
            case 874: {
                name = "scale";
                break;
            }
            case 877: {
                name = "starbirth";
                break;
            }
            case 880: {
                name = "time";
            }
        }
        return name;
    }

    void LoadSound(int soundID) {
        boolean isSFX = false;
        if (this.MIDPSoundHash.containsKey("" + soundID)) {
            return;
        }
        try {
            this.tg.asset_LoadData(soundID);
            short pCombined = (short)((this.tg.asset_DataArray[soundID + 1] & 0xFFFF) >> 0);
            short nID = (short)((this.tg.asset_DataArray[pCombined + 0] & 0xFFFF0000) >> 16);
            int nStart = (this.tg.asset_DataArray[soundID + 0] & 0xFFFFFFFF) >> 0;
            int nSize = (this.tg.asset_DataArray[soundID + 1] & 0xFFFF0000) >> 16;
            byte[] byArray = new byte[nSize];
            for (int j = 0; j < nSize; ++j) {
                byArray[j] = this.tg.asset_DataBufArray[nID][j + nStart];
            }
            this.MIDPSoundHash.put("" + soundID, byArray);
            this.MIDPSoundHash.put("" + soundID + "-type", isSFX ? this.mimeType_SFX : this.mimeType_Music);
            this.tg.asset_FreeData(soundID);
        }
        catch (Exception e) {
            return;
        }
    }

    void PlaySound(int soundID, boolean force) {
        if (!this.MIDPSoundHash.containsKey("" + soundID)) {
            this.LoadSound(soundID);
        }
        this.StopAllSounds();
        if (this.currentPlayer != null) {
            if (this.currentPlayer.getState() == 400 && this.last_soundID == soundID) {
                return;
            }
            try {
                this.currentPlayer.stop();
                this.currentPlayer.deallocate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.last_soundID = soundID;
        this.looped = false;
        try {
            byte[] byArray = (byte[])this.MIDPSoundHash.get("" + soundID);
            ByteArrayInputStream is = new ByteArrayInputStream(byArray, 0, byArray.length);
            this.currentPlayer = Manager.createPlayer((InputStream)is, (String)((String)this.MIDPSoundHash.get(soundID + "-type")));
            this.currentPlayer.realize();
            VolumeControl vc = (VolumeControl)this.currentPlayer.getControl("VolumeControl");
            vc.setLevel(50);
            this.currentPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void PlaySoundLooped(int soundID) {
        if (soundID == -1) {
            soundID = this.last_soundID;
        }
        if (!this.MIDPSoundHash.containsKey("" + soundID)) {
            this.LoadSound(soundID);
        }
        this.StopAllSounds();
        if (this.currentPlayer != null) {
            if (this.currentPlayer.getState() == 400 && this.last_soundID == soundID) {
                return;
            }
            try {
                this.currentPlayer.stop();
                this.currentPlayer.deallocate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.last_soundID = soundID;
        this.looped = true;
        try {
            byte[] byArray = (byte[])this.MIDPSoundHash.get("" + soundID);
            ByteArrayInputStream is = new ByteArrayInputStream(byArray, 0, byArray.length);
            this.currentPlayer = Manager.createPlayer((InputStream)is, (String)((String)this.MIDPSoundHash.get(soundID + "-type")));
            this.currentPlayer.setLoopCount(-1);
            this.currentPlayer.realize();
            VolumeControl vc = (VolumeControl)this.currentPlayer.getControl("VolumeControl");
            vc.setLevel(50);
            this.currentPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void StopSound(int soundID) {
        this.looped = false;
        this.StopAllSounds();
        if (this.currentPlayer != null) {
            try {
                this.currentPlayer.stop();
                this.currentPlayer.deallocate();
                this.currentPlayer = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.currentPlayer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void StopAllSounds() {
        try {
            if (this.currentPlayer != null) {
                this.currentPlayer.stop();
            }
        }
        catch (MediaException e) {
            // empty catch block
        }
        try {
            if (this.currentPlayer != null) {
                this.currentPlayer.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.currentPlayer != null) {
                this.currentPlayer.deallocate();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.currentPlayer = null;
        this.looped = false;
        if (this.currentPlayer != null) {
            try {
                this.currentPlayer.stop();
                this.currentPlayer.deallocate();
                this.currentPlayer = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.currentPlayer = null;
            }
        }
    }

    void UpdateVolume(boolean testVolume) {
    }

    boolean IsAnotherSoundPlaying() {
        return false;
    }

    void AddNewSound(int soundID, Player sound) {
    }

    public void playerUpdate(Player player, String event, Object eventData) {
    }

    void StopAndResetSoundIfStarted(Player sound) {
        try {
            if (sound.getState() == 400) {
                this.StopAllSounds();
                sound.stop();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void SetVolume(int SoundID, int newVolume) {
    }
}

