/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CLabel
extends CControl {
    public static byte[] textFind;
    public static byte[] textReplace;
    byte[] text;
    byte alignment;
    byte font;
    int yOffset;
    int txtIndex;
    int[] lines;
    boolean upArrow;
    boolean downArrow;
    int visibleLines;

    public CLabel(short left, short top, short width, short height, byte[] txt, byte fontId, byte alignment, byte z) {
        super(new CRect(left, top, left + width, top + height));
        this.font = fontId;
        this.txtIndex = -1;
        this.alignment = alignment;
        this.changeText(txt);
        this.zDepth = z;
        this.type = (byte)5;
    }

    public CLabel(CRect rect, byte[] txt, byte fontId, byte alignment, byte z) {
        super(rect);
        this.font = fontId;
        this.txtIndex = -1;
        this.alignment = alignment;
        this.changeText(txt);
        this.zDepth = z;
        this.type = (byte)5;
    }

    public CLabel(CRect rect, int txt, byte fontId, byte alignment, byte z) {
        super(rect);
        this.font = fontId;
        this.txtIndex = -1;
        this.alignment = alignment;
        if (txt != -1) {
            this.changeText(txt);
        }
        this.zDepth = z;
        this.type = (byte)5;
    }

    public CLabel(short left, short top, short width, short height, int txt, byte fontId, byte alignment, byte z) {
        super(new CRect(left, top, left + width, top + height));
        this.font = fontId;
        this.txtIndex = txt;
        this.alignment = alignment;
        if (txt != -1) {
            this.changeText(txt);
        }
        this.zDepth = z;
        this.type = (byte)5;
    }

    public void changeProps(short left, short top, short width, short height, int txt, byte fontId, byte alignment, byte z) {
        this.bounds = new CRect(left, top, left + width, top + height);
        this.font = fontId;
        this.txtIndex = txt;
        this.alignment = alignment;
        if (txt != -1) {
            this.changeText(txt);
        }
        this.zDepth = z;
        this.type = (byte)5;
    }

    public void changeText(int txtId) {
        this.txtIndex = txtId;
        if (txtId == -1) {
            this.changeText(new byte[0]);
        } else {
            this.changeText(CResManager.getTextBytes(txtId));
        }
    }

    public void changeText(byte[] text) {
        this.downArrow = false;
        this.upArrow = false;
        if (textFind != null && textReplace != null) {
            byte[] newtext = CLabel.replaceString(text, textFind, textReplace);
            if (newtext != null) {
                text = newtext;
            }
            textFind = null;
            textReplace = null;
        }
        this.text = text;
        this.lines = CFontManager.wrapText(text, this.bounds.getWidth(), this.font);
        this.yOffset = 0;
        CEvents.removeControlFromEvent(this, (byte)12);
        CEvents.removeControlFromEvent(this, (byte)13);
        int nrLines = this.bounds.getHeight() / CFontManager.getFontHeight(this.font);
        int newHeight = nrLines * CFontManager.getFontHeight(this.font);
        int n = this.visibleLines = nrLines < this.lines.length - 1 ? nrLines : this.lines.length - 1;
        if (nrLines < this.getNumberOfLines()) {
            this.downArrow = true;
        }
        this.bounds.move(0, this.bounds.getHeight() - newHeight >> 1);
        this.bounds.resize(-1, newHeight);
        if (this.getNumberOfLines() * CFontManager.getFontHeight(this.font) > this.bounds.getHeight()) {
            CEvents.setControlOnEvent(this, (byte)12);
            CEvents.setControlOnEvent(this, (byte)13);
        } else if (this.alignment == 1) {
            this.centerVertically();
        }
        this.notifyParent((byte)30);
    }

    public int getNumberOfLines() {
        return this.lines.length - 1;
    }

    public boolean needsScroll() {
        return this.bounds.getHeight() < this.getNumberOfLines() * CFontManager.getFontHeight(this.font);
    }

    void centerVertically() {
        if (!this.needsScroll()) {
            this.yOffset = this.bounds.getHeight() - this.getNumberOfLines() * CFontManager.getFontHeight(this.font) >> 1;
        }
    }

    public void processEvent(byte event) {
        if (event == 12) {
            this.upArrow = true;
            this.downArrow = true;
            this.yOffset += CFontManager.getFontHeight(this.font);
            if (this.yOffset >= 0) {
                this.yOffset = 0;
                this.upArrow = false;
            }
            CEvents.setEvent(46);
            this.notifyParent((byte)30);
        } else if (event == 13) {
            this.upArrow = true;
            this.downArrow = true;
            this.yOffset -= CFontManager.getFontHeight(this.font);
            if (this.getNumberOfLines() * CFontManager.getFontHeight(this.font) + this.yOffset <= this.bounds.getHeight()) {
                this.yOffset = this.bounds.getHeight() - this.getNumberOfLines() * CFontManager.getFontHeight(this.font);
                this.downArrow = false;
            }
            CEvents.setEvent(47);
            this.notifyParent((byte)30);
        }
    }

    public void paint(Graphics g, CRect forcedClip) {
        if (this.text == null || !this.isVisible) {
            return;
        }
        if (forcedClip == null) {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
        } else {
            g.setClip(this.bounds.left, this.bounds.top, this.bounds.getWidth(), this.bounds.getHeight());
            g.clipRect(forcedClip.left, forcedClip.top, forcedClip.getWidth(), forcedClip.getHeight());
        }
        int xOffset = 0;
        int fontHeight = CFontManager.getFontHeight(this.font);
        int firstLine = this.yOffset >= 0 ? 0 : -this.yOffset / fontHeight;
        int lastLine = firstLine + this.visibleLines;
        for (int i = firstLine; i < lastLine; ++i) {
            int start;
            int end = this.lines[i + 1];
            for (start = this.lines[i]; this.text[start] == 32 && start < end; ++start) {
            }
            while (this.text[end - 1] == 32 && end > start) {
                --end;
            }
            if (this.alignment == 1) {
                xOffset = this.bounds.getWidth() - CFontManager.getStringLength(this.text, start, end, this.font) >> 1;
                CFontManager.printString(this.text, start, end, this.bounds.left + xOffset, this.bounds.top + this.yOffset + CFontManager.getFontHeight(this.font) * i, g, this.font);
                continue;
            }
            if (this.alignment == 0) {
                CFontManager.printString(this.text, start, end, this.bounds.left, this.bounds.top + this.yOffset + CFontManager.getFontHeight(this.font) * i, g, this.font);
                continue;
            }
            if (this.alignment == 2) {
                xOffset = this.bounds.getWidth() - CFontManager.getStringLength(this.text, start, end, this.font);
                CFontManager.printString(this.text, start, end, this.bounds.left + xOffset, this.bounds.top + this.yOffset + CFontManager.getFontHeight(this.font) * i, g, this.font);
                continue;
            }
            if (this.alignment != 3) continue;
            byte fontSpace = CFontManager.SPACE_WIDTH[this.font];
            int strLength = CFontManager.getStringLength(this.text, this.lines[i], this.lines[i + 1], this.font);
            if (strLength > this.bounds.getWidth() * 3 >> 2) {
                while (strLength < this.bounds.getWidth()) {
                    strLength = CFontManager.getStringLength(this.text, this.lines[i], this.lines[i + 1], this.font);
                    byte by = this.font;
                    CFontManager.SPACE_WIDTH[by] = (byte)(CFontManager.SPACE_WIDTH[by] + 1);
                }
                byte by = this.font;
                CFontManager.SPACE_WIDTH[by] = (byte)(CFontManager.SPACE_WIDTH[by] - 2);
            }
            int skip = this.text[this.lines[i]] == 32 ? 1 : 0;
            CFontManager.printString(this.text, this.lines[i] + skip, this.lines[i + 1], this.bounds.left + xOffset, this.bounds.top + this.yOffset + CFontManager.getFontHeight(this.font) * i, g, this.font);
            CFontManager.SPACE_WIDTH[this.font] = fontSpace;
        }
    }

    public String toString() {
        return "adr: " + this.hashCode() + "; type: " + this.getClass() + "; txt: " + this.text + "; font: " + this.font + "; alignment: " + this.alignment + "; bounds: " + this.bounds;
    }

    public static byte[] replaceString(byte[] main, byte[] find, byte[] replace) {
        if (main == null || find == null || replace == null || find.length == 0) {
            return main;
        }
        int len = 0;
        int[] indeces = new int[main.length / find.length + 1];
        int nrfind = 0;
        for (int i = 0; i < main.length; ++i) {
            len = main[i] == find[len] ? ++len : 0;
            if (len != find.length) continue;
            indeces[nrfind] = i - len + 1 - nrfind * (find.length - replace.length);
            len = 0;
            ++nrfind;
        }
        byte[] ret = main;
        if (nrfind > 0) {
            ret = new byte[main.length - nrfind * (find.length - replace.length)];
            indeces[nrfind] = ret.length;
            int k = 0;
            for (int i = 0; i < ret.length; ++i) {
                if (i - indeces[k] == replace.length) {
                    ++k;
                }
                ret[i] = i - indeces[k] < replace.length && i - indeces[k] >= 0 ? replace[i - indeces[k]] : main[i + k * (find.length - replace.length)];
            }
        }
        return ret;
    }

    public static byte[] trimString(byte[] str) {
        int i;
        int nb = 0;
        for (i = 0; i < str.length && str[i] == 32; ++i) {
            ++nb;
        }
        int start = i;
        if (start == str.length) {
            return new byte[0];
        }
        for (i = str.length - 1; i > start && str[i] == 32; --i) {
            ++nb;
        }
        int end = i;
        byte[] rez = new byte[str.length - nb];
        System.arraycopy(str, start, rez, 0, end - start + 1);
        return rez;
    }
}

