/*
 * Decompiled with CFR 0.152.
 */
public class CGame {
    public static int quizStep = 0;
    public static int quizCrtAnswer = 0;
    public static byte quizSavedAnswer = (byte)-1;
    public static short[] quizQuestions;
    public static short[] usedQuestions;
    public static short[] usedMiniQuestions;
    public static int quizCrtQuestionId;
    public static byte quizPoints;
    public static boolean wasBackPressed;
    public static boolean isCorrectAnswer;
    public static int lastQuestionPoints;
    public static boolean isCheatOn;
    public static int answersNb;
    public static int questionsNb;
    public static int totalQuestionsNb;
    public static int firstQuestionId;
    public static byte juryScore1;
    public static byte juryScore2;
    public static boolean hasPerfectOutfit;
    public static byte hairType;
    public static short totalScore;
    public static short spendingPoints;
    public static int scorTimer;
    public static byte[] destinationsScore;
    public static byte bufferScore;
    public static int crtShopItem;
    public static int[][] shopAvailable;
    public static int puzzleTime;
    public static byte puzzleLevel;
    public static byte sniper1Level;
    public static byte sniper2Level;
    public static int[] sniperTargetsUp;
    public static int[] sniperTargetsDown;
    public static int sniperBullet;
    public static int bonusPeriod;
    public static int sniperPoints;
    public static int sniperTime;
    public static int sniper2TotalTg;
    public static int sniperGivenBonus;
    public static int[] sniper2TargetsUp;
    public static int[] sniper2TargetsDown;
    public static int[] sniper2InitialTargetsUp;
    public static int[] sniper2InitialTargetsDown;
    public static int unhitTargets;

    public static void furnishShopItems(int location) {
        int i;
        for (i = 0; i < 4; ++i) {
            CGame.shopAvailable[i] = null;
        }
        for (i = 1; i <= location; ++i) {
            CGame.addItemsInShop(i);
        }
    }

    public static void addItemsInShop(int location) {
        for (int i = 0; i < 4; ++i) {
            if (shopAvailable[i] == null) {
                CGame.shopAvailable[i] = new int[IGame.AVAILABLE_ITEMS[location][i].length];
                System.arraycopy(IGame.AVAILABLE_ITEMS[location][i], 0, shopAvailable[i], 0, shopAvailable[i].length);
                continue;
            }
            int[] buffer = shopAvailable[i];
            CGame.shopAvailable[i] = new int[buffer.length + IGame.AVAILABLE_ITEMS[location][i].length];
            System.arraycopy(buffer, 0, shopAvailable[i], 0, buffer.length);
            System.arraycopy(IGame.AVAILABLE_ITEMS[location][i], 0, shopAvailable[i], buffer.length, IGame.AVAILABLE_ITEMS[location][i].length);
        }
    }

    public static void resetQuest() {
        CRMSManager.resetQuest();
        totalScore = 0;
        spendingPoints = 0;
        quizPoints = 0;
        sniperPoints = 0;
        quizSavedAnswer = (byte)-1;
        for (int i = 0; i < 4; ++i) {
            CGame.destinationsScore[i] = 0;
        }
    }

    public static void addToScore(int score) {
        totalScore = (short)(totalScore + score);
        spendingPoints = (short)(spendingPoints + score * 250 / 100);
    }

    public static int addToCircular(int crt, int amount, int limit) {
        crt += amount;
        if ((crt %= limit) < 0) {
            crt += limit;
        }
        return crt;
    }

    public static void entryQuiz() {
        answersNb = 4;
        questionsNb = 15;
        totalQuestionsNb = 30;
        firstQuestionId = 163;
        CGame.generateQuestions();
        quizCrtQuestionId = 0;
        quizCrtAnswer = 0;
        quizPoints = 0;
        if (usedQuestions == null) {
            usedQuestions = new short[questionsNb];
            System.arraycopy(quizQuestions, 0, usedQuestions, 0, usedQuestions.length);
        } else {
            short[] ret = new short[usedQuestions.length + quizQuestions.length];
            System.arraycopy(usedQuestions, 0, ret, 0, usedQuestions.length);
            System.arraycopy(quizQuestions, 0, ret, usedQuestions.length, ret.length - usedQuestions.length);
            usedQuestions = ret;
            if (usedQuestions.length >= 30) {
                usedQuestions = null;
            }
        }
        if (isCheatOn) {
            CGame.showAllQuizTexts();
        }
    }

    public static void entryMiniQuiz() {
        answersNb = 3;
        questionsNb = 7;
        totalQuestionsNb = 50;
        firstQuestionId = 436;
        quizCrtAnswer = 0;
        if (!CFlags.isComingFromLoad) {
            CGame.generateQuestions();
            quizCrtQuestionId = 0;
            quizPoints = 0;
            if (usedMiniQuestions == null) {
                usedMiniQuestions = new short[questionsNb];
                System.arraycopy(quizQuestions, 0, usedMiniQuestions, 0, usedMiniQuestions.length);
            } else {
                short[] ret = new short[usedMiniQuestions.length + quizQuestions.length];
                System.arraycopy(usedMiniQuestions, 0, ret, 0, usedMiniQuestions.length);
                System.arraycopy(quizQuestions, 0, ret, usedMiniQuestions.length, ret.length - usedMiniQuestions.length);
                usedMiniQuestions = ret;
                if (usedMiniQuestions.length >= 50) {
                    usedMiniQuestions = null;
                }
            }
        }
        if (isCheatOn) {
            CGame.showAllQuizTexts();
        }
    }

    public static void showAllQuizTexts() {
        questionsNb = totalQuestionsNb;
        quizQuestions = new short[questionsNb];
        for (int i = 0; i < questionsNb; ++i) {
            CGame.quizQuestions[i] = (short)(firstQuestionId + i * (answersNb * 2 + 1));
        }
    }

    public static void generateQuestions() {
        quizQuestions = new short[questionsNb];
        for (int i = 0; i < questionsNb; ++i) {
            short random = (short)(CAMARandom.abs(CAMARandom.getNextInt()) % (long)totalQuestionsNb);
            boolean ok = false;
            block1: while (!ok) {
                short[] usedQ;
                ok = true;
                CGame.quizQuestions[i] = (short)(firstQuestionId + random % totalQuestionsNb * (answersNb * 2 + 1));
                for (int j = 0; j < i; ++j) {
                    if (quizQuestions[i] != quizQuestions[j]) continue;
                    ok = false;
                    random = (short)(random + 1);
                    break;
                }
                if ((usedQ = questionsNb == 15 ? usedQuestions : usedMiniQuestions) == null || !ok) continue;
                for (int k = 0; k < usedQ.length; ++k) {
                    if (usedQ[k] != quizQuestions[i]) continue;
                    ok = false;
                    random = (short)(random + 1);
                    continue block1;
                }
            }
        }
    }

    public static void saveSound() {
        CRMSManager.rmsSoundsLevel = CSoundManager.volIndex;
    }

    public static void saveSettings() {
        CRMSManager.rmsGeneralSettings = CFlags.isMinigameUnLocked ? (byte)1 : 0;
    }

    public static void loadAllSettings() {
        CSoundManager.volIndex = CRMSManager.rmsSoundsLevel;
        CFlags.isMinigameUnLocked = CRMSManager.rmsGeneralSettings == 1;
    }

    public static void saveQuest(short currentState) {
        int i;
        int offset = 0;
        CRMSManager.rmsQuest = new byte[57];
        CFlags.stateBeforeMenu = currentState;
        if (currentState == 15 || currentState == 18) {
            currentState = (short)14;
        }
        CRMSManager.rmsQuest[offset++] = Bitwise.intToBytes(currentState)[3];
        CRMSManager.rmsQuest[offset++] = quizPoints;
        CRMSManager.rmsQuest[offset++] = (byte)quizCrtQuestionId;
        if (currentState == 17) {
            for (i = 0; i < 7; ++i) {
                CRMSManager.rmsQuest[offset++] = (byte)(0xFF & quizQuestions[i]);
                CRMSManager.rmsQuest[offset++] = (byte)(0xFF & quizQuestions[i] >> 8);
            }
        } else {
            offset += 14;
        }
        CRMSManager.rmsQuest[offset++] = CFlags.questDestination;
        for (i = 0; i < 4; ++i) {
            CRMSManager.rmsQuest[offset++] = destinationsScore[i];
        }
        CRMSManager.rmsQuest[offset++] = (byte)(0xFF & spendingPoints);
        CRMSManager.rmsQuest[offset++] = (byte)(0xFF & spendingPoints >> 8);
        CRMSManager.rmsQuest[offset++] = (byte)(0xFF & sniperPoints);
        CRMSManager.rmsQuest[offset++] = (byte)(0xFF & sniperPoints >> 8);
        CRMSManager.rmsQuest[offset++] = quizSavedAnswer;
        byte[] g = CGirl.theGirl.save();
        System.arraycopy(g, 0, CRMSManager.rmsQuest, offset, g.length);
    }

    public static short loadQuest() {
        int i;
        short currentState;
        CFlags.wasFashionExplShown = true;
        int offset = 0;
        if ((currentState = (short)CRMSManager.rmsQuest[offset++]) == 32 || currentState == 19 || currentState == 17) {
            CFlags.isComingFromLoad = true;
        }
        if (currentState == 32 || currentState == 28 || currentState == 29) {
            CFlags.isInQuestForSave = false;
        }
        if (currentState == 14) {
            if (CFlags.stateBeforeMenu == 15 || CFlags.stateBeforeMenu == 18) {
                CFlags.isComingFromLoad = true;
            }
            if (!CFlags.destinationHasBack) {
                CFlags.isComingFromLoad = true;
            }
        }
        quizPoints = CRMSManager.rmsQuest[offset++];
        quizCrtQuestionId = CRMSManager.rmsQuest[offset++];
        if (currentState == 17) {
            quizQuestions = new short[7];
            CFlags.wasMiniQuizPopupShown = true;
            CFlags.isComingFromLoad = true;
            for (i = 0; i < 7; ++i) {
                CGame.quizQuestions[i] = (short)((CRMSManager.rmsQuest[offset++] & 0xFF) + ((CRMSManager.rmsQuest[offset++] & 0xFF) << 8));
            }
        } else {
            offset += 14;
        }
        CFlags.questDestination = CRMSManager.rmsQuest[offset++];
        totalScore = currentState == 17 ? (short)0 : (short)(quizPoints * 3);
        for (i = 0; i < 4; ++i) {
            CGame.destinationsScore[i] = CRMSManager.rmsQuest[offset++];
            totalScore = (short)(totalScore + destinationsScore[i]);
        }
        spendingPoints = (short)((CRMSManager.rmsQuest[offset++] & 0xFF) + ((CRMSManager.rmsQuest[offset++] & 0xFF) << 8));
        sniperPoints = (short)((CRMSManager.rmsQuest[offset++] & 0xFF) + ((CRMSManager.rmsQuest[offset++] & 0xFF) << 8));
        totalScore = (short)(totalScore + sniperPoints);
        quizSavedAnswer = CRMSManager.rmsQuest[offset++];
        quizCrtAnswer = quizSavedAnswer;
        byte[] load = new byte[30];
        System.arraycopy(CRMSManager.rmsQuest, offset, load, 0, 30);
        CGirl.loadData = load;
        return currentState;
    }

    public static void savePicture(int poz, byte[] name, byte destination, CGirl girl) {
        CRMSManager.rmsPictures[poz] = new byte[39];
        int t = 0;
        System.arraycopy(name, 0, CRMSManager.rmsPictures[poz], t, name.length);
        t += name.length;
        while (t < 8) {
            CRMSManager.rmsPictures[poz][t++] = 32;
        }
        CRMSManager.rmsPictures[poz][t++] = destination;
        byte[] savedGirl = girl.save();
        System.arraycopy(savedGirl, 0, CRMSManager.rmsPictures[poz], t, savedGirl.length);
        t += savedGirl.length;
    }

    public static int loadPicture(int poz, CGirl girl) {
        if (CRMSManager.rmsPictures[poz].length != 39) {
            return -1;
        }
        int t = 8;
        byte destination = CRMSManager.rmsPictures[poz][t++];
        byte[] girlData = new byte[30];
        System.arraycopy(CRMSManager.rmsPictures[poz], t, girlData, 0, 30);
        CGirl.loadData = girlData;
        girl.load();
        return destination;
    }

    public static void createPredefinedPicture(int poz, CGirl girl) {
        girl.initElems((byte)1);
        girl.setCloseViewMode(false);
        for (int i = 0; i < IGame.PREDEFINED_PICTURES[poz].length; ++i) {
            if (IGame.PREDEFINED_PICTURES[poz][i] == -2) continue;
            girl.putItem(i + 3, IGame.PREDEFINED_PICTURES[poz][i]);
        }
    }

    public static void computeScore(CGirl girl, int destination) {
        int j;
        int i;
        int hair;
        --destination;
        int score = 0;
        boolean hasDress = false;
        if (girl.getItemID(3) <= 3) {
            hasDress = true;
        }
        if ((hair = girl.getItemID(1)) <= 1) {
            hairType = 0;
        } else {
            hairType = (byte)2;
            for (int i2 = 0; i2 < IGame.SUITABLE_HAIR[destination].length; ++i2) {
                if (hair != IGame.SUITABLE_HAIR[destination][i2]) continue;
                score = (byte)(score + IGame.SUITABLE_SCORE[4]);
                hairType = 1;
                break;
            }
        }
        boolean hasPerfectOutfit = false;
        CGame.hasPerfectOutfit = false;
        for (i = 0; i < IGame.PERFECT_OUTFIT[destination].length; ++i) {
            for (j = 0; j < IGame.PERFECT_OUTFIT[destination][i].length && (girl.getItemID(j + 3) == IGame.PERFECT_OUTFIT[destination][i][j] || IGame.PERFECT_OUTFIT[destination][i][j] == -2); ++j) {
            }
            if (j != IGame.PERFECT_OUTFIT[destination][i].length) continue;
            hasPerfectOutfit = true;
            break;
        }
        if (hasPerfectOutfit && hairType == 1) {
            score = (byte)(score + 3);
            CGame.hasPerfectOutfit = true;
        }
        block3: for (i = 3; i <= 6; ++i) {
            if (CGame.hasPerfectOutfit) {
                score = (byte)(score + IGame.SUITABLE_SCORE[i - 3]);
                continue;
            }
            if (hasDress && i == 4) continue;
            int currentID = girl.getItemID(i);
            for (j = 0; j < IGame.SUITABLE_ITEMS[destination][i - 3].length; ++j) {
                if (currentID != IGame.SUITABLE_ITEMS[destination][i - 3][j]) continue;
                if (i == 3 && hasDress) {
                    score = (byte)(score + IGame.SUITABLE_SCORE[i - 3]);
                }
                score = (byte)(score + IGame.SUITABLE_SCORE[i - 3]);
                continue block3;
            }
        }
        bufferScore = (byte)score;
        CAMARandom.init();
        juryScore1 = (byte)(score / 2);
        juryScore2 = (byte)(score / 2);
        if ((CAMARandom.getNextInt() & 1) == 0) {
            juryScore2 = (byte)(juryScore2 + (byte)(score % 2));
        } else {
            juryScore1 = (byte)(juryScore1 + (byte)(score % 2));
        }
        if (juryScore1 > 10) {
            juryScore1 = (byte)10;
        }
        if (juryScore2 > 10) {
            juryScore2 = (byte)10;
        }
        if (juryScore1 == juryScore2 && juryScore1 > 1 && juryScore1 < 10) {
            juryScore1 = (byte)(juryScore1 + 1);
            juryScore2 = (byte)(juryScore2 - 1);
        }
    }

    public static CSprite getShopNextItem(boolean goForward) {
        int[] crt = CGame.getItemInfo();
        int itemIndexinAni = shopAvailable[crt[0]][crt[1]];
        int picture = CGirl.theGirl.getItemFromRes(crt[0] + 3, itemIndexinAni)[CGirl.IMG_ID];
        picture = CResManager.getSpriteImageId(picture);
        CResManager.images[picture] = null;
        crtShopItem = goForward ? crtShopItem + 1 : crtShopItem - 1;
        crt = CGame.getItemInfo();
        itemIndexinAni = shopAvailable[crt[0]][crt[1]];
        picture = CGirl.theGirl.getItemFromRes(crt[0] + 3, itemIndexinAni)[CGirl.IMG_ID];
        if (CResManager.images[CResManager.getSpriteImageId(picture = CResManager.getSpriteImageId(picture))] == null) {
            CResManager.loadImage(CResManager.getSpriteImageId(picture), false, null);
        }
        if (CGirl.theGirl.availableItems[crt[0]][itemIndexinAni]) {
            return CGame.getShopNextItem(goForward);
        }
        CSprite c = new CSprite(0, 0, CGirl.theGirl.getItemFromRes(crt[0] + 3, itemIndexinAni)[CGirl.IMG_ID], 0);
        if (crt[0] + 3 == 5) {
            c = (CSprite)CResManager.getControl(CResManager.getControlDate(14, itemIndexinAni, 0));
        }
        c.center();
        c.move(0, -20);
        return c;
    }

    public static int getShopItemPrice() {
        int[] crt = CGame.getItemInfo();
        return IGame.ITEM_PRICES[crt[0]][shopAvailable[crt[0]][crt[1]]];
    }

    public static void setItemAvailable() {
        int[] crt = CGame.getItemInfo();
        CGirl.theGirl.availableItems[crt[0]][CGame.shopAvailable[crt[0]][crt[1]]] = true;
    }

    public static int[] getItemInfo() {
        int crtItemIndex;
        int crtType = 0;
        int i = 0;
        int numberOfTypes = 4;
        if (crtShopItem < 0) {
            for (i = 0; i < numberOfTypes; ++i) {
                crtShopItem += shopAvailable[i].length;
            }
            crtItemIndex = shopAvailable[i - 1].length - 1;
            crtType = numberOfTypes - 1;
        } else {
            for (crtItemIndex = crtShopItem; crtItemIndex >= shopAvailable[crtType].length; crtItemIndex -= shopAvailable[crtType].length) {
                if (++crtType != numberOfTypes) continue;
            }
            if (crtType >= numberOfTypes) {
                crtShopItem = 0;
                crtItemIndex = 0;
                crtType = 0;
            }
        }
        int[] x = new int[]{crtType, crtItemIndex};
        return x;
    }

    public static int getStatus() {
        if (CFlags.questDestination == 0) {
            return 0;
        }
        for (int i = IGame.OVERALL_SCORE_LEVELS.length - 1; i >= 0; --i) {
            if (totalScore + (!CFlags.isScoreFinished ? destinationsScore[CFlags.questDestination - 1] : (short)0) < IGame.OVERALL_SCORE_LEVELS[i]) continue;
            return i + 1;
        }
        return 0;
    }

    public static byte[] fillStringWithChar(byte[] name, int font, int size, char ch) {
        int extra = (size - CFontManager.getStringLength(name, font)) / CFontManager.getCharWidth(ch, font);
        byte[] newName = new byte[name.length + extra];
        System.arraycopy(name, 0, newName, 0, name.length);
        for (int i = name.length; i < newName.length; ++i) {
            newName[i] = 46;
        }
        return newName;
    }

    public static int insertNewFamous(int score) {
        int i;
        int pos;
        int namesNb;
        for (namesNb = 0; namesNb < 5 && CRMSManager.rmsFamous[namesNb][0] != -1; ++namesNb) {
        }
        for (pos = 0; pos < namesNb && CRMSManager.getFamousScore(pos) > score; ++pos) {
        }
        if (pos >= 5) {
            return -1;
        }
        for (i = namesNb - 1; i >= pos; --i) {
            if (i == 4) continue;
            System.arraycopy(CRMSManager.rmsFamous[i], 0, CRMSManager.rmsFamous[i + 1], 0, 10);
        }
        for (i = 0; i < 8; ++i) {
            CRMSManager.rmsFamous[pos][i] = 46;
        }
        CRMSManager.rmsFamous[pos][8] = (byte)(0xFF & totalScore);
        CRMSManager.rmsFamous[pos][9] = (byte)(0xFF & totalScore >> 8);
        return pos;
    }

    public static void initiateSniper2Targets() {
        for (int i = 0; i < sniper2TotalTg; ++i) {
            if (i < 7) {
                CGame.sniper1AddTgsGradually(sniper2InitialTargetsUp, false);
                CGame.sniper1AddTgsGradually(sniper2InitialTargetsDown, true);
                continue;
            }
            CGame.sniper2AddTgs(sniper2InitialTargetsUp, false);
            CGame.sniper2AddTgs(sniper2InitialTargetsDown, true);
        }
    }

    public static void sniper2AddTgsGradually(int[] targets, boolean down) {
        if (!down) {
            for (int i = 0; i < CFlags.sniperFrameCount; ++i) {
                targets[i] = sniper2InitialTargetsUp[i];
            }
        } else {
            for (int i = 6; i > 6 - CFlags.sniperFrameCount; --i) {
                targets[i] = sniper2InitialTargetsDown[i];
            }
        }
    }

    public static void sniper1AddTgsGradually(int[] targets, boolean down) {
        int i;
        if (CFlags.sniperFrameCount < 7) {
            ++CFlags.sniperFrameCount;
        }
        int stars = 0;
        int buls = 0;
        int empties = 0;
        int n = i = down ? 7 - CFlags.sniperFrameCount + 1 : CFlags.sniperFrameCount - 2;
        while (down ? i < 7 : i >= 0) {
            if (targets[i] == 196715) {
                ++stars;
            }
            if (targets[i] == 131179) {
                ++buls;
            }
            if (targets[i] == -1) {
                ++empties;
            }
            targets[down ? i - 1 : i + 1] = targets[i];
            i = down ? i + 1 : i - 1;
        }
        targets[down ? 6 : 0] = CGame.generateNewTarget(stars, buls, empties);
    }

    public static void sniper2AddTgs(int[] targets, boolean down) {
        int stars = 0;
        int buls = 0;
        int empties = 0;
        CGame.sniper2ShiftTargets(targets, down);
        for (int i = 1; i < 7; ++i) {
            if (targets[i] == 196715 || targets[i] == 65644) {
                ++stars;
            }
            if (targets[i] == 131179 || targets[i] == 262251) {
                ++buls;
            }
            if (targets[i] != -1) continue;
            ++empties;
        }
        targets[down ? 6 : 0] = CGame.generateNewTarget(stars, buls, empties);
    }

    public static int generateNewTarget(int stars, int buls, int empties) {
        boolean isOk = false;
        int what = -1;
        while (!isOk) {
            int r = CAMARandom.getNextInt() % 3;
            r = r > 0 ? r : -r;
            switch (r) {
                case 0: {
                    what = -1;
                    break;
                }
                case 1: {
                    what = 196715;
                    break;
                }
                case 2: {
                    what = 131179;
                    break;
                }
            }
            isOk = what == 196715 && (stars + buls < 4 || stars + buls < 4) || what == 131179 && (buls + stars < 4 || buls + stars < 4) || what == -1 && (empties < 3 || empties < 3);
        }
        if (what != -1 && !CFlags.isInFirstSniper) {
            ++unhitTargets;
        }
        return what;
    }

    public static void sniperAddBonus() {
        int r;
        if (sniperTargetsUp[0] == -1 && ++bonusPeriod > 8) {
            bonusPeriod = 0;
            r = CAMARandom.getNextInt() % 5;
            r = r > 0 ? r : -r;
            CGame.sniperTargetsUp[0] = IGame.SNIPER_BONUS[r];
        }
        if (sniperTargetsDown[6] == -1 && bonusPeriod > 8) {
            bonusPeriod = 0;
            r = CAMARandom.getNextInt() % 5;
            r = r > 0 ? r : -r;
            CGame.sniperTargetsDown[6] = IGame.SNIPER_BONUS[r];
        }
    }

    public static void sniper2ShiftTargets(int[] targets, boolean down) {
        int i;
        int what = targets[down ? 0 : targets.length - 1];
        int n = i = down ? 1 : targets.length - 2;
        while (down ? i < targets.length : i >= 0) {
            targets[down ? i - 1 : i + 1] = targets[i];
            i = down ? i + 1 : i - 1;
        }
        targets[down ? targets.length - 1 : 0] = what;
    }

    public static void changeItems(int[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] == 196714) {
                targets[i] = 65644;
                continue;
            }
            if (targets[i] == 65642) {
                targets[i] = 262251;
                continue;
            }
            if (targets[i] != 131178) continue;
            targets[i] = -1;
        }
    }

    static int getLevelScore(int level, boolean firstSniper) {
        if (level > 2 || level < 0) {
            return 0;
        }
        byte[] score = firstSniper ? CRMSManager.rmsSniper1Scores : CRMSManager.rmsSniper2Scores;
        return (score[level << 1] & 0xFF) + ((score[(level << 1) + 1] & 0xFF) << 8);
    }

    static void setLevelScore(int level, boolean firstSniper, int scr) {
        if (level > 2 || level < 0) {
            return;
        }
        byte[] score = firstSniper ? CRMSManager.rmsSniper1Scores : CRMSManager.rmsSniper2Scores;
        score[level << 1] = (byte)(0xFF & scr);
        score[(level << 1) + 1] = (byte)(0xFF & scr >> 8);
    }

    public static byte[] timeToString(int seconds) {
        StringBuffer time = new StringBuffer();
        if (seconds / 60 < 10) {
            time.append("0");
        }
        time.append(seconds / 60 + ":");
        if (seconds % 60 < 10) {
            time.append("0");
        }
        time.append(seconds % 60);
        return time.toString().getBytes();
    }

    static {
        quizCrtQuestionId = 0;
        quizPoints = 0;
        wasBackPressed = false;
        isCorrectAnswer = false;
        lastQuestionPoints = 0;
        isCheatOn = false;
        destinationsScore = new byte[4];
        crtShopItem = 0;
        shopAvailable = new int[4][];
        puzzleLevel = 0;
        sniper1Level = 0;
        sniper2Level = 0;
        sniperTargetsUp = new int[7];
        sniperTargetsDown = new int[7];
    }
}

