/*
 * Decompiled with CFR 0.152.
 */
public class Bitwise {
    public static final int UNSIGNED_LIMIT = 9;

    public static void write(int n, int bits, byte[] v, int offset) {
        if (bits > 9 && n < 0) {
            n = -n;
            n |= 1 << bits - 1;
        }
        for (int i = offset; i < offset + bits; ++i) {
            if ((n & 1 << bits - 1 - (i - offset)) != 0) {
                int n2 = i >> 3;
                v[n2] = (byte)(v[n2] | (byte)(1 << 7 - (i & 7)));
                continue;
            }
            int n3 = i >> 3;
            v[n3] = (byte)(v[n3] & (byte)(~(1 << 7 - (i & 7))));
        }
    }

    public static void write(int n, int bits, short[] v, int offset) {
        if (bits > 9 && n < 0) {
            n = -n;
            n |= 1 << bits - 1;
        }
        for (int i = offset; i < offset + bits; ++i) {
            if ((n & 1 << bits - 1 - (i - offset)) != 0) {
                int n2 = i >> 3;
                v[n2] = (short)(v[n2] | (byte)(1 << 7 - (i & 7)));
                continue;
            }
            int n3 = i >> 3;
            v[n3] = (short)(v[n3] & (byte)(~(1 << 7 - (i & 7))));
        }
    }

    public static int read(int bits, byte[] v, int offset) {
        int rez = 0;
        for (int i = offset; i < offset + bits; ++i) {
            if ((v[i >> 3] & 1 << 7 - (i & 7)) == 0) continue;
            rez |= 1 << bits - 1 - (i - offset);
        }
        if (bits > 9 && (rez & 1 << bits - 1) != 0) {
            rez &= ~(1 << bits - 1);
            rez = -rez;
        }
        return rez;
    }

    public static int read(int bits, short[] v, int offset) {
        int rez = 0;
        for (int i = offset; i < offset + bits; ++i) {
            if ((v[i >> 3] & 1 << 7 - (i & 7)) == 0) continue;
            rez |= 1 << bits - 1 - (i - offset);
        }
        if (bits > 9 && (rez & 1 << bits - 1) != 0) {
            rez &= ~(1 << bits - 1);
            rez = -rez;
        }
        return rez;
    }

    public static int bytesToInt(byte[] readInt, int startIdx, boolean mToL) {
        int rez = 0;
        for (int i = startIdx; i < startIdx + 4; ++i) {
            rez += (readInt[i] & 0xFF) << (mToL ? startIdx + 3 - i : i - startIdx) * 8;
        }
        return rez;
    }

    public static int bytesToInt(short[] readInt, int startIdx) {
        int rez = 0;
        for (int i = startIdx; i < startIdx + 4; ++i) {
            rez += (readInt[i] & 0xFF) << (startIdx + 3 - i) * 8;
        }
        return rez;
    }

    public static byte[] intToBytes(int readInt) {
        byte[] rez = new byte[4];
        for (int i = 3; i >= 0; --i) {
            rez[i] = (byte)(0xFF & readInt);
            readInt >>= 8;
        }
        return rez;
    }

    public static int leftBits(int source, int sourceLen, int n) {
        return source >> sourceLen - n;
    }

    public static int rightBits(int source, int n) {
        return source % (1 << n);
    }

    public static short readShort(byte[] v, int offset) {
        short rez = (short)(0xFF & v[offset]);
        rez = (short)(rez | (short)((short)v[offset + 1] << 8));
        return rez;
    }
}

