/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.snd;

import com.slg.j2me.lib.sys.Application;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundBank
implements PlayerListener {
    public static Player player;
    public static int MICKHYvolume;
    private static VolumeControl volume;
    private static SoundBank instance;
    public static boolean soundEnbaled;
    public static int volume_level;
    public static int currentSound;
    public static boolean looping;
    public static boolean paused;
    public static int numSounds;
    private static final String[][] strAudioMimeTypes;
    private static String[] audioFiles;
    private static final int midiStop = -1;
    private static final int midiDoNothing = -2;
    private static int nextMidiTrack;
    public static int nextVolume;
    public static boolean isNextLooping;

    public static void setChannelSounds(int channel, String[] _audioFiles) {
        if (channel != 0) {
            return;
        }
        System.out.println("SoundBank.startup");
        audioFiles = _audioFiles;
        numSounds = audioFiles.length;
        if (numSounds <= 0) {
            System.out.println("Assertion Failure: numSounds>0\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\snd/SoundBank_MMA_Simple.java.h[45]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (instance == null) {
            instance = new SoundBank();
        }
        currentSound = -1;
    }

    public static boolean load(int i) {
        if (player != null) {
            try {
                player.stop();
                player.deallocate();
                player.close();
                player = null;
            }
            catch (MediaException pe) {
                System.out.println("\n\n*******************************************************\nSoundBank: Failed to shutdown sound #" + currentSound + " ME: " + pe.toString() + "\n*******************************************************\n\n");
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nSoundBank: Failed to shutdown sound #" + currentSound + ": " + e.toString() + "\n*******************************************************\n\n");
            }
        }
        volume = null;
        try {
            String strMimeType = null;
            for (int j = 0; j < strAudioMimeTypes.length; ++j) {
                if (!audioFiles[i].endsWith(strAudioMimeTypes[j][0])) continue;
                strMimeType = strAudioMimeTypes[j][1];
            }
            if (strMimeType == null) {
                System.out.println("\n\n*******************************************************\nMIDI Bank: unknown audio mime type for file " + audioFiles[i] + "\n*******************************************************\n\n");
                return false;
            }
            InputStream is = Application.instance.getClass().getResourceAsStream(audioFiles[i]);
            if (is == null) {
                System.out.println("\n\n*******************************************************\nMIDI Bank: could not open " + audioFiles[i] + "\n*******************************************************\n\n");
                return false;
            }
            System.out.println("SoundBank: Loading midi: " + audioFiles[i]);
            player = Manager.createPlayer((InputStream)is, (String)strMimeType);
            if (player != null) {
                System.out.println("SoundBank: realizing midi: " + audioFiles[i] + " [" + strMimeType + "]");
                player.realize();
                volume = (VolumeControl)player.getControl("VolumeControl");
                if (volume == null) {
                    System.out.println("\n\n*******************************************************\nSoundBank: Failed to get volume control!\n*******************************************************\n\n");
                }
                player.prefetch();
            } else {
                System.out.println("\n\n*******************************************************\nSoundBank: Failed loading midi: " + audioFiles[i] + "\n*******************************************************\n\n");
            }
        }
        catch (MediaException pe) {
            System.out.println("\n\n*******************************************************\nSoundBank: Failed to load tune ME: " + pe.toString() + " " + audioFiles[i] + "\n*******************************************************\n\n");
        }
        catch (IOException ioe) {
            System.out.println("\n\n*******************************************************\nSoundBank: Failed to load tune IOE: " + ioe.toString() + " " + audioFiles[i] + "\n*******************************************************\n\n");
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nSoundBank: Failed to load tune E:" + e.toString() + "\n*******************************************************\n\n");
        }
        currentSound = i;
        return true;
    }

    public static void shutdown() {
        System.out.println("SimpleSound::shutdown");
        if (player != null) {
            try {
                player.stop();
                player.close();
                player = null;
            }
            catch (MediaException pe) {
                System.out.println("\n\n*******************************************************\nSoundBank: Failed to shutdown sound #" + currentSound + " ME: " + pe.toString() + "\n*******************************************************\n\n");
            }
            catch (Exception e) {
                System.out.println("\n\n*******************************************************\nSoundBank: Failed to shutdown sound #" + currentSound + ": " + e.toString() + "\n*******************************************************\n\n");
            }
        }
        volume = null;
        currentSound = -1;
        Application.gc();
    }

    public static void play(int channel, int idx, boolean _looping, int _priority) {
        if (!soundEnbaled || channel != 0) {
            return;
        }
        System.out.println("SoundBank: playing " + idx);
        try {
            if (idx != currentSound) {
                if (!SoundBank.load(idx)) {
                    return;
                }
            } else {
                player.stop();
                player.setMediaTime(0L);
            }
            player.setLoopCount(_looping ? -1 : 1);
            if (volume != null) {
                volume.setLevel(volume_level);
                System.out.println("SoundBank: set volume level " + volume_level);
            }
            player.start();
            paused = false;
            looping = _looping;
        }
        catch (MediaException pe) {
            System.out.println("\n\n*******************************************************\nSoundBank: Failed to start tune ME: " + pe.toString() + "\n*******************************************************\n\n");
        }
        catch (Exception e) {
            System.out.println("\n\n*******************************************************\nSoundBank: Failed to start tune: " + e.toString() + "\n*******************************************************\n\n");
        }
    }

    public static void stop(int channel) {
        System.out.println("SimpleSound::stop " + channel);
        if (channel != 0) {
            return;
        }
        SoundBank.shutdown();
    }

    public static void setVolume(int channel, int vol) {
        if (channel != 0) {
            return;
        }
        System.out.println("Soundbank.setVolume " + vol);
        if (vol < 0 || vol > 100) {
            System.out.println("Assertion Failure: vol >=0 && vol <= 100\nD:\\FLWBF2_CODE\\FLWBF2_k750\\FLWBF2_SonyEricsson_K750i_v0-4-2_SRC/src/master_code/com/slg/j2me/lib\\snd/SoundBank_MMA_Simple.java.h[250]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        volume_level = vol;
        nextVolume = vol;
        MICKHYvolume = vol;
        if (volume != null) {
            System.out.println("Actually Setting volume level");
            volume.setLevel(volume_level);
        } else {
            System.out.println("volume control  is null!");
        }
    }

    public static void enableSound(boolean enabled) {
        System.out.println("SimpleSound::enableSound " + enabled);
        soundEnbaled = enabled;
        if (!soundEnbaled) {
            SoundBank.stop(0);
        }
    }

    public void playerUpdate(Player player, String str, Object obj) {
    }

    public static void serialStop(int channel) {
        if (channel != 0) {
            return;
        }
        System.out.println("SimpleSound::serialStop " + channel);
        nextMidiTrack = -1;
    }

    public static void serialPlay(int channel, int track, boolean _looping, int priority) {
        if (channel != 0) {
            return;
        }
        nextMidiTrack = track;
        System.out.println("SimpleSound::serialPlay " + channel);
        isNextLooping = _looping;
    }

    public static void serialSetVolume(int channel, int vol) {
        if (channel != 0) {
            return;
        }
        nextVolume = vol;
    }

    public static void process() {
        if (nextVolume != volume_level) {
            SoundBank.setVolume(0, nextVolume);
        }
        if (nextMidiTrack == -1) {
            SoundBank.stop(0);
            nextMidiTrack = -2;
        } else if (nextMidiTrack != -2) {
            SoundBank.play(0, nextMidiTrack, isNextLooping, 0);
            nextMidiTrack = -2;
        }
    }

    static {
        MICKHYvolume = 100;
        instance = null;
        soundEnbaled = true;
        volume_level = MICKHYvolume;
        currentSound = -1;
        looping = false;
        paused = false;
        numSounds = 0;
        strAudioMimeTypes = new String[][]{{".amr", "audio/amr"}, {".mid", "audio/midi"}};
        nextMidiTrack = -2;
        nextVolume = volume_level;
    }
}

