/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.sys;

import com.slg.j2me.lib.sys.Application;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedPoint {
    public static int[] sinlut = null;
    public static int[] asinlut = null;
    private static final int asinLutLowIndexScalar = FixedPoint.stringToFP("85.33333");

    public static final void startup() {
        DataInputStream datain;
        InputStream inputstream = Application.instance.getClass().getResourceAsStream("/math.bin");
        if (inputstream == null) {
            System.out.println("Assertion Failure: inputstream != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/FixedPoint.java[46]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((datain = new DataInputStream(inputstream)) == null) {
            System.out.println("Assertion Failure: datain != null\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/FixedPoint.java[50]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            int sinsize = datain.readShort();
            sinlut = new int[sinsize];
            for (int i = 0; i < sinsize; ++i) {
                FixedPoint.sinlut[i] = datain.readInt();
            }
            short asinsize = datain.readShort();
            short asinsize2 = datain.readShort();
            asinlut = new int[asinsize + asinsize2];
            for (int i = 0; i < asinsize + asinsize2; ++i) {
                FixedPoint.asinlut[i] = datain.readInt();
            }
        }
        catch (IOException err) {
            System.out.println("\n\n*******************************************************\nError reading math.bin!\n*******************************************************\n\n");
        }
    }

    public static final int linearInterpolate(int t, int t0, int t1) {
        int b = t < 0 ? 0 : (t > 65536 ? 65536 : t);
        int a = t1 - t0;
        return (((a ^ b) & 0x8000000) != 0 ? -((int)((long)(-a) * (long)b >> 16)) : (int)((long)a * (long)b >> 16)) + t0;
    }

    public static final int sinLut(int fp_angle) {
        int fp_frac;
        int angle;
        if (fp_angle < 0) {
            System.out.println("Assertion Failure: fp_angle>=0\nD:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/FixedPoint.java[128]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (((sinlut[angle = fp_angle >> 16 & 0xFF] ^ 65536 - (fp_frac = fp_angle & 0xFFFF)) & 0x8000000) != 0 ? -((int)((long)(-sinlut[angle]) * (long)(65536 - fp_frac) >> 16)) : (int)((long)sinlut[angle] * (long)(65536 - fp_frac) >> 16)) + (((sinlut[angle + 1] ^ fp_frac) & 0x8000000) != 0 ? -((int)((long)(-sinlut[angle + 1]) * (long)fp_frac >> 16)) : (int)((long)sinlut[angle + 1] * (long)fp_frac >> 16));
    }

    public static final int asinLut(int fp_sin) {
        int fp_index = 0;
        int start = 0;
        boolean neg = false;
        if (fp_sin < 0) {
            fp_sin = -fp_sin;
            neg = true;
        }
        if (fp_sin < 49152) {
            fp_index = (int)((long)fp_sin * (long)asinLutLowIndexScalar >> 16);
        } else {
            fp_index = (fp_sin - 49152) * 768;
            start = 65;
        }
        int fp_asin = 0;
        if (fp_index >= 0xC00000) {
            fp_asin = 0x400000;
        } else {
            int index = fp_index < 0 ? -(-fp_index >> 16) : fp_index >> 16;
            int fp_frac = fp_index & 0xFFFF;
            fp_asin = (((asinlut[start + index] ^ 65536 - fp_frac) & 0x8000000) != 0 ? -((int)((long)(-asinlut[start + index]) * (long)(65536 - fp_frac) >> 16)) : (int)((long)asinlut[start + index] * (long)(65536 - fp_frac) >> 16)) + (((asinlut[start + index + 1] ^ fp_frac) & 0x8000000) != 0 ? -((int)((long)(-asinlut[start + index + 1]) * (long)fp_frac >> 16)) : (int)((long)asinlut[start + index + 1] * (long)fp_frac >> 16));
        }
        return neg ? -fp_asin : fp_asin;
    }

    public static final int sqrt_div(int fp) {
        int s = fp + 65536 >> 1;
        for (int i = 0; i < 8; ++i) {
            s = s + (int)(((long)fp << 16) / (long)s) >> 1;
        }
        return s;
    }

    public static final int sqrt_bits(int sqr) {
        int delta = sqr > 65536 ? sqr : 65536;
        int M = sqr;
        int root = 0;
        do {
            long step;
            if ((step = (long)delta * (long)((root << 1) + delta) >> 16) > (long)M) continue;
            M = (int)((long)M - step);
            root += delta;
        } while ((delta >>= 1) != 0);
        return root;
    }

    public static final int sqrt_bits(long sqr) {
        long delta = sqr > 65536L ? sqr : 65536L;
        long M = sqr;
        long root = 0L;
        do {
            long step;
            if ((step = delta * ((root << 1) + delta) >> 16) > M) continue;
            M -= step;
            root += delta;
        } while ((delta >>= 1) != 0L);
        return (int)root;
    }

    public static final String toString_fp(int fp) {
        long frac;
        boolean negative;
        boolean bl = negative = fp < 0;
        if (negative) {
            fp = -fp;
        }
        String zeros = (frac = (long)(fp & 0xFFFF) * 100000L / 65536L) < 10L ? "0000" : (frac < 100L ? "000" : (frac < 1000L ? "00" : (frac < 10000L ? "0" : "")));
        return (negative ? "-" : "") + (fp >> 16) + "." + zeros + frac;
    }

    public static final int stringToFP(String str) {
        long number = 0L;
        int divisor = 0;
        boolean negative = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                if (divisor != 0) {
                    System.out.println("\n\n*******************************************************\nFixedPoint.stringToFP() - " + str + " BAD NUMBER FORMAT: found 2+ decimal points" + "\n*******************************************************\n\n");
                }
                divisor = 1;
                continue;
            }
            if (c == '-') {
                if (negative || number != 0L) {
                    System.out.println("\n\n*******************************************************\nFixedPoint.stringToFP() - " + str + " BAD NUMBER FORMAT: found 2+ minus signs or minus sign not at start of number" + "\n*******************************************************\n\n");
                }
                negative = true;
                continue;
            }
            if (c < '0' || c > '9') continue;
            number *= 10L;
            divisor *= 10;
            number += (long)(c - 48);
        }
        if (negative) {
            number = -number;
        }
        if (divisor > 1) {
            return (int)(((long)((int)number) << 16) / (long)divisor);
        }
        return (int)number < 0 ? -(-((int)number) << 16) : (int)number << 16;
    }

    public static String maskToString(int mask, int start) {
        String ret = "";
        for (int i = start - 1; i >= 0; --i) {
            ret = (mask & 1 << i) != 0 ? ret.concat("1") : ret.concat("0");
            if ((i & 7) != 0) continue;
            ret = ret.concat(" ");
        }
        return ret;
    }

    public static int getNextSetBit(int mask, int start) {
        if (mask == 0 || start == 31) {
            return -1;
        }
        int startnibble = ++start >> 2;
        if (start >= 32 || start < 0) {
            System.out.println("Assertion Failure: start < 32 && start >= 0 with msg: " + start + " is out of range" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/FixedPoint.java" + "[" + 264 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int nibble = startnibble; nibble < 8; ++nibble) {
            int startbit;
            if ((mask & 15 << (nibble << 2)) == 0) continue;
            for (int bit = startbit = startnibble == nibble ? start & 3 : 0; bit < 4; ++bit) {
                int checkbit = (nibble << 2) + bit;
                if ((mask & 1 << checkbit) == 0) continue;
                return checkbit;
            }
        }
        return -1;
    }

    public static int getPrevSetBit(int mask, int start) {
        int startnibble;
        if (mask == 0 || start == 0) {
            return -1;
        }
        start = start == -1 ? 31 : --start;
        if (start >= 32 || start < 0) {
            System.out.println("Assertion Failure: start < 32 && start >= 0 with msg: " + start + " is out of range" + "\n" + "D:\\FLWBF2_CODE\\FLWBF2_F500\\FLWBF2_SonyEricsson_F500i_v0-5-5_SRC/src/master_code/com/slg/j2me/lib\\sys/FixedPoint.java" + "[" + 285 + "]");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int nibble = startnibble = start >> 2; nibble >= 0; --nibble) {
            int startbit;
            if ((mask & 15 << (nibble << 2)) == 0) continue;
            for (int bit = startbit = startnibble == nibble ? start & 3 : 3; bit >= 0; --bit) {
                int checkbit = (nibble << 2) + bit;
                if ((mask & 1 << checkbit) == 0) continue;
                return checkbit;
            }
        }
        return -1;
    }

    public static int getBitCount(int mask) {
        int v = mask - (mask >> 1 & 0x55555555);
        v = (v & 0x33333333) + (v >> 2 & 0x33333333);
        return (v + (v >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }

    public static final void unitTest() {
        int fp_err;
        int fp_asin;
        int i;
        int i2;
        int fp_inc = 5957;
        for (i2 = 0; i2 < 0x1000000; i2 += fp_inc) {
            System.out.println("sin(" + FixedPoint.toString_fp(i2) + ")=" + FixedPoint.toString_fp(FixedPoint.sinLut(i2)));
        }
        for (i2 = 0; i2 < 0x1000000; i2 += fp_inc) {
            System.out.println("cos(" + FixedPoint.toString_fp(i2) + ")=" + FixedPoint.toString_fp(FixedPoint.sinLut(i2 + 0x400000)));
        }
        for (i2 = 1; i2 < 65536; i2 <<= 1) {
            int fp_i = i2 < 0 ? -(-i2 << 16) : i2 << 16;
            int fp_rt = FixedPoint.sqrt_bits(fp_i);
            System.out.println("sqrt(" + i2 + ")=" + FixedPoint.toString_fp(fp_rt));
        }
        fp_inc = 5957;
        int fp_maxerr = 0;
        int i3 = fp_inc;
        while ((i3 < 0 ? -(-i3 >> 16) : i3 >> 16) < 5) {
            int fp_sqrt = FixedPoint.sqrt_bits(i3);
            int fp_err2 = i3 - (((fp_sqrt ^ fp_sqrt) & 0x8000000) != 0 ? -((int)((long)(-fp_sqrt) * (long)fp_sqrt >> 16)) : (int)((long)fp_sqrt * (long)fp_sqrt >> 16));
            if (fp_err2 > fp_maxerr) {
                fp_maxerr = fp_err2;
            }
            System.out.println("sqrt(" + FixedPoint.toString_fp(i3) + ")=" + FixedPoint.toString_fp(fp_sqrt) + " err:" + FixedPoint.toString_fp(fp_err2));
            i3 += fp_inc;
        }
        System.out.println("-- sqrt max err = " + FixedPoint.toString_fp(fp_maxerr));
        fp_inc = 21845;
        long start_bits = System.currentTimeMillis();
        int j = 0;
        int i4 = fp_inc;
        while ((i4 < 0 ? -(-i4 >> 16) : i4 >> 16) < 16384) {
            FixedPoint.sqrt_bits(i4);
            i4 += fp_inc;
            ++j;
        }
        long end_bits = System.currentTimeMillis();
        long start_div = System.currentTimeMillis();
        j = 0;
        int i5 = fp_inc;
        while ((i5 < 0 ? -(-i5 >> 16) : i5 >> 16) < 16384) {
            FixedPoint.sqrt_div(i5);
            i5 += fp_inc;
            ++j;
        }
        long end_div = System.currentTimeMillis();
        System.out.println("SQRT timings: " + j + " iterations.");
        System.out.println("sqrt_bits = " + (end_bits - start_bits) + "ms");
        System.out.println("sqrt_div= " + (end_div - start_div) + "ms");
        fp_inc = 58;
        fp_maxerr = 0;
        for (i = -65536; i <= 65536; i += fp_inc) {
            for (fp_asin = FixedPoint.asinLut(i); fp_asin < 0; fp_asin += 0x1000001) {
            }
            while (fp_asin > 0x1000000) {
                fp_asin -= 0x1000001;
            }
            fp_err = i - FixedPoint.sinLut(fp_asin);
            if ((fp_err < 0 ? -fp_err : fp_err) > fp_maxerr) {
                fp_maxerr = fp_err < 0 ? -fp_err : fp_err;
            }
            System.out.println("asin(" + FixedPoint.toString_fp(i) + ")=" + FixedPoint.toString_fp(fp_asin) + " err:" + FixedPoint.toString_fp(fp_err));
        }
        System.out.println("-------");
        fp_inc = FixedPoint.stringToFP("0.00002");
        for (i = FixedPoint.stringToFP("0.995"); i <= 65536; i += fp_inc) {
            for (fp_asin = FixedPoint.asinLut(i); fp_asin < 0; fp_asin += 0x1000001) {
            }
            while (fp_asin > 0x1000000) {
                fp_asin -= 0x1000001;
            }
            fp_err = i - FixedPoint.sinLut(fp_asin);
            if ((fp_err < 0 ? -fp_err : fp_err) > fp_maxerr) {
                fp_maxerr = fp_err < 0 ? -fp_err : fp_err;
            }
            System.out.println("asin(" + FixedPoint.toString_fp(i) + ")=" + FixedPoint.toString_fp(fp_asin) + " err:" + FixedPoint.toString_fp(fp_err));
        }
        System.out.println("-- asin max err = " + FixedPoint.toString_fp(fp_maxerr));
    }
}

