/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResourceLoader {
    public static byte[] loadByteArray(String name) {
        int fileLength = ResourceLoader.getSizeOfFile(name);
        byte[] buffer = new byte[fileLength];
        try {
            DataInputStream ds = new DataInputStream(name.getClass().getResourceAsStream(name));
            for (int i = 0; i < fileLength; ++i) {
                buffer[i] = ds.readByte();
            }
            ds.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    private static int getSizeOfFile(String name) {
        int size = 0;
        try {
            InputStream str = name.getClass().getResourceAsStream(name);
            while (str.read() >= 0) {
                ++size;
            }
            str.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    public static final short toShort(byte[] b, int i) {
        int val = (b[i] & 0xFF) << 8;
        return (short)(val += b[i + 1] & 0xFF);
    }

    public static String[] loadText(String name, int textOffset, int textCount) {
        byte[] buffer = ResourceLoader.loadByteArray(name);
        String[] text = new String[textCount];
        int offset = 0;
        short length = 0;
        try {
            for (int i = 0; i < textCount; ++i) {
                length = ResourceLoader.toShort(buffer, offset);
                offset += 2;
                if (textOffset == 0) {
                    text[i] = new String(buffer, offset, (int)length, "ISO-8859-1");
                } else {
                    text[i - textOffset] = new String(buffer, offset, (int)length, "ISO-8859-1");
                }
                offset += length;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buffer = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return text;
    }
}

