/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.rim.util;

import com.magmic.lang.CommonStrings;
import com.magmic.maglet.Maglet;
import com.magmic.rim.util.NetworkConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import net.rim.device.api.io.LineReader;
import net.rim.device.api.system.EncodedImage;
import net.rim.device.api.system.RadioInfo;

public final class Utilities {
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_FAILED = 400;
    public static final int CODE_DUPLICATE_ALIAS = 450;
    public static final int CODE_NO_ACCOUNT_EXISTS = 451;
    public static final int CODE_INVALID_PASSWORD = 452;
    public static final int CODE_INVALID_USERNAME = 453;
    public static final int CODE_INVALID_SESSIONID = 454;
    public static final int CODE_NOT_ACTIVE = 455;
    public static final int CODE_COMM_FAILURE = 500;
    public static final char STD_CODE_DELIM = '?';
    public static final char STD_BLOCK_DELIM = ':';
    public static final char STD_FIELD_DELIM = ',';
    public static final char STD_MESSAGE_DELIM = ';';
    private static final String charsToEncode = "+;/?:@=&\"'<>#%{}|\\^~[]`";
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalizedResourceText(Object object, String string) {
        InputStream inputStream = object.getClass().getResourceAsStream('/' + string);
        if (inputStream == null) {
            return "";
        }
        LineReader lineReader = new LineReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            try {
                while (true) {
                    byte[] byArray = lineReader.readLine();
                    stringBuffer.append(new String(byArray)).append('\n');
                }
            }
            catch (Exception exception) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (charsToEncode.indexOf(c) != -1) {
                stringBuffer.append('%');
                String string2 = Integer.toHexString(c).toUpperCase();
                if (string2.length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                try {
                    int n = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                    stringBuffer.append((char)n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
                i += 2;
                continue;
            }
            if (c == '+') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static byte[] POST(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append('=').append(Utilities.encode(stringArray2[i])).append('&');
        }
        return Utilities.POST(string, stringBuffer.toString().getBytes(), stringArray3, stringArray4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] POST(String string, byte[] byArray, String[] stringArray, String[] stringArray2) throws IOException {
        IOException iOException = null;
        HttpConnection httpConnection = null;
        OutputStream outputStream = null;
        byte[] byArray2 = null;
        try {
            httpConnection = Utilities.connect(string, "POST", stringArray, stringArray2);
            httpConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            outputStream = httpConnection.openOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            byArray2 = Utilities.bufferedRead(httpConnection.openInputStream());
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception) {}
        }
        if (iOException != null) {
            throw iOException;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] GET(String string, String[] stringArray, String[] stringArray2) throws IOException {
        HttpConnection httpConnection = null;
        IOException iOException = null;
        byte[] byArray = null;
        try {
            httpConnection = Utilities.connect(string, "GET", stringArray, stringArray2);
            byArray = Utilities.bufferedRead(httpConnection.openInputStream());
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            try {
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception) {}
        }
        if (iOException != null) {
            throw iOException;
        }
        return byArray;
    }

    public static final byte[] bufferedRead(InputStream inputStream) throws IOException {
        return Utilities.bufferedRead(inputStream, 1024, 1024);
    }

    public static byte[] bufferedRead(InputStream inputStream, int n, int n2) throws IOException {
        byte[] byArray;
        int n3 = 0;
        int n4 = -1;
        byte[] byArray2 = new byte[n];
        while ((n4 = inputStream.read(byArray2, n3, n2)) == n2) {
            byArray = new byte[byArray2.length + n2];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = byArray;
            n3 += n2;
        }
        inputStream.close();
        if (n4 == -1) {
            ++n4;
        }
        if ((byArray = new byte[byArray2.length - (n2 - n4)]).length == 0) {
            return byArray;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        byArray2 = byArray;
        return byArray2;
    }

    public static HttpConnection connect(String string, String string2, String[] stringArray, String[] stringArray2) throws IOException {
        HttpConnection httpConnection = null;
        try {
            if ((RadioInfo.getNetworkService() & 4) == 0) {
                throw new ConnectionNotFoundException("Network Data Service Not Available");
            }
            httpConnection = (HttpConnection)Connector.open((String)(string + NetworkConfiguration.getWAPParameters()), (int)(string2 == "POST" ? 3 : 1), (boolean)true);
            httpConnection.setRequestMethod(string2);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray2[i] == null) continue;
                    httpConnection.setRequestProperty(stringArray[i], stringArray2[i]);
                }
            }
        }
        catch (IOException iOException) {
            if (httpConnection != null) {
                httpConnection.close();
            }
            throw iOException;
        }
        return httpConnection;
    }

    public static int[] getResponseCode(byte[] byArray, int n) {
        return Utilities.getResponseCode(byArray, n, '?');
    }

    public static int[] getResponseCode(byte[] byArray, int n, char c) {
        String string = new String(byArray);
        int n2 = string.indexOf(c, n);
        if (n2 < 0) {
            return new int[]{-1, -1};
        }
        return new int[]{Integer.parseInt(string.substring(n2)), n2};
    }

    public static int getResponseMessage(byte[] byArray, int n, String[] stringArray) {
        return Utilities.getResponseMessage(byArray, n, ';', stringArray);
    }

    public static int getResponseMessage(byte[] byArray, int n, char c, String[] stringArray) {
        String string = new String(byArray, n, byArray.length - n);
        n = string.indexOf(c);
        stringArray[0] = string.substring(n);
        return n;
    }

    public static int parseData(byte[] byArray, int n, char c, char c2, String[][] stringArray) {
        int n2;
        String string = new String(byArray, n, byArray.length - n);
        n = 0;
        int n3 = 0;
        for (n2 = 0; n < string.length() && n2 < stringArray.length; ++n2) {
            int n4 = n;
            int n5 = string.indexOf(c, n4);
            if (n5 < 0) {
                n5 = string.length();
            }
            String string2 = string.substring(n4, n5);
            int n6 = 0;
            while ((n3 = string2.indexOf(c2, n3)) > 0) {
                ++n6;
            }
            String[] stringArray2 = new String[n6];
            for (int i = 0; i < stringArray2.length; ++i) {
                int n7 = n3 + 1;
                n3 = string2.indexOf(c2, n3 + 1);
                stringArray2[i] = string2.substring(n7, n3);
            }
            stringArray[n2] = stringArray2;
            n = ++n5;
        }
        return n2;
    }

    public static final String getResponseCodeMessage(int n) {
        switch (n) {
            case 200: {
                return CommonStrings.LOGIN_SUCCESSFUL;
            }
            case 400: {
                return CommonStrings.CODE_FAILED_MSG;
            }
            case 450: {
                return CommonStrings.CODE_DUPLICATE_ALIAS_MSG;
            }
            case 451: {
                return CommonStrings.CODE_NO_ACCOUNT_EXISTS_MSG;
            }
            case 452: {
                return CommonStrings.CODE_INVALID_PASSWORD_MSG;
            }
            case 453: {
                return CommonStrings.CODE_INVALID_USERNAME_MSG;
            }
            case 454: {
                return CommonStrings.CODE_INVALID_SESSIONID;
            }
            case 455: {
                return CommonStrings.CODE_NOT_ACTIVE_MSG;
            }
            case 500: {
                return CommonStrings.CODE_COMM_FAILURE_MSG;
            }
        }
        return CommonStrings.UNKNOWN_CODE_MSG;
    }

    public static final EncodedImage loadEncodedImage(Class clazz, String string, int n) {
        EncodedImage encodedImage = null;
        try {
            InputStream inputStream = Maglet.getResourceInputStream(string);
            byte[] byArray = Utilities.bufferedRead(inputStream, n, 1024);
            encodedImage = EncodedImage.createEncodedImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return encodedImage;
    }
}

